<?php 

	class Materias extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MMATERIAS);
		}

		public function Materias()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Materias";
			$data['page_title'] = "MATERIAS <small>UAF</small>";
			$data['page_name'] = "materias";
			$data['page_functions_js'] = "functions_materias.js";
			$data['niveles'] = $this->model->selectNiveles();
			$data['carreras'] = $this->model->selectCarreras();
			$data['materias'] = $this->model->selectAntecesoras();
			$this->views->getView($this,"materias",$data);
		}

		public function setMateria(){
			if($_POST){	
				
				if(empty($_POST['txtMateria']) || empty($_POST['txtDuracion']) || empty($_POST['txtSemestre']) || empty($_POST['listNivel']) || empty($_POST['listCarrera']) || empty($_POST['listStatus']))
				{
					$arrResponse = array("status" => false, "msg" => 'Llenar todos los campos obligatorios.');
				}else{ 
					$idMateria = intval($_POST['idMateria']);
					$strClaveMateria = mb_strtoupper(strClean($_POST['txtClave']), 'UTF-8');
					$strMateria =  mb_strtoupper(strClean($_POST['txtMateria']), 'UTF-8');
					$intDuracion = intval($_POST['txtDuracion']);
					$intSemestre = intval($_POST['txtSemestre']);
					$intNivelId = intval($_POST['listNivel']);
					$intSemestreId = intval($_POST['txtSemestre']);
					$intNivelId = intval($_POST['listNivel']);
					$intCarreraId = intval($_POST['listCarrera']);
					$intAntecesoraId = strClean($_POST['listAntecesora']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];

					$intStatus = intval($_POST['listStatus']);
					$requestMateria = "";

					if($idMateria == 0)
					{
						$option = 1;
						$strTipoMovimiento = 'Alta';
						if($_SESSION['permisosMod']['w']){
							$requestMateria = $this->model->insertMateria($strClaveMateria,
																		$strMateria, 
																		$intDuracion,
																		$intSemestre,
																		$intAntecesoraId, 
																		$intNivelId,
																		$intCarreraId,
																		$strModificador,
																		$strTipoMovimiento,
																		$intStatus);
						}
					}else{
						$option = 2;
						$strTipoMovimiento = 'Actualización';
						if($_SESSION['permisosMod']['u']){
							$requestMateria = $this->model->updateMateria($idMateria,
																		$strClaveMateria,
																		$strMateria, 
																		$intDuracion,
																		$intSemestre,
																		$intAntecesoraId, 
																		$intNivelId,
																		$intCarreraId,
																		$strModificador,
																		$strTipoMovimiento,
																		$intStatus);
						}

					}

					if(intval($requestMateria) > 0 )
					{
						if($option == 1){
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
						}else{
							$data = $this->model->selectCarreraFormat($intCarreraId);
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.', 'data' => $data);
						}
					}else if($requestMateria == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! Esta materia ya se encuentra registrada en el sistema.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getMaterias()
		{
			if($_SESSION['permisosMod']['r']){
				
				$arrData = $this->model->selectMaterias();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					if($arrData[$i]['status'] == 1)
					{
						$arrData[$i]['status'] = '<span class="badge badge-success">Activo</span>';
					}else{
						$arrData[$i]['status'] = '<span class="badge badge-danger">Inactivo</span>';
					}

					if($_SESSION['permisosMod']['r']){
						$btnView = '<button class="btn btn-info btn-sm btnViewMateria" onClick="fntViewMateria('.$arrData[$i]['idmateria'].')" title="Ver materia"><i class="far fa-eye"></i></button>';
					}
					if($_SESSION['permisosMod']['u']){
						$btnEdit = '<button class="btn btn-primary  btn-sm btnEditMateria" onClick="fntEditMateria(this,'.$arrData[$i]['idmateria'].')" title="Editar materia"><i class="fas fa-pencil-alt"></i></button>';
					}
					if($_SESSION['permisosMod']['d']){
						
						$btnDelete = '<button class="btn btn-danger btn-sm btnDelMateria" onClick="fntDelMateria('.$arrData[$i]['idmateria'].')" title="Eliminar materia"><i class="far fa-trash-alt"></i></button>';
			
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getMateria($idmateria){
			if($_SESSION['permisosMod']['r']){
				$intIdMateria = intval($idmateria);
				if(intval($intIdMateria) > 0)
				{
					$arrData = $this->model->selectMateria($intIdMateria);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delMateria()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdMateria = intval($_POST['idmateria']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$requestDelete = $this->model->deleteMateria($intIdMateria, $strModificador);
					if(intval($requestDelete)>0)
					{
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente la materia');
					}elseif($requestDelete == 'permisivo'){
						$arrResponse = array('status' => false, 'msg' => 'No se puede aliminar la materia, ya que se encuentra ligada a un horario escolar activo.');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar la materia.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getAntecesoras()
		{
			
				$request = $this->model->selectAntecesoras();
				$arrResponse = array('status' => true, 'data' => $request, 'msg' => 'Información generada exitosamente');
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			
			die();
		}

	}
 ?>