<?php 

	class Niveles extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MNIVELES);
		}

		public function Niveles()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Niveles";
			$data['page_title'] = "NIVELES <small>UAF</small>";
			$data['page_name'] = "niveles";
			$data['page_functions_js'] = "functions_niveles.js";
			$data['usuarios'] = $this->model->selectUsuarios();
			$this->views->getView($this,"niveles",$data);
		}

		public function setNivel(){
			if($_POST){	
				
				if(empty($_POST['txtNivel']) || empty($_POST['listStatus']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{ 
					$idNivel = intval($_POST['idNivel']);
					$strNivel = mb_strtoupper(strClean($_POST['txtNivel']), 'UTF-8');
					$intCoordinador = intVal($_POST['listCoordinador']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$intStatus = intval($_POST['listStatus']);
					$strTipoMovimiento = '';
					$requestNivel = "";

					if($idNivel == 0)
					{
						$option = 1;
						$strTipoMovimiento = 'Alta';
						if($_SESSION['permisosMod']['w']){
							$requestNivel = $this->model->insertNivel($strNivel,
																		$intCoordinador,
																		$strModificador, 
																		$strTipoMovimiento,
																		$intStatus);
						}
					}else{
						$option = 2;
						$strTipoMovimiento = 'Actualización';
						if($_SESSION['permisosMod']['u']){
							$requestNivel = $this->model->updateNivel($idNivel,
																		$strNivel,
																		$intCoordinador,
																		$strModificador,
																		$strTipoMovimiento, 
																		$intStatus);
						}

					}

					if(intval($requestNivel) > 0 )
					{
						if($option == 1){
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
						}else{
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
						}
					}else if($requestNivel == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! El Nivel ya se encuentra registrado en el sistema.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getNiveles()
		{
			if($_SESSION['permisosMod']['r']){
				
				$arrData = $this->model->selectNiveles();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					if($arrData[$i]['status'] == 1)
					{
						$arrData[$i]['status'] = '<span class="badge badge-success">Activo</span>';
					}else{
						$arrData[$i]['status'] = '<span class="badge badge-danger">Inactivo</span>';
					}

					if($_SESSION['permisosMod']['r']){
						$btnView = '<button class="btn btn-info btn-sm btnViewNivel" onClick="fntViewNivel('.$arrData[$i]['idnivel'].')" title="Ver nivel"><i class="far fa-eye"></i></button>';
					}
					if($_SESSION['permisosMod']['u']){
						$btnEdit = '<button class="btn btn-primary  btn-sm btnEditNivel" onClick="fntEditNivel(this,'.$arrData[$i]['idnivel'].')" title="Editar nivel"><i class="fas fa-pencil-alt"></i></button>';
					}
					if($_SESSION['permisosMod']['d']){
						
						$btnDelete = '<button class="btn btn-danger btn-sm btnDelNivel" onClick="fntDelNivel('.$arrData[$i]['idnivel'].')" title="Eliminar nivel"><i class="far fa-trash-alt"></i></button>';
			
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getNivel($idnivel){
			if($_SESSION['permisosMod']['r']){
				$intIdNivel = intval($idnivel);
				if(intval($intIdNivel) > 0)
				{
					$arrData = $this->model->selectNivel($intIdNivel);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delNivel()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdNivel = intval($_POST['idnivel']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$requestDelete = $this->model->deleteNivel($intIdNivel, $strModificador);
					if(intval($requestDelete)>0)
					{
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente el nivel');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar el nivel.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}
	}
 ?>