<?php 
	require 'Libraries/html2pdf/vendor/autoload.php';
	use Spipu\Html2Pdf\Html2Pdf;

	class Pindividual extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MPROMEDIOS);
		}

		public function Pindividual()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Promedio Individual";
			$data['page_title'] = "PROMEDIO INDIVIDUAL <small>UAF</small>";
			$data['page_name'] = "Promedio individual";
			$data['page_functions_js'] = "functions_pindividual.js";
			$data['carreras'] = $this->model->selectCarreras();
			$this->views->getView($this,"pindividual",$data);
		}

		public function getAlumnos($carreraid){
			if($_SESSION['permisosMod']['r']){
				$intCarreraId = intval($carreraid);
				if(intval($intCarreraId) > 0)
				{
					$arrData = $this->model->selectAlumnos($intCarreraId);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se encontraron alumnos asignados a la carrera y nivel seleccionados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData, 'msg' => 'A continuación se listan los alumnos correspondientes a la carrera y nivel seleccionados.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getBusquedaAlumno()
		{
			if($_POST)
			{
				if($_SESSION['permisosMod']['u'])
				{
					//$intCarreraId = intval($_POST['listCarreras']);
					$intAlumnoId = intval($_POST['listAlumnos']);
					$strOption = strClean($_POST['rbOption']);
					$intPrimero = intval($_POST['primero']);
					$intSegundo = intval($_POST['segundo']);
					$intTercero = intval($_POST['tercero']);
					$intCuarto = intval($_POST['cuarto']);
					$intQuinto = intval($_POST['quinto']);
					$intSexto = intval($_POST['sexto']);
					$intSeptimo = intval($_POST['septimo']);
					$intOctavo = intval($_POST['octavo']);
					$intNoveno = intval($_POST['noveno']);
					$semestres = array();

					if($intPrimero == 1){
						array_push($semestres, 1);
					}
					if($intSegundo == 1){
						array_push($semestres, 2);
					}
					if($intTercero == 1){
						array_push($semestres, 3);
					}
					if($intCuarto == 1){
						array_push($semestres, 4);
					}
					if($intQuinto == 1){
						array_push($semestres, 5);
					}
					if($intSexto == 1){
						array_push($semestres, 6);
					}
					if($intSeptimo == 1){
						array_push($semestres, 7);
					}
					if($intOctavo == 1){
						array_push($semestres, 8);
					}
					if($intNoveno == 1){
						array_push($semestres, 9);
					}
					
					if($strOption == "Personalizado"){
						$arrData = $this->model->selectKardexSemestres($intAlumnoId, $semestres);	
					}else{
						$arrData = $this->model->selectKardexTodos($intAlumnoId);
					}
					
					/*if(intval($arrData)>0){
						
						//$idkardex = $data['idkardex'];
						ob_end_clean();
						$html = getFile("Template/Modals/kardexECalificacionesPDF",$arrData);
						$html2pdf = new Html2Pdf('p','A4','es','true','UTF-8');
						$html2pdf->writeHTML($html);
						$html2pdf->output('Kardex-'.$arrData[0]['nombre_alumno'].'.pdf');
					}else{
						echo "Dato no válido";
					}*/
					
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se encontraron registros de calificaciones con los datos de la búsqueda seleccionados');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData, 'url' => base_url(), 'msg' => 'A continuación se listan los grupos correspondientes a la carrera seleccionada.');
					}
					
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
					die();
				}

			}
			
		}

		public function formatoPromedioIndividual($params)
		{
			if($_SESSION['permisosMod']['r']){
				$array = explode(",", $params);
				$intAlumnoId = $array[0];
				$strOption = $array[1];
				$intPrimero = $array[2];
				$intSegundo = $array[3];
				$intTercero = $array[4];
				$intCuarto = $array[5];
				$intQuinto = $array[6];
				$intSexto = $array[7];
				$intSeptimo = $array[8];
				$intOctavo = $array[9];
				$intNoveno = $array[10];
				$semestres = array();
				
				if(intval($intAlumnoId)>0){
					if($strOption == "Custom"){
						if($intPrimero == 1){
							array_push($semestres, 1);
						}
						if($intSegundo == 1){
							array_push($semestres, 2);
						}
						if($intTercero == 1){
							array_push($semestres, 3);
						}
						if($intCuarto == 1){
							array_push($semestres, 4);
						}
						if($intQuinto == 1){
							array_push($semestres, 5);
						}
						if($intSexto == 1){
							array_push($semestres, 6);
						}
						if($intSeptimo == 1){
							array_push($semestres, 7);
						}
						if($intOctavo == 1){
							array_push($semestres, 8);
						}
						if($intNoveno == 1){
							array_push($semestres, 9);
						}
						$arrData = $this->model->selectKardexSemestres($intAlumnoId, $semestres);	
					}else{
						$arrData = $this->model->selectKardexTodos($intAlumnoId);
					}

					if(empty($arrData)){
						echo "Error: Datos no encontrados, intente más tarde.";
					}else{
						ob_end_clean();
						$html = getFile("Template/Modals/promedioIndividualPDF",$arrData);
						$html2pdf = new Html2Pdf('p','A4','es','true','UTF-8');
						//$html2pdf->Image(media().'/images/logoVertical.png' , 10 ,100, 190 , 150,'PNG');
						$html2pdf->writeHTML($html);
						$html2pdf->output('promedio_Individual: '.$arrData[0]['nombre_alumno'].'.pdf');
					}
				}else{
					echo "Dato no válido";
				}
			}else{
				header('Location: '.base_url().'/login');
				die();
			}
		}

	}

 ?>