<?php 

	class Recursos extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			//session_regenerate_id(true);
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MRECURSOS);
		}

		public function Recursos()
		{
		    if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_id'] = 5;
			$data['page_tag'] = "Recursos";
			$data['page_name'] = "recursos";
			$data['page_title'] = "RECURSOS <small> UAF</small>";
			$data['page_functions_js'] = "functions_recursos.js";
			$data['recursos'] = $this->getRecursos();
			$this->views->getView($this,"recursos",$data);

		}

		public function setRecurso(){
			if($_POST){
				if(empty($_POST['txtNombre']) || empty($_FILES['archivo']) )
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{
					date_default_timezone_set('America/Mexico_City');
					//$strUltimaModificacion=date('Y-m-d H:i:s');
					$intIdRecurso = intval($_POST['idRecurso']);
					$strNombreMin = strtolower(strClean($_POST['txtNombre']));
					$strNombre = ucwords($strNombreMin);
					$strExtension = strClean($_POST['listExtension']);
					$archivo = $_FILES['archivo'];
					$nombre_archivo = $archivo['name'];
					$type = $archivo['type'];
					$url_temp = $archivo['tmp_name'];
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$strTipoMovimiento = '';
					$intRolId = $_SESSION['userData']['idrol'];
					$ruta='';

					$request_recurso = "";
					if($nombre_archivo != ''){
						$nombre_recurso = 'Recurso_'.rand(1,10000).$nombre_archivo;
					}

					if($strExtension=="PDF"){
						$imagen="logo-pdf.png";
						$extFin=".pdf";
					}else if($strExtension=="Excel"){
						$imagen="logo-excel.png";
						$extFin=".xlsx";
					}else if($strExtension=="Imagen"){
						$imagen="logo-imagen.png";
					}else if($strExtension=="Power Point"){
						$imagen="logo-power.png";
					}else if($strExtension=="Word"){
						$imagen="logo-word.png";
					}

					if($intRolId == RADMINISTRADOR){
						$ruta=base_url().'/Assets/recursos/Tecnologia/'.$nombre_recurso;
					}elseif($intRolId == RRECTORIA){
						$ruta=base_url().'/Assets/recursos/Rectoria/'.$nombre_recurso;
					}elseif($intRolId == RADMINESCOLARES || $intRolId == RAUXESCOLARES){
						$ruta=base_url().'/Assets/recursos/Escolares/'.$nombre_recurso;
					}elseif($intRolId == RADMINBACHILLERATO){
						$ruta=base_url().'/Assets/recursos/Bachillerato/'.$nombre_recurso;
					}elseif($intRolId == RADMINLICENCIATURA){
						$ruta=base_url().'/Assets/recursos/Licenciatura/'.$nombre_recurso;
					}elseif($intRolId == RADMININGENIERIA){
						$ruta=base_url().'/Assets/recursos/Ingenieria/'.$nombre_recurso;
					}elseif($intRolId == RADMINPOSGRADO){
						$ruta=base_url().'/Assets/recursos/Posgrado/'.$nombre_recurso;
					}elseif($intRolId == RADMINFINANCIEROS || $intRolId == RAUXFINANCIEROS){
						$ruta=base_url().'/Assets/recursos/Financieros/'.$nombre_recurso;
					}elseif($intRolId == RADMINVINCULACION){
						$ruta=base_url().'/Assets/recursos/Vinculacion/'.$nombre_recurso;
					}elseif($intRolId == RADMINPROMOCION){
						$ruta=base_url().'/Assets/recursos/Promocion/'.$nombre_recurso;
					}elseif($intRolId == RADMINRECURSOSHUMANOS){
						$ruta=base_url().'/Assets/recursos/Capital/'.$nombre_recurso;
					}else{
						$ruta=base_url().'/Assets/recursos/General/'.$nombre_recurso;
					}

					if($intIdRecurso == 0)
					{
						//Crear
						$strTipoMovimiento = 'Alta';
						if($_SESSION['permisosMod']['w']){
							$request_recurso = $this->model->insertRecurso($strNombre, $nombre_recurso, $ruta, $strExtension, $imagen, $intRolId, $strModificador, $strTipoMovimiento);
							$option = 1;
						}
					}else{
						//Actualizar
						if($_SESSION['permisosMod']['u']){
							/*if($nombre_foto == ''){
								if($_POST['foto_actual'] != 'portada_categoria.png' && $_POST['foto_remove'] == 0 ){
									$imgPortada = $_POST['foto_actual'];
								}
							}
							$request_recurso = $this->model->updateCategoria($intIdcategoria,$strCategoria, $strDescipcion,$imgPortada,$ruta,$intStatus);
							$option = 2;*/
						}
					}
					if($request_recurso > 0 )
					{
						if($option == 1)
						{
							$strCarpeta = '';
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
							if($nombre_recurso != '')
							{ 
								if($intRolId == RADMINISTRADOR){
									if(is_dir('Assets/recursos/Tecnologia'))
									{
										$strCarpeta = 'Tecnologia';
										uploadRecurso($archivo,$nombre_recurso,$strCarpeta);
									}
								}elseif($intRolId == RRECTORIA){
									if(is_dir('Assets/recursos/Rectoria'))
									{
										$strCarpeta = 'Rectoria';
										uploadRecurso($archivo,$nombre_recurso,$strCarpeta);
									}
								}elseif($intRolId == RADMINESCOLARES || $intRolId == RAUXESCOLARES){
									if(is_dir('Assets/recursos/Escolares'))
									{
										$strCarpeta = 'Escolares';
										uploadRecurso($archivo,$nombre_recurso,$strCarpeta);
									}
								}elseif($intRolId == RADMINBACHILLERATO){
									if(is_dir('Assets/recursos/Bachillerato'))
									{
										$strCarpeta = 'Bachillerato';
										uploadRecurso($archivo,$nombre_recurso,$strCarpeta);
									}
								}elseif($intRolId == RADMINLICENCIATURA){
									if(is_dir('Assets/recursos/Licenciatura'))
									{
										$strCarpeta = 'Licenciatura';
										uploadRecurso($archivo,$nombre_recurso,$strCarpeta);
									}
								}elseif($intRolId == RADMININGENIERIA){
									if(is_dir('Assets/recursos/Ingenieria'))
									{
										$strCarpeta = 'Ingenieria';
										uploadRecurso($archivo,$nombre_recurso,$strCarpeta);
									}
								}elseif($intRolId == RADMINPOSGRADO){
									if(is_dir('Assets/recursos/Posgrado'))
									{
										$strCarpeta = 'Posgrado';
										uploadRecurso($archivo,$nombre_recurso,$strCarpeta);
									}
								}elseif($intRolId == RADMINFINANCIEROS || $intRolId == RAUXFINANCIEROS){
									if(is_dir('Assets/recursos/Financieros'))
									{
										$strCarpeta = 'Financieros';
										uploadRecurso($archivo,$nombre_recurso,$strCarpeta);
									}
								}elseif($intRolId == RADMINVINCULACION){
									if(is_dir('Assets/recursos/Vinculacion'))
									{
										$strCarpeta = 'Vinculacion';
										uploadRecurso($archivo,$nombre_recurso,$strCarpeta);
									}
								}elseif($intRolId == RADMINPROMOCION){
									if(is_dir('Assets/recursos/Promocion'))
									{
										$strCarpeta = 'Promocion';
										uploadRecurso($archivo,$nombre_recurso,$strCarpeta);
									}
								}elseif($intRolId == RADMINRECURSOSHUMANOS){
									if(is_dir('Assets/recursos/Capital'))
									{
										$strCarpeta = 'Capital';
										uploadRecurso($archivo,$nombre_recurso,$strCarpeta);
									}
								}else{
									if(is_dir('Assets/recursos/General'))
									{
										$strCarpeta = 'General';
										uploadRecurso($archivo,$nombre_recurso,$strCarpeta);
									}
								}
							}
						}else{
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
						}
					}else if($request_recurso == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! El recurso ya existe.');
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getRecursos()
		{
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectRecursos();
				return $arrData;
			}
			die();
		}

		public function getRecurso($strBuscar)
		{
			if($_SESSION['permisosMod']['r']){
				$strBusqueda = strClean($strBuscar);
				$arrData = $this->model->selectRecurso($strBusqueda);
				if(empty($arrData))
				{
					$arrResponse = array('status' => false, 'msg' => 'No se encontraron coincidencias.');
				}else{
					$arrResponse = array('status' => true, 'data' => $arrData);
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function delRecurso()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdRecurso = intval($_POST['idRecurso']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$intRolId = $_SESSION['userData']['idrol'];
					$requestRecurso = $this->model->buscarRecurso($intIdRecurso);
					$nombre=$requestRecurso['nombre_recurso'];
					//$nombre=explode('/', $requestRecurso['ruta'])[7];
					$requestDelete = $this->model->deleteRecurso($intIdRecurso, $strModificador);
					if(intval($requestDelete) > 0)
					{
						if($intRolId == RADMINISTRADOR){
							if(is_dir('Assets/recursos/Tecnologia') && $nombre != '')
							{
								$strCarpeta = 'Tecnologia';
								deleteRecurso($nombre,$strCarpeta);
							}
						}elseif($intRolId == RRECTORIA){
							if(is_dir('Assets/recursos/Rectoria') && $nombre != '')
							{
								$strCarpeta = 'Rectoria';
								deleteRecurso($nombre,$strCarpeta);
							}
						}elseif($intRolId == RADMINESCOLARES || $intRolId == RAUXESCOLARES){
							if(is_dir('Assets/recursos/Escolares') && $nombre != '')
							{
								$strCarpeta = 'Escolares';
								deleteRecurso($nombre,$strCarpeta);
							}
						}elseif($intRolId == RADMINBACHILLERATO){
							if(is_dir('Assets/recursos/Bachillerato'))
							{
								$strCarpeta = 'Bachillerato';
								deleteRecurso($nombre,$strCarpeta);
							}
						} elseif($intRolId == RADMINLICENCIATURA){
							if(is_dir('Assets/recursos/Licenciatura'))
							{
								$strCarpeta = 'Licenciatura';
								deleteRecurso($nombre,$strCarpeta);
							}
						}elseif($intRolId == RADMININGENIERIA){
							if(is_dir('Assets/recursos/Ingenieria'))
							{
								$strCarpeta = 'Ingenieria';
								deleteRecurso($nombre,$strCarpeta);
							}
						} elseif($intRolId == RADMINPOSGRADO){
							if(is_dir('Assets/recursos/Posgrado'))
							{
								$strCarpeta = 'Posgrado';
								deleteRecurso($nombre,$strCarpeta);
							}
						}elseif($intRolId == RADMINFINANCIEROS || $intRolId == RAUXFINANCIEROS){
							if(is_dir('Assets/recursos/Financieros'))
							{
								$strCarpeta = 'Financieros';
								deleteRecurso($nombre,$strCarpeta);
							}
						}  elseif($intRolId == RADMINVINCULACION){
							if(is_dir('Assets/recursos/Vinculacion'))
							{
								$strCarpeta = 'Vinculacion';
								deleteRecurso($nombre,$strCarpeta);
							}
						}elseif($intRolId == RADMINPROMOCION){
							if(is_dir('Assets/recursos/Promocion'))
							{
								$strCarpeta = 'Promocion';
								deleteRecurso($nombre,$strCarpeta);
							}
						}elseif($intRolId == RADMINRECURSOSHUMANOS){
							if(is_dir('Assets/recursos/Capital'))
							{
								$strCarpeta = 'Capital';
								deleteRecurso($nombre,$strCarpeta);
							}
						}else{
							if(is_dir('Assets/recursos/General'))
							{
								$strCarpeta = 'General';
								deleteRecurso($nombre,$strCarpeta);
							}
						}
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente el recurso');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al eliminar el recurso. Intente mas tarde.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

	}

 ?>