<?php 

	class Reinscripciones extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MREINSCRIPCIONES);
		}

		public function Reinscripciones()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Reinscripciones";
			$data['page_title'] = "REINSCRIPCIONES <small>UAF</small>";
			$data['page_name'] = "reinscripciones";
			$data['page_functions_js'] = "functions_reinscripciones.js";
			$data['datos'] = $this->model->selectDatosPersonales();
			/*dep($_SESSION['userData']);
			dep($data['datos']);
			exit;*/
			$this->views->getView($this,"reinscripciones",$data);
		}

		public function setReinscripcion(){
			if($_POST){	
				
				if(empty($_POST['txtNombres']) || empty($_POST['txtApellidos']) || empty($_POST['txtFechaNacimiento']) || empty($_POST['txtCurp']) || empty($_POST['txtTelefonoCelular']) || empty($_POST['txtTelefonoFijo']) || empty($_POST['txtEmail']) || empty($_POST['txtCalle']) || empty($_POST['txtNumeroExterior']) || empty($_POST['txtColonia']) || empty($_POST['txtLocalidad']) || empty($_POST['txtSemestreActual']) || empty($_POST['txtSemestreNuevo']))
				{
					$arrResponse = array("status" => false, "msg" => 'Llenar todos los campos obligatorios.');
				}else{ 
					$idPersona = intval($_POST['txtIdPersona']);
					$idAlumno = intval($_POST['txtIdAlumno']);
					$strNombres = mb_strtoupper(strClean($_POST['txtNombres'], 'UTF-8'));
					$strApellidos = mb_strtoupper(strClean($_POST['txtApellidos'], 'UTF-8'));
					$strFechaNacimiento = strClean($_POST['txtFechaNacimiento']);
					$strCurp = mb_strtoupper(strClean($_POST['txtCurp']), 'UTF-8');
					$strTelefonoCelular =  strClean($_POST['txtTelefonoCelular']);
					$strTelefonoFijo =  strClean($_POST['txtTelefonoFijo']);
					$strEmail = strClean($_POST['txtEmail']);
					$strCalle = ucwords(strClean($_POST['txtCalle']));
					$strNumeroExterior = strClean($_POST['txtNumeroExterior']);
					$strNumeroInterior = strClean($_POST['txtNumeroInterior']);
					$strColonia = ucwords(strClean($_POST['txtColonia']));
					$strLocalidad = ucwords(strClean($_POST['txtLocalidad']));
					$strNombreTutor = mb_strtoupper(strClean($_POST['txtNombreTutor'], 'UTF-8'));
					$strTelefonoTutor = strClean($_POST['txtTelefonoTutor']);
					$strNombreEmpresa = strClean($_POST['txtNombreEmpresa']);
					$strTelefonoEmpresa = strClean($_POST['txtTelefonoEmpresa']);
					$intSemestreActual = intval($_POST['txtSemestreActual']);
					$intSemestreNuevo = intval($_POST['txtSemestreNuevo']);
					$requestReinscripcion = "";

					/*dep("ID PERSONA: ".$idPersona);
					dep("ID ALUMNO: ".$idAlumno);
					dep("NOMBRES: ".$strNombres);
					dep("APELLIDOS: ".$strApellidos);
					dep("FECHA NACIMIENTO: ".$strFechaNacimiento);
					dep("CURP: ".$strCurp);
					dep("TEL. CELULAR: ".$strTelefonoCelular);
					dep("TEL. FIJO: ".$strTelefonoFijo);
					dep("EMAIL: ".$strEmail);
					dep("CALLE: ".$strCalle);
					dep("NO. EXTERIOR: ".$strNumeroExterior);
					dep("NO. INTERIOR: ".$strNumeroInterior);
					dep("COLONIA: ".$strColonia);
					dep("LOCALIDAD: ".$strLocalidad);
					dep("NOMBRE TUTOR: ".$strNombreTutor);
					dep("TEL. TUTOR: ".$strTelefonoTutor);
					dep("EMPRESA: ".$strNombreEmpresa);
					dep("TEL. EMPRESA: ".$strTelefonoEmpresa);
					dep("SEMESTRE ACTUAL: ".$intSemestreActual);
					dep("NUEVO SEMESTRE: ".$intSemestreNuevo);
					exit;*/

					if($idAlumno != '')
					{
						if($_SESSION['permisosMod']['w']){
							$requestReinscripcion = $this->model->updateReinscripcion($idPersona,
																		$idAlumno, 
																		$strNombres,
																		$strApellidos,
																		$strFechaNacimiento, 
																		$strCurp,
																		$strTelefonoCelular,
																		$strTelefonoFijo,
																		$strEmail,
																		$strCalle,
																		$strNumeroExterior,
																		$strNumeroInterior,
																		$strColonia, 
																		$strLocalidad,
																		$strNombreTutor,
																		$strTelefonoTutor, 
																		$strNombreEmpresa,
																		$strTelefonoEmpresa,
																		$intSemestreActual,
																		$intSemestreNuevo);
						}
					}

					if(intval($requestReinscripcion) > 0 )
					{
						$arrResponse = array('status' => true, 'msg' => 'Reinscripción generada exitosamente.');
						
					}else if($requestReinscripcion == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! Este email ya se encuentra registrado en el sistema.');		
					}else if($requestReinscripcion == 'reinscrito'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! Ya haz cumplido con este proceso de reinscripción.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getMaterias()
		{
			if($_SESSION['permisosMod']['r']){
				
				$arrData = $this->model->selectMaterias();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					if($arrData[$i]['status'] == 1)
					{
						$arrData[$i]['status'] = '<span class="badge badge-success">Activo</span>';
					}else{
						$arrData[$i]['status'] = '<span class="badge badge-danger">Inactivo</span>';
					}

					if($_SESSION['permisosMod']['r']){
						$btnView = '<button class="btn btn-info btn-sm btnViewMateria" onClick="fntViewMateria('.$arrData[$i]['idmateria'].')" title="Ver materia"><i class="far fa-eye"></i></button>';
					}
					if($_SESSION['permisosMod']['u']){
						$btnEdit = '<button class="btn btn-primary  btn-sm btnEditMateria" onClick="fntEditMateria(this,'.$arrData[$i]['idmateria'].')" title="Editar materia"><i class="fas fa-pencil-alt"></i></button>';
					}
					if($_SESSION['permisosMod']['d']){
						
						$btnDelete = '<button class="btn btn-danger btn-sm btnDelMateria" onClick="fntDelMateria('.$arrData[$i]['idmateria'].')" title="Eliminar materia"><i class="far fa-trash-alt"></i></button>';
			
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getMateria($idmateria){
			if($_SESSION['permisosMod']['r']){
				$intIdMateria = intval($idmateria);
				if(intval($intIdMateria) > 0)
				{
					$arrData = $this->model->selectMateria($intIdMateria);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delMateria()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdMateria = intval($_POST['idmateria']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$requestDelete = $this->model->deleteMateria($intIdMateria, $strModificador);
					if(intval($requestDelete)>0)
					{
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente la materia');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar la materia.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}
	}
 ?>