<?php 

	class Respaldos extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MRESPALDOS);
		}

		public function Respaldos()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Respaldos";
			$data['page_title'] = "RESPALDOS <small>UAF</small>";
			$data['page_name'] = "RESPALDOS";
			$data['page_functions_js'] = "functions_RESPALDOS.js";
			$data['usuarios'] = $this->model->selectUsuarios();
			$this->views->getView($this,"RESPALDOS",$data);
		}

		public function setRespaldo(){
			if($_POST){	
				
				if(empty($_POST['listUsuarios']) || empty($_POST['txtFecha']) || empty($_POST['listStatus']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incompletos.');
				}else{ 
					$idRespaldo = intval($_POST['idRespaldo']);
					$intPersonaId = strClean($_POST['listUsuarios']);
					$strFecha = strClean($_POST['txtFecha']);
					$strComentarios = strClean($_POST['txtComentarios']);
					$intStatus = strClean($_POST['listStatus']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$strTipoMovimiento = '';
					$requestRespaldo = "";

					if($idRespaldo == 0)
					{
						$option = 1;
						$strEstado = "Pendiente";
						$strTipoMovimiento = 'Alta';
						if($_SESSION['permisosMod']['w']){
							$requestRespaldo = $this->model->insertRespaldo($intPersonaId,
																		$strFecha,
																		$strComentarios,
																		$strModificador,
																		$strTipoMovimiento,
																		$intStatus);
						}
					}else{
						$option = 2;
						$strTipoMovimiento = 'Actualización';
						if($_SESSION['permisosMod']['u']){
							$requestRespaldo = $this->model->updateRespaldo($idRespaldo,
																		$intPersonaId,
																		$strFecha,
																		$strComentarios,
																		$strModificador,
																		$strTipoMovimiento,
																		$intStatus);
						}

					}

					if(intval($requestRespaldo) > 0 )
					{
						if($option == 1){
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
						}else{
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
						}
					}else if($requestNivel == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! Este respalgo ya se encuentra registrado en el sistema.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getRespaldos()
		{
			if($_SESSION['permisosMod']['r']){
				
				$arrData = $this->model->selectRespaldos();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					if($arrData[$i]['status'] == 1)
					{
						$arrData[$i]['status'] = '<span class="badge badge-success">Activo</span>';
					}else{
						$arrData[$i]['status'] = '<span class="badge badge-danger">Activo</span>';
					}

					if($_SESSION['permisosMod']['r']){
						$btnView = '<button class="btn btn-info btn-sm btnViewRespaldo" onClick="fntViewRespaldo('.$arrData[$i]['idrespaldo'].')" title="Ver respaldo"><i class="far fa-eye"></i></button>';
					}
					if($_SESSION['permisosMod']['u']){
						$btnEdit = '<button class="btn btn-primary btn-sm btnEditRespaldo" onClick="fntEditRespaldo(this,'.$arrData[$i]['idrespaldo'].')" title="Editar respaldo"><i class="fas fa-pencil-alt"></i></button>';
					}
					if($_SESSION['permisosMod']['d']){
						
						$btnDelete = '<button class="btn btn-danger btn-sm btnDelRespaldo" onClick="fntDelRespaldo('.$arrData[$i]['idrespaldo'].')" title="Eliminar respaldo"><i class="far fa-trash-alt"></i></button>';
			
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getRespaldo($idrespaldo){
			if($_SESSION['permisosMod']['r']){
				$intIdRespaldo = intval($idrespaldo);
				if(intval($intIdRespaldo) > 0)
				{
					$arrData = $this->model->selectRespaldo($intIdRespaldo);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delRespaldo()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdRespaldo = intval($_POST['idrespaldo']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$requestDelete = $this->model->deleteRespaldo($intIdRespaldo, $strModificador);
					if(intval($requestDelete) > 0)
					{
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente el registro');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar el registro.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}
	}
 ?>