<?php 

	class Solicitudes extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MSOLICITUDES);
		}

		public function Solicitudes()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Solicitudes";
			$data['page_title'] = "SOLICITUDES <small>UAF</small>";
			$data['page_name'] = "solicitudes";
			$data['page_functions_js'] = "functions_solicitudes.js";
			$this->views->getView($this,"solicitudes",$data);
		}

		public function setSolicitud(){
			if($_POST){	
				
				if(empty($_POST['txtSolicitante']) || empty($_POST['txtDescripcion']) || empty($_POST['txtFecha']) || empty($_POST['listEstado']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{ 
					$idSolicitud = intval($_POST['idSolicitud']);
					$strSolicitante = mb_strtoupper(strClean($_POST['txtSolicitante']), 'UTF-8');
					$strDescripcion = ucfirst(strClean($_POST['txtDescripcion']));
					$strFecha = strClean($_POST['txtFecha']);
					$strComentarios = strClean($_POST['txtComentarios']);
					$strEstado = strClean($_POST['listEstado']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$strTipoMovimiento = '';
					$requestSolicitud = "";

					if($idSolicitud == 0)
					{
						$option = 1;
						$strEstado = "Pendiente";
						$strTipoMovimiento = 'Alta';
						if($_SESSION['permisosMod']['w']){
							$requestSolicitud = $this->model->insertSolicitud($strSolicitante,
																		$strDescripcion, 
																		$strFecha,
																		$strComentarios,
																		$strEstado, 
																		$strModificador,
																		$strTipoMovimiento);
						}
					}else{
						$option = 2;
						$strTipoMovimiento = 'Actualización';
						if($_SESSION['permisosMod']['u']){
							$requestSolicitud = $this->model->updateSolicitud($idSolicitud,
																		$strSolicitante,
																		$strDescripcion, 
																		$strFecha,
																		$strComentarios,
																		$strEstado, 
																		$strModificador,
																		$strTipoMovimiento);
						}

					}

					if(intval($requestSolicitud) > 0 )
					{
						if($option == 1){
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
						}else{
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
						}
					}else if($requestNivel == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! Esta solicitud ya se encuentra registrado en el sistema.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getSolicitudes()
		{
			if($_SESSION['permisosMod']['r']){
				
				$arrData = $this->model->selectSolicitudes();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					if($arrData[$i]['estado'] == "Terminado")
					{
						$arrData[$i]['btnEstado'] = '<span class="badge badge-success">Terminado</span>';
					}else{
						$arrData[$i]['btnEstado'] = '<span class="badge badge-warning">Pendiente</span>';
					}

					if($_SESSION['permisosMod']['r']){
						$btnView = '<button class="btn btn-info btn-sm btnViewSolicitud" onClick="fntViewSolicitud('.$arrData[$i]['idsolicitud'].')" title="Ver solicitud"><i class="far fa-eye"></i></button>';
					}
					if($_SESSION['permisosMod']['u']){
						$btnEdit = '<button class="btn btn-primary btn-sm btnEditSolicitud" onClick="fntEditSolicitud(this,'.$arrData[$i]['idsolicitud'].')" title="Editar solicitud"><i class="fas fa-pencil-alt"></i></button>';
					}
					if($_SESSION['permisosMod']['d']){
						
						$btnDelete = '<button class="btn btn-danger btn-sm btnDelSolicitud" onClick="fntDelSolicitud('.$arrData[$i]['idsolicitud'].')" title="Eliminar solicitud"><i class="far fa-trash-alt"></i></button>';
			
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getSolicitud($idsolicitud){
			if($_SESSION['permisosMod']['r']){
				$intIdSolicitud = intval($idsolicitud);
				if(intval($intIdSolicitud) > 0)
				{
					$arrData = $this->model->selectSolicitud($intIdSolicitud);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delSolicitud()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdSolicitud = intval($_POST['idsolicitud']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$requestDelete = $this->model->deleteSolicitud($intIdSolicitud, $strModificador);
					if(intval($requestDelete) > 0)
					{
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente el registro');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar el registro.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}
	}
 ?>