<?php 

	class Usuarios extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MUSUARIOS);
		}

		public function Usuarios()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Usuarios";
			$data['page_title'] = "USUARIOS <small> UAF</small>";
			$data['page_name'] = "usuarios";
			$data['page_functions_js'] = "functions_usuarios.js?v=<?= time();";
			$this->views->getView($this,"usuarios",$data);
		}

		public function setUsuario(){
			if($_POST){	

				/*dep("No Empleado: ".$_POST['txtIdentificador']);	
				dep("Nombres: ".$_POST['txtNombre']);	
				dep("Apellidos: ".$_POST['txtApellido']);	
				dep("Email: ".$_POST['txtEmail']);	
				dep("ID Rol: ".$_POST['listRolid']);	
				dep("Estatus: ".$_POST['listStatus']);
				exit;*/
				if(empty($_POST['txtIdentificador']) || empty($_POST['txtNombre']) || empty($_POST['txtApellido']) || empty($_POST['txtEmail']) || empty($_POST['listRolid']) || empty($_POST['listStatus']) )
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{ 
					$idUsuario = intval($_POST['idUsuario']);
					$strIdentificador = strClean($_POST['txtIdentificador']);
					$strNombre = mb_strtoupper(strClean($_POST['txtNombre'], 'UTF-8'));
					$strApellido = mb_strtoupper(strClean($_POST['txtApellido'], 'UTF-8'));
					$strEmail = strtolower(strClean($_POST['txtEmail']));
					$intTipoId = intval(strClean($_POST['listRolid']));
					$strDireccion = strClean($_POST['txtDireccion']);
					$strTelefono = strClean($_POST['txtTelefono']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$strTipoMovimiento = '';
					$intStatus = intval(strClean($_POST['listStatus']));
					$request_user = "";

					$foto   	 	= $_FILES['foto'];
					$nombre_foto 	= $foto['name'];
					$type 		 	= $foto['type'];
					$url_temp    	= $foto['tmp_name'];
					$nombreImagen 	= 'avatar.png';
					$request_cateria = "";
					if($nombre_foto != ''){
						$nombreImagen = 'foto_'.$strNombre.' '.$strApellido.'_'.rand(1,10000).'_'.$nombre_foto;
					}


					if($idUsuario == 0)
					{
						$option = 1;
						$strTipoMovimiento = 'Alta';
						$strPassword =  empty($_POST['txtPassword']) ? hash("SHA256",passGenerator()) : hash("SHA256",$_POST['txtPassword']);

						if($_SESSION['permisosMod']['w']){
							$request_user = $this->model->insertUsuario($strIdentificador,
																			$nombreImagen,
																			$strNombre, 
																			$strApellido, 
																			$strEmail,
																			$strPassword, 
																			$intTipoId,
																			$strDireccion, 
																			$strTelefono, 
																			$strModificador, 
																			$strTipoMovimiento,
																			$intStatus);
						}
					}else{
						$option = 2;
						if($nombre_foto == ''){
							if($_POST['foto_actual'] != 'avatar.png' AND $_POST['foto_remove'] == 0 ){
								$nombreImagen = $_POST['foto_actual'];
							}
							if($nombre_foto == '' AND $_POST['foto_remove'] == 1 AND $_POST['foto_actual'] != '')
							{
								$nombreImagen = $_POST['foto_actual'];
							}
						}
						$strTipoMovimiento = 'Actualización';
						$strPassword =  empty($_POST['txtPassword']) ? "" : hash("SHA256",$_POST['txtPassword']);
						if($_SESSION['permisosMod']['u']){
							$request_user = $this->model->updateUsuario($idUsuario,
																			$strIdentificador,
																			$nombreImagen, 
																			$strNombre,
																			$strApellido, 
																			$strEmail,
																			$strPassword, 
																			$intTipoId,
																			$strDireccion, 
																			$strTelefono, 
																			$strModificador, 
																			$strTipoMovimiento,
																			$intStatus);
						}

					}

					if(intval($request_user) > 0 )
					{
						if($option == 1){
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
							if($nombre_foto != "")
							{
								if(is_dir('Assets/fotos_usuarios'))
								{
									uploadFoto($foto,$nombreImagen);
								}else{
									mkdir("Assets/fotos_usuarios/", 0777);
									uploadFoto($foto,$nombreImagen);
								}
							}
						}else{
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
							if($nombre_foto != "" && $nombreImagen!='avatar.png')
							{
								if(is_dir('Assets/fotos_usuarios'))
								{
									uploadFoto($foto,$nombreImagen);
									if($_POST['foto_actual'] != 'avatar.png'){
										deleteFoto($_POST['foto_actual']);
									}
								}else{
									mkdir("Assets/fotos_usuarios/", 0777);
									uploadFoto($foto,$nombreImagen);
									if($_POST['foto_actual'] != 'avatar.png'){
										deleteFoto($_POST['foto_actual']);
									}
								}
							}
						}
					}else if($request_user == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! el email o la identificación ya existe, ingrese otro.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getUsuarios()
		{
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectUsuarios();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					if($arrData[$i]['status'] == 1)
					{
						$arrData[$i]['status'] = '<span class="badge badge-success">Activo</span>';
					}else{
						$arrData[$i]['status'] = '<span class="badge badge-danger">Inactivo</span>';
					}

					if($_SESSION['permisosMod']['r']){
						$btnView = '<button class="btn btn-info btn-sm btnViewUsuario" onClick="fntViewUsuario('.$arrData[$i]['idpersona'].')" title="Ver usuario"><i class="far fa-eye"></i></button>';
					}
					if($_SESSION['permisosMod']['u']){
						if(($_SESSION['idUser'] == 1 and $_SESSION['userData']['idrol'] == 1) ||
							($_SESSION['userData']['idrol'] == 1 and $arrData[$i]['idrol'] != 1) ){
							if($arrData[$i]['idrol'] != RALUMNO AND $arrData[$i]['idrol'] != RDOCENTE)
							{
								$btnEdit = '<button class="btn btn-primary  btn-sm btnEditUsuario" onClick="fntEditUsuario(this,'.$arrData[$i]['idpersona'].')" title="Editar usuario"><i class="fas fa-pencil-alt"></i></button>';
							}else{
								$btnEdit = '<button class="btn btn-secondary btn-sm" disabled ><i class="fas fa-pencil-alt"></i></button>';
							}
							
						}else{
							$btnEdit = '<button class="btn btn-secondary btn-sm" disabled ><i class="fas fa-pencil-alt"></i></button>';
						}
					}
					if($_SESSION['permisosMod']['d']){
						if(($_SESSION['idUser'] == 1 and $_SESSION['userData']['idrol'] == 1) ||
							($_SESSION['userData']['idrol'] == 1 and $arrData[$i]['idrol'] != 1) and
							($_SESSION['userData']['idpersona'] != $arrData[$i]['idpersona'] )
							 ){
							$btnDelete = '<button class="btn btn-danger btn-sm btnDelUsuario" onClick="fntDelUsuario('.$arrData[$i]['idpersona'].')" title="Eliminar usuario"><i class="far fa-trash-alt"></i></button>';
						}else{
							$btnDelete = '<button class="btn btn-secondary btn-sm" disabled ><i class="far fa-trash-alt"></i></button>';
						}
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getUsuario($idpersona){
			if($_SESSION['permisosMod']['r']){
				$idusuario = intval($idpersona);
				if($idusuario > 0)
				{
					$arrData = $this->model->selectUsuario($idusuario);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrData['url_foto'] = media().'/fotos_usuarios/'.$arrData['foto'];
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delUsuario()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdpersona = intval($_POST['idUsuario']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$requestRol = $this->model->selectRol($intIdpersona);
					$requestFoto = $this->model->buscarFoto($intIdpersona);
					$foto=$requestFoto['foto'];
					$requestDelete = $this->model->deleteUsuario($intIdpersona, $strModificador, $requestRol['rolid']);
					if(intval($requestDelete)>0)
					{
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente el usuario');
						if(is_dir('Assets/fotos_usuarios') AND $foto != '' AND $foto != 'avatar.png')
						{
							deleteFoto($foto);
						}
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al eliminar el usuario.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function listSupervisor()
		{
			$htmlOptions = "";
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectUsuarios();
				
					if(count($arrData) > 0 ){
						for ($i=0; $i < count($arrData); $i++) { 
							if($arrData[$i]['idrol']==2 && $arrData[$i]['status']==1)
							{
								$htmlOptions .= '<option value="'.$arrData[$i]['nombres'].' '.$arrData[$i]['apellidos'].'">'.$arrData[$i]['nombres'].' '.$arrData[$i]['apellidos'].'</option>';
							}
						}
					}
					echo $htmlOptions;
			}
			die();
		}

		public function getAlumno($idpersona){
			$idAlumno = intval($idpersona);
			if($idAlumno > 0)
			{
				$arrData = $this->model->selectAlumno($idAlumno);
				if(empty($arrData))
				{
					$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
				}else{
					$arrData['url_foto'] = media().'/fotos_usuarios/'.$arrData['foto'];
					$arrResponse = array('status' => true, 'data' => $arrData);
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function perfil(){
			$data['page_tag'] = "Perfil";
			$data['page_title'] = "Perfil de usuario";
			$data['page_name'] = "perfil";
			$data['page_functions_js'] = "functions_usuarios.js";
			$data['dataUser'] = $this->model->selectAlumno($_SESSION['userData']['idpersona']);
			//dep($_SESSION['userData']);
			$this->views->getView($this,"perfil",$data);
		}

		public function putPerfil(){
			if($_POST){
				if(empty($_POST['txtNombre']) || empty($_POST['txtApellido'])  || empty($_POST['txtEmail']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{
					$idUsuario = $_SESSION['idUser'];
					$strNombre = mb_strtoupper(strClean($_POST['txtNombre'], 'UTF-8'));
					$strApellido = mb_strtoupper(strClean($_POST['txtApellido'], 'UTF-8'));
					$strEmail = strtolower(strClean($_POST['txtEmail']));
					$strPassword = "";
					$strDireccion = strClean($_POST['txtDireccion']);
					$strTelefono = strClean($_POST['txtTelefono']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$strTipoMovimiento = 'Actualización';

					$foto   	 	= $_FILES['foto'];
					$nombre_foto 	= $foto['name'];
					$type 		 	= $foto['type'];
					$url_temp    	= $foto['tmp_name'];
					$nombreImagen 	= 'avatar.png';
					$request_cateria = "";
					if($nombre_foto != ''){
						$nombreImagen = 'foto_'.$strNombre.' '.$strApellido.'_'.rand(1,10000).'_'.$nombre_foto;
					}
					
					if(!empty($_POST['txtPassword'])){
						$strPassword = hash("SHA256",$_POST['txtPassword']);
					}
					if($nombre_foto == ''){
						if($_POST['foto_actual'] != 'avatar.png' AND $_POST['foto_remove'] == 0 ){
							$nombreImagen = $_POST['foto_actual'];
						}
						if($nombre_foto == '' AND $_POST['foto_remove'] == 1 AND $_POST['foto_actual'] != '')
						{
							$nombreImagen = $_POST['foto_actual'];
						}
					}
					$request_user = $this->model->updatePerfil($idUsuario,
																$nombreImagen,
																$strNombre,
																$strApellido, 
																$strEmail,
																$strPassword,
																$strDireccion,
																$strTelefono,
																$strModificador,
																$strTipoMovimiento);
					if($request_user)
					{
						$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
						$arrData = $this->model->sessionLogin($_SESSION['idUser']);
						if($nombre_foto != "" && $nombreImagen!='avatar.png')
						{
							if(is_dir('Assets/fotos_usuarios'))
							{
								uploadFoto($foto,$nombreImagen);
								if($_POST['foto_actual'] != 'avatar.png'){
									deleteFoto($_POST['foto_actual']);
								}
							}else{
								mkdir("Assets/fotos_usuarios/", 0777);
								uploadFoto($foto,$nombreImagen);
								if($_POST['foto_actual'] != 'avatar.png'){
									deleteFoto($_POST['foto_actual']);
								}
							}
						}
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible actualizar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function perfilAlumno(){
			$data['page_tag'] = "Perfil";
			$data['page_title'] = "Perfil de alumno";
			$data['page_name'] = "perfil";
			$data['page_functions_js'] = "functions_usuarios.js";
			$data['dataAlumno'] = $this->model->selectAlumno($_SESSION['userData']['idpersona']);
			$data['adeudosAlumno'] = $this->model->selectAdeudosAlumno($data['dataAlumno']['idalumno']);
			/*dep($data['adeudosAlumno']);
			exit;*/
			$this->views->getView($this,"perfilAlumno",$data);
		}

		public function putPerfilAlumno()
		{
			if($_POST){
				if(empty($_POST['txtEmail']) || empty($_POST['txtNombre']) || empty($_POST['txtApellido']) || empty($_POST['txtTelefonoCelular']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{
					$idUsuario = $_SESSION['idUser'];
					$strNombre = mb_strtoupper(strClean($_POST['txtNombre'], 'UTF-8'));
					$strApellido = mb_strtoupper(strClean($_POST['txtApellido'], 'UTF-8'));
					$strPassword = "";
					$strTelefonoCelular = strClean($_POST['txtTelefonoCelular']);
					$strTelefonoFijo = strClean($_POST['txtTelefonoFijo']);
					$strEmail = strtolower(strClean($_POST['txtEmail']));
					$strCalle = strClean($_POST['txtCalle']);
					$strNumeroExterior = strClean($_POST['txtNumeroExterior']);
					$strNumeroInterior = strClean($_POST['txtNumeroInterior']);
					$strLocalidad = strClean($_POST['txtLocalidad']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$strTipoMovimiento = 'Actualización';

					$foto   	 	= $_FILES['foto'];
					$nombre_foto 	= $foto['name'];
					$type 		 	= $foto['type'];
					$url_temp    	= $foto['tmp_name'];
					$nombreImagen 	= 'avatar.png';
					$request_cateria = "";
					if($nombre_foto != ''){
						$nombreImagen = 'foto_'.$strNombre.' '.$strApellido.'_'.rand(1,10000).'_'.$nombre_foto;
					}
					
					if(!empty($_POST['txtPassword'])){
						$strPassword = hash("SHA256",$_POST['txtPassword']);
					}
					if($nombre_foto == ''){
						if($_POST['foto_actual'] != 'avatar.png' AND $_POST['foto_remove'] == 0 ){
							$nombreImagen = $_POST['foto_actual'];
						}
						if($nombre_foto == '' AND $_POST['foto_remove'] == 1 AND $_POST['foto_actual'] != '')
						{
							$nombreImagen = $_POST['foto_actual'];
						}
					}
					$request_user = $this->model->updatePerfilAlumno($idUsuario,
																$nombreImagen,
																$strNombre,
																$strApellido, 
																$strPassword,
																$strTelefonoCelular,
																$strTelefonoFijo,
																$strEmail,
																$strCalle,
																$strNumeroExterior,
																$strNumeroInterior,
																$strLocalidad,
																$strModificador,
																$strTipoMovimiento);
					if($request_user)
					{
						$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
						$arrData = $this->model->sessionLogin($_SESSION['idUser']);
						if($nombre_foto != "" && $nombreImagen!='avatar.png')
						{
							if(is_dir('Assets/fotos_usuarios'))
							{
								uploadFoto($foto,$nombreImagen);
								if($_POST['foto_actual'] != 'avatar.png'){
									deleteFoto($_POST['foto_actual']);
								}
							}else{
								mkdir("Assets/fotos_usuarios/", 0777);
								uploadFoto($foto,$nombreImagen);
								if($_POST['foto_actual'] != 'avatar.png'){
									deleteFoto($_POST['foto_actual']);
								}
							}
						}
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible actualizar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getRoles()
		{
			$htmlOptions = "";
			$arrData = $this->model->selectRoles();
			if(count($arrData) > 0 ){
				for ($i=0; $i < count($arrData); $i++) { 
					if($arrData[$i]['status'] == 1 ){
					$htmlOptions .= '<option value="'.$arrData[$i]['idrol'].'">'.$arrData[$i]['nombre_rol'].'</option>';
					}
				}
			}
			echo $htmlOptions;
			die();		
		}

	}

 ?>