<?php 

	class Actualizar_semestreModel extends Mysql
	{
		private $intIdCarrera;
		private $intIdAlumno;
		private $strCarrera;
		private $intGrupoId;
		private $arrayAlumnos;
		private $intGrupoIdConsecutivo;
		private $strRevision;
		private $intNivelId;
		private $strModalidad;
		private $intPersonaId;
		private $strDatecreated;
		private $strNuevoSemestre;
		private $intStatus;

		public function __construct()
		{
			parent::__construct();
		}	

		public function selectGrupos()
		{
			$sql = "SELECT CONCAT(grado,'-',grupo) AS grupo_format, idgrupo, grado, grupo 
					FROM grupos
					WHERE status != 0";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectBusqueda(int $grupoid){
			$this->intGrupoId = $grupoid;
			$sql = "SELECT CONCAT(a.nombres,' ',a.apellidos) AS nombre_alumno, a.matricula, a.grupoid, a.idalumno, a.status, a.baja, a.egresado, g.idgrupo, g. grado, g.grupo, CONCAT(g.grado,'-',g.grupo) AS grupo_format
					FROM alumnos a
					INNER JOIN grupos g
					ON a.grupoid = g.idgrupo
					WHERE a.grupoid = '$this->intGrupoId' AND a.status = 1 AND a.baja = 2 AND a.egresado = 2 AND tipo_registro = 'Alumno'
					ORDER BY a.matricula ASC";
			$request = $this->select_all($sql);

			return $request;
		}

		public function selectGrupoUpdate(int $idalumno){
			$this->intIdAlumno = $idalumno;
			$sql = "SELECT grado,grupo FROM alumnos WHERE idalumno = $this->intIdAlumno";
			$request = $this->select_all($sql);
			return $request;
		}

		public function aumentarSemestre(int $idalumno, string $nuevo_semestre){
			$this->intIdAlumno = $idalumno;
			$this->strNuevoSemestre = $nuevo_semestre;
			$sql = "UPDATE alumnos SET grado = ? WHERE idalumno = $this->intIdAlumno";
			$arrData = array($this->strNuevoSemestre);
			$request = $this->update($sql,$arrData);
			return $request;
		}

		public function selectActualizar(array $arrayAlumnos, int $grupoid, int $grupo_consecutivo){
			$this->arrayAlumnos = $arrayAlumnos;
			$this->intGrupoId = $grupoid;
			$this->intGrupoIdConsecutivo = $grupo_consecutivo;
			foreach ($this->arrayAlumnos as $alumnos) {
				$this->intIdAlumno = $alumnos;
				$sql = "UPDATE alumnos SET grupoid = ? WHERE idalumno = $this->intIdAlumno";
				$arrData = array($this->intGrupoIdConsecutivo);
				$request = $this->update($sql,$arrData);
			}
			return $request;
		}

		public function selectGrado(int $idalumno){
			$this->intIdAlumno = $idalumno;
			$sql = "SELECT 
			            a.grupoid, 
			            g1.idgrupo, 
			            g1.grado, 
			            g1.grupo, 
			            g1.grupoid_consecutivo, 
			            CONCAT(g2.grado, '-', g2.grupo) AS grupo_consecutivo_format 
			        FROM alumnos a
			        INNER JOIN grupos g1 ON g1.idgrupo = a.grupoid
			        INNER JOIN grupos g2 ON g2.idgrupo = g1.grupoid_consecutivo
			        WHERE a.idalumno = $this->intIdAlumno";
			$request = $this->select($sql);
			return $request;
		}

	}
 ?>