<?php 

	class AdeudosModel extends Mysql
	{
		private $intIdAdeudo;
		private $intAlumnoId;
		private $strAdeudo;
		private $strModificador;
		private $strUltimaModificacion;
		private $strTipoMovimiento;
		private $intStatus;

		public function __construct()
		{
			parent::__construct();
		}	

		public function insertAdeudo(string $alumnoid, string $adeudo, string $modificador, string $tipo_movimiento, int $status){
			$this->intAlumnoId = $alumnoid;
			$this->strAdeudo = $adeudo;
			$this->strModificador = $modificador;    
			$this->strTipoMovimiento = $tipo_movimiento;
			$this->intStatus = $status;
			$return = 0;

			$sqlAdeudo = "SELECT * FROM adeudos WHERE alumnoid = $this->intAlumnoId AND status != 0";
			$requestAdeudo = $this->select_all($sqlAdeudo);

			if(empty($requestAdeudo))
			{
				$query_insert  = "INSERT INTO adeudos(alumnoid,adeudo,modificador,tipo_movimiento,status) 
								  VALUES(?,?,?,?,?)";
	       		$arrData = array($this->intAlumnoId,
        						$this->strAdeudo,
        						$this->strModificador,
        						$this->strTipoMovimiento,
        						$this->intStatus);
	       		$request_insert = $this->insert($query_insert,$arrData);
	       		$return = $request_insert;
			}else{
				$return = "exist";
			}

	        return $return;
		}

		public function updateAdeudo(int $idadeudo, string $alumnoid, string $adeudo, string $modificador, string $tipo_movimiento, int $status){
			date_default_timezone_set('America/Mexico_city');
			$this->intIdAdeudo = $idadeudo;
			$this->intAlumnoId = $alumnoid;
			$this->strAdeudo = $adeudo;
			$this->strModificador = $modificador; 
			$this->strUltimaModificacion = date("Y-m-d H:i:s");    
			$this->strTipoMovimiento = $tipo_movimiento;
			$this->intStatus = $status;

			$sqlAdeudo = "SELECT * FROM adeudos WHERE alumnoid = $this->intAlumnoId AND status != 0 AND idadeudo != $this->intIdAdeudo";
			$requestAdeudo = $this->select_all($sqlAdeudo);

			if(empty($requestAdeudo))
			{
				$sql = "UPDATE adeudos SET  alumnoid = ?, adeudo = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idadeudo = $this->intIdAdeudo ";
				$arrData = array($this->intAlumnoId,
        						$this->strAdeudo,
        						$this->strModificador,
        						$this->strUltimaModificacion,
        						$this->strTipoMovimiento,
        						$this->intStatus);
				$request = $this->update($sql,$arrData);
				$return = $request;
			}else{
				$return = "exist";
			}
		    return $return;
		}

		public function selectadeudos()
		{
			$sql = "SELECT a.idalumno, CONCAT(a.nombres,' ',a.apellidos) AS nombre_alumno, DATE_FORMAT(ad.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, ad.*
					FROM adeudos ad
					INNER JOIN alumnos a
					ON a.idalumno = ad.alumnoid
					WHERE ad.status != 0 ORDER BY ad.ultima_modificacion DESC";
					$request = $this->select($sql);
					return $request;
		}

		public function selectAdeudo(int $idadeudo)
		{
			$this->intIdAdeudo = $idadeudo;
			$sql = "SELECT a.idalumno, CONCAT(a.nombres,' ',a.apellidos) AS nombre_alumno, DATE_FORMAT(ad.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, ad.*
					FROM adeudos ad
					INNER JOIN alumnos a
					ON a.idalumno = ad.alumnoid
					WHERE idadeudo = $this->intIdAdeudo";
			$request = $this->select($sql);
			return $request;
		}

		public function deleteAdeudo(int $idadeudo, string $modificador)
		{
			$this->intIdAdeudo = $idadeudo;		
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date("Y-m-d H:i:s");
			$this->strTipoMovimiento = 'Eliminación';
			$sql = "UPDATE adeudos SET modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idadeudo = $this->intIdAdeudo ";
			$arrData = array($this->strModificador,
								$this->strUltimaModificacion,
								$this->strTipoMovimiento,
								0);
			$request = $this->update($sql,$arrData);
			return $request;
		}

		public function selectAlumnos()
		{
			$sql = "SELECT idalumno, CONCAT(nombres,' ',apellidos) AS nombre_alumno, matricula FROM alumnos WHERE status = 1";
					$request = $this->select_all($sql);
					return $request;
		}

	}
 ?>