<?php 
class AgendaModel extends Mysql
{
	private $intIdAgenda;
	private $strEvento;
	private $strUbicacion;
	private $strDescripcion;
	private $strHoraInicial;
	private $strHoraFinal;
	private $intPersonaId;
	private $strNivel;
	private $strFechaInicial;
	private $strFechaFinal;
	private $strModificador;
	private $strTipoMovimiento;
	private $intStatus;
	
	public function __construct()
	{
		parent::__construct();
	}	

	public function insertEvento(string $evento, string $ubicacion, string $descripcion, string $hora_inicial, string $hora_final, string $fecha_inicial, string $fecha_final, int $status){
		$this->strEvento = $evento;
		$this->strUbicacion = $ubicacion;
		$this->strDescripcion = $descripcion;
		$this->strHoraInicial = $hora_inicial;
		$this->strHoraFinal = $hora_final;
		$this->strFechaInicial = $fecha_inicial;
		$this->strFechaFinal = $fecha_final;
		$this->strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
		$this->intStatus = $status;

		$return = 0;
		$sql = "SELECT * FROM agenda_rectoria WHERE evento = '{$this->strEvento}' AND fecha_inicial = '{$this->strFechaInicial}' AND ubicacion = '{$this->strUbicacion}'";
		$request = $this->select_all($sql);


		if(empty($request))
		{
			$query_insert  = "INSERT INTO agenda_rectoria(evento,ubicacion,descripcion,hora_inicial,hora_final,fecha_inicial,fecha_final,modificador,status) 
							  VALUES(?,?,?,?,?,?,?,?,?)";
        	$arrData = array($this->strEvento,
    						$this->strUbicacion,
    						$this->strDescripcion,
    						$this->strHoraInicial,
    						$this->strHoraFinal,
    						$this->strFechaInicial,
    						$this->strFechaFinal,
    						$this->strModificador,
    						$this->intStatus);
        	$request_insert = $this->insert($query_insert,$arrData);
        	$return = $request_insert;
		}else{
			$return = "exist";
		}
        return $return;
	}

	public function updateEvento(int $idagenda, string $evento, string $ubicacion, string $descripcion, string $hora_inicial, string $hora_final, string $fecha_inicial, string $fecha_final, int $status){
		$this->intIdAgenda = $idagenda;
		$this->strEvento = $evento;
		$this->strUbicacion = $ubicacion;
		$this->strDescripcion = $descripcion;
		$this->strHoraInicial = $hora_inicial;
		$this->strHoraFinal = $hora_final;
		$this->strFechaInicial = $fecha_inicial;
		$this->strFechaFinal = $fecha_final;
		$this->strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
		$this->strUltimaModificacion = date('Y-m-d h:i:s');
		$this->strTipoMovimiento = 'Actualización';
		$this->intStatus = $status;

		$sql = "SELECT * FROM agenda_rectoria WHERE (evento = '{$this->strEvento}' AND fecha_inicial = '{$this->strFechaInicial}' AND ubicacion = '{$this->strUbicacion}' AND idagenda != $this->intIdAgenda)";
		$request = $this->select_all($sql);

		if(empty($request))
		{	
			$sql = "UPDATE agenda_rectoria SET evento=?, ubicacion=?, descripcion=?, hora_inicial=?, hora_final=?, fecha_inicial=?, fecha_final=?, modificador=?, ultima_modificacion=?, tipo_movimiento=?,status=? WHERE idagenda = $this->intIdAgenda ";
			$arrData = array($this->strEvento,
    						$this->strUbicacion,
    						$this->strDescripcion,
    						$this->strHoraInicial,
    						$this->strHoraFinal,
    						$this->strFechaInicial,
    						$this->strFechaFinal,
    						$this->strModificador,
    						$this->strUltimaModificacion,
    						$this->strTipoMovimiento,
    						$this->intStatus);
			
			$request = $this->update($sql,$arrData);
		}else{
			$request = "exist";
		}
		return $request;
	}

	public function selectEventos()
	{
		$sql = "SELECT *, DATE_FORMAT(fecha_inicial, '%d-%m-%Y') AS fecha_inicial_format, DATE_FORMAT(fecha_final, '%d-%m-%Y') AS fecha_final_format FROM agenda_rectoria WHERE status != 0";
		$request = $this->select_all($sql);
		return $request;
	}

	public function selectEvento($idagenda)
	{
		$this->intIdAgenda = $idagenda;
		$sql = "SELECT *, DATE_FORMAT(fecha_inicial, '%d-%m-%Y') AS fecha_inicial_format, DATE_FORMAT(fecha_final, '%d-%m-%Y') AS fecha_final_format FROM agenda_rectoria WHERE idagenda = $this->intIdAgenda AND status != 0"; 
		$request = $this->select($sql);
		return $request;
	}

	public function deleteEvento(int $idagenda)
	{
		$this->intIdAgenda = $idagenda;
		$this->strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
		$this->strUltimaModificacion = date('Y-m-d');
		$this->strTipoMovimiento = 'Eliminación';
		$sql = "UPDATE agenda_rectoria SET modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idagenda = $this->intIdAgenda ";
		$arrData = array($this->strModificador,
							$this->strUltimaModificacion,
							$this->strTipoMovimiento,
							0);
		$request = $this->update($sql,$arrData);
		return $request;
	}

}

?>