<?php 

	class AparcialModel extends Mysql
	{
		private $strMatricula;
		private $intNivelId;
		private $intCarreraId;
		private $intSemestre;
		private $intMateriaId;
		private $intHorarioId;
		private $intAlumnoId;
		private $intDocenteId;
		private $strGrado;
		private $strGrupo;
		private $strCalificacionA;
		private $strFechaCapturaA;
		private $strCalificacionB;
		private $strFechaCapturaB;
		private $strCalificacionC;
		private $strFechaCapturaC;
		private $strCalificacionD;
		private $strFechaCapturaD;
		private $strFechaCaptura;
		private $intPersonaId;
		private $strModificador;
		private $strUltimaModificacion;
		private $intStatus;

		private $semestres;
		private $intPrimero;
		private $intSegundo;
		private $intTercero;
		private $intCuarto;
		private $intQuinto;
		private $intSexto;
		private $intSeptimo;
		private $intOctavo;
		private $intNoveno;

		public function __construct()
		{
			parent::__construct();
		}	

		public function selectGrupo(int $carreraid, string $grado, string $grupo)
		{
			$this->intCarreraId = $carreraid;
			$this->strGrado = $grado;
			$this->strGrupo = $grupo;

			$sql = "SELECT idalumno, CONCAT(a.nombres,' ',a.apellidos) AS nombre_alumno, a.matricula, a.sexo, a.grado, a.grupo, n.idnivel, n.nivel, c.idcarrera, c.carrera  
					FROM alumnos a
					INNER JOIN niveles n
					ON n.idnivel = a.nivelid
					INNER JOIN carreras c
					ON c.idcarrera = a.carreraid 
					WHERE (a.carreraid = $this->intCarreraId AND a.grado = '$this->strGrado' AND a.grupo = '$this->strGrupo') ORDER BY a.apellidos ASC"; 
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectCarreras()
		{
			$sql = "SELECT c.idcarrera, c.carrera, c.reforma, n.idnivel, n.nivel 
					FROM carreras c
					INNER JOIN niveles n
					ON n.idnivel = c.nivelid
					WHERE c.status = 1";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectAlumnos(int $carreraid)
		{
			$this->intCarreraId = $carreraid;
			$sql = "SELECT idalumno, CONCAT(nombres,' ',apellidos) AS nombre_alumno, matricula FROM alumnos WHERE carreraid = $this->intCarreraId AND egresado != 1 AND baja != 1 AND status = 1 ORDER BY matricula ASC;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectCalificacionesTodos(int $alumnoid)
		{
			$this->intAlumnoId = $alumnoid;
			$sql = "SELECT cal.*, a.idalumno, a.matricula, CONCAT(a.nombres,' ',a.apellidos) AS nombre_alumno, m.materia, DATE_FORMAT(cal.primero_fecha, '%d-%m-%Y') AS fecha_a_format, CONCAT(p.nombres,' ',p.apellidos) AS nombre_docente, n.nivel, c.carrera, g.idgrupo, g.grado, g.grupo, CONCAT(g.grado,'-',g.grupo) AS grupo_format
					FROM calificaciones cal
					INNER JOIN alumnos a
					ON a.idalumno = cal.alumnoid 
					INNER JOIN materias m
					ON m.idmateria = cal.materiaid
					INNER JOIN persona p
					ON p.idpersona = cal.profesorid
					INNER JOIN niveles n
					ON n.idnivel = cal.nivelid
					INNER JOIN carreras c
					ON c.idcarrera = cal.carreraid
					INNER JOIN grupos g
					ON g.idgrupo = cal.grupoid
					WHERE cal.alumnoid = $this->intAlumnoId AND cal.status = 1 ORDER BY cal.semestre ASC;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectCalificacionesSemestres(int $alumnoid, array $semestres)
		{
			$this->intAlumnoId = $alumnoid;
			$this->semestres = $semestres;
			$condicion = "";

			for($i=0;$i<sizeof($semestres);$i++){  
                if($i==0){
                   

                   if($i == (sizeof($semestres)-1))
                	{
                		$condicion.="AND (cal.semestre=".$semestres[$i].")";
                	}else{
                		$condicion.="AND (cal.semestre=".$semestres[$i];
                	}

               }else{           
                	if($i == (sizeof($semestres)-1)){
                		$condicion.=" OR cal.semestre=".$semestres[$i].")";
                	}else{
                		$condicion.=" OR cal.semestre=".$semestres[$i];
                	}
	            }
	        }

			$sql = "SELECT cal.*, a.idalumno, a.matricula, CONCAT(a.nombres,' ',a.apellidos) AS nombre_alumno, m.materia, DATE_FORMAT(cal.primero_fecha, '%d-%m-%Y') AS fecha_a_format, CONCAT(p.nombres,' ',p.apellidos) AS nombre_docente, n.nivel, c.carrera, g.idgrupo, g.grado, g.grupo, CONCAT(g.grado,'-',g.grupo) AS grupo_format
					FROM calificaciones cal
					INNER JOIN alumnos a
					ON a.idalumno = cal.alumnoid 
					INNER JOIN materias m
					ON m.idmateria = cal.materiaid
					INNER JOIN persona p
					ON p.idpersona = cal.profesorid
					INNER JOIN niveles n
					ON n.idnivel = cal.nivelid
					INNER JOIN carreras c
					ON c.idcarrera = cal.carreraid
					INNER JOIN grupos g
					ON g.idgrupo = cal.grupoid
					WHERE cal.alumnoid = $this->intAlumnoId AND cal.status = 1 $condicion ORDER BY cal.semestre ASC;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectGrupos(int $carreraid, int $personaid)
		{
			$this->intCarreraId = $carreraid;
			$this->intPersonaId = $personaid;

			if($_SESSION['userData']['idrol'] != RADMINESCOLARES && $_SESSION['userData']['idrol'] != RAUXESCOLARES && $_SESSION['userData']['idrol'] != RADMINISTRADOR)
			{
				$personaid=$_SESSION['userData']['idpersona'];
				$where=" AND docenteid=$this->intPersonaId ";
			}else{
				$where="";
			}

			$sql = "SELECT DISTINCT grupo FROM horarios WHERE carreraid = $this->intCarreraId AND status = 1".$where;
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectMaterias(int $carreraid, string $grupo, int $personaid)
		{
			$this->intCarreraId = $carreraid;
			$this->strGrupo = $grupo;
			$this->intPersonaId = $personaid;

			if($_SESSION['userData']['idrol'] != RADMINESCOLARES && $_SESSION['userData']['idrol'] != RAUXESCOLARES && $_SESSION['userData']['idrol'] != RADMINISTRADOR)
			{
				$personaid=$_SESSION['userData']['idpersona'];
				$where=" AND h.docenteid=$this->intPersonaId ";
			}else{
				$where="";
			}

			$sql = "SELECT m.idmateria, m.materia, h.materiaid, h.grupo, h.docenteid 
						FROM horarios h
						INNER JOIN materias m
						ON m.idmateria = h.materiaid
						WHERE h.carreraid = $this->intCarreraId AND h.status = 1 AND h.grupo = '$this->strGrupo'".$where;
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectBusquedaAlumnos(int $nivelid, int $carreraid, string $grado, string $grupo){
			$this->intNivelId = $nivelid;
			$this->intCarreraId = $carreraid;
			$this->strGrado = $grado;
			$this->strGrupo = $grupo;
			
			$sql = "SELECT idalumno, matricula, CONCAT(nombres,' ',apellidos) AS nombre_alumno, grado, grupo, CONCAT(grado,'-',grupo) AS grupo_format
						FROM alumnos 
						WHERE nivelid = $this->intNivelId AND carreraid = $this->intCarreraId AND grado = '$this->strGrado' AND grupo = '$this->strGrupo' AND egresado != 1 AND status =1 ORDER BY apellidos ASC;";
			//dep($sql);
			$request = $this->select_all($sql);

			return $request;
		}

		public function selectData(int $nivelid, int $carreraid, int $materiaid, string $grupo){
			
			$this->intNivelId = $nivelid;
			$this->intCarreraId = $carreraid;
			$this->intMateriaId = $materiaid;
			$this->strGrupo = $grupo;

			/*dep("Nivel: ".$this->intNivelId);
			dep("Carrera: ".$this->intCarreraId);
			dep("Materia: ".$this->intMateriaId);
			dep("Grupo: ".$this->strGrupo);
			exit;*/
			
			$sql = "SELECT docenteid FROM horarios WHERE nivelid = $this->intNivelId AND materiaid = $this->intMateriaId AND carreraid = $this->intCarreraId AND grupo = '$this->strGrupo' AND status = 1 ORDER BY idcarga DESC;";
			$request = $this->select($sql);

			return $request;
		}

		public function selectPermisivoFecha(int $docenteid, int $materiaid, int $carreraid, string $grupo){
			/*date_default_timezone_set('America/Mexico_city');
			$strUltimaModificacion = date('Y-m-d');*/
			$this->intDocenteId = $docenteid;
			$this->intMateriaId = $materiaid;
			$this->intCarreraId = $carreraid;
			$this->strGrupo = $grupo;
			
			$sql = "SELECT fecha_inicial, fecha_final FROM horarios WHERE docenteid = $this->intDocenteId AND materiaid = $this->intMateriaId AND carreraid = $this->intCarreraId AND grupo = '$this->strGrupo' AND status = 1;";
			$request = $this->select($sql);

			return $request;
		}

		public function selectBusquedaNivel(int $nivelid){
			$this->intNivelId = $nivelid;
			
			$sql = "SELECT idnivel, nivel FROM niveles WHERE idnivel = $this->intNivelId AND status = 1;";
			$request = $this->select($sql);

			return $request;
		}

		public function selectBusquedaCarrera(int $carreraid){
			$this->intCarreraId = $carreraid;
			
			$sql = "SELECT idcarrera, carrera FROM carreras WHERE idcarrera = $this->intCarreraId AND status = 1;";
			$request = $this->select($sql);

			return $request;
		}

		public function selectBusquedaDocente(int $idpersona){
			$this->intPersonaId = $idpersona;
			
			$sql = "SELECT idpersona, CONCAT(nombres,' ',apellidos) AS nombre_docente FROM persona WHERE idpersona = $this->intPersonaId AND status = 1;";
			$request = $this->select($sql);

			return $request;
		}

		public function selectBusquedaMateria(int $idmateria){
			$this->intMateriaId = $idmateria;
			
			$sql = "SELECT idmateria, materia FROM materias WHERE idmateria = $this->intMateriaId AND status = 1;";
			$request = $this->select($sql);

			return $request;
		}

	}

 ?>