<?php 
	#[\AllowDynamicProperties]
	class AsistenciasModel extends Mysql
	{
		private $intIdAsistencia;
		private $strFecha;
		private $strFecha2;
		private $strFechaFormateada;
		private $intGrupoId;
		private $intProfesorId;
		private $intMateriaId;
		private $intAlumnoId;
		private $strAsistencia;
		private $strDataJson;
		private $strDataArray;
		private $strUltimaModificacion;
		private $strModificador;
		private $intCicloId;
		private $intStatus;

		public function __construct()
		{
			parent::__construct();
		}	

		public function insertAsistencia(string $fecha, int $grupoid, int $profesorid, int $materiaid, string $data, string $modificador, string $tipo_movimiento){
			$this->strFecha = $fecha;
			$this->strFecha2 = DateTime::createFromFormat('m/d/Y', $this->strFecha);
			$this->strFechaFormateada = $this->strFecha2->format('Y/m/d');
			$this->intGrupoId = $grupoid;
			$this->intProfesorId = $profesorid;
			$this->intMateriaId = $materiaid;
			$this->strDataJson = $data;
			$this->strDataArray = json_decode($data, true);
			$this->strModificador = $modificador;
			$this->strTipoMovimiento = $tipo_movimiento;
			$this->intCicloId = IDCICLO;
			$return = 0;
			
			$sql = "SELECT * FROM asistencias WHERE (grupoid = {$this->intGrupoId} AND profesorid = $this->intProfesorId AND materiaid = $this->intMateriaId AND status != 0 AND fecha = '{$this->strFechaFormateada}')";
			$request = $this->select_all($sql);

			if(empty($request))
			{
				for ($i=0; $i < count($this->strDataArray); $i++) { 
					$query_insert  = "INSERT INTO asistencias(fecha,grupoid,profesorid,materiaid,alumnoid,asistencia,comentarios,modificador,tipo_movimiento,cicloid) 
								  VALUES(?,?,?,?,?,?,?,?,?,?)";
		        	$arrData = array($this->strFechaFormateada,
	        						$this->intGrupoId,
	        						$this->intProfesorId,
	        						$this->intMateriaId,
	        						$this->strDataArray[$i]['idalumno'],
	        						$this->strDataArray[$i]['asistencia'],
	        						$this->strDataArray[$i]['comentarios'],
	        						$this->strModificador,
	        						$this->strTipoMovimiento,
	        						$this->intCicloId);
		        	$request_insert = $this->insert($query_insert,$arrData);
				}
	        	$return = $request_insert;
			}else{
				$return = "exist";
			}
			
	        return $return;
		}

		public function updateAsistencia(string $fecha, int $grupoid, int $profesorid, int $materiaid, string $data, string $modificador, string $tipo_movimiento){
			date_default_timezone_set('America/Mexico_city');
			$this->strFecha = $fecha;
			$this->intGrupoId = $grupoid;
			$this->intProfesorId = $profesorid;
			$this->intMateriaId = $materiaid;
			$this->strDataJson = $data;
			$this->strDataArray = json_decode($data, true);
			$this->strModificador = $modificador;
			$this->strTipoMovimiento = $tipo_movimiento;
			$this->strUltimaModificacion = date('Y-m-d h:i:s');
			$return = 1;

			for ($i=0; $i < count($this->strDataArray); $i++) { 
				$query_insert  = "UPDATE asistencias SET asistencia=?, comentarios=?, ultima_modificacion=?, modificador=?, tipo_movimiento=? WHERE grupoid=$this->intGrupoId AND profesorid=$this->intProfesorId AND materiaid=$this->intMateriaId AND alumnoid={$this->strDataArray[$i]['idalumno']} AND fecha='$this->strFecha';";
	        	$arrData = array($this->strDataArray[$i]['asistencia'],
        						$this->strDataArray[$i]['comentarios'],
        						$this->strUltimaModificacion,
        						$this->strModificador,
        						$this->strTipoMovimiento);
	        	$request_insert = $this->update($query_insert,$arrData);
			}
			
	        return $return;		
		}

		public function selectAlumnos(int $grupoid, int $materiaid)
		{
			$this->intGrupoId = $grupoid;
			$this->intMateriaId = $materiaid;
			$sql = "SELECT a.idalumno, a.status, CONCAT(a.apellidos, ' ', a.nombres) AS nombre_alumno, MIN(h.idhorario) AS idhorario, h.grupoid, h.materiaid, h.profesorid, CONCAT(p.nombres, ' ', p.apellidos) AS nombre_docente, m.idmateria, m.materia, g.grado, g.grupo
					FROM alumnos a
					INNER JOIN horarios h ON h.grupoid = a.grupoid
					INNER JOIN persona p ON p.idpersona = h.profesorid 
					INNER JOIN materias m ON h.materiaid = m.idmateria
					INNER JOIN grupos g ON h.grupoid = g.idgrupo
					WHERE h.grupoid = $this->intGrupoId AND h.materiaid = $this->intMateriaId AND a.status = 1
					GROUP BY a.idalumno, nombre_alumno, h.grupoid, h.materiaid, h.profesorid, nombre_docente, m.idmateria, m.materia
					ORDER BY a.apellidos ASC;";
			/*dep($sql);
			exit;*/
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectFechas(int $grupoid, int $profesorid, int $materiaid)
		{
			$this->intGrupoId = $grupoid;
			$this->intProfesorId = $profesorid;
			$this->intMateriaId = $materiaid;
			$sql = "SELECT DISTINCT fecha, grupoid, profesorid, materiaid
					FROM asistencias
					WHERE grupoid = $this->intGrupoId AND materiaid = $this->intMateriaId AND profesorid = $this->intProfesorId
					ORDER BY fecha ASC;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectAsistencia(int $grupoid, int $profesorid, int $materiaid, string $fecha)
		{
			$this->intGrupoId = $grupoid;
			$this->intProfesorId = $profesorid;
			$this->intMateriaId = $materiaid;
			$this->strFechaFormateada = $fecha;
			$this->intCicloId = IDCICLO;
			$sql = "SELECT al.idalumno, CONCAT(al.apellidos, ' ', al.nombres) AS nombre_alumno, a.*
					FROM asistencias a
					INNER JOIN alumnos al ON al.idalumno = a.alumnoid
					WHERE a.grupoid = $this->intGrupoId AND a.profesorid = $this->intProfesorId AND a.materiaid = $this->intMateriaId AND a.status=1 AND a.fecha = '{$this->strFechaFormateada}' AND a.cicloid=".IDCICLO."
					ORDER BY al.apellidos ASC ";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectAsistenciasGrupo(int $grupoid, int $profesorid, int $materiaid, string $fecha_inicial, string $fecha_final)
		{
			$this->intGrupoId = $grupoid;
			$this->intProfesorId = $profesorid;
			$this->intMateriaId = $materiaid;
			$this->strFechaInicial = $fecha_inicial;
			$this->strFechaFinal = $fecha_final;
			
			if(($this->strFechaInicial!="" && $this->strFechaFinal!="") AND ($this->strFechaInicial!='undefined' && $this->strFechaFinal!='undefined'))
			{
				$sql = "SELECT a.idalumno, CONCAT(a.nombres,' ',a.apellidos) AS nombre_alumno, p.idpersona, CONCAT(p.nombres,' ',p.apellidos) AS nombre_profesor, m.idmateria, m.materia, m.nivelid, g.idgrupo, CONCAT(g.grado,'-',g.grupo) AS grupo_format, g.grado, g.grupo, n.idnivel, n.nivel, DATE_FORMAT(asis.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, asis.*
					FROM asistencias asis
					INNER JOIN alumnos a
					ON a.idalumno = asis.alumnoid
					INNER JOIN persona p
					ON p.idpersona = asis.profesorid
					INNER JOIN materias m
					ON m.idmateria = asis.materiaid
					INNER JOIN grupos g
					ON g.idgrupo = asis.grupoid
					INNER JOIN niveles n
					ON n.idnivel = m.nivelid
					WHERE asis.fecha BETWEEN '$this->strFechaInicial' AND '$this->strFechaFinal' AND asis.grupoid = $this->intGrupoId AND asis.profesorid = $this->intProfesorId AND asis.status = 1 AND asis.materiaid = $this->intMateriaId AND asis.cicloid=".IDCICLO." ORDER BY asis.fecha ASC";
			}else{
				$sql = "SELECT a.idalumno, CONCAT(a.nombres,' ',a.apellidos) AS nombre_alumno, p.idpersona, CONCAT(p.nombres,' ',p.apellidos) AS nombre_profesor, m.idmateria, m.materia, m.nivelid, g.idgrupo, CONCAT(g.grado,'-',g.grupo) AS grupo_format, g.grado, g.grupo, n.idnivel, n.nivel, DATE_FORMAT(asis.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, asis.*
					FROM asistencias asis
					INNER JOIN alumnos a
					ON a.idalumno = asis.alumnoid
					INNER JOIN persona p
					ON p.idpersona = asis.profesorid
					INNER JOIN materias m
					ON m.idmateria = asis.materiaid
					INNER JOIN grupos g
					ON g.idgrupo = asis.grupoid
					INNER JOIN niveles n
					ON n.idnivel = m.nivelid
					WHERE asis.grupoid = $this->intGrupoId AND asis.profesorid = $this->intProfesorId AND asis.materiaid = $this->intMateriaId AND asis.status=1 AND asis.cicloid=".IDCICLO." ORDER BY asis.fecha ASC";
			}
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectGrupos($profesorid)
		{
			$this->intProfesorId = $profesorid;
			if($_SESSION['userData']['idrol'] == 1)
			{
				$sql = "SELECT DISTINCT (h.materiaid AND h.grupoid), h.grupoid, h.carreraid, h.profesorid, CONCAT(p.nombres,' ',p.apellidos) AS nombre_docente, g.idgrupo, g.grado, g.grupo, c.idcarrera, c.carrera, c.nivelid, m.idmateria, m.materia, n.idnivel, n.nivel  
					FROM horarios h
					INNER JOIN persona p
					ON p.idpersona = h.profesorid 
					INNER JOIN grupos g
					ON g.idgrupo = h.grupoid
					INNER JOIN materias m
					ON m.idmateria = h.materiaid  
					INNER JOIN carreras c
					ON c.idcarrera = h.carreraid 
					INNER JOIN niveles n
					ON n.idnivel = c.nivelid 
					WHERE h.status = 1 AND h.cicloid=".IDCICLO."
					ORDER BY n.idnivel, g.grado, g.grupo, m.materia";					
				$request = $this->select($sql);
			}else{
				$sql = "SELECT DISTINCT (h.materiaid AND h.grupoid), h.grupoid, h.carreraid, h.profesorid, CONCAT(p.nombres,' ',p.apellidos) AS nombre_docente, g.idgrupo, g.grado, g.grupo, c.idcarrera, c.carrera, c.nivelid, m.idmateria, m.materia, n.idnivel, n.nivel  
					FROM horarios h
					INNER JOIN persona p
					ON p.idpersona = h.profesorid 
					INNER JOIN grupos g
					ON g.idgrupo = h.grupoid
					INNER JOIN materias m
					ON m.idmateria = h.materiaid  
					INNER JOIN carreras c
					ON c.idcarrera = h.carreraid 
					INNER JOIN niveles n
					ON n.idnivel = c.nivelid 
					WHERE h.profesorid = $this->intProfesorId AND h.status = 1 AND h.cicloid = ".IDCICLO;	
			}
			
				
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectMateria(int $idmateria){
			$this->intIdMateria = $idmateria;
			$sql = "SELECT n.idnivel, n.nivel, DATE_FORMAT(m.datecreated, '%d-%m-%Y %H:%i:%s') AS datecreated_format, m.*
					FROM materias m 
					INNER JOIN niveles n
					ON n.idnivel = m.nivelid
					WHERE m.idmateria = $this->intIdMateria";
			$request = $this->select($sql);
			return $request;
		}

		public function deleteMateria(int $idmateria)
		{
			$this->intIdMateria = $idmateria;		
			$sql = "UPDATE materias SET status = ? WHERE idmateria = $this->intIdMateria ";
			$arrData = array(0);
			$request = $this->update($sql,$arrData);
			return $request;
		}

		public function selectCiclos(){
			$sql = "SELECT idciclo, ciclo_escolar, status
					FROM ciclos_escolares
					WHERE status = 1";
			$request = $this->select($sql);
			return $request;
		}

	}

 ?>