<?php 

	class CalificacionesModel extends Mysql
	{
		private $intCalificacionId;
		private $strMatricula;
		private $intAlumnoId;
		private $intSemestre;
		private $intNivelId;
		private $intCarreraId;
		private $intGrupoId;
		private $intProfesorId;
		private $intMateriaId;
		private $strJsonData;
		private $strFechaCaptura;
		private $intParcial;
		private $campo;
		private $campoAlterno;
		private $campoAlternoN;
		private $strModificador;
		private $strUltimaModificacion;
		private $intStatus;

		public function __construct()
		{
			parent::__construct();
		}	

		public function insertCalificacion(int $semestre, int $nivelid, int $carreraid, int $grupoid, int $profesorid, int $materiaid, string $data, string $fecha_captura, string $modificador, string $tipo_movimiento)
		{
		    date_default_timezone_set('America/Mexico_city');
		    $this->intSemestre = $semestre;
		    $this->intNivelId = $nivelid;
		    $this->intCarreraId = $carreraid;
		    $this->intGrupoId = $grupoid;
		    $this->intProfesorId = $profesorid;
		    $this->intMateriaId = $materiaid;
		    $this->strDataJson = '[' . $data . ']'; 
		    $this->strDataArray = json_decode($this->strDataJson, true); 		    
		    $this->strFechaCaptura = $fecha_captura;
		    $this->strModificador = $modificador;
		    $this->strTipoMovimiento = $tipo_movimiento;
		    $this->strUltimaModificacion = date('Y-m-d H:i:s');

		    $procesados = 0;

		    $sql = "SELECT * FROM calificaciones 
		            WHERE grupoid = {$this->intGrupoId} 
		            AND nivelid = {$this->intNivelId} 
		            AND carreraid = {$this->intCarreraId} 
		            AND profesorid = {$this->intProfesorId} 
		            AND materiaid = {$this->intMateriaId} 
		            AND status != 0 
		            AND cicloid = " . IDCICLO . ";";
		    $request_db = $this->select_all($sql);

		    $registros_existentes = [];
		    if (!empty($request_db)) {
		        foreach ($request_db as $registro) {
		            $registros_existentes[$registro['alumnoid']] = $registro;
		        }
		    }
		    
		    if (is_array($this->strDataArray) && count($this->strDataArray) > 0) {
		        foreach ($this->strDataArray as $alumno_data) {
		            
		            // Eliminar las llaves que vienen vacías en el JSON para que no entren al UPDATE
		            foreach ($alumno_data as $key => $value) {
		                if ($value === "" || $value === null) {
		                    unset($alumno_data[$key]);
		                }
		            }

		            $idalumno = $alumno_data['idalumno'];
		            $intParcial = $alumno_data['parcial'] ?? 0;
		            $fecha = $this->strFechaCaptura;

		            $campo = ""; 
		            $es_parcial = false;
		            if ($intParcial == 1) { $campo = "primero_"; $es_parcial = true; } 
		            elseif ($intParcial == 2) { $campo = "segundo_"; $es_parcial = true; } 
		            elseif ($intParcial == 3) { $campo = "tercero_"; $es_parcial = true; }
		            
		            if (isset($registros_existentes[$idalumno])) {
		                
		                $idcalificacion_update = $registros_existentes[$idalumno]['idcalificacion'];
		                $set_fields = [];
		                $arrData = [];
		                
		                if ($es_parcial) {
		                    // Solo si sobrevivieron al 'unset' de arriba, se agregan al SQL
		                    if (isset($alumno_data['tareas_nentregadas'])) {
		                        $set_fields[] = "{$campo}ntareas = ?";
		                        $arrData[] = $alumno_data['tareas_nentregadas'];
		                    }
		                    if (isset($alumno_data['faltas'])) {
		                        $set_fields[] = "{$campo}inasistencias = ?";
		                        $arrData[] = $alumno_data['faltas'];
		                    }
		                    if (isset($alumno_data['calificacion'])) {
		                        $set_fields[] = "{$campo}calificacion = ?";
		                        $arrData[] = $alumno_data['calificacion'];
		                    }
		                    
		                    if (!empty($set_fields)) {
		                        $set_fields[] = "{$campo}fecha = ?";
		                        $arrData[] = $fecha;
		                    }
		                }
		                
		                if (isset($alumno_data['calificacion_ordinario'])) {
		                    $set_fields[] = "ordinario_calificacion = ?";
		                    $arrData[] = $alumno_data['calificacion_ordinario'];
		                    $set_fields[] = "ordinario_fecha = ?";
		                    $arrData[] = $fecha;
		                }
		                
		                if (empty($set_fields)) continue;

		                $set_fields[] = "modificador = ?";
		                $arrData[] = $this->strModificador;
		                $set_fields[] = "tipo_movimiento = ?";
		                $arrData[] = $this->strTipoMovimiento;
		                $set_fields[] = "ultima_modificacion = ?";
		                $arrData[] = $this->strUltimaModificacion;

		                $sql_update = "UPDATE calificaciones SET " . implode(', ', $set_fields) . " 
		                               WHERE idcalificacion = ? AND alumnoid = ?";
		                $arrData[] = $idcalificacion_update;
		                $arrData[] = $idalumno;

		                $this->update($sql_update, $arrData);
		            
		            } else {
		                $ntareas = $alumno_data['tareas_nentregadas'] ?? null;
		                $faltas = $alumno_data['faltas'] ?? null;
		                $calificacion = $alumno_data['calificacion'] ?? null;
		                $ordinario = $alumno_data['calificacion_ordinario'] ?? null;

		                $campos_sql = "alumnoid, semestre, nivelid, carreraid, grupoid, profesorid, materiaid, json_data, modificador, tipo_movimiento, cicloid, ultima_modificacion";
		                $valores_sql = "?,?,?,?,?,?,?,?,?,?,?,?";
		                $arrData = [$idalumno, $this->intSemestre, $this->intNivelId, $this->intCarreraId, $this->intGrupoId, $this->intProfesorId, $this->intMateriaId, $this->strDataJson, $this->strModificador, $this->strTipoMovimiento, IDCICLO, $this->strUltimaModificacion];

		                if ($es_parcial) {
		                    $campos_sql .= ", {$campo}ntareas, {$campo}inasistencias, {$campo}calificacion, {$campo}fecha";
		                    $valores_sql .= ", ?, ?, ?, ?";
		                    array_push($arrData, $ntareas, $faltas, $calificacion, $fecha);
		                }

		                if (!is_null($ordinario)) {
		                    $campos_sql .= ", ordinario_calificacion, ordinario_fecha";
		                    $valores_sql .= ", ?, ?";
		                    array_push($arrData, $ordinario, $fecha);
		                }

		                $sql_insert = "INSERT INTO calificaciones ({$campos_sql}) VALUES ({$valores_sql})";
		                $this->insert($sql_insert, $arrData);
		            }
		            $procesados++;
		        }
		    }
		    return ($procesados > 0) ? true : "error";
		}

		public function selectGrupo(int $carreraid, string $grado, string $grupo)
		{
			$this->intCarreraId = $carreraid;
			$this->strGrado = $grado;
			$this->strGrupo = $grupo;

			$sql = "SELECT idalumno, CONCAT(a.nombres,' ',a.apellidos) AS nombre_alumno, a.matricula, a.sexo, a.grado, a.grupo, n.idnivel, n.nivel, c.idcarrera, c.carrera  
					FROM alumnos a
					INNER JOIN niveles n
					ON n.idnivel = a.nivelid
					INNER JOIN carreras c
					ON c.idcarrera = a.carreraid 
					WHERE (a.carreraid = $this->intCarreraId AND a.grado = '$this->strGrado' AND a.grupo = '$this->strGrupo') ORDER BY a.apellidos, a.nombres ASC"; 
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectNiveles()
		{
			$sql = "SELECT idnivel, nivel FROM niveles WHERE status = 1";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectCarreras(int $nivelid)
		{
			$this->intNivelId = $nivelid;
			$sql = "SELECT * FROM carreras WHERE nivelid = $this->intNivelId";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectGrupos(int $carreraid, int $personaid)
		{
			$this->intCarreraId = $carreraid;
			$this->intPersonaId = $personaid;

			if($_SESSION['userData']['idrol'] != RADMINESCOLARES && $_SESSION['userData']['idrol'] != RAUXESCOLARES && $_SESSION['userData']['idrol'] != RADMINISTRADOR && $_SESSION['userData']['idrol'] != RADMINBACHILLERATO)
			{
				$personaid=$_SESSION['userData']['idpersona'];
				$where=" AND h.profesorid=$this->intPersonaId ";
			}else{
				$where="";
			}

			$sql = "SELECT DISTINCT h.grupoid, g.idgrupo, g.grado, g.grupo
			 		FROM horarios h
			 		INNER JOIN grupos g 
			 		ON g.idgrupo = h.grupoid
			 		WHERE h.carreraid = $this->intCarreraId AND h.status = 1".$where." ORDER BY g.grado, g.grupo ASC";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectMaterias(int $carreraid, string $grupoid, int $personaid)
		{
			$this->intCarreraId = $carreraid;
			$this->intGrupoId = $grupoid;
			$this->intPersonaId = $personaid;

			if($_SESSION['userData']['idrol'] != RADMINESCOLARES && $_SESSION['userData']['idrol'] != RAUXESCOLARES && $_SESSION['userData']['idrol'] != RADMINISTRADOR && $_SESSION['userData']['idrol'] != RADMINBACHILLERATO)
			{
				$personaid=$_SESSION['userData']['idpersona'];
				$where=" AND h.profesorid=$this->intPersonaId ";
			}else{
				$where="";
			}

			$sql = "SELECT DISTINCT(m.idmateria), m.materia, h.materiaid, h.grupoid, h.profesorid, g.idgrupo, g.grado, g.grupo 
						FROM horarios h
						INNER JOIN materias m
						ON m.idmateria = h.materiaid
						INNER JOIN grupos g
						ON g.idgrupo = h.grupoid
						WHERE h.carreraid = $this->intCarreraId AND h.status = 1 AND h.grupoid = '$this->intGrupoId'".$where;
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectBusquedaAlumnos(int $nivelid, int $carreraid, string $grupoid, int $profesorid, int $materiaid){
			$this->intNivelId = $nivelid;
			$this->intCarreraId = $carreraid;
			$this->intGrupoId = $grupoid;
			$this->intProfesorId = $profesorid;
			$this->intMateriaId = $materiaid;

			$sqlPermisivo = "SELECT * FROM kardex WHERE (grupoid = '{$this->intGrupoId}' AND nivelid = {$this->intNivelId} AND carreraid = {$this->intCarreraId} AND profesorid = {$this->intProfesorId} AND materiaid = {$this->intMateriaId} AND status != 0)";
			$requestPermisivo = $this->select_all($sqlPermisivo);

			if(empty($requestPermisivo))
			{
				$sql = "SELECT a.idalumno, a.matricula, CONCAT(a.apellidos,' ',a.nombres) AS nombre_alumno, a.grupoid, a.tipo_registro, g.idgrupo, g.grado, g.grupo, CONCAT(g.grado,'-',g.grupo) AS grupo_format
						FROM alumnos a
						INNER JOIN grupos g
						ON g.idgrupo = a.grupoid
						WHERE a.nivelid = $this->intNivelId AND a.carreraid = $this->intCarreraId AND a.grupoid = '$this->intGrupoId' AND a.egresado != 1 AND a.tipo_registro='Alumno' AND a.status = 1 ORDER BY a.matricula, a.apellidos, a.nombres ASC;";
				$request = $this->select_all($sql);
			}else{
				$request = 'exist';
			}

			return $request;
		}

		public function selectData(int $nivelid, int $carreraid, int $materiaid, string $grupoid){
			
			$this->intNivelId = $nivelid;
			$this->intCarreraId = $carreraid;
			$this->intMateriaId = $materiaid;
			$this->intGrupoId = $grupoid;

			/*dep("Nivel: ".$this->intNivelId);
			dep("Carrera: ".$this->intCarreraId);
			dep("Materia: ".$this->intMateriaId);
			dep("Grupo: ".$this->strGrupo);
			exit;*/
			
			$sql = "SELECT profesorid FROM horarios WHERE materiaid = $this->intMateriaId AND carreraid = $this->intCarreraId AND grupoid = '$this->intGrupoId' AND status = 1 ORDER BY idhorario DESC;";
			$request = $this->select($sql);

			return $request;
		}

		public function selectBusquedaCalificaciones(int $nivelid, int $carreraid, int $materiaid, string $grupoid){
			
			$this->intNivelId = $nivelid;
			$this->intCarreraId = $carreraid;
			$this->intMateriaId = $materiaid;
			$this->intGrupoId = $grupoid;
			
			$sql = "SELECT * FROM calificaciones WHERE nivelid = $this->intNivelId AND carreraid = $this->intCarreraId AND materiaid = $this->intMateriaId AND grupoid = $this->intGrupoId AND status != 0";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectPermisivoFecha(int $profesorid, int $materiaid, int $carreraid, string $grupoid){
			/*date_default_timezone_set('America/Mexico_city');
			$strUltimaModificacion = date('Y-m-d');*/
			$this->intProfesorId = $profesorid;
			$this->intMateriaId = $materiaid;
			$this->intCarreraId = $carreraid;
			$this->intGrupoId = $grupoid;
			
			$sql = "SELECT fecha_inicial, fecha_final FROM horarios WHERE profesorid = $this->intProfesorId AND materiaid = $this->intMateriaId AND carreraid = $this->intCarreraId AND grupoid = '$this->intGrupoId' AND status = 1;";
			$request = $this->select($sql);

			return $request;
		}

		public function selectBusquedaNivel(int $nivelid){
			$this->intNivelId = $nivelid;
			
			$sql = "SELECT idnivel, nivel FROM niveles WHERE idnivel = $this->intNivelId AND status = 1;";
			$request = $this->select($sql);

			return $request;
		}

		public function selectBusquedaCarrera(int $carreraid){
			$this->intCarreraId = $carreraid;
			
			$sql = "SELECT idcarrera, carrera FROM carreras WHERE idcarrera = $this->intCarreraId AND status = 1;";
			$request = $this->select($sql);

			return $request;
		}

		public function selectBusquedaDocente(int $idpersona){
			$this->intPersonaId = $idpersona;
			
			$sql = "SELECT idpersona, CONCAT(nombres,' ',apellidos) AS nombre_docente FROM persona WHERE idpersona = $this->intPersonaId AND status = 1;";
			$request = $this->select($sql);

			return $request;
		}

		public function selectBusquedaMateria(int $idmateria){
			$this->intMateriaId = $idmateria;
			
			$sql = "SELECT idmateria, materia FROM materias WHERE idmateria = $this->intMateriaId AND status = 1;";
			$request = $this->select($sql);

			return $request;
		}

		public function selectCalificacionesActa(int $nivelid, int $carreraid, int $materiaid, string $grupoid){
			
			$this->intNivelId = $nivelid;
			$this->intCarreraId = $carreraid;
			$this->intMateriaId = $materiaid;
			$this->intGrupoId = $grupoid;
			
			$sql = "SELECT CONCAT(a.apellidos,' ',a.nombres) AS nombre_alumno, a.idalumno, a.matricula, a.grupoid, CONCAT(p.nombres,' ',p.apellidos) AS nombre_profesor, p.idpersona, m.idmateria, m.materia, n.idnivel, n.nivel, ca.idcarrera, ca.carrera, g.idgrupo, CONCAT(g.grado,'-',g.grupo) AS grupo_format, c.* 
					FROM calificaciones c
					INNER JOIN alumnos a 
					ON a.idalumno = c.alumnoid
					INNER JOIN persona p
					ON p.idpersona = c.profesorid
					INNER JOIN niveles n 
					ON n.idnivel = c.nivelid
					INNER JOIN carreras ca 
					ON ca.idcarrera = c.carreraid
					INNER JOIN materias m 
					ON m.idmateria = c.materiaid
					INNER JOIN grupos g
					ON g.idgrupo = c.grupoid
					WHERE c.nivelid = $this->intNivelId AND c.carreraid = $this->intCarreraId AND c.materiaid = $this->intMateriaId AND c.grupoid = $this->intGrupoId AND c.status != 0 AND a.status !=0 AND cicloid = ".IDCICLO."
					ORDER BY a.apellidos, a.nombres ASC";
			$request = $this->select_all($sql);
			return $request;
		}

	}

 ?>