<?php 

	class CargasModel extends Mysql
	{
		private $intIdCarga;
		private $intDocenteId;
		private $intMateriaId;
		private $intNivelId;
		private $intCarreraId;
		private $strGrupo;
		private $strFechaInicial;
		private $strFechaFinal;
		private $strHoraInicial;
		private $strHoraFinal;
		private $strAula;
		private $strLunes;
		private $strMartes;
		private $strMiercoles;
		private $strJueves;
		private $strViernes;
		private $intPersonaId;
		private $strModificador;
		private $strUltimaModificacion;
		private $strTipoMovimiento;
		private $strComentarios;
		private $strFormatoJson;
		private $strDataElementos;
		private $strListaElementos;
		private $nombreDocente;
		private $strDireccion;
		private $strTelefono;
		private $strEmail;
		private $intRolId;

		public function __construct()
		{
			parent::__construct();
		}	

		public function insertCarga(int $docenteid, int $carreraid, string $grupo, string $modificador, string $tipo_movimiento, string $lista_elementos)
		{
			$this->intDocenteId = $docenteid;
			$this->intCarreraId = $carreraid;
			$this->strGrupo = $grupo;
			$this->strModificador = $modificador;
			$this->strTipoMovimiento = $tipo_movimiento;
			$this->strDataElementos = $lista_elementos;
			$this->strListaElementos = json_decode($lista_elementos, true);
			$arrDataNivel = $this->selectNivelCarrera($this->intCarreraId);
			$this->intNivelId = $arrDataNivel['nivelid'];
		
			/*dep("ID Docente: ".$this->intDocenteId);
			dep("ID Carrera: ".$this->intDocenteId);
			dep("Grupo: ".$this->strGrupo);
			dep("ID Modificador: ".$this->intPersonaId);
			dep("Tipo Movimiento: ".$this->strTipoMovimiento);
			dep("Data Elementos: ".$this->strDataElementos);
			dep($this->strListaElementos);
			dep("Nombre Docente: ".$this->strNombreDocente);
			dep("Apellidos Docente: ".$this->strApellidosDocente);
			dep("Direccion: ".$this->strDireccion);
			dep("Teléfono: ".$this->strTelefono);
			dep("Email: ".$this->strEmail);
			dep($this->strModificador);
			exit;*/

			$sql = "SELECT * FROM persona WHERE (email_user = '{$this->strEmail}' AND idpersona != $this->intDocenteId AND status != 0)";
			$request = $this->select_all($sql);

			if(empty($request))
			{
				
				$query_insert  = "INSERT INTO horarios_json(docenteid,nivelid,carreraid,grupo,data,modificador,tipo_movimiento) 
								  VALUES(?,?,?,?,?,?,?)";
	        	$arrData = array($this->intDocenteId,
	        					$this->intNivelId,
	        					$this->intCarreraId,
        						$this->strGrupo,
        						$this->strDataElementos,
        						$this->strModificador,
        						$this->strTipoMovimiento);
	        	$request_insert = $this->insert($query_insert,$arrData);
	        	

	        	if(intval($request_insert)>0)
	        	{
	        		if(!empty($this->strListaElementos))
	        		{
		        		for ($i=0; $i < count($this->strListaElementos); $i++) { 
			        		$query_asignacion = "INSERT INTO horarios(docenteid,nivelid,materiaid,carreraid,grupo,fecha_inicial,fecha_final,hora_inicial,hora_final,aula,lunes,martes,miercoles,jueves,viernes,modificador,tipo_movimiento,comentarios,formato_json,horariojid) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			        		if($this->strListaElementos[$i]['lunes'] == ''){
			        			$this->strListaElementos[$i]['lunes'] = 0;
			        		}
			        		if($this->strListaElementos[$i]['martes'] == ''){
			        			$this->strListaElementos[$i]['martes'] = 0;
			        		}
			        		if($this->strListaElementos[$i]['miercoles'] == ''){
			        			$this->strListaElementos[$i]['miercoles'] = 0;
			        		}
			        		if($this->strListaElementos[$i]['jueves'] == ''){
			        			$this->strListaElementos[$i]['jueves'] = 0;
			        		}
			        		if($this->strListaElementos[$i]['viernes'] == ''){
			        			$this->strListaElementos[$i]['viernes'] = 0;
			        		}

			        		$arrAsignacion = array($this->intDocenteId,
			        					$this->intNivelId,
		        						$this->strListaElementos[$i]['materia'],
		        						$this->intCarreraId,
		        						$this->strGrupo,
		        						$this->strListaElementos[$i]['fecha_inicial'],
		        						$this->strListaElementos[$i]['fecha_final'],
		        						$this->strListaElementos[$i]['hora_inicial'],
		        						$this->strListaElementos[$i]['hora_final'],
		        						$this->strListaElementos[$i]['aula'],
		        						$this->strListaElementos[$i]['lunes'],
		        						$this->strListaElementos[$i]['martes'],
		        						$this->strListaElementos[$i]['miercoles'],
		        						$this->strListaElementos[$i]['jueves'],
		        						$this->strListaElementos[$i]['viernes'],
		        						$this->strModificador,
		        						$this->strTipoMovimiento,
		        						$this->strListaElementos[$i]['comentarios'],
		        						$this->strDataElementos,
		        						$request_insert);
			        		$request_asignacion = $this->insert($query_asignacion,$arrAsignacion);
			        		$return = $request_asignacion;
		        		}
		   
		        	}

	        	}

			}else{
				$return = "exist";
			}
	        return $return;
		}

		public function UpdateCarga(int $idhorario, int $docenteid, int $carreraid, string $grupo, string $modificador, string $tipo_movimiento, string $lista_elementos){
			$this->intIdCarga = $idhorario;
			$this->intDocenteId = $docenteid;
			$this->intCarreraId = $carreraid;
			$this->strGrupo = $grupo;
			$this->strModificador = $modificador;
			$this->strTipoMovimiento = $tipo_movimiento;
			$this->strDataElementos = $lista_elementos;
			$this->strListaElementos = json_decode($lista_elementos, true);

			$arrDataNivel = $this->selectNivelCarrera($this->intCarreraId);
			$this->intNivelId = $arrDataNivel['nivelid'];

			$sqlDelete = "DELETE FROM horarios WHERE horariojid = $this->intIdCarga ";
			$requestDelete = $this->delete($sqlDelete);

			if(intval($requestDelete)>0)
        	{	

        		$sqlDeleteJson = "DELETE FROM horarios_json WHERE idhorarioj = $this->intIdCarga ";
				$requestDeleteJson = $this->delete($sqlDeleteJson);

				if(intval($requestDeleteJson)>0 && !empty($this->strListaElementos))
        		{
        			
        			$query_insert  = "INSERT INTO horarios_json(docenteid,nivelid,carreraid,grupo,data,modificador,tipo_movimiento) 
								  VALUES(?,?,?,?,?,?,?)";
		        	$arrData = array($this->intDocenteId,
		        					$this->intNivelId,
		        					$this->intCarreraId,
	        						$this->strGrupo,
	        						$this->strDataElementos,
	        						$this->strModificador,
	        						$this->strTipoMovimiento);
		        	$request_insert = $this->insert($query_insert,$arrData);

        			for ($i=0; $i < count($this->strListaElementos); $i++) { 
        				if($this->strListaElementos[$i]['lunes'] == ''){
		        			$this->strListaElementos[$i]['lunes'] = 0;
		        		}
		        		if($this->strListaElementos[$i]['martes'] == ''){
		        			$this->strListaElementos[$i]['martes'] = 0;
		        		}
		        		if($this->strListaElementos[$i]['miercoles'] == ''){
		        			$this->strListaElementos[$i]['miercoles'] = 0;
		        		}
		        		if($this->strListaElementos[$i]['jueves'] == ''){
		        			$this->strListaElementos[$i]['jueves'] = 0;
		        		}
		        		if($this->strListaElementos[$i]['viernes'] == ''){
		        			$this->strListaElementos[$i]['viernes'] = 0;
		        		}

		        		$query_asignacion = "INSERT INTO horarios(docenteid,nivelid,materiaid,carreraid,grupo,fecha_inicial,fecha_final,hora_inicial,hora_final,aula,lunes,martes,miercoles,jueves,viernes,modificador,tipo_movimiento,comentarios,formato_json,horariojid) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		        		$arrAsignacion = array($this->intDocenteId,
		        					$this->intNivelId,
	        						$this->strListaElementos[$i]['materia'],
	        						$this->intCarreraId,
	        						$this->strGrupo,
	        						$this->strListaElementos[$i]['fecha_inicial'],
	        						$this->strListaElementos[$i]['fecha_final'],
	        						$this->strListaElementos[$i]['hora_inicial'],
	        						$this->strListaElementos[$i]['hora_final'],
	        						$this->strListaElementos[$i]['aula'],
	        						$this->strListaElementos[$i]['lunes'],
	        						$this->strListaElementos[$i]['martes'],
	        						$this->strListaElementos[$i]['miercoles'],
	        						$this->strListaElementos[$i]['jueves'],
	        						$this->strListaElementos[$i]['viernes'],
	        						$this->strModificador,
	        						$this->strTipoMovimiento,
	        						$this->strListaElementos[$i]['comentarios'],
	        						$this->strDataElementos,
	        						$request_insert);
		        		$request_asignacion = $this->insert($query_asignacion,$arrAsignacion);
		        		$return = $request_asignacion;
	        		}
        		}else{
        			$return = $requestDeleteJson;
        		}

        	}

		    return $return;			
		}

		public function selectNivelCarrera(int $carreraid)
		{
			$this->intCarreraId = $carreraid;	
			$sql = "SELECT nivelid FROM carreras WHERE idcarrera = $this->intCarreraId";
			$request = $this->select($sql);
			return $request;
		}

		public function selectHorarios()
		{
			$sql = "SELECT CONCAT(p.nombres,' ',p.apellidos) AS nombre_persona, n.nivel, g.idgrupo, g.grado, g.grupo, CONCAT(g.grado,'-',g.grupo) AS grupo_format, DATE_FORMAT(hj.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS datecreated_format, hj.*
					FROM horarios_json hj 
					INNER JOIN persona p
					ON p.idpersona = hj.personaid
					INNER JOIN niveles n
					ON n.idnivel = hj.nivelid
					INNER JOIN grupos g
					ON g.idgrupo = hj.grupoid
					WHERE hj.status = 1 AND hjcicloid=".IDCICLO;
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectDocentes()
		{
			$this->intRolId = RDOCENTE;
			$sql = "SELECT CONCAT(p.nombres,' ',p.apellidos) AS nombre_docente, p.idpersona, p.direccion, p.telefono, p.email_user, DATE_FORMAT(p.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, p.status 
					FROM persona p 
					WHERE p.status != 0 AND rolid = $this->intRolId";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectDocente(int $idpersona)
		{
			$this->intPersonaId = $idpersona;	
			$sql = "SELECT CONCAT(p.nombres,' ',p.apellidos) AS nombre_docente, p.idpersona, p.nombres,p.apellidos, p.idpersona, p.direccion, p.telefono, p.email_user, DATE_FORMAT(p.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS datecreated_format, p.status 
					FROM persona p WHERE p.idpersona = $this->intPersonaId";
			$request = $this->select($sql);
			return $request;
		}

		public function selectMateriasDocente(int $idpersona)
		{
			$this->intPersonaId = $idpersona;	
			$sql = "SELECT * FROM horarios WHERE docenteid = $this->intPersonaId AND status != 0 AND cicloid=".IDCICLO;
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectFormatoDocente(int $idpersona)
		{
			$this->intPersonaId = $idpersona;	
			/*$sql = "SELECT m.materia, c.carrera, CONCAT(p.nombres,' ',p.apellidos) AS nombre_docente, p.direccion, p.telefono, DATE_FORMAT(h.hora_inicial, '%d-%m-%Y') AS fecha_inicial_format, DATE_FORMAT(h.hora_final, '%d-%m-%Y') AS fecha_final_format, DATE_FORMAT(h.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, g.idgrupo, g.carreraid, g.nivelid, h.*
			 		FROM horarios h
			 		INNER JOIN materias m
			 		ON m.idmateria = h.materiaid
			 		INNER JOIN grupos g
			 		ON g.idgrupo = h.grupoid
			 		INNER JOIN carreras c
			 		ON c.idcarrera = g.carreraid
			 		INNER JOIN persona p
			 		ON p.idpersona = h.profesorid
			 		WHERE h.profesorid = $this->intPersonaId AND h.status != 0 ORDER BY h.hora_inicial DESC";*/
	 		$sql="SELECT CONCAT(p.nombres,' ',p.apellidos) AS nombre_profesor, n.nivel, CONCAT(c.abreviatura,'/',g.grado,'-',g.grupo) AS grupo_format, g.idgrupo, g.grado, g.grupo, m.materia, DATE_FORMAT(h.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, c.idcarrera, c.carrera, c.abreviatura, h.* 
					FROM horarios h 
					INNER JOIN persona p 
					ON p.idpersona = h.profesorid
					INNER JOIN grupos g 
					ON g.idgrupo = h.grupoid 
					INNER JOIN materias m 
					ON m.idmateria = h.materiaid 
					INNER JOIN carreras c 
					ON c.idcarrera = h.carreraid
					INNER JOIN niveles n 
					ON n.idnivel = c.nivelid 
					WHERE h.profesorid = $this->intPersonaId AND h.status !=0 AND h.cicloid = ".IDCICLO." ORDER BY h.dia = 'sabado', h.dia = 'viernes', h.dia = 'jueves', h.dia = 'miercoles', h.dia='martes', h.dia='lunes', h.hora_inicial ASC";
			//dep($sql);
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectEditCarga(int $docenteid, int $carreraid, string $grupo)
		{
			$this->intDocenteId = $docenteid;	
			$this->intCarreraId = $carreraid;	
			$this->strGrupo = $grupo;	
			$sql = "SELECT * FROM horarios WHERE docenteid = $this->intDocenteId AND carreraid = $this->intCarreraId AND grupo = '{$this->strGrupo}' AND status != 0";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectMateriasCarrera($carreraid)
		{
			$this->intCarreraId = $carreraid;
			$sql = "SELECT idmateria, materia FROM materias WHERE carreraid = {$this->intCarreraId} AND status != 0";
					$request = $this->select_all($sql);
					return $request;
		}

		public function selectHorario($idhorarioj)
		{
			$this->intIdHorarioJ = $idhorarioj;	
			$sql = "SELECT CONCAT(p.nombres,' ',p.apellidos) AS nombre_persona, n.nivel, g.idgrupo, g.grado, g.grupo, CONCAT(g.grado,'-',g.grupo) AS grupo_format, DATE_FORMAT(hj.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS datecreated_format, hj.*
					FROM horarios_json hj 
					INNER JOIN persona p
					ON p.idpersona = hj.personaid
					INNER JOIN niveles n
					ON n.idnivel = hj.nivelid
					INNER JOIN grupos g
					ON g.idgrupo = hj.grupoid
					WHERE idhorarioj = $this->intIdHorarioJ AND hj.status != 0";
			$request = $this->select($sql);
			return $request;
		}

		public function deleteHorario(int $idhorarioj, string $modificador)
		{
			$this->intIdHorarioJ = $idhorarioj;	
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date("Y-m-d H:i:s");
			$this->strTipoMovimiento = "Eliminación";	
			$sql = "UPDATE horarios_json SET modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idhorarioj = $this->intIdHorarioJ ";
			$arrData = array($this->strModificador,
								$this->strUltimaModificacion,
								$this->strTipoMovimiento,
								0);
			$request = $this->update($sql,$arrData);
			if(intval($request) > 0)
			{
				$sqlDelete = "UPDATE horarios SET modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE horariojid = $this->intIdHorarioJ ";
				$arrDataDelete = array($this->strModificador,
										$this->strUltimaModificacion,
										$this->strTipoMovimiento,
										0);
				$requestDelete = $this->update($sqlDelete,$arrDataDelete);
			}
			return $request;
		}

		public function selectGruposCarrera(int $carreraid)
		{
			$this->intCarreraId = $carreraid;
			//$sql = "SELECT DISTINCT(grado), CONCAT(grado,'-',grupo) AS grupo_format FROM alumnos WHERE carreraid = $this->intCarreraId";
			$sql = "SELECT CONCAT(g.grado,'-',g.grupo) AS grupo_format, g.idgrupo, g.grado, g.grupo, g.carreraid, c.idcarrera, c.carrera
					FROM grupos g
					INNER JOIN carreras c
					ON c.idcarrera = g.carreraid
					WHERE g.status=1 AND g.carreraid=$this->intCarreraId";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectCarreras()
		{
			$sql = "SELECT idcarrera, carrera FROM carreras WHERE status = 1";
					$request = $this->select_all($sql);
					return $request;
		}

		

		/*public function selectGrupos()
		{
			$sql = "SELECT g.idgrupo, g.grado, g.grupo, n.nivel 
					FROM grupos g
					INNER JOIN niveles n
					ON n.idnivel = g.nivelid
					WHERE g.status != 0";
					$request = $this->select_all($sql);
					return $request;
		}*/

		public function selectMaterias()
		{
			$sql = "SELECT idmateria, materia FROM materias WHERE status != 0";
					$request = $this->select_all($sql);
					return $request;
		}

		public function selectUsuarios()
		{
			$sql = "SELECT idpersona, CONCAT(nombres,' ',apellidos) AS nombre FROM persona WHERE status != 0";			
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectNivel(int $grupoid)
		{
			$this->intGrupoId = $grupoid;		
			$sql = "SELECT nivelid FROM grupos WHERE idgrupo = $this->intGrupoId ";
			$request = $this->select($sql);
			return $request;
		}

		public function selectTableHorario($idhorarioj)
		{
			$this->intIdHorarioJ = $idhorarioj;	
			$sql = "SELECT CONCAT(p.nombres,' ',p.apellidos) AS nombre_persona, m.idmateria, m.materia, g.idgrupo, g.grado, g.grupo, CONCAT(g.grado,'-',g.grupo) AS grupo_format, h.*
					FROM horarios h 
					INNER JOIN persona p
					ON p.idpersona = h.profesorid
					INNER JOIN materias m
					ON m.idmateria = h.materiaid
					INNER JOIN grupos g
					ON g.idgrupo = h.grupoid
					WHERE horariojid = $this->intIdHorarioJ AND h.status != 0 ORDER BY h.hora_inicial ASC";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectHorarioJ(int $idhorarioj)
		{	
			$this->intIdHorarioJ = $idhorarioj;
			$sql = "SELECT CONCAT(p.nombres,' ',p.apellidos) AS nombre_persona, n.nivel, g.idgrupo, g.grado, g.grupo, m.materia, hj.data_lunes, hj.data_martes, hj.data_miercoles, hj.data_jueves, hj.data_viernes, DATE_FORMAT(h.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS datecreated_format, h.* 
					FROM horarios h 
					INNER JOIN persona p 
					ON p.idpersona = h.profesorid 
					INNER JOIN grupos g 
					ON g.idgrupo = h.grupoid 
					INNER JOIN niveles n 
					ON n.idnivel = g.nivelid 
					INNER JOIN materias m 
					ON m.idmateria = h.materiaid 
					INNER JOIN horarios_json hj 
					ON hj.idhorarioj = h.horariojid 
					WHERE h.horariojid = $this->intIdHorarioJ AND h.status !=0 ORDER BY h.dia = 'viernes', h.dia = 'jueves', h.dia = 'miercoles', h.dia='martes', h.dia='lunes', h.hora_inicial ASC";
			$request = $this->select_all($sql);
			
			return $request;
		}

		public function selectCantidadMaterias(int $idpersona)
		{
			$this->intPersonaId = $idpersona;
			//$sql = "SELECT COUNT(*) AS cantidad_materias FROM horarios WHERE profesorid = $this->intPersonaId";
			$sql = "SELECT COUNT(*) AS cantidad_materias 
					FROM ( SELECT DISTINCT h.materiaid, h.grupoid FROM horarios h WHERE h.status = 1 AND cicloid=".IDCICLO." AND h.profesorid = $this->intPersonaId ) AS t;";
			$request = $this->select($sql);
			return $request['cantidad_materias'];
		}

	}
 ?>