<?php 

	class CarrerasModel extends Mysql
	{
		private $intIdCarrera;
		private $strCarrera;
		private $strAbreviatura;
		private $strModelo;
		private $strReforma;
		private $strRevision;
		private $intNivelId;
		private $strModalidad;
		private $strModificador;
		private $strUltimaModificacion;
		private $strTipoMovimiento;
		private $intStatus;

		public function __construct()
		{
			parent::__construct();
		}	

		public function insertCarrera(string $carrera, string $abreviatura, string $modelo, string $reforma, string $revision, int $nivelid, string $modalidad, string $modificador, string $tipo_movimiento, int $status){
			$this->strCarrera = $carrera;
			$this->strAbreviatura = $abreviatura;
			$this->strModelo = $modelo;
			$this->strReforma = $reforma;
			$this->strRevision = $revision;
			$this->intNivelId = $nivelid;
			$this->strModalidad = $modalidad;
			$this->strModificador = $modificador;
			$this->strTipoMovimiento = $tipo_movimiento;
			$this->intStatus = $status;
			$return = 0;

			$sql = "SELECT * FROM carreras WHERE (carrera = '{$this->strCarrera}' AND reforma = '{$this->strReforma}' AND status != 0)";
			$request = $this->select_all($sql);

			if(empty($request))
			{
				$query_insert  = "INSERT INTO carreras(carrera,abreviatura,modelo,reforma,revision,nivelid,modalidad,modificador,tipo_movimiento,status) 
								  VALUES(?,?,?,?,?,?,?,?,?,?)";
	        	$arrData = array($this->strCarrera,
									$this->strAbreviatura,
									$this->strModelo,
									$this->strReforma,
									$this->strRevision,
									$this->intNivelId,
									$this->strModalidad,
									$this->strModificador,
									$this->strTipoMovimiento,
									$this->intStatus);
	        	$request_insert = $this->insert($query_insert,$arrData);
	        	$return = $request_insert;
			}else{
				$return = "exist";
			}
	        return $return;
		}

		public function updateCarrera(int $idcarrera, string $carrera, string $abreviatura, string $modelo, string $reforma, string $revision, int $nivelid, string $modalidad, string $modificador, string $tipo_movimiento, int $status){
			date_default_timezone_set('America/Mexico_city');
			$this->intIdCarrera = $idcarrera;
			$this->strCarrera = $carrera;
			$this->strAbreviatura = $abreviatura;
			$this->strModelo = $modelo;
			$this->strReforma = $reforma;
			$this->strRevision = $revision;
			$this->intNivelId = $nivelid;
			$this->strModalidad = $modalidad;
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date("Y-m-d H:i:s");
			$this->strTipoMovimiento = $tipo_movimiento;     
			$this->intStatus = $status;

			$sql = "SELECT * FROM carreras WHERE (carrera = '{$this->strCarrera}' AND idcarrera != $this->intIdCarrera AND status != 0)";
			$request = $this->select_all($sql);

			if(empty($request))
			{
				$sql = "UPDATE carreras SET carrera = ?, abreviatura = ?, modelo = ?, reforma = ?, revision = ?, nivelid= ?, modalidad = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idcarrera = $this->intIdCarrera;";
				$arrData = array($this->strCarrera,
									$this->strAbreviatura,
									$this->strModelo,
									$this->strReforma,
									$this->strRevision,
									$this->intNivelId,
									$this->strModalidad,
									$this->strModificador,
									$this->strUltimaModificacion,
									$this->strTipoMovimiento,
									$this->intStatus);
				$request = $this->update($sql,$arrData);
			}else{
				$request = "exist";
			}
		    return $request;			
		}

		public function selectCarreras()
		{
			$sql = "SELECT DATE_FORMAT(c.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, n.idnivel, n.nivel, c.*
					FROM carreras c 
					INNER JOIN niveles n
					ON n.idnivel = c.nivelid
					WHERE c.status != 0";
					$request = $this->select_all($sql);
					return $request;
		}

		public function selectCarrera(int $idcarrera)
		{
			$this->intIdCarrera = $idcarrera;
			$sql = "SELECT DATE_FORMAT(c.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, n.idnivel, n.nivel, c.*
					FROM carreras c 
					INNER JOIN niveles n
					ON n.idnivel = c.nivelid
					WHERE c.idcarrera = $this->intIdCarrera";
			$request = $this->select($sql);
			return $request;
		}

		public function deleteCarrera(int $idcarrera, string $modificador)
		{
			date_default_timezone_set('America/Mexico_city');
			$this->intIdCarrera = $idcarrera;		
			$this->strModificador = $modificador;
			$this->strTipoMovimiento = "Eliminación";
			$this->strUltimaModificacion = date("Y-m-d H:i:s");
			$sql = "UPDATE carreras SET modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idcarrera = $this->intIdCarrera ";
			$arrData = array($this->strModificador,
								$this->strUltimaModificacion,
								$this->strTipoMovimiento,
								0);
			$request = $this->update($sql,$arrData);
			return $request;
		}

		public function selectNiveles()
		{
			$sql = "SELECT idnivel, nivel FROM niveles  WHERE status != 0";
			$request = $this->select_all($sql);
			return $request;
		}
	}
 ?>