<?php 
class CcomputoModel extends Mysql
{
	private $intIdSolicitud;
	private $intPersonaId;
	private $strCentroComputo;
	private $strDescripcion;
	private $strHoraInicial;
	private $strHoraFinal;
	private $strFechaInicial;
	private $strFechaFinal;
	private $strEstado;
	private $strFechaSolicitud;
	private $data;
	private $dataJson;
	private $strModificador;
	private $strUltimaModificacion;
	private $strTipoMovimiento;
	private $intStatus;
	
	public function __construct()
	{
		parent::__construct();
	}	

	public function insertSolicitud(int $personaid, string $centro_computo, string $descripcion, string $hora_inicial, string $hora_final, string $fecha_inicial, string $fecha_final, string $data){
		$this->intPersonaId = $personaid;
		$this->strCentroComputo = $centro_computo;
		$this->strDescripcion = $descripcion;
		$this->strHoraInicial = $hora_inicial;
		$this->strHoraFinal = $hora_final;
		$this->strFechaInicial = $fecha_inicial;
		$this->strFechaFinal = $fecha_final;
		$this->strData = $data;
		$this->strDataJson = json_decode($data, true);
		$this->strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];

		$return = 0;
		$sql = "SELECT * FROM centros_computo WHERE descripcion = '{$this->strDescripcion}' AND hora_inicial = '{$this->strHoraInicial}' AND hora_final = '{$this->strHoraFinal}' AND fecha_inicial = '{$this->strFechaInicial}' AND centro_computo = '{$this->strCentroComputo}'";
		$request = $this->select_all($sql);

		if(empty($request))
		{
			$query_insert  = "INSERT INTO centros_computo(personaid,centro_computo,descripcion,hora_inicial,hora_final,fecha_inicial,fecha_final,modificador) 
							  VALUES(?,?,?,?,?,?,?,?)";
        	$arrData = array($this->intPersonaId,
    						$this->strCentroComputo,
    						$this->strDescripcion,
    						$this->strHoraInicial,
    						$this->strHoraFinal,
    						$this->strFechaInicial,
    						$this->strFechaFinal,
    						$this->strModificador);
        	$request_insert = $this->insert($query_insert,$arrData);
        	$return = $request_insert;
		}else{
			$return = "exist";
		}
        return $return;
	}

	public function updateSolicitud(int $idsolicitud, int $personaid, string $centro_computo, string $descripcion, string $hora_inicial, string $hora_final, string $fecha_inicial, string $fecha_final, string $estado, string $comentarios_ti, string $data){
		$this->intIdSolicitud = $idsolicitud;
		$this->intPersonaId = $personaid;
		$this->strCentroComputo = $centro_computo;
		$this->strDescripcion = $descripcion;
		$this->strHoraInicial = $hora_inicial;
		$this->strHoraFinal = $hora_final;
		$this->strFechaInicial = $fecha_inicial;
		$this->strFechaFinal = $fecha_final;
		$this->strEstado = $estado;
		$this->strComentarios = $comentarios_ti;
		$this->strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
		$this->strUltimaModificacion = date('Y-m-d h:i:s');
		$this->strTipoMovimiento = 'Actualización';

		$sql = "SELECT * FROM centros_computo WHERE descripcion = '{$this->strDescripcion}' AND hora_inicial = '{$this->strHoraInicial}' AND hora_final = '{$this->strHoraFinal}' AND fecha_inicial = '{$this->strFechaInicial}' AND centro_computo = '{$this->strCentroComputo}' AND idsolicitud != $this->intIdSolicitud";
		$request = $this->select_all($sql);

		if(empty($request))
		{	
			$sql = "UPDATE centros_computo SET centro_computo=?, descripcion=?, hora_inicial=?, hora_final=?, fecha_inicial=?, fecha_final=?, estado=?, comentarios_ti = ?, modificador=?, ultima_modificacion=?, tipo_movimiento=? WHERE idsolicitud = $this->intIdSolicitud ";
			$arrData = array($this->strCentroComputo,
    						$this->strDescripcion,
    						$this->strHoraInicial,
    						$this->strHoraFinal,
    						$this->strFechaInicial,
    						$this->strFechaFinal,
    						$this->strEstado,
    						$this->strComentarios,
    						$this->strModificador,
    						$this->strUltimaModificacion,
    						$this->strTipoMovimiento);
			$request = $this->update($sql,$arrData);
		}else{
			$request = "exist";
		}
		return $request;
	}

	public function selectSolicitudes()
	{
		$sql = "SELECT CONCAT(p.nombres,' ',p.apellidos) AS nombre_solicitante, DATE_FORMAT(c.fecha_inicial, '%d-%m-%Y') AS fecha_inicial_format, DATE_FORMAT(c.fecha_final, '%d-%m-%Y') AS fecha_final_format, CONCAT(c.hora_inicial,'-',c.hora_final) AS format_horario, c.*
				 FROM centros_computo c
				 INNER JOIN persona p
				 ON p.idpersona = c.personaid
				 WHERE c.status != 0";
		$request = $this->select_all($sql);
		return $request;
	}

	public function selectSolicitud($idsolicitud)
	{
		$this->intIdSolicitud = $idsolicitud;
		$sql = "SELECT CONCAT(p.nombres,' ',p.apellidos) AS nombre_solicitante, DATE_FORMAT(c.fecha_inicial, '%d-%m-%Y') AS fecha_inicial_format, DATE_FORMAT(c.fecha_final, '%d-%m-%Y') AS fecha_final_format, CONCAT(c.hora_inicial,'-',c.hora_final) AS format_horario, c.*
				 FROM centros_computo c
				 INNER JOIN persona p
				 ON p.idpersona = c.personaid
				 WHERE c.idsolicitud = $this->intIdSolicitud AND c.status != 0"; 
		$request = $this->select($sql);
		return $request;
	}

	public function updateEstado(int $idsolicitud, string $estado, string $tipo_movimiento, string $modificador)
	{
		$this->intIdSolicitud = $idsolicitud;		
		$this->strEstado = $estado;		
		$this->strModificador = $modificador;
		$this->strUltimaModificacion = date("Y-m-d H:i:s");
		$this->strTipoMovimiento = $tipo_movimiento;
		$sql = "UPDATE centros_computo SET estado = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ? WHERE idsolicitud = $this->intIdSolicitud ";
		$arrData = array($this->strEstado,
						$this->strModificador,
						$this->strUltimaModificacion,
						$this->strTipoMovimiento);
		$request = $this->update($sql,$arrData);
		return $request;
	}

	public function deleteSolicitud(int $idsolicitud)
	{
		$this->intIdSolicitud = $idsolicitud;
		$this->strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
		$this->strUltimaModificacion = date('Y-m-d h:i:s');
		$this->strTipoMovimiento = "Eliminación";
		$sql = "UPDATE centros_computo SET modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idsolicitud = $this->intIdSolicitud ";
		$arrData = array($this->strModificador,
							$this->strUltimaModificacion,
							$this->strTipoMovimiento,
							0);
		$request = $this->update($sql,$arrData);
		return $request;
	}

}

 ?>