<?php 
	#[\AllowDynamicProperties]
	class CiclosModel extends Mysql
	{
		private $intIdCiclo;
		private $strCicloEscolar;
		private $strModificador;
		private $strUltimaModificacion;
		private $strTipoMovimiento;
		private $strStatus;
		private $intStatus;

		public function __construct()
		{
			parent::__construct();
		}	

		public function insertCiclo(string $ciclo_escolar, string $modificador, int $status){
			$this->strCicloEscolar = $ciclo_escolar;
			$this->strModificador = $modificador;
			$this->intStatus = $status;
			$return = 0;
			$condicion=0;
	
			$sql = "SELECT * FROM ciclos_escolares WHERE (ciclo_escolar = '{$this->strCicloEscolar}' AND status !=0)";
			$request = $this->select_all($sql);
			if(!empty($request)){
				$condicion++;
			}
			if($this->intStatus == 1){
				$sqlStatus = "SELECT * FROM ciclos_escolares WHERE (status = 1)";
				$requestStatus = $this->select_all($sqlStatus);
				if(!empty($requestStatus)){
					$condicion++;
				}
			}
			

			if($condicion == 0)
			{
				$query_insert  = "INSERT INTO ciclos_escolares(ciclo_escolar,modificador,status) 
								  VALUES(?,?,?)";
	        	$arrData = array($this->strCicloEscolar,
        						$this->strModificador,
        						$this->intStatus);
	        	$request_insert = $this->insert($query_insert,$arrData);
	        	$return = $request_insert;
			}else{
				$return = "exist";
			}
	        return $return;
		}

		public function updateCiclo(int $idciclo, string $ciclo_escolar, string $modificador, int $status){
			date_default_timezone_set('America/Mexico_city');
			$this->intIdCiclo = $idciclo;
			$this->strCicloEscolar = $ciclo_escolar;
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date('Y-m-d h:i:s');
			$this->strTipoMovimiento = "Actualización";
			$this->intStatus = $status;

			$sql = "SELECT * FROM ciclos_escolares WHERE (ciclo_escolar = '{$this->strCicloEscolar}' AND idciclo != $this->intIdCiclo AND status != 0)";
			$request = $this->select_all($sql);

			if(empty($request))
			{
				$sql = "UPDATE ciclos_escolares SET modificador=?, ultima_modificacion=?, tipo_movimiento = ?, status = ? WHERE idciclo = $this->intIdCiclo ";
				$arrData = array($this->strModificador,
        						$this->strUltimaModificacion,
        						$this->strTipoMovimiento,
        						$this->intStatus);
				$request = $this->update($sql,$arrData);
			}else{
				$request = "exist";
			}
		    return $request;			
		}

		public function selectCiclos()
		{
			$sql = "SELECT *, DATE_FORMAT(ultima_modificacion, '%d-%m-%Y %H:i%:%s') AS ultima_modificacion_format 
					FROM ciclos_escolares 
					WHERE status != 0";
					$request = $this->select_all($sql);
					return $request;
		}

		public function selectCiclo(int $idciclo){
			$this->intIdCiclo = $idciclo;
			$sql = "SELECT *, DATE_FORMAT(ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format
					FROM ciclos_escolares 
					WHERE idciclo = $this->intIdCiclo";
			$request = $this->select($sql);
			return $request;
		}

		public function deleteMateria(int $idciclo, string $modificador, string $tipo_movimiento)
		{
			date_default_timezone_set('America/Mexico_city');
			$this->intIdCiclo = $idciclo;
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date('Y-m-d h:i:s');
			$this->strTipoMovimiento = $tipo_movimiento;	
			$requestAsignacion = $this->selectAsignacionCiclo($this->intIdCiclo);
			if(empty($requestAsignacion) > 0){
				$sql = "UPDATE materias SET modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idciclo = $this->intIdMateria ";
				$arrData = array($this->strModificador,
									$this->strUltimaModificacion,
									$this->strTipoMovimiento,
									0);
				$request = $this->update($sql,$arrData);
			}else{
				$request = "ciclo";
			}
			return $request;
		}

		public function selectAsignacionCiclo($idciclo)
		{
			$this->intIdCiclo = $idciclo;
			$sql = "SELECT ciclo_escolar FROM grupos WHERE cicloid = $this->intIdCiclo AND status != 0;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function updateStatus(int $idciclo, string $status, string $modificador, string $tipo_movimiento)
		{
			date_default_timezone_set('America/Mexico_city');
			$this->intIdCiclo = $idciclo;
			$this->strStatus = $status;
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date('Y-m-d H:i:s');
			$this->strTipoMovimiento = $tipo_movimiento;
			$this->intStatus;
			$request;

			if($this->strStatus=="Activo"){
				$sql = "SELECT * FROM ciclos_escolares WHERE status = 1";
				$request = $this->select($sql);
				$this->intStatus = 1;
			}else{
				$this->intStatus = 2;
			}

			if(empty($request)){
				$sqlUpdate = "UPDATE ciclos_escolares SET modificador=?,ultima_modificacion=?,tipo_movimiento=?,status=? WHERE idciclo = $this->intIdCiclo;";
				$arrDataUpdate = array($this->strModificador,
										$this->strUltimaModificacion,
										$this->strTipoMovimiento,
										$this->intStatus);
				$requestUpdate = $this->update($sqlUpdate,$arrDataUpdate);
			}else{
				$requestUpdate="exist";
			}
			
			return $requestUpdate;
		}

	}

 ?>