<?php 
	class DashboardModel extends Mysql
	{
		public function __construct()
		{
			parent::__construct();
		}

		public function selectUsuarios()
		{
			$sql = "SELECT * FROM persona WHERE status != 0";
			$request = $this->select_all($sql); 
			return $request;
		}

		public function selectAlumnos()
		{
			$whereTutor="";
			/*if($_SESSION['userData']['idrol'] == RTUTOR)
			{
				$personaid=$_SESSION['userData']['idpersona'];
				$whereTutor=" AND personaid=$personaid ";
			}else{
				$whereTutor="";
			}*/
			
			$sql = "SELECT n.idnivel, n.nivel, CONCAT(a.nombres,' ',a.apellidos) AS nombre_alumno, g.grado, g.grupo, a.* 
					FROM alumnos a  
					INNER JOIN niveles n
					ON n.idnivel = a.nivelid
					INNER JOIN grupos g
					ON g.idgrupo = a.grupoid 
					WHERE a.baja != 0 AND a.status=1 $whereTutor ORDER BY a.matricula ASC, a.apellidos ASC LIMIT 100"; 
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectDocentes()
		{	
			$sql = "SELECT * FROM persona WHERE rolid = ".RDOCENTE." AND status != 0 ORDER BY identificador ASC, apellidos ASC LIMIT 100";
			$request = $this->select_all($sql); 
			return $request;
		}

		public function selectNiveles()
		{	
			$sql = "SELECT idnivel, nivel, DATE_FORMAT(ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, status FROM niveles WHERE status != 0 LIMIT 100";
			$request = $this->select_all($sql); 
			return $request;
		}

		public function selectCarreras()
		{	
			$sql = "SELECT idcarrera, carrera, reforma, DATE_FORMAT(ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, status FROM carreras WHERE status != 0 LIMIT 100";
			$request = $this->select_all($sql); 
			return $request;
		}

		public function selectExtensiones()
		{	
			$sql = "SELECT idequipo, extension, usuario, DATE_FORMAT(ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, status FROM equipos WHERE status != 0 ORDER BY extension ASC LIMIT 100";
			$request = $this->select_all($sql); 
			return $request;
		}

		public function distribucionGenero()
		{
			$sql = "SELECT DISTINCT sexo as sexo, COUNT(*) AS cantidad FROM alumnos GROUP BY sexo;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function distribucionEscuelas()
		{
			$sql = "SELECT DISTINCT escuela_procedencia as escuela_procedencia, COUNT(*) AS cantidad FROM alumnos GROUP BY escuela_procedencia ORDER BY cantidad DESC;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function distribucionColonias()
		{
			$sql = "SELECT DISTINCT colonia as colonia, COUNT(*) AS cantidad FROM alumnos GROUP BY colonia ORDER BY cantidad DESC;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function distribucionBecados()
		{
			$sql = "SELECT DISTINCT beca as beca, COUNT(*) AS cantidad FROM alumnos GROUP BY beca LIMIT 100;";
			$request = $this->select_all($sql);
			for ($i=0; $i < count($request); $i++) { 
				if($request[$i]['beca'] == 1){
					$request[$i]['beca'] = 'Becado';
				}else{
					$request[$i]['beca'] = 'No Becado';
				}
			}
			return $request;
		}

		public function distribucionPaisNacimiento()
		{
			$sql = "SELECT DISTINCT pais_nacimiento, COUNT(*) AS cantidad  
					FROM alumnos 
					GROUP BY pais_nacimiento
					ORDER BY cantidad DESC; LIMIT 100";
			$request = $this->select_all($sql);
			return $request;
		}

		public function distribucionTipoBeca()
		{
			$sql = "SELECT DISTINCT tipo_beca, COUNT(*) AS cantidad  
					FROM alumnos 
					GROUP BY tipo_beca; LIMIT 100";
			$request = $this->select_all($sql);
			return $request;
		}

		public function distribucionMedioPromocion()
		{
			$sql = "SELECT DISTINCT medio_promocion, COUNT(*) AS cantidad  
					FROM alumnos 
					GROUP BY medio_promocion
					ORDER BY cantidad DESC; LIMIT 100";
			$request = $this->select_all($sql);
			return $request;
		}

		public function distribucionNiveles()
		{
			$sql = "SELECT DISTINCT a.nivelid as idnivel, COUNT(*) AS cantidad, n.nivel 
					FROM alumnos a 
					INNER JOIN niveles n 
					ON n.idnivel = a.nivelid  
					GROUP BY idnivel LIMIT 100;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function distribucionGrupos()
		{
			$sql = "SELECT DISTINCT a.grupoid as idgupo, COUNT(*) AS cantidad, g.grado, g.grupo, n.idnivel, n.nivel
					FROM alumnos a 
					INNER JOIN grupos g 
					ON g.idgrupo = a.grupoid 
					INNER JOIN niveles n 
					ON n.idnivel = g.nivelid 
					GROUP BY idgupo LIMIT 100;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectIngresosMes(int $anio, int $mes){
			$rolid = $_SESSION['userData']['idrol'];
			$idUser = $_SESSION['userData']['idpersona'];
			$where = "";
			
			$totalIngresosMes = 0;
			$arrIngresoDias = array();
			$dias = cal_days_in_month(CAL_GREGORIAN,$mes, $anio);
			$n_dia = 1;
			for ($i=0; $i < $dias ; $i++) { 
				$date = date_create($anio."-".$mes."-".$n_dia);
				$fechaIngreso = date_format($date,"Y-m-d");
				$sql = "SELECT DAY(fecha_pago) AS dia, COUNT(idpago) AS cantidad, SUM(importe) AS total 
						FROM pagos 
						WHERE DATE(fecha_pago) = '$fechaIngreso' AND status = 1 ".$where;
				$ingresoDia = $this->select($sql);
				$ingresoDia['dia'] = $n_dia;
				$ingresoDia['total'] = $ingresoDia['total'] == "" ? 0 : $ingresoDia['total'];
				$totalIngresosMes += $ingresoDia['total'];
				array_push($arrIngresoDias, $ingresoDia);
				$n_dia++;
			}
			$meses = Meses();
			$arrData = array('anio' => $anio, 'mes' => $meses[intval($mes-1)], 'total' => $totalIngresosMes,'ingresos' => $arrIngresoDias );
			return $arrData;
		}

		public function selectIngresosAnio(int $anio){
			$arrMIngresos = array();
			$arrMeses = Meses();
			for ($i=1; $i <= 12; $i++) { 
				$arrData = array('anio'=>'','no_mes'=>'','mes'=>'','ingreso'=>'');
				$sql = "SELECT $anio AS anio, $i AS mes, SUM(importe) AS ingreso 
						FROM pagos 
						WHERE MONTH(fecha_pago)= $i AND YEAR(fecha_pago) = $anio AND status = 1 
						GROUP BY MONTH(fecha_pago) ";
				$ingresoMes = $this->select($sql);
				$arrData['mes'] = $arrMeses[$i-1];
				if(empty($ingresoMes)){
					$arrData['anio'] = $anio;
					$arrData['no_mes'] = $i;
					$arrData['ingreso'] = 0;
				}else{
					$arrData['anio'] = $ingresoMes['anio'];
					$arrData['no_mes'] = $ingresoMes['mes'];
					$arrData['ingreso'] = $ingresoMes['ingreso'];
				}
				array_push($arrMIngresos, $arrData);
				# code...
			}
			$arrIngresos = array('anio' => $anio, 'meses' => $arrMIngresos);
			return $arrIngresos;
		}

		public function selectGastosMes(int $anio, int $mes){
			$rolid = $_SESSION['userData']['idrol'];
			$idUser = $_SESSION['userData']['idpersona'];
			$where = "";
			
			$totalGastosMes = 0;
			$arrGastoDias = array();
			$dias = cal_days_in_month(CAL_GREGORIAN,$mes, $anio);
			$n_dia = 1;
			for ($i=0; $i < $dias ; $i++) { 
				$date = date_create($anio."-".$mes."-".$n_dia);
				$fechaGasto = date_format($date,"Y-m-d");
				$sql = "SELECT DAY(fecha_gasto) AS dia, COUNT(idgasto) AS cantidad, SUM(cantidad) AS total 
						FROM gastos 
						WHERE DATE(fecha_gasto) = '$fechaGasto' AND status = 1 ".$where;
				$gastoDia = $this->select($sql);
				$gastoDia['dia'] = $n_dia;
				$gastoDia['total'] = $gastoDia['total'] == "" ? 0 : $gastoDia['total'];
				$totalGastosMes += $gastoDia['total'];
				array_push($arrGastoDias, $gastoDia);
				$n_dia++;
			}
			$meses = Meses();
			$arrData = array('anio' => $anio, 'mes' => $meses[intval($mes-1)], 'total' => $totalGastosMes,'gastos' => $arrGastoDias );
			return $arrData;
		}

		public function selectGastosAnio(int $anio){
			$arrMGastos = array();
			$arrMeses = Meses();
			for ($i=1; $i <= 12; $i++) { 
				$arrData = array('anio'=>'','no_mes'=>'','mes'=>'','gasto'=>'');
				$sql = "SELECT $anio AS anio, $i AS mes, SUM(cantidad) AS gasto 
						FROM gastos 
						WHERE MONTH(fecha_gasto)= $i AND YEAR(fecha_gasto) = $anio AND status = 1 
						GROUP BY MONTH(fecha_gasto) ";
				$gastoMes = $this->select($sql);
				$arrData['mes'] = $arrMeses[$i-1];
				if(empty($gastoMes)){
					$arrData['anio'] = $anio;
					$arrData['no_mes'] = $i;
					$arrData['gasto'] = 0;
				}else{
					$arrData['anio'] = $gastoMes['anio'];
					$arrData['no_mes'] = $gastoMes['mes'];
					$arrData['gasto'] = $gastoMes['gasto'];
				}
				array_push($arrMGastos, $arrData);
				# code...
			}
			$arrGastos = array('anio' => $anio, 'meses' => $arrMGastos);
			return $arrGastos;
		}

		public function selectLastEvents(){
			date_default_timezone_set("America/Mexico_city");
			$fechaInicial = date("Y-m-d");
			$fechaFinal = strtotime('+30 day', strtotime($fechaInicial));
			$fechaFinal = date('Y-m-d', $fechaFinal);
			$sql = "SELECT DATE_FORMAT(e.fecha_inicial, '%d-%m-%Y') AS fecha_inicial_format, DATE_FORMAT(e.fecha_final, '%d-%m-%Y') AS fecha_final_format, e.idevento, e.evento, e.nivel 
					FROM eventos e 
					WHERE e.status != 0 AND fecha_inicial BETWEEN '$fechaInicial' AND '$fechaFinal' ORDER BY e.fecha_inicial ASC LIMIT 10;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectLastBirthdays(){
			date_default_timezone_set("America/Mexico_city");
			$fechaInicial = date("Y-m-d");
			$fechaIncialEntero = strtotime($fechaInicial);
			$mesInicial = date('m', $fechaIncialEntero);
			$fechaFinal = strtotime('+1 month', strtotime($fechaInicial));
			$mesFinal = date('m', $fechaFinal);
			$fechaFinal = date('Y-m-d', $fechaFinal);
			$sql = "SELECT CONCAT(nombres,' ',apellidos) AS nombre_alumno, DATE_FORMAT(fecha_nacimiento, '%d-%m-%Y') AS fecha_format, matricula FROM alumnos WHERE status != 0 AND MONTH(fecha_nacimiento) BETWEEN '$mesInicial' AND '$mesFinal' ORDER BY fecha_nacimiento ASC LIMIT 10;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function cantUsuarios()
		{
			$sql = "SELECT COUNT(*) as total FROM persona WHERE status != 0";
			$request = $this->select($sql);
			$total = $request['total']; 
			return $total;
		}

		public function cantEmpleados()
		{
			$whereAdmin="";
			if($_SESSION['userData']['idrol']==2){
				$whereAdmin=" AND supervisorid=".$_SESSION['userData']['idpersona'].";";
				//$whereAdmin = "AND supervisorid = ".$_SESSION['userData']['idpersona']."; ";
			}
			$sql = "SELECT COUNT(*) as total FROM empleados WHERE estatus != 0 $whereAdmin";
			$request = $this->select($sql);
			$total = $request['total']; 
			return $total;
		}

		public function cantEmpleadosHombres()
		{
			$whereAdmin="";
			if($_SESSION['userData']['idrol']==2){
				$whereAdmin=" AND supervisorid=".$_SESSION['userData']['idpersona'].";";
				//$whereAdmin = "AND supervisorid = ".$_SESSION['userData']['idpersona']."; ";
			}
			$sql = "SELECT COUNT(*) as total FROM empleados WHERE sexo = 'M' $whereAdmin";
			$request = $this->select($sql);
			$total = $request['total']; 
			return $total;
		}

		public function cantEmpleadosMujeres()
		{
			$whereAdmin="";
			if($_SESSION['userData']['idrol']==2){
				$whereAdmin=" AND supervisorid=".$_SESSION['userData']['idpersona'].";";
				//$whereAdmin = "AND supervisorid = ".$_SESSION['userData']['idpersona']."; ";
			}
			$sql = "SELECT COUNT(*) as total FROM empleados WHERE sexo = 'F' $whereAdmin";
			$request = $this->select($sql);
			$total = $request['total']; 
			return $total;
		}

		public function cantEmpleadosPlus()
		{
			$whereAdmin="";
			if($_SESSION['userData']['idrol']==2){
				$whereAdmin=" AND supervisorid=".$_SESSION['userData']['idpersona'].";";
				//$whereAdmin = "AND supervisorid = ".$_SESSION['userData']['idpersona']."; ";
			}
			$sql = "SELECT COUNT(*) as total FROM empleados WHERE categoria = 'Especialista Plus' $whereAdmin";
			$request = $this->select($sql);
			$total = $request['total']; 
			return $total;
		}

		public function cantEmpleadosEspecialistas()
		{
			$whereAdmin="";
			if($_SESSION['userData']['idrol']==2){
				$whereAdmin=" AND supervisorid=".$_SESSION['userData']['idpersona'].";";
				//$whereAdmin = "AND supervisorid = ".$_SESSION['userData']['idpersona']."; ";
			}
			$sql = "SELECT COUNT(*) as total FROM empleados WHERE categoria = 'Especialista' $whereAdmin";
			$request = $this->select($sql);
			$total = $request['total']; 
			return $total;
		}

		public function cantEmpleadosOficiales()
		{
			$whereAdmin="";
			if($_SESSION['userData']['idrol']==2){
				$whereAdmin=" AND supervisorid=".$_SESSION['userData']['idpersona'].";";
				//$whereAdmin = "AND supervisorid = ".$_SESSION['userData']['idpersona']."; ";
			}
			$sql = "SELECT COUNT(*) as total FROM empleados WHERE categoria = 'Oficial' $whereAdmin";
			$request = $this->select($sql);
			$total = $request['total']; 
			return $total;
		}

		public function cantEmpleadosGenerales()
		{
			$whereAdmin="";
			if($_SESSION['userData']['idrol']==2){
				$whereAdmin=" AND supervisorid=".$_SESSION['userData']['idpersona'].";";
				//$whereAdmin = "AND supervisorid = ".$_SESSION['userData']['idpersona']."; ";
			}
			$sql = "SELECT COUNT(*) as total FROM empleados WHERE categoria = 'General' $whereAdmin";
			$request = $this->select($sql);
			$total = $request['total']; 
			return $total;
		}

		public function distribucionDepartamentos()
		{
			$whereAdmin="";
			if($_SESSION['userData']['idrol']==2){
				$whereAdmin="WHERE supervisorid=".$_SESSION['userData']['idpersona']."";
			}
			$sql = "SELECT DISTINCT e.departamentoid as departamentoid, d.departamento AS departamento, COUNT(*) AS cantidad 
					FROM empleados e
					INNER JOIN departamentos d
					ON e.departamentoid = d.iddepartamento
					$whereAdmin GROUP BY departamento;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function distribucionCategorias()
		{
			$whereAdmin="";
			if($_SESSION['userData']['idrol']==2){
				$whereAdmin="WHERE supervisorid=".$_SESSION['userData']['idpersona']."";
			}
			$sql = "SELECT DISTINCT categoria as categoria, COUNT(*) AS cantidad FROM empleados $whereAdmin GROUP BY categoria;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function distribucionAreas()
		{
			$whereAdmin="";
			if($_SESSION['userData']['idrol']==2){
				$whereAdmin="WHERE supervisorid=".$_SESSION['userData']['idpersona']."";
			}
			$sql = "SELECT DISTINCT e.areaid as areaid, a.area AS area, COUNT(*) AS cantidad 
					FROM empleados e
					INNER JOIN areas a 
					ON e.areaid = a.idarea
					 $whereAdmin GROUP BY area;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function distribucionFacilitadores()
		{
			$whereAdmin="";
			if($_SESSION['userData']['idrol']==2){
				$whereAdmin="WHERE supervisorid=".$_SESSION['userData']['idpersona']."";
			}
			$sql = "SELECT DISTINCT e.supervisorid as supervisorid, CONCAT(p.nombres,' ',p.apellidos) AS supervisor, COUNT(*) AS cantidad 
					FROM empleados e 
					INNER JOIN persona p 
					ON e.supervisorid = p.idpersona 
					$whereAdmin GROUP BY supervisor;";
			$request = $this->select_all($sql);
			return $request;
		}
	}
 ?>