<?php 

	class Editar_calificacionesModel extends Mysql
	{
		private $intIdKardex;
		private $intIdKardexj;
		private $strMatricula;
		private $intNivelId;
		private $intCarreraId;
		private $intSemestre;
		private $intMateriaId;
		private $intHorarioId;
		private $intAlumnoId;
		private $intProfesorId;
		private $intGrupoId;
		private $strGrupoFormat;
		private $strGrado;
		private $strGrupo;
		private $strCalificacionA;
		private $strFechaCapturaA;
		private $strCalificacionB;
		private $strFechaCapturaB;
		private $strCalificacionC;
		private $strFechaCapturaC;
		private $strCalificacionD;
		private $strFechaCapturaD;
		private $strFechaCaptura;
		private $intPersonaId;
		private $strModificador;
		private $strUltimaModificacion;
		private $strEliminar;
		private $intCicloId;
		private $intStatus;
		private $strFecha;

		public function __construct()
		{
			parent::__construct();
		}	

		public function updateCalificaciones(int $idkardexj, string $matricula, int $nivelid, int $carreraid, int $semestre, int $grupoid, int $profesorid, int $materiaid, string $data, string $fecha_captura, string $modificador, string $tipo_movimiento)
		{
			date_default_timezone_set('America/Mexico_city');
			$this->strFecha = date('Y-m-d');
			$this->intIdKardexj = $idkardexj;
			$this->strMatricula = $matricula;
			$this->intNivelId = $nivelid;
			$this->intCarreraId = $carreraid;
			$this->intSemestre = $semestre;
			$this->intGrupoId = $grupoid;
			$this->intProfesorId = $profesorid;
			$this->intMateriaId = $materiaid;
			$this->strDataJson = $data;
			$this->strFechaCaptura = $fecha_captura;
			$this->strDataArray = json_decode($data, true);
			$this->strModificador = $modificador;
			$this->strTipoMovimiento = $tipo_movimiento;
			$this->strEliminar = "Eliminado por actualización";
			$return = 0;
			$request = "";

			if(empty($request))
			{
				$sqlDeleteJ = "UPDATE kardex_json SET modificador = ?, tipo_movimiento = ?, status = ? WHERE idkardexj = $this->intIdKardexj";
					$arrDataDeleteJ = array($this->strModificador,
											$this->strEliminar,
											0);
					$requestDeleteJ = $this->update($sqlDeleteJ,$arrDataDeleteJ);

	        	if(intval($requestDeleteJ) > 0)
	        	{
	        		$sqlDelete = "UPDATE kardex SET modificador = ?, tipo_movimiento = ?, status = ? WHERE kardexidj = $this->intIdKardexj";
					$arrDataDelete = array($this->strModificador,
											$this->strEliminar,
											0);
					$requestDelete = $this->update($sqlDelete,$arrDataDelete);

					if(intval($requestDelete) > 0)
	        		{
	        			$query_insert  = "INSERT INTO kardex_json(nivelid,carreraid,semestre,materiaid,profesorid,grupoid,data,modificador,tipo_movimiento,cicloid) 
								  VALUES(?,?,?,?,?,?,?,?,?,?)";
			        	$arrData = array($this->intNivelId,
		        						$this->intCarreraId,
		        						$this->intSemestre,
		        						$this->intMateriaId,
		        						$this->intProfesorId,
		        						$this->intGrupoId,
		        						$this->strDataJson,
		        						$this->strModificador,
		        						$this->strTipoMovimiento,
		        						IDCICLO);
			        	$request_insert = $this->insert($query_insert,$arrData);

			        	if(intval($request_insert) > 0)
			        	{
		        			for ($i=0; $i < count($this->strDataArray); $i++) 
		        			{ 
		        				$irregular = false;
		        				$this->strCalificacionA = $this->strDataArray[$i]['calificacion_a']!='' && $this->strDataArray[$i]['calificacion_a']!=0 ? $this->strDataArray[$i]['calificacion_a'] : '';
		        				$this->strFechaA = $this->strCalificacionA!='' ? $this->strFecha : NULL;

		        				$this->strCalificacionB = $this->strDataArray[$i]['calificacion_b']!='' && $this->strDataArray[$i]['calificacion_b']!=0 ? $this->strDataArray[$i]['calificacion_b'] : '';
		        				$this->strFechaB = $this->strCalificacionB!='' ? $this->strFecha : NULL;

		        				$this->strCalificacionC = $this->strDataArray[$i]['calificacion_c']!='' && $this->strDataArray[$i]['calificacion_c']!=0 ? $this->strDataArray[$i]['calificacion_c'] : '';
		        				$this->strFechaC = $this->strCalificacionC!='' ? $this->strFecha : NULL;

		        				$this->strCalificacionD = $this->strDataArray[$i]['calificacion_d']!='' && $this->strDataArray[$i]['calificacion_d']!=0 ? $this->strDataArray[$i]['calificacion_d'] : '';
		        				$this->strFechaD = $this->strCalificacionD!='' ? $this->strFecha : NULL;

		        				$query_asignacion = "INSERT INTO kardex(matricula,alumnoid,nivelid,carreraid,semestre,grupoid,profesorid,materiaid,json_data,calificacion_a,fecha_a,calificacion_b,fecha_b,calificacion_c,fecha_c,calificacion_d,fecha_d,modificador,tipo_movimiento,kardexidj,cicloid) 
												  VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
					        	$arrAsignacion = array($this->strDataArray[$i]['matricula'],
				        								$this->strDataArray[$i]['idalumno'],
				        								$this->intNivelId,
			        									$this->intCarreraId,
			        									$this->intSemestre,
			        									$this->intGrupoId,
			        									$this->intProfesorId,
			        									$this->intMateriaId,
			        									$this->strDataJson,
			        									strtoupper($this->strCalificacionA),
			        									$this->strFechaA,
			        									strtoupper($this->strCalificacionB),
			        									$this->strFechaB,
			        									strtoupper($this->strCalificacionC),
			        									$this->strFechaC,
			        									strtoupper($this->strCalificacionD),
			        									$this->strFechaD,
			        									$this->strModificador,
			        									$this->strTipoMovimiento,
			        									$request_insert,
			        									IDCICLO);
				        		$request_asignacion = $this->insert($query_asignacion,$arrAsignacion);
				        		
				        		$irregular = ((is_numeric($this->strCalificacionA) && $this->strCalificacionA<70) ||  $this->strCalificacionA== 'NA') || ((is_numeric($this->strCalificacionB) && $this->strCalificacionB<70) ||  $this->strCalificacionB== 'NA') || ((is_numeric($this->strCalificacionC) && $this->strCalificacionC<70) ||  $this->strCalificacionC== 'NA') || ((is_numeric($this->strCalificacionD) && $this->strCalificacionD<70) ||  $this->strCalificacionD== 'NA') ? true : false;

					        	if($irregular == true && $this->strDataArray[$i]['checked'] == true)
					        	{
					        		$sqlIrregular = "UPDATE alumnos SET irregular = ? WHERE idalumno = {$this->strDataArray[$i]['idalumno']} ";
					        			
									$arrDataIrregular = array(1);
									$requestIrregular = $this->update($sqlIrregular,$arrDataIrregular);
								}
			        		}
			        	}
	        		}
		        }
	        	$return = $request_insert;
			}else{
				$return = "exist";
			}
	        return $return;
		}

		public function updateCalificacionIndividual(int $idKardex, string $idKardexJ, string $calificacion_a, string $calificacion_b, string $calificacion_c, string $calificacion_d, string $data, string $fecha_captura, string $modificador, string $tipo_movimiento)
		{
			date_default_timezone_set('America/Mexico_city');
			$this->strFecha = date('Y-m-d');
			$this->intIdKardex = $idKardex;
			$this->intIdKardexj = $idKardexJ;
			$this->strCalificacionA = $calificacion_a;
			$this->strCalificacionB = $calificacion_b;
			$this->strCalificacionC = $calificacion_c;
			$this->strCalificacionD = $calificacion_d;
			$this->strDataJson = $data;
			$this->strFechaCaptura = $fecha_captura;
			$this->strModificador = $modificador;
			$this->strTipoMovimiento = $tipo_movimiento;
			$this->strUltimaModificacion = date('Y-m-d h:i:s');
			$this->strEliminar = "Eliminado por actualización";
			$requestFechas = $this->selectFechas($this->intIdKardex);
			$this->strFechaA = ($requestFechas['fecha_a'] == '' && $this->strCalificacionA != '') ? $this->strFechaCaptura : $requestFechas['fecha_a'];
			$this->strFechaB = ($requestFechas['fecha_b'] == '' && $this->strCalificacionB != '') ? $this->strFechaCaptura : $requestFechas['fecha_b'];
			$this->strFechaC = ($requestFechas['fecha_c'] == '' && $this->strCalificacionC != '') ? $this->strFechaCaptura : $requestFechas['fecha_c'];
			$this->strFechaD = ($requestFechas['fecha_d'] == '' && $this->strCalificacionD != '') ? $this->strFechaCaptura : $requestFechas['fecha_d'];
			$this->intAlumnoId = $requestFechas['alumnoid'];
			$irregular = ((is_numeric($this->strCalificacionA) && $this->strCalificacionA<70) ||  $this->strCalificacionA== 'NA') || ((is_numeric($this->strCalificacionB) && $this->strCalificacionB<70) ||  $this->strCalificacionB== 'NA') || ((is_numeric($this->strCalificacionC) && $this->strCalificacionC<70) ||  $this->strCalificacionC== 'NA') || ((is_numeric($this->strCalificacionD) && $this->strCalificacionD<70) ||  $this->strCalificacionD== 'NA') ? true : false;

			/*dep("Fecha: ".$this->strFecha);
			dep("ID KARDEX: ".$this->intIdKardex);
			dep("ID KARDEX JSON: ".$this->intIdKardexj);
			dep("CALIFICACION A: ".$this->strCalificacionA);
			dep("CALIFICACIÓN B: ".$this->strCalificacionB);
			dep("CALIFICACIÓN C: ".$this->strCalificacionC);
			dep("CALIFICACIÓN D: ".$this->strCalificacionD);
			dep("DATA JASON: ".$this->strDataJson);
			dep("FECHA CAPTURA: ".$this->strFechaCaptura);
			dep("MODIFICADOR: ".$this->strModificador);
			dep("TIPO MOVIMIENTO: ".$this->strTipoMovimiento);
			dep("ULTIMA MODIFICACIÓN: ".$this->strUltimaModificacion);
			dep($requestFechas);
			dep("IRREGULAR: ".$irregular);
			exit;*/

			$sql = "UPDATE kardex SET calificacion_a=?, fecha_a=?, calificacion_b=?, fecha_B=?, calificacion_c=?, fecha_c=?, calificacion_d=?, fecha_d=?, modificador=?, ultima_modificacion=?, tipo_movimiento=? WHERE idkardex = $this->intIdKardex";
			$arrData = array($this->strCalificacionA,
										$this->strFechaA,
										$this->strCalificacionB,
										$this->strFechaB,
										$this->strCalificacionC,
										$this->strFechaC,
										$this->strCalificacionD,
										$this->strFechaD,
										$this->strModificador,
										$this->strUltimaModificacion,
										$this->strTipoMovimiento);
			$request = $this->update($sql,$arrData);

	        if(intval($request) > 0)
	        {
	        	$sqlUpdate = "UPDATE kardex_json SET data = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ? WHERE idkardexj = $this->intIdKardexj";
				$arrDataUpdate = array($this->strDataJson,
									$this->strModificador,
									$this->strFechaCaptura,
									$this->strTipoMovimiento);
				$requestUpdate = $this->update($sqlUpdate,$arrDataUpdate);

				if($irregular == true)
	        	{
	        		$sqlIrregular = "UPDATE alumnos SET irregular = ? WHERE idalumno = {$this->intAlumnoId}";
	        			
					$arrDataIrregular = array(1);
					$requestIrregular = $this->update($sqlIrregular,$arrDataIrregular);
				}
	        		
		    }
	        return $request;
		}

		public function selectFechas(int $idKardex)
		{
			$this->intIdKardex = $idKardex;
			$sql = "SELECT alumnoid, fecha_a, fecha_b, fecha_c, fecha_d FROM kardex WHERE idkardex = $this->intIdKardex;";
			$request = $this->select($sql);
			return $request;
		}

		public function selectNiveles()
		{
			$sql = "SELECT idnivel, nivel FROM niveles WHERE status != 0;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectCarreras(int $nivelid)
		{
			$this->intNivelId = $nivelid;
			$sql = "SELECT idcarrera, carrera, reforma FROM carreras WHERE nivelid = $this->intNivelId";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectGrupos(int $carreraid, int $personaid)
		{
			$this->intCarreraId = $carreraid;
			$this->intPersonaId = $personaid;

			if($_SESSION['userData']['idrol'] != RADMINESCOLARES && $_SESSION['userData']['idrol'] != RAUXESCOLARES)
			{
				$personaid=$_SESSION['userData']['idpersona'];
				$where=" AND profesorid=$this->intPersonaId ";
			}else{
				$where="";
			}

			$sql = "SELECT DISTINCT h.grupoid, g.idgrupo, g.grado, g.grupo 
					FROM horarios h
					INNER JOIN grupos g
					ON g.idgrupo = h.grupoid
					WHERE h.carreraid = $this->intCarreraId AND status = 1".$where;
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectAlumnosIndividual(int $carreraid)
		{
			$this->intCarreraId = $carreraid;

			$sql = "SELECT DISTINCT idalumno, CONCAT(nombres,' ',apellidos) AS nombre_alumno FROM alumnos WHERE carreraid = $this->intCarreraId AND status = 1";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectMaterias(int $carreraid, string $grupoid, int $personaid)
		{
			$this->intCarreraId = $carreraid;
			$this->intGrupoId = $grupoid;
			$this->intPersonaId = $personaid;

			if($_SESSION['userData']['idrol'] != RADMINESCOLARES && $_SESSION['userData']['idrol'] != RAUXESCOLARES)
			{
				$personaid=$_SESSION['userData']['idpersona'];
				$where=" AND h.profesorid=$this->intPersonaId ";
			}else{
				$where="";
			}

			$sql = "SELECT DISTINCT(m.idmateria), m.materia, h.materiaid, h.grupoid, h.profesorid 
						FROM horarios h
						INNER JOIN materias m
						ON m.idmateria = h.materiaid
						WHERE h.carreraid = $this->intCarreraId AND h.status = 1 AND h.grupoid = '$this->intGrupoId'".$where;
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectMateriasIndividual(int $carreraid, string $alumnoid)
		{
			$this->intCarreraId = $carreraid;
			$this->intAlumnoId = $alumnoid;
			$sql = "SELECT DISTINCT(k.materiaid), k.carreraid, k.alumnoid, m.idmateria, m.materia
						FROM kardex k
						INNER JOIN materias m
						ON m.idmateria = k.materiaid
						WHERE k.carreraid = $this->intCarreraId AND k.alumnoid = $this->intAlumnoId AND k.status = 1";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectBusquedaEditarAlumnos(int $nivelid, int $carreraid, int $grupoid, int $materiaid){
			$this->intNivelId = $nivelid;
			$this->intCarreraId = $carreraid;
			$this->intGrupoId = $grupoid;
			$this->intMateriaId = $materiaid;
			
			$sql = "SELECT a.idalumno, a.matricula, CONCAT(a.nombres,' ',a.apellidos) AS nombre_alumno, a.grupoid, a.nivelid, a.carreraid, g.idgrupo, g.grado, g.grupo, CONCAT(g.grado,'-',g.grupo) AS grupo_format, k.calificacion_a, k.fecha_a, k.calificacion_b, k.fecha_b, k.calificacion_c, k.fecha_c, k.calificacion_d, k.fecha_d, k.json_data, k.materiaid, k.idkardex, k.kardexidj 
						FROM alumnos a
						INNER JOIN kardex k
						ON a.idalumno = k.alumnoid
						INNER JOIN grupos g
						ON g.idgrupo = a.grupoid
						WHERE k.nivelid = $this->intNivelId AND k.carreraid = $this->intCarreraId AND k.grupoid = '$this->intGrupoId' AND k.materiaid = '$this->intMateriaId' and k.status = 1 ORDER BY a.apellidos ASC;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectBusquedaAlumnoIndividual(int $nivelid, int $carreraid, int $alumnoid, int $materiaid){
			$this->intNivelId = $nivelid;
			$this->intCarreraId = $carreraid;
			$this->intAlumnoId = $alumnoid;
			$this->intMateriaId = $materiaid;
			
			$sql = "SELECT a.idalumno, a.matricula, CONCAT(a.nombres,' ',a.apellidos) AS nombre_alumno, a.grupoid, a.nivelid, a.carreraid, g.idgrupo, g.grado, g.grupo, CONCAT(g.grado,'-',g.grupo) AS grupo_format, k.calificacion_a, k.fecha_a, k.calificacion_b, k.fecha_b, k.calificacion_c, k.fecha_c, k.calificacion_d, k.fecha_d, k.json_data, k.materiaid, k.idkardex, k.kardexidj, kj.data, kj.idkardexj
						FROM alumnos a
						INNER JOIN kardex k
						ON a.idalumno = k.alumnoid
						INNER JOIN grupos g
						ON g.idgrupo = a.grupoid
						INNER JOIN kardex_json kj
						ON kj.idkardexj = k.kardexidj
						WHERE k.nivelid = $this->intNivelId AND k.carreraid = $this->intCarreraId AND k.alumnoid = '$this->intAlumnoId' AND k.materiaid = '$this->intMateriaId' and k.status = 1 ORDER BY a.apellidos ASC;";
			$request = $this->select($sql);
			return $request;
		}

		public function selectBusquedaDocenteIndividual(int $materiaid, int $nivelid, int $carreraid, int $grupoid){
			$this->intMateriaId = $materiaid;
			$this->intNivelId = $nivelid;
			$this->intCarreraId = $carreraid;
			$this->intGrupoId = $grupoid;

			$sqlDocente = "SELECT profesorid FROM horarios WHERE materiaid = $this->intMateriaId AND carreraid = '$this->intCarreraId' AND grupoid = '$this->intGrupoId' and status = 1";
			$requestDocente = $this->select($sqlDocente);
			$this->intProfesorId = $requestDocente['profesorid'];
			
			$sql = "SELECT CONCAT(nombres,' ',apellidos) AS nombre_docente, idpersona FROM persona WHERE idpersona = $this->intProfesorId AND status=1";
			$request = $this->select($sql);
			return $request;
		}

		public function selectBusquedaAlumnos(int $nivelid, int $carreraid, int $grupoid){
			$this->intNivelId = $nivelid;
			$this->intCarreraId = $carreraid;
			$this->intGrupoId = $grupoid;
			
			$sql = "SELECT a.idalumno, a.matricula, CONCAT(a.nombres,' ',a.apellidos) AS nombre_alumno, a.grupoid, g.idgrupo, g.grado, g.grupo CONCAT(g.grado,'-',g.grupo) AS grupo_format
						FROM alumnos a
						INNER JOIN grupos g
						ON g.idgrupo = a.grupoid
						WHERE a.nivelid = $this->intNivelId AND a.carreraid = $this->intCarreraId AND a.grupoid = '$this->intGrupoId' AND a.egresado != 1 AND a.status =1 ORDER BY a.apellidos ASC;";
			$request = $this->select_all($sql);

			return $request;
		}

		public function selectData(int $nivelid, int $carreraid, int $materiaid, int $grupoid){
			
			$this->intNivelId = $nivelid;
			$this->intCarreraId = $carreraid;
			$this->intMateriaId = $materiaid;
			$this->intGrupoId = $grupoid;
			
			$sql = "SELECT profesorid FROM horarios WHERE materiaid = $this->intMateriaId AND carreraid = $this->intCarreraId AND grupoid = '$this->intGrupoId' AND status = 1 ORDER BY idhorario DESC;";
			$request = $this->select($sql);

			return $request;
		}

		public function selectPermisivoFecha(int $profesorid, int $materiaid, int $carreraid, int $grupoid){
			$this->intProfesorId = $profesorid;
			$this->intMateriaId = $materiaid;
			$this->intCarreraId = $carreraid;
			$this->intGrupoId = $grupoid;
			
			$sql = "SELECT fecha_inicial, fecha_final FROM horarios WHERE profesorid = $this->intProfesorId AND materiaid = $this->intMateriaId AND carreraid = $this->intCarreraId AND grupoid = '$this->intGrupoId' AND status = 1;";
			$request = $this->select($sql);
			return $request;
		}

		public function selectBusquedaNivel(int $nivelid){
			$this->intNivelId = $nivelid;
			
			$sql = "SELECT idnivel, nivel FROM niveles WHERE idnivel = $this->intNivelId AND status = 1;";
			$request = $this->select($sql);
			return $request;
		}

		public function selectBusquedaCarrera(int $carreraid){
			$this->intCarreraId = $carreraid;
			
			$sql = "SELECT idcarrera, carrera FROM carreras WHERE idcarrera = $this->intCarreraId AND status = 1;";
			$request = $this->select($sql);
			return $request;
		}

		public function selectBusquedaDocente(int $idpersona){
			$this->intPersonaId = $idpersona;
			
			$sql = "SELECT idpersona, CONCAT(nombres,' ',apellidos) AS nombre_docente FROM persona WHERE idpersona = $this->intPersonaId AND status = 1;";
			$request = $this->select($sql);

			return $request;
		}

		public function selectBusquedaMateria(int $idmateria){
			$this->intMateriaId = $idmateria;
		
			$sql = "SELECT idmateria, materia FROM materias WHERE idmateria = $this->intMateriaId AND status = 1;";
			$request = $this->select($sql);
			return $request;
		}

		public function selectFormatoCalificaciones(int $idkardexj){
			$this->intIdKardexj = $idkardexj;

			$sql = "SELECT k.*, DATE_FORMAT(K.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, c.carrera, n.nivel, CONCAT(p.nombres,' ',p.apellidos) AS nombre_docente, m.materia, a.matricula, CONCAT(a.nombres,' ',a.apellidos) AS nombre_alumno 
					FROM kardex k
					INNER JOIN carreras c
					ON c.idcarrera = k.carreraid
					INNER JOIN niveles n
					ON n.idnivel = k.nivelid
					INNER JOIN persona p
					ON p.idpersona = k.profesorid
					INNER JOIN materias m
					ON m.idmateria = k.materiaid
					INNER JOIN alumnos a
					ON a.idalumno = k.alumnoid
					WHERE k.kardexidj = $this->intIdKardexj AND k.status = 1;";
			$request = $this->select_all($sql);
			return $request;
		}
	}
	
 ?>