<?php 

	class EquiposModel extends Mysql
	{
		private $intIdEquipo;
		private $strUsuario;
		private $strIp;
		private $strTipoIp;
		private $strMac;
		private $strAnyDesk;
		private $strDepartamento;
		private $strSynology;
		private $strExtension;
		private $strIpTelefono;
		private $strTipoIpTelefono;
		private $strDns;
		private $strModificador;
		private $strUltimaModificacion;
		private $strTipoMovimiento;
		private $strComentarios;
		private $intStatus;

		public function __construct()
		{
			parent::__construct();
		}	

		public function insertEquipo(string $usuario, string $ip, string $tipo_ip, string $mac, string $anydesk, string $departamento, string $synology, string $extension, string $ip_telefono, string $tipo_ip_telefono, string $tipo_dns, string $modificador, string $tipo_movimiento, string $comentarios, string $status){
			$this->strUsuario = $usuario;
			$this->strIp = $ip;
			$this->strTipoIp = $tipo_ip;
			$this->strMac = $mac;
			$this->strAnyDesk = $anydesk;
			$this->strDepartamento = $departamento;
			$this->strSynology = $synology;
			$this->strExtension = $extension;
			$this->strIpTelefono = $ip_telefono;
			$this->strTipoIpTelefono = $tipo_ip_telefono;
			$this->strDns = $tipo_dns;
			$this->strModificador = $modificador;
			$this->strTipoMovimiento = $tipo_movimiento;
			$this->strComentarios = $comentarios;
			$this->intStatus = $status;
			$return = 0;

			$sql = "SELECT * FROM equipos WHERE (usuario = '{$this->strUsuario}' AND extension = '{$this->strExtension}' AND status != 0)";
			$request = $this->select_all($sql);

			if(empty($request))
			{
				$query_insert  = "INSERT INTO equipos(usuario,ip,tipo_ip,mac,anydesk,departamento,synology,extension,ip_telefono,tipo_ip_telefono,tipo_dns,modificador,tipo_movimiento,comentarios,status) 
								  VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
	        	$arrData = array($this->strUsuario,
        						$this->strIp,
        						$this->strTipoIp,
        						$this->strMac,
        						$this->strAnyDesk,
        						$this->strDepartamento,
        						$this->strSynology,
        						$this->strExtension,
        						$this->strIpTelefono,
        						$this->strTipoIpTelefono,
        						$this->strDns,
        						$this->strModificador,
        						$this->strTipoMovimiento,
        						$this->strComentarios,
        						$this->intStatus);
	        	$request_insert = $this->insert($query_insert,$arrData);
	        	$return = $request_insert;
			}else{
				$return = "exist";
			}
	        return $return;
		}

		public function updateEquipo(int $idequipo, string $usuario, string $ip, string $tipo_ip, string $mac, string $anydesk, string $departamento, string $synology, string $extension, string $ip_telefono, string $tipo_ip_telefono, string $tipo_dns, string $modificador, string $tipo_movimiento, string $comentarios, int $status){
			date_default_timezone_set('America/Mexico_city');
			$this->intIdEquipo = $idequipo;
			$this->strUsuario = $usuario;
			$this->strIp = $ip;
			$this->strTipoIp = $tipo_ip;
			$this->strMac = $mac;
			$this->strAnyDesk = $anydesk;
			$this->strDepartamento = $departamento;
			$this->strSynology = $synology;
			$this->strExtension = $extension;
			$this->strIpTelefono = $ip_telefono;
			$this->strTipoIpTelefono = $tipo_ip_telefono;
			$this->strDns = $tipo_dns;
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date("Y-m-d H:i:s");   
			$this->strTipoMovimiento = $tipo_movimiento;
			$this->strComentarios = $comentarios;
			$this->intStatus = $status;

			/*dep("ID Equipo: ".$this->intIdEquipo);
			dep("Usuario: ".$this->strUsuario);
			dep("IP: ".$this->strIp);
			dep("Tipo IP: ".$this->strTipoIp);
			dep("MAC: ".$this->strMac);
			dep("AnyDesk: ".$this->strAnyDesk);
			dep("Departamento: ".$this->strDepartamento);
			dep("Synology: ".$this->strSynology);
			dep("Extension: ".$this->strExtension);
			dep("IP Telefono: ".$this->strIpTelefono);
			dep("Tipo IP Telefono: ".$this->strTipoIpTelefono);
			dep("DNS: ".$this->strDns);
			dep("Comentarios: ".$this->strComentarios);
			dep("ID Persona: ".$this->strModificador);
			dep("Ultima Modificacion: ".$this->strUltimaModificacion);
			dep("Tipo Movimiento: ".$this->strTipoMovimiento);
			dep("Estatus: ".$this->intStatus);
			exit;*/

			  
			$this->intStatus = $status;

			$sql = "SELECT * FROM equipos WHERE (usuario = '{$this->strUsuario}' AND extension = '{$this->strExtension}' AND idequipo != $this->intIdEquipo)";
			$request = $this->select_all($sql);

			if(empty($request))
			{
				$sql = "UPDATE equipos SET usuario = ?, ip = ?, tipo_ip = ?, mac = ?, anydesk = ?, departamento = ?, synology = ?, extension = ?, ip_telefono = ?, tipo_ip_telefono = ?, tipo_dns = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, comentarios = ?, status = ? WHERE idequipo = $this->intIdEquipo ";
				$arrData = array($this->strUsuario,
        						$this->strIp,
        						$this->strTipoIp,
        						$this->strMac,
        						$this->strAnyDesk,
        						$this->strDepartamento,
        						$this->strSynology,
        						$this->strExtension,
        						$this->strIpTelefono,
        						$this->strTipoIpTelefono,
        						$this->strDns,
        						$this->strModificador,
        						$this->strUltimaModificacion,
        						$this->strTipoMovimiento,
        						$this->strComentarios,
        						$this->intStatus);
				$request = $this->update($sql,$arrData);
			}else{
				$request = "exist";
			}
		    return $request;			
		}

		public function selectEquipos()
		{
			$sql = "SELECT *, DATE_FORMAT(ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format FROM equipos WHERE status != 0 ORDER BY extension ASC";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectEquipo(int $idequipo)
		{
			$this->intIdEquipo = $idequipo;
			$sql = "SELECT *, DATE_FORMAT(ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format FROM equipos WHERE idequipo = $this->intIdEquipo ORDER BY extension ASC";
			$request = $this->select($sql);
			return $request;
		}

		public function deleteEquipo(int $idequipo, string $modificador)
		{
			$this->intIdEquipo = $idequipo;		
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date("Y-m-d H:i:s");
			$this->strTipoMovimiento = "Eliminación";
			$sql = "UPDATE equipos SET modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idequipo = $this->intIdEquipo ";
			$arrData = array($this->strModificador,
								$this->strUltimaModificacion,
								$this->strTipoMovimiento,
								0);
			$request = $this->update($sql,$arrData);
			return $request;
		}

		public function updateSynology(int $idequipo, string $estado, string $tipo_movimiento, string $modificador)
		{
			$this->intIdEquipo = $idequipo;		
			$this->strSynology = $estado;
			$this->strTipoMovimiento = $tipo_movimiento;		
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date("Y-m-d H:i:s");
			$sql = "UPDATE equipos SET synology = ?, tipo_movimiento = ?, modificador = ?, ultima_modificacion = ? WHERE idequipo = $this->intIdEquipo ";
			$arrData = array($this->strSynology,
							$this->strTipoMovimiento,
							$this->strModificador,
							$this->strUltimaModificacion);
			$request = $this->update($sql,$arrData);
			return $request;
		}

		public function updateTipoIp(int $idequipo, string $estado, string $tipo_movimiento, string $modificador)
		{
			$this->intIdEquipo = $idequipo;		
			$this->strTipoIp = $estado;
			$this->strTipoMovimiento = $tipo_movimiento;		
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date("Y-m-d H:i:s");
			$sql = "UPDATE equipos SET tipo_ip = ?, tipo_movimiento = ?, modificador = ?, ultima_modificacion = ? WHERE idequipo = $this->intIdEquipo ";
			$arrData = array($this->strTipoIp,
							$this->strTipoMovimiento,
							$this->strModificador,
							$this->strUltimaModificacion);
			$request = $this->update($sql,$arrData);
			return $request;
		}

		public function updateTipoIpTelefono(int $idequipo, string $estado, string $tipo_movimiento, string $modificador)
		{
			$this->intIdEquipo = $idequipo;		
			$this->strTipoIpTelefono = $estado;
			$this->strTipoMovimiento = $tipo_movimiento;		
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date("Y-m-d H:i:s");
			$sql = "UPDATE equipos SET tipo_ip_telefono = ?, tipo_movimiento = ?, modificador = ?, ultima_modificacion = ? WHERE idequipo = $this->intIdEquipo ";
			$arrData = array($this->strTipoIpTelefono,
							$this->strTipoMovimiento,
							$this->strModificador,
							$this->strUltimaModificacion);
			$request = $this->update($sql,$arrData);
			return $request;
		}

	}
 ?>