<?php 

	class EscuelasModel extends Mysql
	{
		private $intIdEscuela;
		private $strNombre;
		private $strLocalidad;
		private $strModificador;
		private $strUltimaModificacion;
		private $intStatus;

		public function __construct()
		{
			parent::__construct();
		}	

		public function insertEscuela(string $nombre, string $localidad, string $modificador, string $tipo_movimiento, int $status){
			$this->strNombre = $nombre;
			$this->strLocalidad = $localidad;
			$this->strModificador = $modificador;
			$this->strTipoMovimiento = $tipo_movimiento;    
			$this->intStatus = $status;
			$return = 0;

			$sql = "SELECT * FROM escuelas WHERE (nombre = '{$this->strNombre}' AND status != 0)";
			$request = $this->select_all($sql);

			if(empty($request))
			{
				$query_insert  = "INSERT INTO escuelas(nombre,localidad,modificador,tipo_movimiento,status) 
								  VALUES(?,?,?,?,?)";
	        	$arrData = array($this->strNombre,
	        					$this->strLocalidad,
        						$this->strModificador,
        						$this->strTipoMovimiento,
        						$this->intStatus);
	        	$request_insert = $this->insert($query_insert,$arrData);
	        	$return = $request_insert;
			}else{
				$return = "exist";
			}
	        return $return;
		}

		public function updateEscuela(int $idescuela, string $nombre, string $localidad, string $modificador, string $tipo_movimiento, int $status){
			date_default_timezone_set('America/Mexico_city');
			$this->intIdEscuela = $idescuela;
			$this->strNombre = $nombre;
			$this->strLocalidad = $localidad;
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date("Y-m-d H:i:s"); 
			$this->strTipoMovimiento = $tipo_movimiento;    
			$this->intStatus = $status;

			$sql = "SELECT * FROM escuelas WHERE (nombre = '{$this->strNombre}' AND idescuela != $this->intIdEscuela AND status != 0)";
			$request = $this->select_all($sql);

			if(empty($request))
			{
				$sql = "UPDATE escuelas SET nombre = ?, localidad = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idescuela = $this->intIdEscuela ";
				$arrData = array($this->strNombre,
								$this->strLocalidad,
        						$this->strModificador,
        						$this->strUltimaModificacion,
        						$this->strTipoMovimiento,
        						$this->intStatus);
				$request = $this->update($sql,$arrData);
			}else{
				$request = "exist";
			}
		    return $request;			
		}

		public function selectEscuelas()
		{
			$sql = "SELECT *, DATE_FORMAT(ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format  FROM escuelas WHERE status != 0";
					$request = $this->select_all($sql);
					return $request;
		}

		public function selectEscuela(int $idescuela)
		{
			$this->intIdEscuela = $idescuela;
			$sql = "SELECT *, DATE_FORMAT(ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format FROM escuelas WHERE idescuela = $this->intIdEscuela";
			$request = $this->select($sql);
			return $request;
		}

		public function deleteEscuela(int $idescuela, string $modificador)
		{
			$this->intIdEscuela = $idescuela;		
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date("Y-m-d H:i:s");
			$this->strTipoMovimiento = 'Eliminación';
			$sql = "UPDATE escuelas SET modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idescuela = $this->intIdEscuela ";
			$arrData = array($this->strModificador,
								$this->strUltimaModificacion,
								$this->strTipoMovimiento,
								0);
			$request = $this->update($sql,$arrData);
			return $request;
		}
	}
 ?>