<?php 
	#[\AllowDynamicProperties]
	class EstadisticasModel extends Mysql
	{
		private $intIdMateria;
		private $strClave;
		private $strMateria;
		private $intNivelId;
		private $strComentarios;
		private $strModificador;
		private $strUltimaModificacion;
		private $strTipoMovimiento;
		private $intStatus;

		public function __construct()
		{
			parent::__construct();
		}	

		public function selectAlumnos()
		{
			$sql = "SELECT idalumno, status, CONCAT(apellidos,' ',nombres) AS nombre_alumno, matricula, grupoid, nivelid
					FROM alumnos
					WHERE status != 0 
					ORDER BY matricula, nombre_alumno ASC";
					$request = $this->select_all($sql);
					return $request;
		}

		public function selectAlumno(int $idalumno)
		{
			$this->intIdAlumno = $idalumno;
			$sql = "SELECT idalumno, status, CONCAT(apellidos,' ',nombres) AS nombre_alumno, matricula, grupoid, nivelid
					FROM alumnos
					WHERE idalumno = $this->intIdAlumno 
					ORDER BY matricula, nombre_alumno ASC";
					$request = $this->select_all($sql);
					return $request;
		}

		public function selectCalificacionesAlumno(int $idalumno)
		{
			$this->intIdAlumno = $idalumno;
			$sql = "SELECT a.idalumno, a.status, CONCAT(a.apellidos,' ',a.nombres) AS nombre_alumno, a.matricula, a.grupoid, a.nivelid, m.idmateria, m.materia, n.idnivel, n.nivel, g.idgrupo, g.grado, g.grupo, CONCAT(g.grado,'-',g.grupo) AS grupo_format, k.*
					FROM calificaciones k
					INNER JOIN alumnos a
					ON a.idalumno = k.alumnoid
					INNER JOIN materias m
					ON m.idmateria = k.materiaid
					INNER JOIN niveles n
					ON n.idnivel = k.nivelid
					INNER JOIN grupos g
					ON g.idgrupo = k.grupoid
					WHERE k.alumnoid = $this->intIdAlumno AND k.status = 1 
					ORDER BY k.semestre, m.materia";
					$request = $this->select_all($sql);
					return $request;
		}

		public function selectAsistenciasAlumno(int $idalumno)
		{
			$this->intIdAlumno = $idalumno;
			$sql = "SELECT a.idalumno, a.status, CONCAT(a.apellidos,' ',a.nombres) AS nombre_alumno, a.matricula, a.grupoid, a.nivelid, m.idmateria, m.materia, g.idgrupo, g.grado, g.grupo, CONCAT(g.grado,'-',g.grupo) AS grupo_format, asis.*
					FROM asistencias asis
					INNER JOIN alumnos a
					ON a.idalumno = asis.alumnoid
					INNER JOIN materias m
					ON m.idmateria = asis.materiaid
					INNER JOIN grupos g
					ON g.idgrupo = asis.grupoid
					WHERE asis.alumnoid = $this->intIdAlumno AND asis.status = 1
					ORDER BY asis.grupoid, m.materia";
					$request = $this->select_all($sql);
					return $request;
		}

		public function selectIncidenciasAlumno(int $idalumno)
		{
			$this->intIdAlumno = $idalumno;
			$sql = "SELECT a.idalumno, a.status, CONCAT(a.apellidos,' ',a.nombres) AS nombre_alumno, a.matricula, a.grupoid, a.nivelid, p.idpersona, CONCAT(p.apellidos,' ',p.nombres) AS nombre_profesor, DATE_FORMAT(i.fecha_incidencia, '%d-%m-%Y') AS fecha_incidencia_format, i.*
					FROM incidencias i
					INNER JOIN alumnos a
					ON a.idalumno = i.alumnoid
					INNER JOIN persona p
					ON p.idpersona = i.personaid
					WHERE i.alumnoid = $this->intIdAlumno AND i.status = 1
					ORDER BY i.fecha_incidencia";
					$request = $this->select_all($sql);
					return $request;
		}

		public function selectMaterias()
		{
			$sql = "SELECT c.idcampo, c.campo, c.materiaid, n.idnivel, n.nivel, DATE_FORMAT(m.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, m.*
					FROM materias m 
					LEFT JOIN campos c
					ON m.idmateria = c.materiaid
					INNER JOIN niveles n
					ON n.idnivel = m.nivelid
					WHERE m.status != 0 
					ORDER BY n.nivel";
					$request = $this->select_all($sql);
					return $request;
		}

		public function selectNiveles()
		{
			$sql = "SELECT idnivel, nivel FROM niveles WHERE status != 0";			
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectMateria(int $idmateria){
			$this->intIdMateria = $idmateria;
			$sql = "SELECT c.idcampo, c.campo, c.materiaid, n.idnivel, n.nivel, DATE_FORMAT(m.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, m.*
					FROM materias m 
					LEFT JOIN campos c
					ON m.idmateria = c.materiaid
					INNER JOIN niveles n
					ON n.idnivel = m.nivelid
					WHERE m.idmateria = $this->intIdMateria";
			$request = $this->select($sql);
			return $request;
		}

		public function deleteMateria(int $idmateria, string $modificador, string $tipo_movimiento)
		{
			date_default_timezone_set('America/Mexico_city');
			$this->intIdMateria = $idmateria;
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date('Y-m-d h:i:s');
			$this->strTipoMovimiento = $tipo_movimiento;
			$requestMateriaHorario = $this->selectMateriaHorario($this->intIdMateria);
			if(empty($requestMateriaHorario))
			{

				$requestCampo = $this->selectCampoFormativo($this->intIdMateria);
				if(empty($requestCampo) > 0){
					$sql = "UPDATE materias SET modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idmateria = $this->intIdMateria ";
					$arrData = array($this->strModificador,
										$this->strUltimaModificacion,
										$this->strTipoMovimiento,
										0);
					$request = $this->update($sql,$arrData);
				}else{
					$request = "campo";
				}

			}else{
				$request = "asignada";
			}
			
			return $request;
		}

		public function selectCampoFormativo($idmateria)
		{
			$this->intIdMateria = $idmateria;
			$sql = "SELECT idcampo, campo, materiaid FROM campos WHERE materiaid = $this->intIdMateria AND status != 0;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectMateriaHorario($idmateria)
		{
			$this->intIdMateria = $idmateria;
			$sql = "SELECT idhorario, materiaid FROM horarios WHERE materiaid = $this->intIdMateria AND status != 0;";
			$request = $this->select_all($sql);
			return $request;
		}

	}

 ?>