<?php 
class EventosModel extends Mysql
{
	private $intIdEvento;
	private $strEvento;
	private $strUbicacion;
	private $strHoraInicial;
	private $strHoraFinal;
	private $intPersonaId;
	private $strNivel;
	private $strFechaInicial;
	private $strFechaFinal;
	private $strDescripcion;
	private $strModificador;
	private $strTipoMovimiento;
	private $intStatus;
	
	public function __construct()
	{
		parent::__construct();
	}	

	public function insertEvento(string $evento, string $ubicacion, string $hora_inicial, string $hora_final, int $personaid, string $nivel, string $fecha_inicial, string $fecha_final, string $descripcion, int $status){
		$this->strEvento = $evento;
		$this->strUbicacion = $ubicacion;
		$this->strHoraInicial = $hora_inicial;
		$this->strHoraFinal = $hora_final;
		$this->intPersonaId = $personaid;
		$this->strNivel = $nivel;
		$this->strFechaInicial = $fecha_inicial;
		$this->strFechaFinal = $fecha_final;
		$this->strDescripcion = $descripcion;
		$this->strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
		//$this->strTipoMovimiento = $fecha;
		$this->intStatus = $status;

		$return = 0;
		$sql = "SELECT * FROM eventos WHERE evento = '{$this->strEvento}' AND fecha_inicial = '{$this->strFechaInicial}' AND nivel = '{$this->strNivel}'";
		$request = $this->select_all($sql);


		if(empty($request))
		{
			$query_insert  = "INSERT INTO eventos(evento,ubicacion,hora_inicial,hora_final,personaid,nivel,fecha_inicial,fecha_final,descripcion,modificador,status) 
							  VALUES(?,?,?,?,?,?,?,?,?,?,?)";
        	$arrData = array($this->strEvento,
    						$this->strUbicacion,
    						$this->strHoraInicial,
    						$this->strHoraFinal,
    						$this->intPersonaId,
    						$this->strNivel,
    						$this->strFechaInicial,
    						$this->strFechaFinal,
    						$this->strDescripcion,
    						$this->strModificador,
    						$this->intStatus);
        	$request_insert = $this->insert($query_insert,$arrData);
        	$return = $request_insert;
		}else{
			$return = "exist";
		}
        return $return;
	}

	public function updateEvento(int $idevento, string $evento, string $ubicacion, string $hora_inicial, string $hora_final, int $personaid, string $nivel, string $fecha_inicial, string $fecha_final, string $descripcion, int $status){
		$this->intIdEvento = $idevento;
		$this->strEvento = $evento;
		$this->strUbicacion = $ubicacion;
		$this->strHoraInicial = $hora_inicial;
		$this->strHoraFinal = $hora_final;
		$this->intPersonaId = $personaid;
		$this->strNivel = $nivel;
		$this->strFechaInicial = $fecha_inicial;
		$this->strFechaFinal = $fecha_final;
		$this->strDescripcion = $descripcion;
		$this->strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
		$this->strUltimaModificacion = date('Y-m-d h:i:s');
		$this->strTipoMovimiento = 'Actualización';
		$this->intStatus = $status;

		$sql = "SELECT * FROM eventos WHERE (evento = '{$this->strEvento}' AND fecha_inicial = '{$this->strFechaInicial}' AND nivel = '{$this->strNivel}' AND idevento != $this->intIdEvento)";
		$request = $this->select_all($sql);

		if(empty($request))
		{	
			$sql = "UPDATE eventos SET evento=?, ubicacion=?, hora_inicial=?, hora_final=?, personaid=?, nivel=?, fecha_inicial=?, fecha_final=?, descripcion=?, modificador=?, ultima_modificacion=?, tipo_movimiento=?,status=? WHERE idevento = $this->intIdEvento ";
			$arrData = array($this->strEvento,
    						$this->strUbicacion,
    						$this->strHoraInicial,
    						$this->strHoraFinal,
    						$this->intPersonaId,
    						$this->strNivel,
    						$this->strFechaInicial,
    						$this->strFechaFinal,
    						$this->strDescripcion,
    						$this->strModificador,
    						$this->strUltimaModificacion,
    						$this->strTipoMovimiento,
    						$this->intStatus);
			
			$request = $this->update($sql,$arrData);
		}else{
			$request = "exist";
		}
		return $request;
	}

	public function selectEventos()
	{
		/*if($_SESSION['userData']['idrol']!=1)
		{
			$personaid=$_SESSION['userData']['idpersona'];
			$whereAdmin="AND personaid=$personaid";
		}else{
			$whereAdmin="";
		}
		$this->intPersonaId = $personaid;*/

		$sql = "SELECT CONCAT(p.nombres,' ',p.apellidos) AS nombre_persona, DATE_FORMAT(e.fecha_inicial, '%d-%m-%Y') AS format_fecha_inicial, DATE_FORMAT(e.fecha_final, '%d-%m-%Y') AS format_fecha_final, e.*
				 FROM eventos e
				 INNER JOIN persona p
				 ON p.idpersona = e.personaid
				 WHERE e.status != 0";
		$request = $this->select_all($sql);
		return $request;
	}

	public function selectEvento($idevento)
	{
		$this->intIdEvento = $idevento;
		$sql = "SELECT CONCAT(p.nombres,' ',p.apellidos) AS nombre_persona, DATE_FORMAT(e.fecha_inicial, '%d-%m-%Y') AS format_fecha_inicial, DATE_FORMAT(e.fecha_final, '%d-%m-%Y') AS format_fecha_final, e.*
				 FROM eventos e
				 INNER JOIN persona p
				 ON p.idpersona = e.personaid
				 WHERE e.idevento = $this->intIdEvento AND e.status != 0"; 
		$request = $this->select($sql);
		return $request;
	}

	public function deleteEvento(int $idevento)
	{
		$this->intIdEvento = $idevento;
		$sql = "UPDATE eventos SET status = ? WHERE idevento = $this->intIdEvento ";
		$arrData = array(0);
		$request = $this->update($sql,$arrData);
		return $request;
	}

	public function selectNiveles()
	{
		$sql = "SELECT idnivel, nivel FROM niveles WHERE status != 0";
		$request = $this->select_all($sql);
		return $request;
	}


}

 ?>