<?php 
	#[\AllowDynamicProperties]
	class GruposModel extends Mysql
	{
		private $intIdGrupo;
		private $intNivelId;
		private $intCarreraId;
		private $intGrado;
		private $strGrupo;
		private $intGrupoIdConsecutivo;
		private $intPersonaId;
		private $intAlumnoId;
		private $strDataJson;
		private $strDataArray;
		private $strModificador;
		private $strUltimaModificacion;
		private $strTipoMovimiento;
		private $intCicloId;
		private $strCicloEscolar;
		private $intStatus;

		public function __construct()
		{
			parent::__construct();
		}

		public function insertGrupo(int $grado, string $grupo, int $grupoid_consecutivo, string $modificador, string $tipo_movimiento)
		{
			$this->intGrado = $grado;
			$this->strGrupo = $grupo;
			$this->intGrupoIdConsecutivo = $grupoid_consecutivo;
			$this->strModificador = $modificador;
			$this->strTipoMovimiento = $tipo_movimiento;
			$return = 0;

			$sqlExist = "SELECT * FROM grupos WHERE (grado = {$this->intGrado} AND grupo = '{$this->strGrupo}' AND status != 0)";
			$requestExist = $this->select_all($sqlExist);

			if(empty($requestExist))
			{

				$sqlConsecutivo = "SELECT * FROM grupos WHERE (grupoid_consecutivo = $this->intGrupoIdConsecutivo  AND status != 0)";
				$requestConsecutivo = $this->select_all($sqlConsecutivo);

				if(empty($requestConsecutivo))
				{
					$query_insert  = "INSERT INTO grupos(grado,grupo,grupoid_consecutivo,modificador,tipo_movimiento) 
									  VALUES(?,?,?,?,?)";
		        	$arrData = array($this->intGrado,
	        						$this->strGrupo,
	        						$this->intGrupoIdConsecutivo,
	        						$this->strModificador,
		        					$this->strTipoMovimiento);
		        	$request_insert = $this->insert($query_insert,$arrData);
		        	$return = $request_insert;
		        }else{
		        	$return = "consecutivo";	
		        }
	        	
			}else{
				$return = "exist";
			}
	        return $return;
		}

		public function updateGrupo(int $idgrupo, int $grado, string $grupo, int $grupoid_consecutivo, string $modificador, string $tipo_movimiento){
			date_default_timezone_set('America/Mexico_city');
			$this->intIdGrupo = $idgrupo;
			$this->intGrado = $grado;
			$this->strGrupo = $grupo;
			$this->intGrupoIdConsecutivo = $grupoid_consecutivo;
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date('Y-m-d h:i:s');
			$this->strTipoMovimiento = $tipo_movimiento;

			$sql = "SELECT * FROM grupos WHERE (grado = {$this->intGrado} AND grupo = '{$this->strGrupo}' AND status != 0) AND idgrupo != {$this->intIdGrupo}";
			$request = $this->select_all($sql);

			if(empty($request))
			{
				$sqlConsecutivo = "SELECT * FROM grupos WHERE (grupoid_consecutivo = $this->intGrupoIdConsecutivo  AND status != 0)";
				$requestConsecutivo = $this->select_all($sqlConsecutivo);

				if(empty($requestConsecutivo))
				{
					$query_update  = "UPDATE grupos set grado=?,grupo=?,grupoid_consecutivo=?,modificador=?,ultima_modificacion=?,tipo_movimiento=? WHERE idgrupo = {$this->intIdGrupo}";
		        	$arrData = array($this->intGrado,
	        						$this->strGrupo,
	        						$this->intGrupoIdConsecutivo,
	        						$this->strModificador,
	        						$this->strUltimaModificacion,
	        						$this->strTipoMovimiento);
		        	$request_update = $this->update($query_update,$arrData);
		        	$return = $request_update;
		        }else{
		        	$return = "consecutivo";
		        }
			}else{
				$return = "exist";
			}
	        return $return;			
		}

		public function deleteGrupo(int $idgrupo,$modificador,$tipo_movimiento)
		{
			date_default_timezone_set('America/Mexico_city');
			$this->intIdGrupo = $idgrupo;
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date('Y-m-d h:i:s');
			$this->strTipoMovimiento = $tipo_movimiento;		

			$sqlPer = "SELECT * FROM alumnos WHERE grupoid = $this->intIdGrupo AND status != 0";
			$requestPer = $this->select_all($sqlPer);
			if(empty($requestPer)){
				$sql = "UPDATE grupos SET modificador=?,ultima_modificacion=?,tipo_movimiento=?,status = ? WHERE idgrupo = $this->intIdGrupo ";
				$arrData = array($this->strModificador,
									$this->strUltimaModificacion,
									$this->strTipoMovimiento,
									0);
				$request = $this->update($sql,$arrData);
			}else{
				$request = "alumnos";
			}

			return $request;
		}

		public function selectGrupos()
		{
			$sql = "SELECT
			    g1.*,
			    DATE_FORMAT(g1.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format,
			    CONCAT(g1.grado,'-',g1.grupo) AS grupo_actual_format,
			    CONCAT(g2.grado,'-',g2.grupo) AS grupo_siguiente_format
			FROM
			    grupos g1
			LEFT JOIN
			    grupos g2 ON g1.grupoid_consecutivo = g2.idgrupo
			WHERE
			    g1.status != 0"; 
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectGrupo(int $idgrupo)
		{	
			$this->intIdGrupo = $idgrupo;
			$sql = "SELECT *, DATE_FORMAT(ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format
			 	FROM grupos 
			 	WHERE idgrupo = $this->intIdGrupo AND status=1";
			$request = $this->select($sql);
			return $request;
		}	

		public function selectGrupoAlumnos(int $idgrupo)
		{	
			$this->intIdGrupo = $idgrupo;
			$sql = "SELECT CONCAT(a.apellidos,' ',a.nombres) AS nombre_alumno, a.matricula, a.sexo, a.grupoid, DATE_FORMAT(g.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, n.idnivel, n.nivel, g.*
			 	FROM grupos g
			 	INNER JOIN alumnos a
			 	ON g.idgrupo = a.grupoid 
			 	INNER JOIN niveles n
			 	ON n.idnivel = a.nivelid
			 	WHERE g.idgrupo = $this->intIdGrupo AND g.status=1 AND a.status=1 ORDER BY a.matricula ASC";
			$request = $this->select_all($sql);
			
			return $request;
		}

		public function selectAlumnos(int $nivelid)
		{	$this->intNivelId = $nivelid;
			$sql = "SELECT CONCAT(a.nombres,' ',a.apellidos) AS nombre, a.idalumno, a.nivelid, a.asignado, a.status, n.nivel
			 FROM alumnos a
			 INNER JOIN niveles n
			 ON a.nivelid = n.idnivel 
			 WHERE a.nivelid=$this->intNivelId AND a.status = 1"; 
			$request = $this->select_all($sql);
			
			return $request;
		}

		public function selectAlumno(int $idalumno)
		{	$this->intIdAlumno = $idalumno;
			$sql = "SELECT CONCAT(a.nombres,' ',a.apellidos) AS nombre, a.idalumno, a.matricula, a.sexo, a.nivelid, a.status, n.nivel
			 FROM alumnos a
			 INNER JOIN niveles n
			 ON a.nivelid = n.idnivel 
			 WHERE a.idalumno=$this->intIdAlumno AND a.status = 1"; 
			$request = $this->select($sql);
			
			return $request;
		}

		public function selectCiclosEscolares()
		{	
			$sql = "SELECT * FROM ciclos_escolares WHERE status = 1";
			$request = $this->select_all($sql);
			return $request;
		}

	}

 ?>