<?php 
	#[\AllowDynamicProperties]
	class GruposModel extends Mysql
	{
		private $intIdGrupo;
		private $intNivelId;
		private $intCarreraId;
		private $intGrado;
		private $strGrupo;
		private $intPersonaId;
		private $intAlumnoId;
		private $strDataJson;
		private $strDataArray;
		private $strModificador;
		private $strUltimaModificacion;
		private $strTipoMovimiento;
		private $intCicloId;
		private $strCicloEscolar;
		private $intStatus;

		public function __construct()
		{
			parent::__construct();
		}

		public function insertGrupo(int $nivelid, int $carreraid, int $grado, string $grupo, int $personaid, string $modificador, string $tipo_movimiento)
		{
			$this->intNivelId = $nivelid;
			$this->intCarreraId = $carreraid;
			$this->intGrado = $grado;
			$this->strGrupo = $grupo;
			$this->intPersonaId = $personaid;
			$this->strModificador = $modificador;
			$this->strTipoMovimiento = $tipo_movimiento;
			$return = 0;

			$sql = "SELECT * FROM grupos WHERE (nivelid = {$this->intNivelId} AND carreraid = {$this->intCarreraId} AND grado = {$this->intGrado} AND grupo = '{$this->strGrupo}' AND status != 0)";
			$request = $this->select_all($sql);

			if(empty($request))
			{
				$query_insert  = "INSERT INTO grupos(nivelid,carreraid,grado,grupo,personaid,modificador,tipo_movimiento) 
								  VALUES(?,?,?,?,?,?,?)";
	        	$arrData = array($this->intNivelId,
	        					$this->intCarreraId,
        						$this->intGrado,
        						$this->strGrupo,
        						$this->intPersonaId,
        						$this->strModificador,
	        					$this->strTipoMovimiento);
	        	$request_insert = $this->insert($query_insert,$arrData);
	        	$return = $request_insert;
			}else{
				$return = "exist";
			}
	        return $return;
		}

		public function updateGrupo(int $idgrupo, int $nivelid, int $carreraid, int $grado, string $grupo, int $personaid, string $modificador, string $tipo_movimiento){
			date_default_timezone_set('America/Mexico_city');
			$this->intIdGrupo = $idgrupo;
			$this->intNivelId = $nivelid;
			$this->intCarreraId = $carreraid;
			$this->intGrado = $grado;
			$this->strGrupo = $grupo;
			$this->intPersonaId = $personaid;
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date('Y-m-d h:i:s');
			$this->strTipoMovimiento = $tipo_movimiento;

			$sql = "SELECT * FROM grupos WHERE (nivelid = {$this->intNivelId} AND carreraid = {$this->intCarreraId} AND grado = {$this->intGrado} AND grupo = '{$this->strGrupo}' AND status != 0) AND idgrupo != {$this->intIdGrupo}";
			$request = $this->select_all($sql);

			if(empty($request))
			{
				$query_update  = "UPDATE grupos set nivelid=?,carreraid=?,grado=?,grupo=?,personaid=?,modificador=?,ultima_modificacion=?,tipo_movimiento=? WHERE idgrupo = {$this->intIdGrupo}";
	        	$arrData = array($this->intNivelId,
	        					$this->intCarreraId,
        						$this->intGrado,
        						$this->strGrupo,
        						$this->intPersonaId,
        						$this->strModificador,
        						$this->strUltimaModificacion,
        						$this->strTipoMovimiento);
	        	$request_update = $this->update($query_update,$arrData);
	        	$return = $request_update;
			}else{
				$return = "exist";
			}
	        return $return;			
		}

		public function deleteGrupo(int $idgrupo,$modificador,$tipo_movimiento)
		{
			date_default_timezone_set('America/Mexico_city');
			$this->intIdGrupo = $idgrupo;
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date('Y-m-d h:i:s');
			$this->strTipoMovimiento = $tipo_movimiento;		

			$sqlPer = "SELECT * FROM alumnos WHERE grupoid = $this->intIdGrupo AND status != 0";
			$requestPer = $this->select_all($sqlPer);
			if(empty($requestPer)){
				$sql = "UPDATE grupos SET modificador=?,ultima_modificacion=?,tipo_movimiento=?,status = ? WHERE idgrupo = $this->intIdGrupo ";
				$arrData = array($this->strModificador,
									$this->strUltimaModificacion,
									$this->strTipoMovimiento,
									0);
				$request = $this->update($sql,$arrData);
			}else{
				$request = "alumnos";
			}

			return $request;
		}

		public function selectGrupos()
		{
			$sql = "SELECT n.idnivel, n.nivel, CONCAT(p.nombres,' ',p.apellidos) AS nombre, p.idpersona, DATE_FORMAT(g.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, c.idcarrera, c.abreviatura, c.modelo, c.reforma, c.carrera, g.*
			FROM grupos g
			INNER JOIN persona p
			ON p.idpersona = g.personaid
			INNER JOIN niveles n
			ON n.idnivel = g.nivelid
			INNER JOIN carreras c
			ON c.idcarrera = g.carreraid
			WHERE g.status != 0"; 
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectGrupo(int $idgrupo)
		{	
			$this->intIdGrupo = $idgrupo;
			$sql = "SELECT CONCAT(p.nombres,' ',p.apellidos) AS nombre_coordinador, n.nivel, DATE_FORMAT(g.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, c.idcarrera, c.abreviatura, c.modelo, c.reforma, c.carrera, g.*
			 	FROM grupos g
			 	INNER JOIN persona p
			 	ON g.personaid = p.idpersona
			 	INNER JOIN niveles n
			 	ON g.nivelid = n.idnivel
			 	INNER JOIN carreras c
				ON c.idcarrera = g.carreraid
			 	WHERE g.idgrupo = $this->intIdGrupo AND g.status=1";
			$request = $this->select($sql);
			return $request;
		}	

		public function selectGrupoAlumnos(int $idgrupo)
		{	
			$this->intIdGrupo = $idgrupo;
			$sql = "SELECT CONCAT(a.apellidos,' ',a.nombres) AS nombre_alumno, a.matricula, a.sexo, CONCAT(p.nombres,' ',p.apellidos) AS nombre_coordinador, n.nivel, DATE_FORMAT(g.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, g.*
			 	FROM grupos g
			 	INNER JOIN alumnos a
			 	ON g.idgrupo = a.grupoid 
			 	INNER JOIN persona p
			 	ON g.personaid = p.idpersona
			 	INNER JOIN niveles n
			 	ON g.nivelid = n.idnivel
			 	WHERE g.idgrupo = $this->intIdGrupo AND g.status=1 AND a.status=1 ORDER BY a.apellidos ASC";
			$request = $this->select_all($sql);
			
			return $request;
		}	

		public function selectNiveles()
		{
			$sql = "SELECT n.idnivel, n.nivel, CONCAT(p.nombres,' ',p.apellidos) AS nombre, p.idpersona
			FROM niveles n
			INNER JOIN persona p
			ON p.idpersona = n.coordinadorid
			WHERE n.status != 0"; 
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectCarreras($nivelid)
		{
			$this->intNivelId = $nivelid;
			$sql = "SELECT * FROM carreras WHERE nivelid = $this->intNivelId AND status = 1"; 
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectNivel($idnivel)
		{
			$this->intNivelId = $idnivel;
			$sql = "SELECT n.idnivel, n.nivel, CONCAT(p.nombres,' ',p.apellidos) AS nombre, p.idpersona
			FROM niveles n
			INNER JOIN persona p
			ON p.idpersona = n.coordinadorid
			WHERE n.idnivel = $this->intNivelId AND n.status != 0"; 
			$request = $this->select($sql);
			return $request;
		}

		public function selectAlumnos(int $nivelid)
		{	$this->intNivelId = $nivelid;
			$sql = "SELECT CONCAT(a.nombres,' ',a.apellidos) AS nombre, a.idalumno, a.nivelid, a.asignado, a.status, n.nivel
			 FROM alumnos a
			 INNER JOIN niveles n
			 ON a.nivelid = n.idnivel 
			 WHERE a.nivelid=$this->intNivelId AND a.status = 1"; 
			$request = $this->select_all($sql);
			
			return $request;
		}

		public function selectAlumno(int $idalumno)
		{	$this->intIdAlumno = $idalumno;
			$sql = "SELECT CONCAT(a.nombres,' ',a.apellidos) AS nombre, a.idalumno, a.matricula, a.sexo, a.nivelid, a.status, n.nivel
			 FROM alumnos a
			 INNER JOIN niveles n
			 ON a.nivelid = n.idnivel 
			 WHERE a.idalumno=$this->intIdAlumno AND a.status = 1"; 
			$request = $this->select($sql);
			
			return $request;
		}

		public function selectCiclos()
		{
			$sql = "SELECT * FROM ciclos_escolares WHERE status != 0"; 
			$request = $this->select_all($sql);
			return $request;
		}

	}

 ?>