<?php 
	#[\AllowDynamicProperties]
	class HorariosModel extends Mysql
	{
		private $intIdHorario;
		private $intIdHorarioj;
		private $intGrupoId;
		private $intCarreraId;
		private $strFechaInicial;
		private $strFechaFinal;
		private $strDataLunes;
		private $strArrayLunes;
		private $strDataMartes;
		private $strArrayMartes;
		private $strDataMiercoles;
		private $strArrayMiercoles;
		private $strDataJueves;
		private $strArrayJueves;
		private $strDataViernes;
		private $strArrayViernes;
		private $strDataSabado;
		private $strArraySabado;
		private $strModificador;
		private $strUltimaModificacion;
		private $strTipoMovimiento;
		private $intStatus;

		public function __construct()
		{
			parent::__construct();
		}	

		public function insertHorario(int $grupoid, int $carreraid, string $fecha_inicial, string $fecha_final, string $data_lunes, string $data_martes, string $data_miercoles, string $data_jueves, string $data_viernes, string $data_sabado, string $modificador, string $tipo_movimiento, int $ciclo_escolar, int $status)
		{
			$this->intGrupoId = $grupoid;
			$this->intCarreraId = $carreraid;
			$this->strFechaInicial = $fecha_inicial;
			$this->strFechaFinal = $fecha_final;
			$this->strDataLunes = $data_lunes;
			$this->strArrayLunes = json_decode($data_lunes, true);
			$this->strDataMartes = $data_martes;
			$this->strArrayMartes = json_decode($data_martes, true);
			$this->strDataMiercoles = $data_miercoles;
			$this->strArrayMiercoles = json_decode($data_miercoles, true);
			$this->strDataJueves = $data_jueves;
			$this->strArrayJueves = json_decode($data_jueves, true);
			$this->strDataViernes = $data_viernes;
			$this->strArrayViernes = json_decode($data_viernes, true);
			$this->strDataSabado = $data_sabado;
			$this->strArraySabado = json_decode($data_sabado, true);
			$this->strModificador = $modificador;
			$this->intCicloId = $ciclo_escolar;
			$this->strTipoMovimiento = $tipo_movimiento;
			$this->intStatus = $status;
			$request_nivel = $this->selectNivel($this->intCarreraId);

			if(intval($request_nivel)>0)
			{
				$this->intNivelId = $request_nivel['nivelid'];
			}
			$return = 0;

			$sql = "SELECT * FROM horarios_json WHERE (grupoid = {$this->intGrupoId} AND status = 1 AND cicloid=$this->intCicloId)";
			$request = $this->select_all($sql);

			if(empty($request))
			{
				$query_insert  = "INSERT INTO horarios_json(grupoid,carreraid,nivelid,fecha_inicial,fecha_final,data_lunes,data_martes,data_miercoles,data_jueves,data_viernes,data_sabado,modificador,tipo_movimiento,cicloid,status) 
								  VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
	        	$arrData = array($this->intGrupoId,
	        					$this->intCarreraId,
	        					$this->intNivelId,
	        					$this->strFechaInicial,
	        					$this->strFechaFinal,
        						$this->strDataLunes,
        						$this->strDataMartes,
        						$this->strDataMiercoles,
        						$this->strDataJueves,
        						$this->strDataViernes,
        						$this->strDataSabado,
        						$this->strModificador,
        						$this->strTipoMovimiento,
        						$this->intCicloId,
        						$this->intStatus);
	        	$request_insert = $this->insert($query_insert,$arrData);
	        	$return = $request_insert;

	        	if(intval($request_insert)>0)
	        	{
	        		if(!empty($this->strArrayLunes))
	        		{
		        		for ($i=0; $i < count($this->strArrayLunes); $i++) { 
			        		$query_asignacion = "INSERT INTO horarios(grupoid,carreraid,materiaid,profesorid,fecha_inicial,fecha_final,dia,hora_inicial,hora_final,aula,horariojid,modificador,tipo_movimiento,cicloid,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			        		$arrAsignacion = array($this->strArrayLunes[$i]['grupoid'],
			        					$this->intCarreraId,
		        						$this->strArrayLunes[$i]['materia'],
		        						$this->strArrayLunes[$i]['profesor'],
		        						$this->strFechaInicial,
		        						$this->strFechaFinal,
		        						"lunes",
		        						$this->strArrayLunes[$i]['hora_inicial'],
		        						$this->strArrayLunes[$i]['hora_final'],
		        						$this->strArrayLunes[$i]['aula'],
		        						$request_insert,
		        						$this->strModificador,
		        						$this->strTipoMovimiento,
		        						$this->intCicloId,
		        						$this->intStatus);
			        		$request_asignacion = $this->insert($query_asignacion,$arrAsignacion);
		        		}
		        	}

		        	if(!empty($this->strArrayMartes))
	        		{
		        		for ($i=0; $i < count($this->strArrayMartes); $i++) { 
			        		$query_asignacion = "INSERT INTO horarios(grupoid,carreraid,materiaid,profesorid,fecha_inicial,fecha_final,dia,hora_inicial,hora_final,aula,horariojid,modificador,tipo_movimiento,cicloid,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			        		$arrAsignacion = array($this->strArrayMartes[$i]['grupoid'],
			        					$this->intCarreraId,
		        						$this->strArrayMartes[$i]['materia'],
		        						$this->strArrayMartes[$i]['profesor'],
		        						$this->strFechaInicial,
		        						$this->strFechaFinal,
		        						"martes",
		        						$this->strArrayMartes[$i]['hora_inicial'],
		        						$this->strArrayMartes[$i]['hora_final'],
		        						$this->strArrayMartes[$i]['aula'],
		        						$request_insert,
		        						$this->strModificador,
		        						$this->strTipoMovimiento,
		        						$this->intCicloId,
		        						$this->intStatus);
			        		$request_asignacion = $this->insert($query_asignacion,$arrAsignacion);
		        		}
		        	}

		        	if(!empty($this->strArrayMiercoles))
	        		{
		        		for ($i=0; $i < count($this->strArrayMiercoles); $i++) { 
			        		$query_asignacion = "INSERT INTO horarios(grupoid,carreraid,materiaid,profesorid,fecha_inicial,fecha_final,dia,hora_inicial,hora_final,aula,horariojid,modificador,tipo_movimiento,cicloid,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			        		$arrAsignacion = array($this->strArrayMiercoles[$i]['grupoid'],
			        					$this->intCarreraId,
		        						$this->strArrayMiercoles[$i]['materia'],
		        						$this->strArrayMiercoles[$i]['profesor'],
		        						$this->strFechaInicial,
		        						$this->strFechaFinal,
		        						"miercoles",
		        						$this->strArrayMiercoles[$i]['hora_inicial'],
		        						$this->strArrayMiercoles[$i]['hora_final'],
		        						$this->strArrayMiercoles[$i]['aula'],
		        						$request_insert,
		        						$this->strModificador,
		        						$this->strTipoMovimiento,
		        						$this->intCicloId,
		        						$this->intStatus);
			        		$request_asignacion = $this->insert($query_asignacion,$arrAsignacion);
		        		}
		        	}

		        	if(!empty($this->strArrayJueves))
	        		{
		        		for ($i=0; $i < count($this->strArrayJueves); $i++) { 
			        		$query_asignacion = "INSERT INTO horarios(grupoid,carreraid,materiaid,profesorid,fecha_inicial,fecha_final,dia,hora_inicial,hora_final,aula,horariojid,modificador,tipo_movimiento,cicloid,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			        		$arrAsignacion = array($this->strArrayJueves[$i]['grupoid'],
			        					$this->intCarreraId,
		        						$this->strArrayJueves[$i]['materia'],
		        						$this->strArrayJueves[$i]['profesor'],
		        						$this->strFechaInicial,
		        						$this->strFechaFinal,
		        						"jueves",
		        						$this->strArrayJueves[$i]['hora_inicial'],
		        						$this->strArrayJueves[$i]['hora_final'],
		        						$this->strArrayJueves[$i]['aula'],
		        						$request_insert,
		        						$this->strModificador,
		        						$this->strTipoMovimiento,
		        						$this->intCicloId,
		        						$this->intStatus);
			        		$request_asignacion = $this->insert($query_asignacion,$arrAsignacion);
		        		}
		        	}

		        	if(!empty($this->strArrayViernes))
	        		{
		        		for ($i=0; $i < count($this->strArrayViernes); $i++) { 
			        		$query_asignacion = "INSERT INTO horarios(grupoid,carreraid,materiaid,profesorid,fecha_inicial,fecha_final,dia,hora_inicial,hora_final,aula,horariojid,modificador,tipo_movimiento,cicloid,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			        		$arrAsignacion = array($this->strArrayViernes[$i]['grupoid'],
			        					$this->intCarreraId,
		        						$this->strArrayViernes[$i]['materia'],
		        						$this->strArrayViernes[$i]['profesor'],
		        						$this->strFechaInicial,
		        						$this->strFechaFinal,
		        						"viernes",
		        						$this->strArrayViernes[$i]['hora_inicial'],
		        						$this->strArrayViernes[$i]['hora_final'],
		        						$this->strArrayViernes[$i]['aula'],
		        						$request_insert,
		        						$this->strModificador,
		        						$this->strTipoMovimiento,
		        						$this->intCicloId,
		        						$this->intStatus);
			        		$request_asignacion = $this->insert($query_asignacion,$arrAsignacion);
		        		}
		        	}

		        	if(!empty($this->strArraySabado))
	        		{
		        		for ($i=0; $i < count($this->strArraySabado); $i++) { 
			        		$query_asignacion = "INSERT INTO horarios(grupoid,carreraid,materiaid,profesorid,fecha_inicial,fecha_final,dia,hora_inicial,hora_final,aula,horariojid,modificador,tipo_movimiento,cicloid,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			        		$arrAsignacion = array($this->strArraySabado[$i]['grupoid'],
			        					$this->intCarreraId,
		        						$this->strArraySabado[$i]['materia'],
		        						$this->strArraySabado[$i]['profesor'],
		        						$this->strFechaInicial,
		        						$this->strFechaFinal,
		        						"sabado",
		        						$this->strArraySabado[$i]['hora_inicial'],
		        						$this->strArraySabado[$i]['hora_final'],
		        						$this->strArraySabado[$i]['aula'],
		        						$request_insert,
		        						$this->strModificador,
		        						$this->strTipoMovimiento,
		        						$this->intCicloId,
		        						$this->intStatus);
			        		$request_asignacion = $this->insert($query_asignacion,$arrAsignacion);
		        		}
		        	}

	        	}

			}else{
				$return = "exist";
			}
	        return $return;
		}

		public function UpdateHorario(int $idhorario, int $grupoid, int $carreraid, string $fecha_inicial, string $fecha_final, string $data_lunes, string $data_martes, string $data_miercoles, string $data_jueves, string $data_viernes, string $data_sabado, string $modificador, string $tipo_movimiento, int $ciclo_escolar, int $status){
			date_default_timezone_set('America/Mexico_city');
			$this->intIdHorario = $idhorario;
			$this->intGrupoId = $grupoid;
			$this->intCarreraId = $carreraid;
			$this->strFechaInicial = $fecha_inicial;
			$this->strFechaFinal = $fecha_final;
			$this->strDataLunes = $data_lunes;
			$this->strArrayLunes = json_decode($data_lunes, true);
			$this->strDataMartes = $data_martes;
			$this->strArrayMartes = json_decode($data_martes, true);
			$this->strDataMiercoles = $data_miercoles;
			$this->strArrayMiercoles = json_decode($data_miercoles, true);
			$this->strDataJueves = $data_jueves;
			$this->strArrayJueves = json_decode($data_jueves, true);
			$this->strDataViernes = $data_viernes;
			$this->strArrayViernes = json_decode($data_viernes, true);
			$this->strDataSabado = $data_sabado;
			$this->strArraySabado = json_decode($data_sabado, true);
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date('Y-m-d h:i:s');
			$this->intCicloId = $ciclo_escolar;
			$this->strTipoMovimiento = $tipo_movimiento;
			$this->intStatus = $status;
			$request_nivel = $this->selectNivel($this->intCarreraId);

			if(intval($request_nivel)>0)
			{
				$this->intNivelId = $request_nivel['nivelid'];
			}

			$sql = "SELECT * FROM horarios_json WHERE (grupoid = {$this->intGrupoId} AND carreraid = $this->intCarreraId AND idhorarioj != $this->intIdHorario AND status = 1 AND cicloid=$this->intCicloId)";
			$request = $this->select_all($sql);

			if(empty($request))
			{
				$sql = "UPDATE horarios_json SET grupoid = ?, carreraid = ?, nivelid = ?, fecha_inicial=?, fecha_final=?, data_lunes=?, data_martes=?, data_miercoles=?, data_jueves=?, data_viernes=?, data_sabado=?, modificador=?, ultima_modificacion = ?, tipo_movimiento = ?, cicloid = ?, status = ? WHERE idhorarioj = $this->intIdHorario ";
	        	$arrData = array($this->intGrupoId,
	        					$this->intCarreraId,
	        					$this->intNivelId,
	        					$this->strFechaInicial,
        						$this->strFechaFinal,
	        					$this->strDataLunes,
        						$this->strDataMartes,
        						$this->strDataMiercoles,
        						$this->strDataJueves,
        						$this->strDataViernes,
        						$this->strDataSabado,
        						$this->strModificador,
        						$this->strUltimaModificacion,
        						$this->strTipoMovimiento,
        						$this->intCicloId,
        						$this->intStatus);
				$request = $this->update($sql,$arrData);

				$sqlDelete = "DELETE FROM horarios WHERE horariojid = $this->intIdHorario ";
				$requestDelete = $this->delete($sqlDelete);

				if(intval($requestDelete)>0)
	        	{	
	        		if(!empty($this->strArrayLunes))
	        		{
		        		for ($i=0; $i < count($this->strArrayLunes); $i++) { 
			        		$query_asignacion = "INSERT INTO horarios(grupoid,carreraid,materiaid,profesorid,fecha_inicial,fecha_final,dia,hora_inicial,hora_final,aula,horariojid,modificador,tipo_movimiento,cicloid,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			        		$arrAsignacion = array($this->strArrayLunes[$i]['grupoid'],
			        					$this->intCarreraId,
		        						$this->strArrayLunes[$i]['materia'],
		        						$this->strArrayLunes[$i]['profesor'],
		        						$this->strFechaInicial,
		        						$this->strFechaFinal,
		        						"lunes",
		        						$this->strArrayLunes[$i]['hora_inicial'],
		        						$this->strArrayLunes[$i]['hora_final'],
		        						$this->strArrayLunes[$i]['aula'],
		        						$this->intIdHorario,
		        						$this->strModificador,
		        						$this->strTipoMovimiento,
		        						$this->intCicloId,
		        						$this->intStatus);
			        		$request_asignacion = $this->insert($query_asignacion,$arrAsignacion);
		        		}
		        	}

		        	if(!empty($this->strArrayMartes))
	        		{
		        		for ($i=0; $i < count($this->strArrayMartes); $i++) { 
			        		$query_asignacion = "INSERT INTO horarios(grupoid,carreraid,materiaid,profesorid,fecha_inicial,fecha_final,dia,hora_inicial,hora_final,aula,horariojid,modificador,tipo_movimiento,cicloid,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			        		$arrAsignacion = array($this->strArrayMartes[$i]['grupoid'],
			        					$this->intCarreraId,
		        						$this->strArrayMartes[$i]['materia'],
		        						$this->strArrayMartes[$i]['profesor'],
		        						$this->strFechaInicial,
		        						$this->strFechaFinal,
		        						"martes",
		        						$this->strArrayMartes[$i]['hora_inicial'],
		        						$this->strArrayMartes[$i]['hora_final'],
		        						$this->strArrayMartes[$i]['aula'],
		        						$this->intIdHorario,
		        						$this->strModificador,
		        						$this->strTipoMovimiento,
		        						$this->intCicloId,
		        						$this->intStatus);
			        		$request_asignacion = $this->insert($query_asignacion,$arrAsignacion);
		        		}
		        	}

		        	if(!empty($this->strArrayMiercoles))
	        		{
		        		for ($i=0; $i < count($this->strArrayMiercoles); $i++) { 
			        		$query_asignacion = "INSERT INTO horarios(grupoid,carreraid,materiaid,profesorid,fecha_inicial,fecha_final,dia,hora_inicial,hora_final,aula,horariojid,modificador,tipo_movimiento,cicloid,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			        		$arrAsignacion = array($this->strArrayMiercoles[$i]['grupoid'],
			        					$this->intCarreraId,
		        						$this->strArrayMiercoles[$i]['materia'],
		        						$this->strArrayMiercoles[$i]['profesor'],
		        						$this->strFechaInicial,
		        						$this->strFechaFinal,
		        						"miercoles",
		        						$this->strArrayMiercoles[$i]['hora_inicial'],
		        						$this->strArrayMiercoles[$i]['hora_final'],
		        						$this->strArrayMiercoles[$i]['aula'],
		        						$this->intIdHorario,
		        						$this->strModificador,
		        						$this->strTipoMovimiento,
		        						$this->intCicloId,
		        						$this->intStatus);
			        		$request_asignacion = $this->insert($query_asignacion,$arrAsignacion);
		        		}
		        	}

		        	if(!empty($this->strArrayJueves))
	        		{
		        		for ($i=0; $i < count($this->strArrayJueves); $i++) { 
			        		$query_asignacion = "INSERT INTO horarios(grupoid,carreraid,materiaid,profesorid,fecha_inicial,fecha_final,dia,hora_inicial,hora_final,aula,horariojid,modificador,tipo_movimiento,cicloid,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			        		$arrAsignacion = array($this->strArrayJueves[$i]['grupoid'],
			        					$this->intCarreraId,
		        						$this->strArrayJueves[$i]['materia'],
		        						$this->strArrayJueves[$i]['profesor'],
		        						$this->strFechaInicial,
		        						$this->strFechaFinal,
		        						"jueves",
		        						$this->strArrayJueves[$i]['hora_inicial'],
		        						$this->strArrayJueves[$i]['hora_final'],
		        						$this->strArrayJueves[$i]['aula'],
		        						$this->intIdHorario,
		        						$this->strModificador,
		        						$this->strTipoMovimiento,
		        						$this->intCicloId,
		        						$this->intStatus);
			        		$request_asignacion = $this->insert($query_asignacion,$arrAsignacion);
		        		}
		        	}

		        	if(!empty($this->strArrayViernes))
	        		{
		        		for ($i=0; $i < count($this->strArrayViernes); $i++) { 
			        		$query_asignacion = "INSERT INTO horarios(grupoid,carreraid,materiaid,profesorid,fecha_inicial,fecha_final,dia,hora_inicial,hora_final,aula,horariojid,modificador,tipo_movimiento,cicloid,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			        		$arrAsignacion = array($this->strArrayViernes[$i]['grupoid'],
			        					$this->intCarreraId,
		        						$this->strArrayViernes[$i]['materia'],
		        						$this->strArrayViernes[$i]['profesor'],
		        						$this->strFechaInicial,
		        						$this->strFechaFinal,
		        						"viernes",
		        						$this->strArrayViernes[$i]['hora_inicial'],
		        						$this->strArrayViernes[$i]['hora_final'],
		        						$this->strArrayViernes[$i]['aula'],
		        						$this->intIdHorario,
		        						$this->strModificador,
		        						$this->strTipoMovimiento,
		        						$this->intCicloId,
		        						$this->intStatus);
			        		$request_asignacion = $this->insert($query_asignacion,$arrAsignacion);
		        		}
		        	}

		        	if(!empty($this->strArraySabado))
	        		{
		        		for ($i=0; $i < count($this->strArraySabado); $i++) { 
			        		$query_asignacion = "INSERT INTO horarios(grupoid,carreraid,materiaid,profesorid,fecha_inicial,fecha_final,dia,hora_inicial,hora_final,aula,horariojid,modificador,tipo_movimiento,cicloid,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			        		$arrAsignacion = array($this->strArraySabado[$i]['grupoid'],
			        					$this->intCarreraId,
		        						$this->strArraySabado[$i]['materia'],
		        						$this->strArraySabado[$i]['profesor'],
		        						$this->strFechaInicial,
		        						$this->strFechaFinal,
		        						"sabado",
		        						$this->strArraySabado[$i]['hora_inicial'],
		        						$this->strArraySabado[$i]['hora_final'],
		        						$this->strArraySabado[$i]['aula'],
		        						$this->intIdHorario,
		        						$this->strModificador,
		        						$this->strTipoMovimiento,
		        						$this->intCicloId,
		        						$this->intStatus);
			        		$request_asignacion = $this->insert($query_asignacion,$arrAsignacion);
		        		}
		        	}

	        		return $request;
	        	}

			}else{
				$request = "exist";
			}
		    return $request;			
		}

		public function selectHorarios()
		{
			$sql = "SELECT n.nivel, g.idgrupo, g.grado, g.grupo, CONCAT(g.grado,'-',g.grupo) AS grupo_format, DATE_FORMAT(hj.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, c.idcarrera, c.carrera, c.reforma, c.modelo, hj.*
					FROM horarios_json hj 
					INNER JOIN niveles n
					ON n.idnivel = hj.nivelid
					INNER JOIN grupos g
					ON g.idgrupo = hj.grupoid
					INNER JOIN carreras c
					ON c.idcarrera = hj.carreraid
					WHERE hj.status != 0 AND hj.cicloid=".IDCICLO;
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectHorario($idhorarioj)
		{
			$this->intIdHorarioJ = $idhorarioj;	
			$sql = "SELECT n.nivel, g.idgrupo, g.grado, g.grupo, CONCAT(g.grado,'-',g.grupo) AS grupo_format, DATE_FORMAT(hj.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, c.idcarrera, c.carrera, c.nivelid, hj.*
					FROM horarios_json hj 
					INNER JOIN grupos g
					ON g.idgrupo = hj.grupoid
					INNER JOIN carreras c
					ON c.idcarrera = hj.carreraid
					INNER JOIN niveles n
					ON n.idnivel = c.nivelid
					WHERE idhorarioj = $this->intIdHorarioJ AND hj.status != 0";
			$request = $this->select($sql);
			return $request;
		}

		public function deleteHorario(int $idhorarioj, $modificador, $tipo_movimiento)
		{
			date_default_timezone_set('America/Mexico_city');
			$this->intIdHorarioJ = $idhorarioj;	
			$this->strModificador = $modificador;		
			$this->strUltimaModificacion = date('Y-m-d h:i:s');		
			$this->strTipoMovimiento = $tipo_movimiento;			
			$sql = "UPDATE horarios_json SET modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idhorarioj = $this->intIdHorarioJ ";
			$arrData = array($this->strModificador,
								$this->strUltimaModificacion,
								$this->strTipoMovimiento,
								0);
			$request = $this->update($sql,$arrData);
			if(intval($request) > 0)
			{
				$sqlDelete = "UPDATE horarios SET modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE horariojid = $this->intIdHorarioJ ";
				$arrDataDelete = array($this->strModificador,
										$this->strUltimaModificacion,
										$this->strTipoMovimiento,
										0);
				$requestDelete = $this->update($sqlDelete,$arrDataDelete);
			}
			return $request;
		}

		public function selectCarreras()
		{
			$sql = "SELECT c.idcarrera, c.carrera, c.modelo, c.reforma, c.nivelid, n.idnivel, n.nivel
					FROM carreras c
					INNER JOIN niveles n
					ON n.idnivel = c.nivelid
					WHERE c.status != 0";
					$request = $this->select_all($sql);
					return $request;
		}

		public function selectGrupos()
		{
			$sql = "SELECT * FROM grupos WHERE status != 0";
					$request = $this->select_all($sql);
					return $request;
		}

		public function selectMaterias()
		{
			$sql = "SELECT idmateria, materia FROM materias WHERE status != 0";
					$request = $this->select_all($sql);
					return $request;
		}

		public function selectMateriasCarrera($carreraid)
		{
			$this->intCarreraId = $carreraid;
			$sql = "SELECT m.idmateria,m.materia,m.carreraid,m.semestre,c.idcarrera,c.abreviatura,c.reforma,CONCAT(c.abreviatura,'-',c.reforma) AS carrera_format 
					FROM materias m
					INNER JOIN carreras c
					ON c.idcarrera = m.carreraid
					WHERE m.carreraid = {$this->intCarreraId} AND m.status != 0 ORDER BY m.materia ASC";
			$request = $this->select_all($sql);

			return $request;
		}

		public function selectCarreraGrupo($idgrupo)
		{
			$this->intIdGrupo = $idgrupo;
			$sql = "SELECT carreraid FROM grupos WHERE idgrupo = {$this->intIdGrupo} AND status != 0";
					$request = $this->select($sql);
					return $request;
		}

		public function selectUsuarios()
		{
			$rolProfesor = RDOCENTE;
			$sql = "SELECT idpersona, CONCAT(nombres,' ',apellidos) AS nombre FROM persona WHERE status != 0 AND rolid = $rolProfesor";			
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectNivel(int $carreraid)
		{
			$this->intCarreraId = $carreraid;		
			$sql = "SELECT nivelid FROM carreras WHERE idcarrera = $this->intCarreraId ";
			$request = $this->select($sql);
			return $request;
		}

		public function selectTableHorario($idhorarioj)
		{
			$this->intIdHorarioJ = $idhorarioj;	
			$sql = "SELECT m.idmateria, m.materia, g.idgrupo, g.grado, g.grupo, CONCAT(g.grado,'-',g.grupo) AS grupo_format, h.*
					FROM horarios h 
					INNER JOIN materias m
					ON m.idmateria = h.materiaid
					INNER JOIN grupos g
					ON g.idgrupo = h.grupoid
					WHERE horariojid = $this->intIdHorarioJ AND h.status != 0 ORDER BY h.hora_inicial ASC";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectHorarioJ(int $idhorarioj)
		{	
			$this->intIdHorarioJ = $idhorarioj;
			$sql = "SELECT CONCAT(p.nombres,' ',p.apellidos) AS nombre_profesor, n.nivel, g.idgrupo, g.grado, g.grupo, m.materia, hj.data_lunes, hj.data_martes, hj.data_miercoles, hj.data_jueves, hj.data_viernes, hj.data_sabado, DATE_FORMAT(h.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, c.idcarrera, c.carrera, c.nivelid, h.* 
					FROM horarios h 
					INNER JOIN persona p 
					ON p.idpersona = h.profesorid
					INNER JOIN grupos g 
					ON g.idgrupo = h.grupoid 
					INNER JOIN materias m 
					ON m.idmateria = h.materiaid 
					INNER JOIN carreras c 
					ON c.idcarrera = h.carreraid
					INNER JOIN niveles n 
					ON n.idnivel = c.nivelid 
					INNER JOIN horarios_json hj 
					ON hj.idhorarioj = h.horariojid 
					WHERE h.horariojid = $this->intIdHorarioJ AND h.status !=0 ORDER BY h.dia = 'viernes', h.dia = 'jueves', h.dia = 'miercoles', h.dia='martes', h.dia='lunes', h.hora_inicial ASC";
			$request = $this->select_all($sql);
			
			return $request;
		}

		public function selectCiclos()
		{
			$sql = "SELECT * FROM ciclos_escolares WHERE status != 0";
			$request = $this->select_all($sql);
			return $request;
		}

	}
 ?>