<?php 

	class IncidenciasModel extends Mysql
	{
		private $intIdIncidencia;
		private $intAlumnoId;
		private $intNivelId;
		private $strIncidencia;
		private $intPersonaId;
		private $strFechaIncidencia;
		private $strSeguimiento;
		private $strEstado;
		private $strPersonaSeguimiento;
		private $strUltimaModificacion;
		private $strTipoMovimiento;
		private $intStatus;

		public function __construct()
		{
			parent::__construct();
		}	

		public function insertIncidencia(int $alumnoid, int $nivelid, string $incidencia, int $personaid, string $fecha_incidencia)
		{
			$this->intAlumnoId = $alumnoid;
			$this->intNivelId = $nivelid;
			$this->strIncidencia = $incidencia;
			$this->intPersonaId = $personaid;
			$this->strFechaIncidencia = $fecha_incidencia;
			$this->strEstado = 'Pendiente';
			$this->strTipoMovimiento = 'Alta';
			
			$return = 0;

			$query_insert  = "INSERT INTO incidencias(alumnoid,nivelid,incidencia,personaid,fecha_incidencia,estado,tipo_movimiento) 
							  VALUES(?,?,?,?,?,?,?)";
			$arrData = array($this->intAlumnoId,
							$this->intNivelId,
							$this->strIncidencia,
							$this->intPersonaId,
							$this->strFechaIncidencia,
							$this->strEstado,
							$this->strTipoMovimiento);
			$request_insert = $this->insert($query_insert,$arrData);
			$return = $request_insert;
			
	        return $return;
		}

		public function updateIncidencia(int $idincidencia, int $alumnoid, int $nivelid, string $incidencia, int $personaid, string $fecha_incidencia){
			$this->intIdIncidencia = $idincidencia;
			$this->intAlumnoId = $alumnoid;
			$this->intNivelId = $nivelid;
			$this->strIncidencia = $incidencia;
			$this->intPersonaId = $personaid;
			$this->strFechaIncidencia = $fecha_incidencia;
			$this->strPersonaSeguimiento = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
			$this->strUltimaModificacion = date('Y-m-d h:i:s');
			$this->strTipoMovimiento = 'Actualización';

			$sql = "UPDATE incidencias SET alumnoid = ?, nivelid = ?, incidencia = ?, fecha_incidencia = ?, persona_seguimiento = ?, ultima_modificacion = ?, tipo_movimiento = ? WHERE idincidencia = $this->intIdIncidencia ";
			$arrData = array($this->intAlumnoId,
							$this->intNivelId,
    						$this->strIncidencia,
    						$this->strFechaIncidencia,
    						$this->strPersonaSeguimiento,
    						$this->strUltimaModificacion,
    						$this->strTipoMovimiento);
			$request = $this->update($sql,$arrData);
			
		    return $request;			
		}

		public function updateSeguimiento(int $idincidencia, string $seguimiento, string $estado){
			$this->intIdIncidencia = $idincidencia;
			$this->strSeguimiento = $seguimiento;
			$this->strEstado = $estado;
			$this->strPersonaSeguimiento = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
			$this->strUltimaModificacion = date('Y-m-d h:i:s');
			$this->strTipoMovimiento = 'Actualización';

			$sql = "UPDATE incidencias SET seguimiento = ?, estado = ?, persona_seguimiento = ?, ultima_modificacion = ?, tipo_movimiento = ? WHERE idincidencia = $this->intIdIncidencia ";
			$arrData = array($this->strSeguimiento,
							$this->strEstado,
    						$this->strPersonaSeguimiento,
    						$this->strUltimaModificacion,
    						$this->strTipoMovimiento);
			$request = $this->update($sql,$arrData);
			
		    return $request;			
		}

		public function selectincidencias()
		{
			$where = '';
			if ($_SESSION['userData']['idrol'] == RADMINBACHILLERATO) {
				$where = 'AND (i.nivelid = 1 OR i.nivelid = 2)';
			}else if ($_SESSION['userData']['idrol'] == RADMINLICENCIATURA ) {
				$where = 'AND (i.nivelid = 3 OR i.nivelid = 4)';
			}else if ($_SESSION['userData']['idrol'] == RADMININGENIERIA) {
				$where = 'AND i.nivelid = 4';
			}else if ($_SESSION['userData']['idrol'] == RADMINPOSGRADO) {
				$where = 'AND (i.nivelid = 5 OR i.nivelid = 6 OR i.nivelid = 7)';
			}else if ($_SESSION['userData']['idrol'] == RDOCENTE) {
				$where = 'AND i.personaid = '.$_SESSION['userData']['idpersona'];
			}
			$sql = "SELECT CONCAT(p.nombres,' ',p.apellidos) AS nombre_persona, CONCAT(a.nombres,' ',a.apellidos) AS nombre_alumno, DATE_FORMAT(i.fecha_incidencia, '%d-%m-%Y') AS fecha_incidencia_format, n.nivel, i.*
					FROM incidencias i 
					INNER JOIN persona p
					ON p.idpersona = i.personaid
					INNER JOIN alumnos a
					ON a.idalumno = i.alumnoid
					INNER JOIN niveles n
					ON n.idnivel = i.nivelid
					WHERE i.status != 0 ".$where;
					$request = $this->select_all($sql);
					return $request;
		}

		public function selectIncidencia(int $idincidencia){
			$this->intIdIncidencia = $idincidencia;
			$sql = "SELECT CONCAT(p.nombres,' ',p.apellidos) AS nombre_persona, CONCAT(a.nombres,' ',a.apellidos) AS nombre_alumno, DATE_FORMAT(i.fecha_incidencia, '%d-%m-%Y') AS fecha_incidencia_format, n.nivel, i.*
					FROM incidencias i 
					INNER JOIN persona p
					ON p.idpersona = i.personaid
					INNER JOIN alumnos a
					ON a.idalumno = i.alumnoid
					INNER JOIN niveles n
					ON n.idnivel = i.nivelid
					WHERE i.idincidencia = $this->intIdIncidencia";
			$request = $this->select($sql);
			return $request;
		}

		public function deleteIncidencia(int $idincidencia, string $modificador)
		{
			$this->intIdIncidencia = $idincidencia;		
			$this->strPersonaSeguimiento = $modificador;
			$this->strUltimaModificacion = date("Y-m-d H:i:s");
			$this->strTipoMovimiento = "Eliminación";
			$sql = "UPDATE incidencias SET persona_seguimiento = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idincidencia = $this->intIdIncidencia ";
			$arrData = array($this->strPersonaSeguimiento,
								$this->strUltimaModificacion,
								$this->strTipoMovimiento,
								0);
			$request = $this->update($sql,$arrData);
			return $request;
		}

		public function selectAlumnos()
		{	
			$sql = "SELECT CONCAT(nombres,' ',apellidos) AS nombre_alumno, idalumno FROM alumnos WHERE status = 1"; 
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectNivel(int $alumnoid)
		{	
			$this->intAlumnoId = $alumnoid;
			$sql = "SELECT a.nivelid, n.nivel 
					FROM alumnos a 
					INNER JOIN niveles n
					ON n.idnivel = a.nivelid
					WHERE a.idalumno = $this->intAlumnoId"; 
			$request = $this->select($sql);
			return $request;
		}

		public function updateEstado(int $idincidencia, string $estado, string $tipo_movimiento, string $modificador)
		{
			$this->intIdIncidencia = $idincidencia;		
			$this->strEstado = $estado;
			$this->strTipoMovimiento = $tipo_movimiento;		
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date("Y-m-d H:i:s");
			$sql = "UPDATE incidencias SET estado = ?, tipo_movimiento = ?, persona_seguimiento = ?, ultima_modificacion = ? WHERE idincidencia = $this->intIdIncidencia ";
			$arrData = array($this->strEstado,
							$this->strTipoMovimiento,
							$this->strModificador,
							$this->strUltimaModificacion);
			$request = $this->update($sql,$arrData);
			return $request;
		}

	}

 ?>