<?php 

	class MateriasModel extends Mysql
	{
		private $intIdMateria;
		private $strClaveMateria;
		private $strMateria;
		private $intDuracion;
		private $intSemestre;
		private $intAntecesoraidId;
		private $intNivelId;
		private $intCarreraId;
		private $strModificador;
		private $strUltimaModificacion;
		private $strTipoMovimiento;
		private $intStatus;

		public function __construct()
		{
			parent::__construct();
		}	

		public function insertMateria(string $clave_materia, string $materia, int $duracion, int $semestre, int $antecesoraid, int $nivelid, int $carreraid, string $modificador, string $tipo_movimiento, int $status){
			$this->strClaveMateria = $clave_materia;
			$this->strMateria = $materia;
			$this->intDuracion = $duracion;
			$this->intSemestre = $semestre;
			$this->intAntecesoraidId = $antecesoraid;
			$this->intNivelId = $nivelid;
			$this->intCarreraId = $carreraid;
			$this->strModificador = $modificador;
			$this->strTipoMovimiento = $tipo_movimiento;
			$this->intStatus = $status;
			$return = 0;

			$sql = "SELECT * FROM materias WHERE (materia = '{$this->strMateria}' AND carreraid = $this->intCarreraId AND status != 0)";
			$request = $this->select_all($sql);

			if(empty($request))
			{
				$query_insert  = "INSERT INTO materias(clave_materia,materia,duracion,semestre,antecesoraid,nivelid,carreraid,modificador,tipo_movimiento,status) 
								  VALUES(?,?,?,?,?,?,?,?,?,?)";
	        	$arrData = array($this->strClaveMateria,
        						$this->strMateria,
        						$this->intDuracion,
        						$this->intSemestre,
        						$this->intAntecesoraidId,
        						$this->intNivelId,
        						$this->intCarreraId,
        						$this->strModificador,
        						$this->strTipoMovimiento,
        						$this->intStatus);
	        	$request_insert = $this->insert($query_insert,$arrData);
	        	$return = $request_insert;
			}else{
				$return = "exist";
			}
	        return $return;
		}

		public function updatemateria(int $idmateria, string $clave_materia, string $materia, int $duracion, int $semestre, int $antecesoraid, int $nivelid, int $carreraid, string $modificador, string $tipo_movimiento, int $status){
			date_default_timezone_set('America/Mexico_city');
			$this->intIdMateria = $idmateria;
			$this->strClaveMateria = $clave_materia;
			$this->strMateria = $materia;
			$this->intDuracion = $duracion;
			$this->intSemestre = $semestre;
			$this->intAntecesoraidId = $antecesoraid;
			$this->intNivelId = $nivelid;
			$this->intCarreraId = $carreraid;
			$this->strModificador = $modificador;
			$this->strUltimoMovimiento = date('Y-m-d h:i:s');
			$this->strTipoMovimiento = $tipo_movimiento;
			$this->intStatus = $status;

			$sql = "SELECT * FROM materias WHERE (materia = '{$this->strMateria}' AND idmateria != $this->intIdMateria AND carreraid = $this->intCarreraId AND status != 0 AND idmateria != $this->intIdMateria)";
			$request = $this->select_all($sql);

			if(empty($request))
			{
				$sql = "UPDATE materias SET clave_materia = ?, materia = ?, duracion = ?, semestre = ?, antecesoraid = ?, nivelid = ?, carreraid = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ?  WHERE idmateria = $this->intIdMateria ";
				$arrData = array($this->strClaveMateria,
        						$this->strMateria,
        						$this->intDuracion,
        						$this->intSemestre,
        						$this->intAntecesoraidId,
        						$this->intNivelId,
        						$this->intCarreraId,
        						$this->strModificador,
        						$this->strUltimoMovimiento,
        						$this->strTipoMovimiento,
        						$this->intStatus);
				$request = $this->update($sql,$arrData);
			}else{
				$request = "exist";
			}
		    return $request;			
		}

		public function selectMaterias()
		{
			$sql = "SELECT n.idnivel, n.nivel, c.idcarrera, c.carrera, c.abreviatura, c.reforma, CONCAT(c.abreviatura,'-',c.reforma) AS carrera_format, DATE_FORMAT(m.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, a.idmateria, a.materia AS antecesora, m.*
					FROM materias m 
					LEFT JOIN materias a
					ON m.antecesoraid = a.idmateria
					INNER JOIN niveles n
					ON n.idnivel = m.nivelid
					INNER JOIN carreras c
					ON c.idcarrera = m.carreraid
					WHERE m.status != 0";
					$request = $this->select_all($sql);
					return $request;
		}

		public function selectMateria(int $idmateria){
			$this->intIdMateria = $idmateria;
			$sql = "SELECT n.idnivel, n.nivel, c.idcarrera, c.carrera, CONCAT(c.abreviatura,'-',c.reforma) AS carrera_format, DATE_FORMAT(m.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format, a.idmateria, a.materia AS antecesora, m.*
					FROM materias m 
					LEFT JOIN materias a
					ON m.antecesoraid = a.idmateria
					INNER JOIN niveles n
					ON n.idnivel = m.nivelid
					INNER JOIN carreras c
					ON c.idcarrera = m.carreraid
					WHERE m.idmateria = $this->intIdMateria";
			$request = $this->select($sql);
			return $request;
		}

		public function deleteMateria(int $idmateria, string $modificador)
		{
			date_default_timezone_set('America/Mexico_city');
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date("Y-m-d H:i:s");
			$this->strTipoMovimiento = 'Eliminación';
			$this->intIdMateria = $idmateria;	

			$sqlPermisivo = "SELECT idhorario, materiaid FROM horarios WHERE materiaid = $this->intIdMateria AND status != 0 AND cicloid=".IDCICLO;
			$requestPermisivo = $this->select_all($sqlPermisivo);

			if(intval($requestPermisivo)>0){
				$return = 'permisivo';
			}else{
				$sql = "UPDATE materias SET modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idmateria = $this->intIdMateria ";
				$arrData = array($this->strModificador,
									$this->strUltimaModificacion,
									$this->strTipoMovimiento,
									0);
				$request = $this->update($sql,$arrData);
				$return = $request;
			}
			return $return;
		}

		public function selectNiveles()
		{
			$sql = "SELECT idnivel, nivel FROM niveles WHERE status != 0";			
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectCarreras()
		{
			$sql = "SELECT idcarrera, carrera, reforma, modelo FROM carreras WHERE status != 0";			
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectCarreraFormat(int $idcarrera)
		{
			$this->intCarreraId = $idcarrera;
			$sql = "SELECT idcarrera, abreviatura, reforma, CONCAT(abreviatura,'-',reforma) AS carrera_format FROM carreras WHERE idcarrera = $this->intCarreraId";			
			$request = $this->select($sql);
			return $request;
		}

		public function selectAntecesoras()
		{
			$sql = "SELECT 
		            m.idmateria, 
		            m.clave_materia, 
		            m.materia, 
		            m.carreraid, 
		            c.idcarrera, 
		            c.abreviatura, 
		            c.reforma, 
		            CONCAT(c.abreviatura,'-',c.reforma) AS carrera_format, 
		            m.*
		        FROM materias m
		        LEFT JOIN carreras c
		            ON c.idcarrera = m.carreraid
		        WHERE m.status != 0 ORDER BY m.materia ASC";		
			$request = $this->select_all($sql);
			return $request;
		}

	}
 ?>