<?php 

	class NivelesModel extends Mysql
	{
		private $intIdNivel;
		private $strNivel;
		private $intCoordinadorId;
		private $strModificador;
		private $strUltimaModificacion;
		private $intStatus;

		public function __construct()
		{
			parent::__construct();
		}	

		public function insertNivel(string $nivel, int $coordinadorid, string $modificador, string $tipo_movimiento, int $status){
			$this->strNivel = $nivel;
			$this->intCoordinadorId = $coordinadorid;
			$this->strModificador = $modificador;
			$this->strTipoMovimiento = $tipo_movimiento;    
			$this->intStatus = $status;
			$return = 0;

			$sql = "SELECT * FROM niveles WHERE (nivel = '{$this->strNivel}' AND status != 0)";
			$request = $this->select_all($sql);

			if(empty($request))
			{
				$query_insert  = "INSERT INTO niveles(nivel,coordinadorid,modificador,tipo_movimiento,status) 
								  VALUES(?,?,?,?,?)";
	        	$arrData = array($this->strNivel,
	        					$this->intCoordinadorId,
        						$this->strModificador,
        						$this->strTipoMovimiento,
        						$this->intStatus);
	        	$request_insert = $this->insert($query_insert,$arrData);
	        	$return = $request_insert;
			}else{
				$return = "exist";
			}
	        return $return;
		}

		public function updateNivel(int $idnivel, string $nivel, int $coordinadorid, string $modificador, string $tipo_movimiento, int $status){
			date_default_timezone_set('America/Mexico_city');
			$this->intIdNivel = $idnivel;
			$this->strNivel = $nivel;
			$this->intCoordinadorId = $coordinadorid;
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date("Y-m-d H:i:s"); 
			$this->strTipoMovimiento = $tipo_movimiento;    
			$this->intStatus = $status;

			$sql = "SELECT * FROM niveles WHERE (nivel = '{$this->strNivel}' AND idnivel != $this->intIdNivel AND status != 0)";
			$request = $this->select_all($sql);

			if(empty($request))
			{
				$sql = "UPDATE niveles SET nivel = ?, coordinadorid = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idnivel = $this->intIdNivel ";
				$arrData = array($this->strNivel,
								$this->intCoordinadorId,
        						$this->strModificador,
        						$this->strUltimaModificacion,
        						$this->strTipoMovimiento,
        						$this->intStatus);
				$request = $this->update($sql,$arrData);
			}else{
				$request = "exist";
			}
		    return $request;			
		}

		public function selectNiveles()
		{
			$sql = "SELECT n.*, CONCAT(p.nombres,' ',p.apellidos) AS nombre_coordinador, p.idpersona, DATE_FORMAT(n.ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format 
					FROM niveles n
					LEFT JOIN persona p
					ON p.idpersona = n.coordinadorid
					WHERE n.status != 0";
					$request = $this->select_all($sql);
					return $request;
		}

		public function selectNivel(int $idnivel)
		{
			$this->intIdNivel = $idnivel;
			$sql = "SELECT *, DATE_FORMAT(ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format FROM niveles WHERE idnivel = $this->intIdNivel";
			$request = $this->select($sql);
			return $request;
		}

		public function selectUsuarios()
		{
			$sql = "SELECT CONCAT(nombres,' ',apellidos) AS nombre_usuario, idpersona  
					FROM persona WHERE status != 0";
					$request = $this->select_all($sql);
					return $request;
		}

		public function deleteNivel(int $idnivel, string $modificador)
		{
			$this->intIdNivel = $idnivel;		
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date("Y-m-d H:i:s");
			$this->strTipoMovimiento = 'Eliminación';
			$sql = "UPDATE niveles SET modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idnivel = $this->intIdNivel ";
			$arrData = array($this->strModificador,
								$this->strUltimaModificacion,
								$this->strTipoMovimiento,
								0);
			$request = $this->update($sql,$arrData);
			return $request;
		}
	}
 ?>