<?php 

	class PGrupalModel extends Mysql
	{
		private $strMatricula;
		private $intNivelId;
		private $intCarreraId;
		private $intSemestre;
		private $intMateriaId;
		private $intHorarioId;
		private $intAlumnoId;
		private $intDocenteId;
		private $strGrado;
		private $strGrupo;
		private $strCalificacionA;
		private $strFechaCapturaA;
		private $strCalificacionB;
		private $strFechaCapturaB;
		private $strCalificacionC;
		private $strFechaCapturaC;
		private $strCalificacionD;
		private $strFechaCapturaD;
		private $strFechaCaptura;
		private $intPersonaId;
		private $strModificador;
		private $strUltimaModificacion;
		private $intStatus;

		private $semestres;
		private $intPrimero;
		private $intSegundo;
		private $intTercero;
		private $intCuarto;
		private $intQuinto;
		private $intSexto;
		private $intSeptimo;
		private $intOctavo;
		private $intNoveno;

		public function __construct()
		{
			parent::__construct();
		}	

		public function selectGrupo(int $carreraid, string $grado, string $grupo)
		{
			$this->intCarreraId = $carreraid;
			$this->strGrado = $grado;
			$this->strGrupo = $grupo;

			$sql = "SELECT idalumno, CONCAT(a.apellidos,' ',a.nombres) AS nombre_alumno, a.matricula, a.sexo, a.grado, a.grupo, n.idnivel, n.nivel, c.idcarrera, c.carrera  
					FROM alumnos a
					INNER JOIN niveles n
					ON n.idnivel = a.nivelid
					INNER JOIN carreras c
					ON c.idcarrera = a.carreraid 
					WHERE (a.carreraid = $this->intCarreraId AND a.grado = '$this->strGrado' AND a.grupo = '$this->strGrupo') ORDER BY a.apellidos ASC"; 
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectCarreras()
		{
			$sql = "SELECT c.idcarrera, c.carrera, c.reforma, n.idnivel, n.nivel 
					FROM carreras c
					INNER JOIN niveles n
					ON n.idnivel = c.nivelid
					WHERE c.status = 1";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectCiclos()
		{
			$sql = "SELECT * FROM ciclos_escolares WHERE status != 0;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectGrupos(int $carreraid, int $cicloid)
		{
			$this->intCarreraId = $carreraid;
			$this->intCicloId = $cicloid;
			$sql = "SELECT DISTINCT k.grupoid, k.carreraid, K.nivelid, c.idciclo, c.ciclo_escolar, g.idgrupo, g.grado, g.grupo, ca.idcarrera, ca.nivelid, ca.carrera, n.idnivel, n.nivel
						FROM kardex  k 
						INNER JOIN ciclos_escolares c
						ON c.idciclo = k.cicloid
						INNER JOIN grupos g
						ON g.idgrupo = k.grupoid
						INNER JOIN niveles n
						ON n.idnivel = k.nivelid
						INNER JOIN carreras ca
						ON ca.idcarrera = k.carreraid
						WHERE k.carreraid = $this->intCarreraId AND cicloid = $this->intCicloId AND k.status = 1 ORDER BY k.nivelid, g.grado, g.grupo;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectMaterias(int $carreraid, int $grupoid)
		{
			$this->intCarreraId = $carreraid;
			$this->intGrupoId = $grupoid;
			$sql = "SELECT DISTINCT k.materiaid, m.idmateria, m.materia 
						FROM kardex k
						INNER JOIN materias m
						ON m.idmateria = k.materiaid
						WHERE k.carreraid = $this->intCarreraId AND k.grupoid = '$this->intGrupoId' AND k.status = 1 ORDER BY m.materia;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectKardexTodos(int $carreraid, int $grupoid, int $materiaid)
		{
			$this->intCarreraId = $carreraid;
			$this->intGrupoId = $grupoid;
			$this->intMateriaId = $materiaid;
			$sql = "SELECT k.*, a.idalumno, CONCAT(a.apellidos,' ',a.nombres) AS nombre_alumno, a.matricula, m.materia, DATE_FORMAT(k.fecha_a, '%d-%m-%Y') AS fecha_a_format, CONCAT(p.nombres,' ',p.apellidos) AS nombre_docente, n.nivel, c.carrera
					FROM kardex k
					INNER JOIN alumnos a
					ON a.idalumno = k.alumnoid 
					INNER JOIN materias m
					ON m.idmateria = k.materiaid
					INNER JOIN persona p
					ON p.idpersona = k.profesorid
					INNER JOIN niveles n
					ON n.idnivel = k.nivelid
					INNER JOIN carreras c
					ON c.idcarrera = k.carreraid
					WHERE k.carreraid = $this->intCarreraId AND k.materiaid = $this->intMateriaId AND k.grupoid = '$this->intGrupoId' AND k.status = 1 ORDER BY k.semestre ASC, a.apellidos ASC;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectKardexSemestres(int $carreraid, int $grupoid, int $materiaid, array $semestres)
		{
			$this->intCarreraId = $carreraid;
			$this->intGrupoId = $grupoid;
			$this->intMateriaId = $materiaid;
			$this->semestres = $semestres;
			$condicion = "";

			for($i=0;$i<sizeof($semestres);$i++){  
                if($i==0){
                   

                   if($i == (sizeof($semestres)-1))
                	{
                		$condicion.="AND (k.semestre=".$semestres[$i].")";
                	}else{
                		$condicion.="AND (k.semestre=".$semestres[$i];
                	}

               }else{           
                	if($i == (sizeof($semestres)-1)){
                		$condicion.=" OR k.semestre=".$semestres[$i].")";
                	}else{
                		$condicion.=" OR k.semestre=".$semestres[$i];
                	}
	            }
	        }

			$sql = "SELECT k.*, a.idalumno, CONCAT(a.apellidos,' ',a.nombres) AS nombre_alumno, a.matricula, m.materia, DATE_FORMAT(k.fecha_a, '%d-%m-%Y') AS fecha_a_format, CONCAT(p.nombres,' ',p.apellidos) AS nombre_docente, n.nivel, c.carrera
					FROM kardex k
					INNER JOIN alumnos a
					ON a.idalumno = k.alumnoid 
					INNER JOIN materias m
					ON m.idmateria = k.materiaid
					INNER JOIN persona p
					ON p.idpersona = k.profesorid
					INNER JOIN niveles n
					ON n.idnivel = k.nivelid
					INNER JOIN carreras c
					ON c.idcarrera = k.carreraid
					WHERE k.carreraid = $this->intCarreraId AND k.materiaid = $this->intMateriaId AND k.grupoid = '$this->intGrupoId' AND k.status = 1 $condicion ORDER BY k.semestre ASC, a.apellidos ASC;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectBusquedaAlumnos(int $nivelid, int $carreraid, string $grado, string $grupoid){
			$this->intNivelId = $nivelid;
			$this->intCarreraId = $carreraid;
			$this->strGrado = $grado;
			$this->intGrupoId = $grupoid;
			
			$sql = "SELECT idalumno, matricula, CONCAT(apellidos,' ',nombres) AS nombre_alumno, matricula, grado, grupoid, CONCAT(grado,'-',grupo) AS grupo_format
						FROM alumnos 
						WHERE nivelid = $this->intNivelId AND carreraid = $this->intCarreraId AND grado = '$this->strGrado' AND grupoid = '$this->intGrupoId' AND egresado != 1 AND status =1 ORDER BY apellidos ASC;";
			//dep($sql);
			$request = $this->select_all($sql);

			return $request;
		}

		public function selectData(int $nivelid, int $carreraid, int $materiaid, string $grupo){
			
			$this->intNivelId = $nivelid;
			$this->intCarreraId = $carreraid;
			$this->intMateriaId = $materiaid;
			$this->strGrupo = $grupo;

			/*dep("Nivel: ".$this->intNivelId);
			dep("Carrera: ".$this->intCarreraId);
			dep("Materia: ".$this->intMateriaId);
			dep("Grupo: ".$this->strGrupo);
			exit;*/
			
			$sql = "SELECT profesorid FROM horarios WHERE nivelid = $this->intNivelId AND materiaid = $this->intMateriaId AND carreraid = $this->intCarreraId AND grupo = '$this->strGrupo' AND status = 1 ORDER BY idcarga DESC;";
			$request = $this->select($sql);

			return $request;
		}

		public function selectPermisivoFecha(int $profesorid, int $materiaid, int $carreraid, string $grupo){
			/*date_default_timezone_set('America/Mexico_city');
			$strUltimaModificacion = date('Y-m-d');*/
			$this->intDocenteId = $profesorid;
			$this->intMateriaId = $materiaid;
			$this->intCarreraId = $carreraid;
			$this->strGrupo = $grupo;
			
			$sql = "SELECT fecha_inicial, fecha_final FROM horarios WHERE profesorid = $this->intDocenteId AND materiaid = $this->intMateriaId AND carreraid = $this->intCarreraId AND grupo = '$this->strGrupo' AND status = 1;";
			$request = $this->select($sql);

			return $request;
		}

		public function selectBusquedaNivel(int $nivelid){
			$this->intNivelId = $nivelid;
			
			$sql = "SELECT idnivel, nivel FROM niveles WHERE idnivel = $this->intNivelId AND status = 1;";
			$request = $this->select($sql);

			return $request;
		}

		public function selectBusquedaCarrera(int $carreraid){
			$this->intCarreraId = $carreraid;
			
			$sql = "SELECT idcarrera, carrera FROM carreras WHERE idcarrera = $this->intCarreraId AND status = 1;";
			$request = $this->select($sql);

			return $request;
		}

		public function selectBusquedaDocente(int $idpersona){
			$this->intPersonaId = $idpersona;
			
			$sql = "SELECT idpersona, CONCAT(nombres,' ',apellidos) AS nombre_docente FROM persona WHERE idpersona = $this->intPersonaId AND status = 1;";
			$request = $this->select($sql);

			return $request;
		}

		public function selectBusquedaMateria(int $idmateria){
			$this->intMateriaId = $idmateria;
			
			$sql = "SELECT idmateria, materia FROM materias WHERE idmateria = $this->intMateriaId AND status = 1;";
			$request = $this->select($sql);

			return $request;
		}

	}

 ?>