<?php 

	class RespaldosModel extends Mysql
	{
		private $intIdRespaldo;
		private $intPersonaId;
		private $strFecha;
		private $strComentarios;
		private $strModificador;
		private $strUltimaModificacion;
		private $strTipoMovimiento;
		private $intStatus;

		public function __construct()
		{
			parent::__construct();
		}	

		public function insertRespaldo(string $personaid, string $fecha, string $comentarios, string $modificador, string $tipo_movimiento, int $status){
			$this->intPersonaId = $personaid;
			$this->strFecha = $fecha;
			$this->strComentarios = $comentarios;
			$this->strModificador = $modificador;    
			$this->strTipoMovimiento = $tipo_movimiento;
			$this->intStatus = $status;
			$return = 0;

			/*dep("Solicitante: ".$this->strSolicitante);
			dep("Descripción: ".$this->strDescripcion);
			dep("Fecha: ".$this->strFecha);
			dep("Comentarios: ".$this->strComentarios);
			dep("Estado: ".$this->strEstado);
			dep("Modificador: ".$this->strModificador);
			dep("Tipo Movimiento: ".$this->strTipoMovimiento);
			exit;*/

			$query_insert  = "INSERT INTO respaldos(usuarioid,fecha,comentarios,modificador,tipo_movimiento,status) 
								  VALUES(?,?,?,?,?,?)";
	        $arrData = array($this->intPersonaId,
        						$this->strFecha,
        						$this->strComentarios,
        						$this->strModificador,
        						$this->strTipoMovimiento,
        						$this->intStatus);
	        $request_insert = $this->insert($query_insert,$arrData);
	       	$return = $request_insert;
	        return $return;
		}

		public function updateRespaldo(int $idrespaldo, string $personaid, string $fecha, string $comentarios, string $modificador, string $tipo_movimiento, int $status){
			date_default_timezone_set('America/Mexico_city');
			$this->intIdRespaldo = $idrespaldo;
			$this->intPersonaId = $personaid;
			$this->strFecha = $fecha;
			$this->strComentarios = $comentarios;
			$this->strModificador = $modificador; 
			$this->strUltimaModificacion = date("Y-m-d H:i:s");    
			$this->strTipoMovimiento = $tipo_movimiento;
			$this->intStatus = $status;
			  
			$sql = "UPDATE respaldos SET  usuarioid = ?, fecha = ?, comentarios = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idrespaldo = $this->intIdRespaldo ";
			$arrData = array($this->intPersonaId,
        						$this->strFecha,
        						$this->strComentarios,
        						$this->strModificador,
        						$this->strUltimaModificacion,
        						$this->strTipoMovimiento,
        						$this->intStatus);
			$request = $this->update($sql,$arrData);
		    return $request;			
		}

		public function selectRespaldos()
		{
			$sql = "SELECT p.idpersona, CONCAT(p.nombres,' ',p.apellidos) AS nombre_persona, DATE_FORMAT(r.fecha, '%d-%m-%Y') AS fecha_format, r.*
					FROM respaldos r
					INNER JOIN persona p
					ON p.idpersona = r.usuarioid
					WHERE r.status != 0 ORDER BY r.fecha DESC";
					$request = $this->select_all($sql);
					return $request;
		}

		public function selectRespaldo(int $idrespaldo)
		{
			$this->intIdRespaldo = $idrespaldo;
			$sql = "SELECT p.idpersona, CONCAT(p.nombres,' ',p.apellidos) AS nombre_persona, DATE_FORMAT(r.fecha, '%d-%m-%Y') AS fecha_format, r.*
					FROM respaldos r
					INNER JOIN persona p
					ON p.idpersona = r.usuarioid
					WHERE idrespaldo = $this->intIdRespaldo";
			$request = $this->select($sql);
			return $request;
		}

		public function deleteRespaldo(int $idrespaldo, string $modificador)
		{
			$this->intIdRespaldo = $idrespaldo;		
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date("Y-m-d H:i:s");
			$this->strTipoMovimiento = 'Eliminación';
			$sql = "UPDATE respaldos SET modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idrespaldo = $this->intIdRespaldo ";
			$arrData = array($this->strModificador,
								$this->strUltimaModificacion,
								$this->strTipoMovimiento,
								0);
			$request = $this->update($sql,$arrData);
			return $request;
		}

		public function selectUsuarios()
		{
			$sql = "SELECT idpersona, CONCAT(nombres,' ',apellidos) AS nombre_persona FROM persona WHERE status != 0";
					$request = $this->select_all($sql);
					return $request;
		}

	}
 ?>