<?php 

	class SolicitudesModel extends Mysql
	{
		private $intIdSolicitud;
		private $strSolicitante;
		private $strDescripcion;
		private $strFecha;
		private $strComentarios;
		private $strEstado;
		private $strModificador;
		private $strUltimaModificacion;
		private $strTipoMovimiento;
		private $intStatus;

		public function __construct()
		{
			parent::__construct();
		}	

		public function insertSolicitud(string $solicitante, string $descripcion, string $fecha, string $comentarios, string $estado, string $modificador, string $tipo_movimiento){
			$this->strSolicitante = $solicitante;
			$this->strDescripcion = $descripcion;
			$this->strFecha = $fecha;
			$this->strComentarios = $comentarios;
			$this->strEstado = $estado;
			$this->strModificador = $modificador;    
			$this->strTipoMovimiento = $tipo_movimiento;
			$return = 0;

			/*dep("Solicitante: ".$this->strSolicitante);
			dep("Descripción: ".$this->strDescripcion);
			dep("Fecha: ".$this->strFecha);
			dep("Comentarios: ".$this->strComentarios);
			dep("Estado: ".$this->strEstado);
			dep("Modificador: ".$this->strModificador);
			dep("Tipo Movimiento: ".$this->strTipoMovimiento);
			exit;*/

			$query_insert  = "INSERT INTO solicitudes(solicitante,descripcion,fecha,comentarios,estado,modificador,tipo_movimiento) 
								  VALUES(?,?,?,?,?,?,?)";
	        $arrData = array($this->strSolicitante,
        						$this->strDescripcion,
        						$this->strFecha,
        						$this->strComentarios,
        						$this->strEstado,
        						$this->strModificador,
        						$this->strTipoMovimiento);
	        $request_insert = $this->insert($query_insert,$arrData);
	       	$return = $request_insert;
	        return $return;
		}

		public function updateSolicitud(int $idsolicitud, string $solicitante, string $descripcion, string $fecha, string $comentarios, string $estado, string $modificador, string $tipo_movimiento){
			date_default_timezone_set('America/Mexico_city');
			$this->intIdSolicitud = $idsolicitud;
			$this->strSolicitante = $solicitante;
			$this->strDescripcion = $descripcion;
			$this->strFecha = $fecha;
			$this->strComentarios = $comentarios;
			$this->strEstado = $estado;
			$this->strModificador = $modificador;  
			$this->strUltimaModificacion = date("Y-m-d H:i:s");   
			$this->strTipoMovimiento = $tipo_movimiento;
			
			$sql = "UPDATE solicitudes SET solicitante = ?, descripcion = ?, fecha = ?, comentarios = ?, estado = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ? WHERE idsolicitud = $this->intIdSolicitud ";
			$arrData = array($this->strSolicitante,
        						$this->strDescripcion,
        						$this->strFecha,
        						$this->strComentarios,
        						$this->strEstado,
        						$this->strModificador,
        						$this->strUltimaModificacion,
        						$this->strTipoMovimiento);
			$request = $this->update($sql,$arrData);
		    return $request;			
		}

		public function selectSolicitudes()
		{
			$whereAdmin = '';
			if($_SESSION['userData']['idrol'] != RADMINISTRADOR){
				$strSolicitante = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
				$whereAdmin = " AND solicitante='$strSolicitante'";
			}
			
			$sql = "SELECT *, DATE_FORMAT(fecha, '%d-%m-%Y') AS format_fecha FROM solicitudes WHERE status != 0 $whereAdmin ORDER BY fecha DESC;";
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectSolicitud(int $idsolicitud)
		{
			$this->intIdSolicitud = $idsolicitud;
			$sql = "SELECT * FROM solicitudes WHERE idsolicitud = $this->intIdSolicitud";
			$request = $this->select($sql);
			return $request;
		}

		public function deleteSolicitud(int $idsolicitud, string $modificador)
		{
			$this->intIdSolicitud = $idsolicitud;		
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date("Y-m-d H:i:s");
			$this->strTipoMovimiento = 'Eliminación';
			$sql = "UPDATE solicitudes SET modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idsolicitud = $this->intIdSolicitud ";
			$arrData = array($this->strModificador,
								$this->strUltimaModificacion,
								$this->strTipoMovimiento,
								0);
			$request = $this->update($sql,$arrData);
			return $request;
		}
	}
 ?>