<?php 

	class UsuariosModel extends Mysql
	{
		private $intIdUsuario;
		private $strIdentificador;
		private $strFoto;
		private $strNombre;
		private $strApellido;
		private $strEmail;
		private $strPassword;
		private $strToken;
		private $intTipoId;
		private $strDireccion;
		private $strTelefono;
		private $strModificador;
		private $strUltimaModificacion;
		private $strTipoMovimiento;
		private $intStatus;
		private $strCalle;
		private $strNumeroExterior;
		private $strNumeroInterior;
		private $strLocalidad;
		private $strTelefonoCelular;
		private $strTelefonoFijo;
		private $strEmpty;

		public function __construct()
		{
			parent::__construct();
		}	

		public function insertUsuario(string $identificador, string $foto, string $nombre, string $apellido, string $email, string $password, int $tipoid, string $direccion, string $telefono, string $modificador, string $tipo_movimiento, int $status){
            date_default_timezone_set('America/Mexico_City');
			$this->strIdentificador = $identificador;
			$this->strFoto = $foto;
			$this->strNombre = $nombre;
			$this->strApellido = $apellido;
			$this->strEmail = $email;
			$this->strPassword = $password;
			$this->intTipoId = $tipoid;
			$this->strDireccion = $direccion;
			$this->strTelefono = $telefono;
			$this->strModificador = $modificador;
			$this->strTipoMovimiento = $tipo_movimiento;
			$this->intStatus = $status;
			$return = 0;

			$sql = "SELECT * FROM persona WHERE 
					(email_user = '{$this->strEmail}' or identificador = '{$this->strIdentificador}') AND status != 0 ";
			$request = $this->select_all($sql);

			if(empty($request))
			{
				$query_insert  = "INSERT INTO persona(identificador,foto,nombres,apellidos,email_user,password,rolid,direccion,telefono,modificador,tipo_movimiento,status) 
								  VALUES(?,?,?,?,?,?,?,?,?,?,?,?)";
	        	$arrData = array($this->strIdentificador,
	        					$this->strFoto,
        						$this->strNombre,
        						$this->strApellido,
        						$this->strEmail,
        						$this->strPassword,
        						$this->intTipoId,
        						$this->strDireccion,
        						$this->strTelefono,
        						$this->strModificador,
        						$this->strTipoMovimiento,
        						$this->intStatus);
	        	$request_insert = $this->insert($query_insert,$arrData);
	        	$return = $request_insert;
	        	//Código para insertar la información del registro en la tabla Docentes
	        	if($this->intTipoId == RDOCENTE AND intval($request_insert) > 0)
	        	{
	        		$this->strEmpty = "";
		        	$queryUser  = "INSERT INTO docentes(identificador,foto,nombres,apellidos,email_user,password,rolid,sexo,estado_civil,fecha_nacimiento,rfc,curp,direccion,codigo_postal,ciudad,estado,pais,salario,telefono_celular,telefono_fijo,empresa,telefono_empresa,nombre_emergencia,relacion_emergencia,telefono_emergencia,tipo_sangre,puesto,departamento,nivelid,fecha_contratacion,tipo_docente,forma_pago,nivel_estudios,fecha_egreso,institucion,numero_cedula,campo_estudios,experiencia_docente,experiencia_profesional,experiencia_laboral,prioridad,necesidad_rh,fecha_entrevista_inicial,fecha_microenseñanza,fecha_entrevista_final,fecha_induccion,solicitud_empleo,cv,antecedentes_no_penales,certificado_medico,cartas_recomendacion,fotos,ine,cartilla_militar,e_curp,e_rfc,acta_nacimiento,comprobante_domicilio,certificaciones,titulo,cedula_profesional,curso_ebd,fecha_curso_ebd,otros_cursos,comentarios,modificador,tipo_movimiento,personaid,status) 
								  VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		        	$arrDataUser = array($this->strIdentificador,
		        						$this->strFoto,
										$this->strNombre,
										$this->strApellido,
										$this->strEmail,
										$this->strPassword,
										$this->intTipoId,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strDireccion,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										0.0,
										$this->strTelefono,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										1,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty, 
										$this->strEmpty, 
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty, 
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty, 
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strEmpty,
										$this->strModificador,
										$this->strTipoMovimiento,
										$request_insert,
										$this->intStatus);
		        	$requestInsertUser = $this->insert($queryUser,$arrDataUser);
		        }
			}else{
				$return = "exist";
			}
	        return $return;
		}

		public function selectUsuarios()
		{
			$whereAdmin = "";
			if($_SESSION['idUser'] != 1 ){
				$whereAdmin = " and p.idpersona != 1 ";
			}
			$sql = "SELECT p.idpersona,p.identificador,p.nombres,p.apellidos,p.email_user,p.status,p.ultimo_login,DATE_FORMAT(p.ultimo_login, '%d-%m-%Y %H:%i:%s') AS ultimo_login_format,r.idrol,r.nombre_rol
					FROM persona p 
					INNER JOIN rol r
					ON p.rolid = r.idrol
					WHERE p.status != 0 ".$whereAdmin;
					$request = $this->select_all($sql);
					return $request;
		}

		public function selectUsuario(int $idpersona){
			$this->intIdUsuario = $idpersona;
			$sql = "SELECT p.idpersona,p.identificador,p.foto,p.nombres,p.apellidos,p.email_user,r.idrol,r.nombre_rol,p.status, DATE_FORMAT(p.ultima_modificacion, '%d-%m-%Y %H:%i:%s') as fechaRegistro,p.direccion,p.telefono
					FROM persona p
					INNER JOIN rol r
					ON p.rolid = r.idrol
					WHERE p.idpersona = $this->intIdUsuario";
			$request = $this->select($sql);
			return $request;
		}

		public function updateUsuario(int $idUsuario, string $identificador, string $foto, string $nombre, string $apellido, string $email, string $password, int $tipoid, string $direccion, string $telefono, string $modificador, string $tipo_movimiento, int $status){
			date_default_timezone_set("America/Mexico_city");
			$this->intIdUsuario = $idUsuario;
			$this->strIdentificador = $identificador;
			$this->strFoto = $foto;
			$this->strNombre = $nombre;
			$this->strApellido = $apellido;
			$this->strEmail = $email;
			$this->strPassword = $password;
			$this->intTipoId = $tipoid;
			$this->strDireccion = $direccion;
			$this->strTelefono = $telefono;
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date('Y-m-d H:i:s');
			$this->strTipoMovimiento = $tipo_movimiento;
			$this->intStatus = $status;

			$sql = "SELECT * FROM persona WHERE ((email_user = '{$this->strEmail}' AND idpersona != $this->intIdUsuario)
										  OR (identificador = '{$this->strIdentificador}' AND idpersona != $this->intIdUsuario)) AND status != 0 ";
			$request = $this->select_all($sql);

			if(empty($request))
			{
				if($this->strPassword  != "")
				{
					$sql = "UPDATE persona SET identificador=?, foto=?, nombres=?, apellidos=?, email_user=?, password=?, rolid=?, direccion = ?, telefono = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status=? WHERE idpersona = $this->intIdUsuario ";
					$arrData = array($this->strIdentificador,
									$this->strFoto,
	        						$this->strNombre,
	        						$this->strApellido,
	        						$this->strEmail,
	        						$this->strPassword,
	        						$this->intTipoId,
	        						$this->strDireccion,
        							$this->strTelefono,
	        						$this->strModificador,
	        						$this->strUltimaModificacion,
	        						$this->strTipoMovimiento,
	        						$this->intStatus);

					$sqlUser = "UPDATE docentes SET identificador=?, foto=?, nombres=?, apellidos=?, email_user=?, password=?, rolid=?, direccion = ?, telefono_celular = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status=? WHERE personaid = '$this->intIdUsuario' ";
					$arrDataUser = array($this->strIdentificador,
									$this->strFoto,
	        						$this->strNombre,
	        						$this->strApellido,
	        						$this->strEmail,
	        						$this->strPassword,
	        						$this->intTipoId,
	        						$this->strDireccion,
        							$this->strTelefono,
	        						$this->strModificador,
	        						$this->strUltimaModificacion,
	        						$this->strTipoMovimiento,
	        						$this->intStatus);

					$sqlAlumno = "UPDATE alumnos SET matricula=?, foto=?, nombres=?, apellidos=?, email=?, password=?, telefono_celular = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status=? WHERE personaid = $this->intIdUsuario";
					$arrDataAlumno = array($this->strIdentificador,
									$this->strFoto,
	        						$this->strNombre,
	        						$this->strApellido,
	        						$this->strEmail,
	        						$this->strPassword,
        							$this->strTelefono,
	        						$this->strModificador,
	        						$this->strUltimaModificacion,
	        						$this->strTipoMovimiento,
	        						$this->intStatus);

				}else{
					$sql = "UPDATE persona SET identificador=?, foto=?, nombres=?, apellidos=?, email_user=?, rolid=?, direccion = ?, telefono = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idpersona = $this->intIdUsuario ";
					$arrData = array($this->strIdentificador,
									$this->strFoto,
	        						$this->strNombre,
	        						$this->strApellido,
	        						$this->strEmail,
	        						$this->intTipoId,
	        						$this->strDireccion,
        							$this->strTelefono,
	        						$this->strModificador,
	        						$this->strUltimaModificacion,
	        						$this->strTipoMovimiento,
	        						$this->intStatus);

					$sqlUser = "UPDATE docentes SET identificador=?, foto=?, nombres=?, apellidos=?, email_user=?, rolid=?, direccion = ?, telefono_celular = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE personaid = $this->intIdUsuario ";
					$arrDataUser = array($this->strIdentificador,
									$this->strFoto,
	        						$this->strNombre,
	        						$this->strApellido,
	        						$this->strEmail,
	        						$this->intTipoId,
	        						$this->strDireccion,
        							$this->strTelefono,
	        						$this->strModificador,
	        						$this->strUltimaModificacion,
	        						$this->strTipoMovimiento,
	        						$this->intStatus);

					$sqlAlumno = "UPDATE alumnos SET matricula=?, foto=?, nombres=?, apellidos=?, email=?, telefono_celular = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status=? WHERE personaid = $this->intIdUsuario";
					$arrDataAlumno = array($this->strIdentificador,
									$this->strFoto,
	        						$this->strNombre,
	        						$this->strApellido,
	        						$this->strEmail,
        							$this->strTelefono,
	        						$this->strModificador,
	        						$this->strUltimaModificacion,
	        						$this->strTipoMovimiento,
	        						$this->intStatus);

				}
				$request = $this->update($sql,$arrData);

				if($this->intTipoId == RDOCENTE AND intval($request) > 0)
	        	{
	        		$requestUser = $this->update($sqlUser,$arrDataUser);
	        	}
	        	if($this->intTipoId == RALUMNO AND intval($request) > 0)
	        	{
	        		$requestAlumno = $this->update($sqlAlumno,$arrDataAlumno);
	        	}

			}else{
				$request = "exist";
			}
			return $request;
		
		}

		public function deleteUsuario(int $idpersona, string $modificador, int $rolid)
		{
			$this->intIdUsuario = $idpersona;	
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date("Y-m-d H:i:s");
			$this->strTipoMovimiento = 'Eliminación';
			$this->intTipoId = $rolid;	
	
			$sql = "UPDATE persona SET modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE idpersona = $this->intIdUsuario ";
			$arrData = array($this->strModificador,
	        					$this->strUltimaModificacion,
	        					$this->strTipoMovimiento,
								0);
			$request = $this->update($sql,$arrData);
		
			if(intval($request) > 0 AND $this->intTipoId == RDOCENTE)
			{
				$requestDocumentacion = $this->selectDocumentacion($this->intIdUsuario);
				$anteriorSolicitudEmpleo = $requestDocumentacion['solicitud_empleo'];
				$anteriorCurriculum = $requestDocumentacion['cv'];
				$anteriorAntecedentesPenales = $requestDocumentacion['antecedentes_no_penales'];
				$anteriorCertficadoMedico = $requestDocumentacion['certificado_medico'];
				$anteriorCartasRecomendacion = $requestDocumentacion['cartas_recomendacion'];
				$anteriorFotos = $requestDocumentacion['fotos'];
				$anteriorIne = $requestDocumentacion['ine'];
				$anteriorCartillaMilitar = $requestDocumentacion['cartilla_militar'];
				$anteriorCurp = $requestDocumentacion['e_curp'];
				$anteriorRfc = $requestDocumentacion['e_rfc'];
				$anteriorActaNacimiento = $requestDocumentacion['acta_nacimiento'];
				$anteriorComprobanteDomicilio = $requestDocumentacion['comprobante_domicilio'];
				$anteriorCertificaciones = $requestDocumentacion['certificaciones'];
				$anteriorTitulo = $requestDocumentacion['titulo'];
				$anteriorCedulaProfesional = $requestDocumentacion['cedula_profesional'];		
				
				$sqlDelete = "UPDATE docentes SET modificador = ?, ultima_modificacion = ?, tipo_movimiento = ?, status = ? WHERE personaid = $this->intIdUsuario ";
				$arrDataDelete = array($this->strModificador,
		        					$this->strUltimaModificacion,
		        					$this->strTipoMovimiento,
									0);
				$requestDelete = $this->update($sqlDelete,$arrDataDelete);

				if(intval($requestDelete) > 0)
				{
					if($anteriorSolicitudEmpleo != ''){
						if(is_dir('Assets/documentacion/solicitudes_empleo')){
							deleteDocumentacion($anteriorSolicitudEmpleo,"solicitudes_empleo");
						}
					}
					if($anteriorCurriculum != ''){
						if(is_dir('Assets/documentacion/curriculums')){
							deleteDocumentacion($anteriorCurriculum,"curriculums");
						}
					}			
					if($anteriorAntecedentesPenales != ''){
						if(is_dir('Assets/documentacion/antecedentes_no_penales')){
							deleteDocumentacion($anteriorAntecedentesPenales,"antecedentes_no_penales");
						}
					}
								
					if($anteriorCertficadoMedico != ''){
						if(is_dir('Assets/documentacion/certificados_medicos')){
							deleteDocumentacion($anteriorCertficadoMedico,"certificados_medicos");
						}
					}				
					if($anteriorCartasRecomendacion != ''){
						if(is_dir('Assets/documentacion/cartas_recomendacion')){
							deleteDocumentacion($anteriorCartasRecomendacion,"cartas_recomendacion");
						}
					}				
					if($anteriorFotos != ''){
						if(is_dir('Assets/documentacion/fotos')){
							deleteDocumentacion($anteriorFotos,"fotos");
						}
					}				
					if($anteriorIne != ''){
						if(is_dir('Assets/documentacion/ines')){
							deleteDocumentacion($anteriorIne,"ines");
						}
					}				
					if($anteriorCartillaMilitar != ''){
						if(is_dir('Assets/documentacion/cartillas_militares')){
							deleteDocumentacion($anteriorCartillaMilitar,"cartillas_militares");
						}
					}				
					if($anteriorCurp != ''){
						if(is_dir('Assets/documentacion/curps')){
							deleteDocumentacion($anteriorCurp,"curps");
						}
					}				
					if($anteriorRfc != ''){
						if(is_dir('Assets/documentacion/rfcs')){
							deleteDocumentacion($anteriorRfc,"rfcs");
						}
					}				
					if($anteriorActaNacimiento != ''){
						if(is_dir('Assets/documentacion/actas_nacimiento')){
							deleteDocumentacion($anteriorActaNacimiento,"actas_nacimiento");
						}
					}				
					if($anteriorComprobanteDomicilio != ''){
						if(is_dir('Assets/documentacion/comprobantes_domicilio')){
							deleteDocumentacion($anteriorComprobanteDomicilio,"comprobantes_domicilio");
						}
					}				
					if($anteriorCertificaciones != ''){
						if(is_dir('Assets/documentacion/certificaciones')){
							deleteDocumentacion($anteriorCertificaciones,"certificaciones");
						}
					}				
					if($anteriorTitulo != ''){
						if(is_dir('Assets/documentacion/titulos')){
							deleteDocumentacion($anteriorTitulo,"titulos");
						}
					}				
					if($anteriorCedulaProfesional != ''){
						if(is_dir('Assets/documentacion/cedulas')){
							deleteDocumentacion($anteriorCedulaProfesional,"cedulas");
						}
					}	
				}
			} 
			return $request;
		}

		public function updatePerfil(int $idUsuario, string $foto, string $nombre, string $apellido, string $email, string $password, string $direccion, string $telefono, string $modificador, string $tipo_movimiento){
			$this->intIdUsuario = $idUsuario;
			$this->strFoto = $foto;
			$this->strNombre = $nombre;
			$this->strApellido = $apellido;
			$this->strEmail = $email;
			$this->strPassword = $password;
			$this->strDireccion = $direccion;
			$this->strTelefono = $telefono;
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date('Y-m-d H:i:s');
			$this->strTipoMovimiento = $tipo_movimiento;
			$requestRol = $this->selectRol($this->intIdUsuario);
			$this->intTipoId = $requestRol['rolid'];

			/*dep($this->intIdUsuario);
			dep($this->strFoto);
			dep($this->strNombre);
			dep($this->strApellido);
			dep($this->strEmail);
			dep($this->strPassword);
			dep($this->strDireccion);
			dep($this->strTelefono);
			dep($this->strModificador);
			exit;*/

			if($this->strPassword != "")
			{
				$sql = "UPDATE persona SET foto = ?, nombres = ?, apellidos = ?, email_user = ?, password = ?, direccion = ?, telefono = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ? WHERE idpersona = $this->intIdUsuario ";
				$arrData = array($this->strFoto,
								$this->strNombre,
								$this->strApellido,
								$this->strEmail,
								$this->strPassword,
								$this->strDireccion,
								$this->strTelefono,
								$this->strModificador,
	        					$this->strUltimaModificacion,
	        					$this->strTipoMovimiento);
				$request = $this->update($sql,$arrData);

				if(intval($request) > 0 && $this->intTipoId == RDOCENTE)
				{
					$sqlUpdate = "UPDATE docentes SET foto = ?, nombres = ?, apellidos = ?, email_user = ?, password = ?, direccion = ?, telefono_celular = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ? WHERE personaid = $this->intIdUsuario ";
					$arrDataUpdate = array($this->strFoto,
								$this->strNombre,
								$this->strApellido,
								$this->strEmail,
								$this->strPassword,
								$this->strDireccion,
								$this->strTelefono,
								$this->strModificador,
	        					$this->strUltimaModificacion,
	        					$this->strTipoMovimiento);
					$requestUpdate = $this->update($sqlUpdate,$arrDataUpdate);
				}
			}else{
				$sql = "UPDATE persona SET foto= ?, nombres = ?, apellidos = ?, email_user = ?, direccion = ?, telefono = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ? WHERE idpersona = $this->intIdUsuario ";
				
				$arrData = array($this->strFoto,
								$this->strNombre,
								$this->strApellido,
								$this->strEmail,
								$this->strDireccion,
								$this->strTelefono,
								$this->strModificador,
	        					$this->strUltimaModificacion,
	        					$this->strTipoMovimiento);
				$request = $this->update($sql,$arrData);

				if(intval($request) > 0 && $this->intTipoId == 18)
				{
					$sqlUpdate = "UPDATE docentes SET nombres = ?, apellidos = ?, email_user = ?, direccion = ?, telefono_celular = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ? WHERE personaid = $this->intIdUsuario ";
					$arrDataUpdate = array($this->strNombre,
								$this->strApellido,
								$this->strEmail,
								$this->strDireccion,
								$this->strTelefono,
								$this->strModificador,
	        					$this->strUltimaModificacion,
	        					$this->strTipoMovimiento);
					$requestUpdate = $this->update($sqlUpdate,$arrDataUpdate);
				}
			}
		    return $request;
		}

		public function updatePerfilAlumno(int $idUsuario, string $foto, string $nombre, string $apellido, string $password, string $telefono_celular, string $telefono_fijo, string $email, string $calle, string $numero_exterior, string $numero_interior, string $localidad, string $modificador, string $tipo_movimiento){
			$this->intIdUsuario = $idUsuario;
			$this->strFoto = $foto;
			$this->strNombre = $nombre;
			$this->strApellido = $apellido;
			$this->strPassword = $password;
			$this->strTelefonoCelular = $telefono_celular;
			$this->strTelefonoFijo = $telefono_fijo;
			$this->strEmail = $email;
			$this->strCalle = $calle;
			$this->strNumeroExterior = $numero_exterior;
			$this->strNumeroInterior = $numero_interior;
			$this->strLocalidad = $localidad;
			$this->strModificador = $modificador;
			$this->strUltimaModificacion = date('Y-m-d H:i:s');
			$this->strTipoMovimiento = $tipo_movimiento;
			$requestRol = $this->selectRol($this->intIdUsuario);
			$this->intTipoId = $requestRol['rolid'];

			if($this->strPassword != "")
			{
				$sql = "UPDATE persona SET foto = ?,nombres = ?, apellidos = ?, email_user = ?, password = ?, telefono = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ? WHERE idpersona = $this->intIdUsuario ";
				$arrData = array($this->strFoto,
								$this->strNombre,
								$this->strApellido,
								$this->strEmail,
								$this->strPassword,
								$this->strTelefonoCelular,
								$this->strModificador,
	        					$this->strUltimaModificacion,
	        					$this->strTipoMovimiento);
				$request = $this->update($sql,$arrData);
				
				if(intval($request) > 0)
				{
					$sqlUpdate = "UPDATE alumnos SET foto = ?, nombres = ?, apellidos = ?, password = ?, telefono_celular = ?, telefono_fijo = ?, email = ?, calle = ?, numero_exterior = ?, numero_interior = ?, localidad = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ? WHERE personaid = $this->intIdUsuario ";
					$arrDataUpdate = array($this->strFoto,
								$this->strNombre,
								$this->strApellido,
								$this->strPassword,
								$this->strTelefonoCelular,
								$this->strTelefonoFijo,
								$this->strEmail,
								$this->strCalle,
								$this->strNumeroExterior,
								$this->strNumeroInterior,
								$this->strLocalidad,
								$this->strModificador,
	        					$this->strUltimaModificacion,
	        					$this->strTipoMovimiento);
					$requestUpdate = $this->update($sqlUpdate,$arrDataUpdate);
				}

			}else{
				$sql = "UPDATE persona SET foto = ?,nombres = ?, apellidos = ?, email_user = ?, telefono = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ? WHERE idpersona = $this->intIdUsuario ";
				$arrData = array($this->strFoto,
								$this->strNombre,
								$this->strApellido,
								$this->strEmail,
								$this->strTelefonoCelular,
								$this->strModificador,
	        					$this->strUltimaModificacion,
	        					$this->strTipoMovimiento);
				$request = $this->update($sql,$arrData);

				if(intval($request) > 0)
				{
					$sqlUpdate = "UPDATE alumnos SET foto = ?, nombres = ?, apellidos = ?, telefono_celular = ?, telefono_fijo = ?, email = ?,calle = ?, numero_exterior = ?, numero_interior = ?, localidad = ?, modificador = ?, ultima_modificacion = ?, tipo_movimiento = ? WHERE personaid = $this->intIdUsuario ";
					$arrDataUpdate = array($this->strFoto,
								$this->strNombre,
								$this->strApellido,
								$this->strTelefonoCelular,
								$this->strTelefonoFijo,
								$this->strEmail,
								$this->strCalle,
								$this->strNumeroExterior,
								$this->strNumeroInterior,
								$this->strLocalidad,
								$this->strModificador,
	        					$this->strUltimaModificacion,
	        					$this->strTipoMovimiento);
					$requestUpdate = $this->update($sqlUpdate,$arrDataUpdate);
				}
			}
			$request = $this->update($sql,$arrData);
		    return $request;
		}

		public function selectDepartamentos()
		{
			$sql = "SELECT * FROM departamentos WHERE  status != 0"; 
			$request = $this->select_all($sql);
			return $request;
		}

		public function selectRol($idpersona)
		{
			$this->intIdUsuario = $idpersona;
			$sql = "SELECT rolid FROM persona WHERE idpersona = $this->intIdUsuario "; 
			$request = $this->select($sql);
			return $request;
		}

		public function selectDocumentacion($personaid)
		{
			$this->intIdUsuario = $personaid;
			$sql = "SELECT solicitud_empleo,cv,antecedentes_no_penales,certificado_medico,cartas_recomendacion,fotos,ine,cartilla_militar,e_curp,e_rfc,acta_nacimiento,comprobante_domicilio,certificaciones,titulo,cedula_profesional FROM docentes WHERE personaid = $this->intIdUsuario "; 
			$request = $this->select($sql);
			return $request;
		}

		public function buscarFoto(int $personaid)
		{
			$this->intIdPersona = $personaid;
			$sql = "SELECT foto FROM persona WHERE idpersona = $this->intIdPersona";
			$request = $this->select($sql);
			return $request;
		}

		public function selectAlumno(int $idpersona){
			$this->intIdUsuario = $idpersona;
			$sql = "SELECT idalumno,matricula,nombres,apellidos,email,foto,telefono_celular,telefono_fijo,calle,numero_exterior,numero_interior,localidad,curp FROM alumnos WHERE personaid = $this->intIdUsuario";
			$request = $this->select($sql);
			return $request;
		}

		public function selectAdeudosAlumno(int $idpersona){
			$this->intIdUsuario = $idpersona;
			$sql = "SELECT *, DATE_FORMAT(ultima_modificacion, '%d-%m-%Y %H:%i:%s') AS ultima_modificacion_format FROM adeudos WHERE alumnoid = $this->intIdUsuario AND status != 0";
			$request = $this->select($sql);
			return $request;
		}

		public function selectRoles()
		{
			$whereAdmin = "";
			
			if($_SESSION['userData']['idrol'] != 1){
				$whereAdmin = " and idrol != 1 ORDER BY idrol ASC";
			}
			//EXTRAE ROLES
			$sql = "SELECT * FROM rol WHERE idrol!=".RALUMNO." AND status != 0".$whereAdmin;
			$request = $this->select_all($sql);
			return $request;
		}

		public function sessionLogin(int $iduser){
			$this->intIdUsuario = $iduser;
			//BUSCAR ROL
			$sql = "SELECT p.idpersona,
							p.identificador,
							p.foto,
							p.nombres,
							p.apellidos,
							p.email_user,
							r.idrol,r.nombre_rol,
							p.direccion,
							p.telefono,
							p.status 
					FROM persona p
					INNER JOIN rol r
					ON p.rolid = r.idrol
					WHERE p.idpersona = $this->intIdUsuario";
			$request = $this->select($sql);
			$_SESSION['userData'] = $request;
			return $request;
		}

	}

 ?>