<?php 
    headerAdmin($data); 
    getModal('modalAsistencias',$data);
?>
<main class="app-content">   
    <div class="app-title">
        <div>
            <h1><i class="fas fa-user-tag"></i> <?= $data['page_title'] ?>
                <?php if($_SESSION['permisosMod']['w']){ ?>
                <!--<button class="btn btn-primary" type="button" onclick="openModal();" ><i class="fas fa-plus-circle"></i> Nueva Materia</button>-->
              <?php } ?>
            </h1>
        </div>
        <ul class="app-breadcrumb breadcrumb">
          <li class="breadcrumb-item"><i class="fa fa-home fa-lg"></i></li>
          <li class="breadcrumb-item"><a href="<?= base_url(); ?>/asistencias"><?= $data['page_title'] ?></a></li>
        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
          <div class="tile">
            <div class="tile-body">
              <div class="table-responsive">
                <table class="table table-hover table-bordered" id="tableAsistencias">
                  <thead>
                    <tr>
                      <th hidden>ID</th>
                      <th>Nivel</th>
                      <th>Grupo</th>
                      <th>Materia</th>
                      <th>Docente</th>
                      <th>Acciones</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
    </div>
</main>
<?php footerAdmin($data); ?>
    

    <!--
          <style>
        .sidebar {
            min-height: 100vh;
            background-color: #2c3e50;
        }
        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.8);
        }
        .sidebar .nav-link:hover {
            color: white;
            background-color: #34495e;
        }
        .sidebar .nav-link.active {
            color: white;
            background-color: #18bc9c;
        }
        .header {
            background-color: #18bc9c;
            color: white;
        }
        .card {
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .table-responsive {
            max-height: 500px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
           
            <div class="col-md-3 col-lg-2 d-md-block sidebar collapse bg-dark">
                <div class="position-sticky pt-3">
                    <div class="text-center mb-4">
                        <img src="https://via.placeholder.com/80" alt="Logo Escuela" class="rounded-circle">
                        <h5 class="mt-2 text-white">Escuela Ejemplo</h5>
                    </div>
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link active" href="#">
                                <i class="bi bi-clipboard-check me-2"></i>Asistencias
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#">
                                <i class="bi bi-people me-2"></i>Estudiantes
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#">
                                <i class="bi bi-book me-2"></i>Clases
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#">
                                <i class="bi bi-graph-up me-2"></i>Reportes
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#">
                                <i class="bi bi-gear me-2"></i>Configuración
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

           
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">
                        <i class="bi bi-clipboard-check"></i> Registro de Asistencias
                    </h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="btn-group me-2">
                            <button type="button" class="btn btn-sm btn-outline-secondary">
                                <i class="bi bi-printer"></i> Imprimir
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-secondary">
                                <i class="bi bi-download"></i> Exportar
                            </button>
                        </div>
                        <button type="button" class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#nuevaAsistenciaModal">
                            <i class="bi bi-plus-circle"></i> Nueva Asistencia
                        </button>
                    </div>
                </div>

                
                <div class="card mb-4">
                    <div class="card-header bg-light">
                        <i class="bi bi-funnel"></i> Filtros
                    </div>
                    <div class="card-body">
                        <form>
                            <div class="row">
                                <div class="col-md-3">
                                    <label for="fecha" class="form-label">Fecha</label>
                                    <input type="date" class="form-control" id="fecha">
                                </div>
                                <div class="col-md-3">
                                    <label for="grado" class="form-label">Grado</label>
                                    <select class="form-select" id="grado">
                                        <option selected>Todos</option>
                                        <option>1° Primaria</option>
                                        <option>2° Primaria</option>
                                        <option>3° Primaria</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label for="grupo" class="form-label">Grupo</label>
                                    <select class="form-select" id="grupo">
                                        <option selected>Todos</option>
                                        <option>A</option>
                                        <option>B</option>
                                        <option>C</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label for="materia" class="form-label">Materia</label>
                                    <select class="form-select" id="materia">
                                        <option selected>Todas</option>
                                        <option>Matemáticas</option>
                                        <option>Español</option>
                                        <option>Ciencias</option>
                                    </select>
                                </div>
                            </div>
                            <div class="mt-3 text-end">
                                <button type="button" class="btn btn-secondary me-2">
                                    <i class="bi bi-arrow-counterclockwise"></i> Limpiar
                                </button>
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-search"></i> Buscar
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                
                <div class="card">
                    <div class="card-header bg-light d-flex justify-content-between align-items-center">
                        <span><i class="bi bi-table"></i> Listado de Asistencias</span>
                        <span class="badge bg-primary">Total: 125 registros</span>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover table-striped">
                                <thead class="table-dark">
                                    <tr>
                                        <th>#</th>
                                        <th>Fecha</th>
                                        <th>Estudiante</th>
                                        <th>Grado</th>
                                        <th>Grupo</th>
                                        <th>Materia</th>
                                        <th>Asistencia</th>
                                        <th>Justificación</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1</td>
                                        <td>15/05/2023</td>
                                        <td>Juan Pérez López</td>
                                        <td>5° Primaria</td>
                                        <td>A</td>
                                        <td>Matemáticas</td>
                                        <td><span class="badge bg-success">Presente</span></td>
                                        <td>-</td>
                                        <td>
                                            <button class="btn btn-sm btn-outline-primary"><i class="bi bi-pencil"></i></button>
                                            <button class="btn btn-sm btn-outline-danger"><i class="bi bi-trash"></i></button>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>2</td>
                                        <td>15/05/2023</td>
                                        <td>María García Sánchez</td>
                                        <td>5° Primaria</td>
                                        <td>A</td>
                                        <td>Matemáticas</td>
                                        <td><span class="badge bg-warning text-dark">Tardanza</span></td>
                                        <td>Tráfico</td>
                                        <td>
                                            <button class="btn btn-sm btn-outline-primary"><i class="bi bi-pencil"></i></button>
                                            <button class="btn btn-sm btn-outline-danger"><i class="bi bi-trash"></i></button>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>3</td>
                                        <td>15/05/2023</td>
                                        <td>Carlos Ruiz Méndez</td>
                                        <td>5° Primaria</td>
                                        <td>A</td>
                                        <td>Matemáticas</td>
                                        <td><span class="badge bg-danger">Ausente</span></td>
                                        <td>Enfermedad</td>
                                        <td>
                                            <button class="btn btn-sm btn-outline-primary"><i class="bi bi-pencil"></i></button>
                                            <button class="btn btn-sm btn-outline-danger"><i class="bi bi-trash"></i></button>
                                        </td>
                                    </tr>
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card-footer bg-light">
                        <nav aria-label="Page navigation">
                            <ul class="pagination justify-content-center mb-0">
                                <li class="page-item disabled">
                                    <a class="page-link" href="#" tabindex="-1">Anterior</a>
                                </li>
                                <li class="page-item active"><a class="page-link" href="#">1</a></li>
                                <li class="page-item"><a class="page-link" href="#">2</a></li>
                                <li class="page-item"><a class="page-link" href="#">3</a></li>
                                <li class="page-item">
                                    <a class="page-link" href="#">Siguiente</a>
                                </li>
                            </ul>
                        </nav>
                    </div>
                </div>
            </main>
        </div>
    </div>

    
    <div class="modal fade" id="nuevaAsistenciaModal" tabindex="-1" aria-labelledby="nuevaAsistenciaModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="nuevaAsistenciaModalLabel"><i class="bi bi-plus-circle"></i> Registrar Asistencia</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="modalFecha" class="form-label">Fecha</label>
                                <input type="date" class="form-control" id="modalFecha" required>
                            </div>
                            <div class="col-md-6">
                                <label for="modalMateria" class="form-label">Materia</label>
                                <select class="form-select" id="modalMateria" required>
                                    <option value="" selected disabled>Seleccione una materia</option>
                                    <option>Matemáticas</option>
                                    <option>Español</option>
                                    <option>Ciencias</option>
                                    <option>Historia</option>
                                </select>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <label for="modalGrado" class="form-label">Grado</label>
                                <select class="form-select" id="modalGrado" required>
                                    <option value="" selected disabled>Seleccione un grado</option>
                                    <option>1° Primaria</option>
                                    <option>2° Primaria</option>
                                    <option>3° Primaria</option>
                                    <option>4° Primaria</option>
                                    <option>5° Primaria</option>
                                    <option>6° Primaria</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="modalGrupo" class="form-label">Grupo</label>
                                <select class="form-select" id="modalGrupo" required>
                                    <option value="" selected disabled>Seleccione un grupo</option>
                                    <option>A</option>
                                    <option>B</option>
                                    <option>C</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="modalPeriodo" class="form-label">Periodo</label>
                                <select class="form-select" id="modalPeriodo" required>
                                    <option value="" selected disabled>Seleccione un periodo</option>
                                    <option>Matutino</option>
                                    <option>Vespertino</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Lista de Estudiantes</label>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead class="table-light">
                                        <tr>
                                            <th>#</th>
                                            <th>Estudiante</th>
                                            <th>Asistencia</th>
                                            <th>Justificación</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>1</td>
                                            <td>Juan Pérez López</td>
                                            <td>
                                                <select class="form-select form-select-sm">
                                                    <option value="presente" selected>Presente</option>
                                                    <option value="tardanza">Tardanza</option>
                                                    <option value="ausente">Ausente</option>
                                                </select>
                                            </td>
                                            <td>
                                                <input type="text" class="form-control form-control-sm" placeholder="Motivo (opcional)">
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>2</td>
                                            <td>María García Sánchez</td>
                                            <td>
                                                <select class="form-select form-select-sm">
                                                    <option value="presente">Presente</option>
                                                    <option value="tardanza" selected>Tardanza</option>
                                                    <option value="ausente">Ausente</option>
                                                </select>
                                            </td>
                                            <td>
                                                <input type="text" class="form-control form-control-sm" placeholder="Motivo (opcional)" value="Tráfico">
                                            </td>
                                        </tr>
                                      
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-primary">Guardar Asistencia</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>-->