<?php headerAdmin($data); 
    getModal('dashboardModals/modalUsuarios',$data);
    /*dep($data['distribucionGenero']);
    dep($data['distribucionNiveles']);*/
?>
    <main class="app-content">
      <div class="app-title">
        <div>
          <h1><i class="fa fa-dashboard"></i><?= $data['page_title'] ?></h1>
        </div>
        <ul class="app-breadcrumb breadcrumb">
          <li class="breadcrumb-item"><i class="fa fa-home fa-lg"></i></li>
          <li class="breadcrumb-item"><a href="<?= base_url(); ?>/dashboard">Dashboard</a></li>
        </ul>
      </div>

      <div class="row justify-content-center">
        <div class="col-md-3">
          <div class="widget-small danger"><i class="icon fa fa-user-circle fa-3x"></i>
            <div class="info">
              <h4 style="padding: 6px;">Usuarios</h4>
              <div class=""><p><strong> <?php echo number_format(count($data['usuarios'])) ?></strong></p></div>
              <button class="btn btn-danger btn-sm botwidguet__blue" onClick="fntViewUsuariosDashboard()" title="Ver mas " style="padding: 8px;"> Ver mas <i class="far fa-eye"></i></button>
            </div> 
          </div>
        </div>
        <div class="col-md-3">
          <div class="widget-small danger"><i class="icon fa fa-users fa-3x"></i>
            <div class="info">
              <h4 style="padding: 6px;">Alumnos</h4>
              <div class=""><p><strong> <?php echo number_format(count($data['alumnos'])) ?></strong></p></div>
               <button class="btn btn-danger btn-sm botwidguet__blue" onClick="fntViewAlumnosDashboard()" title="Ver mas " style="padding: 8px;"> Ver mas <i class="far fa-eye"></i></button>
            </div> 
          </div>
        </div> 
        <div class="col-md-3">
           <div class="widget-small danger"><i class="icon fa fa-user-o fa-3x"></i>
            <div class="info">
              <h4 style="padding: 6px;">Docentes</h4>
              <div class=""><p><strong> <?php echo number_format(count($data['docentes'])) ?></strong></p></div>
               <button class="btn btn-danger btn-sm botwidguet__blue" onClick="fntViewProfesoresDashboard()" title="Ver mas " style="padding: 8px;"> Ver mas <i class="far fa-eye"></i></button>
            </div> 
          </div>
        </div> 
        <div class="col-md-3">
          <div class="widget-small danger"><i class="icon fa fa-male fa-3x"></i>
            <div class="info">
              <h4 style="padding: 6px;">Niveles Educ</h4>
              <div class=""><p><strong> <?php echo number_format(count($data['niveles'])) ?></strong></p></div>
               <button class="btn btn-danger btn-sm botwidguet__blue" onClick="fntViewNivelesDashboard()" title="Ver mas " style="padding: 8px;"> Ver mas <i class="far fa-eye"></i></button>
            </div> 
          </div>
        </div> 
      </div>

      <div class="row justify-content-center">
        <div class="col-md-3">
          <div class="widget-small danger"><i class="icon fa fa-user-circle fa-3x"></i>
            <div class="info">
              <h4 style="padding: 6px;">Carreras</h4>
              <div class=""><p><strong> <?php echo number_format(count($data['carreras'])) ?></strong></p></div>
              <button class="btn btn-danger btn-sm botwidguet__blue" onClick="fntViewCarrerasDashboard()" title="Ver mas " style="padding: 8px;"> Ver mas <i class="far fa-eye"></i></button>
            </div> 
          </div>
        </div>
        <div class="col-md-3">
          <div class="widget-small danger"><i class="icon fa fa-phone fa-3x"></i>
            <div class="info">
              <h4 style="padding: 6px;">Directorio</h4>
              <div class=""><p><strong> <?php echo number_format(count($data['extensiones'])) ?></strong></p></div>
               <button class="btn btn-danger btn-sm botwidguet__blue" onClick="fntViewExtensionesDashboard()" title="Ver mas " style="padding: 8px;"> Ver mas <i class="far fa-eye"></i></button>
            </div> 
          </div>
        </div>  
      </div>

      <div class="row">
        <div class="col-md-6">
          <div class="tile">
            <h3 class="tile-title"><i class="icon fa fa-calendar fa-1x"></i> Proximos Eventos</h3>
            <table class="table table-striped table-sm">
              <thead>
                <tr>
                  <th>#</th>
                  <th>Evento</th>
                  <th>Del</th>
                  <th>Al</th>
                  <th>Nivel</th>
                </tr>
              </thead>
              <tbody>
                <?php 
                    $cont = 0;
                    if(count($data['lastEvents']) > 0 ){
                      foreach ($data['lastEvents'] as $evento) {
                        $cont++;
                 ?>
                <tr>
                  <td><?= $cont ?></td>
                  <td><?= $evento['evento'] ?></td>
                  <td><?= $evento['fecha_inicial_format'] ?></td>
                  <td><?= $evento['fecha_final_format'] ?></td>
                  <td><?= $evento['nivel'] ?></td>
                </tr>
                <?php }
                } ?>
              </tbody>
            </table>
          </div>
        </div>
        <div class="col-md-6">
          <div class="tile">
            <h3 class="tile-title"><i class="icon fa fa-birthday-cake fa-1x"></i> Proximos Cumpleaños </h3>
            <table class="table table-striped table-sm">
              <thead>
                <tr>
                  <th>#</th>
                  <th>Matricula</th>
                  <th>Alumno</th>
                  <th>Fecha</th>
                  <th></th>
                </tr>
              </thead>
              <tbody>
                <?php 
                    $cont = 0;
                    if(count($data['lastBirthdays']) > 0 ){
                      foreach ($data['lastBirthdays'] as $birthday) {
                        $cont++;
                 ?>
                <tr>
                  <td><?= $cont ?></td>
                  <td><?= $birthday['matricula'] ?></td>
                  <td><?= $birthday['nombre_alumno'] ?></td>
                  <td><?= $birthday['fecha_format'] ?></td>
                  <td><i class="icon fa fa-birthday-cake fa-1x"></td>
                </tr>
                <?php }
                } ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-md-12">
          <div class="tile">
            <div class="container-title">
              <h3 class="tile-title">Distribución Alumnos Genero</h3>
            </div>
            <div id="distribucionGenero"></div>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-md-12">
          <div class="tile">
            <div class="container-title">
              <h3 class="tile-title">Escuelas Procedencia</h3>
            </div>
            <div id="distribucionEscuelas"></div>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-md-12">
          <div class="tile">
            <div class="container-title">
              <h3 class="tile-title">Escuelas Procedencia</h3>
            </div>
            <div id="distribucionEscuelasBarras"></div>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-md-12">
          <div class="tile">
            <div class="container-title">
              <h3 class="tile-title">Colonias</h3>
            </div>
            <div id="distribucionColonias"></div>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-md-12">
          <div class="tile">
            <div class="container-title">
              <h3 class="tile-title">Colonias</h3>
            </div>
            <div id="distribucionColoniasBarras"></div>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-md-12">
          <div class="tile">
            <div class="container-title">
              <h3 class="tile-title">Distribución Alumnos Becados</h3>
            </div>
            <div id="distribucionBecados"></div>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-md-12">
          <div class="tile">
            <div class="container-title">
              <h3 class="tile-title">Distribución Medios de Promoción</h3>
            </div>
            <div id="distribucionMedioPromocion"></div>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-md-12">
          <div class="tile">
            <div class="container-title">
              <h3 class="tile-title">Distribución País Nacimiento</h3>
            </div>
            <div id="distribucionPaisNacimiento"></div>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-md-12">
          <div class="tile">
            <div class="container-title">
              <h3 class="tile-title">Distribución Tipo Beca</h3>
            </div>
            <div id="distribucionTipoBeca"></div>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-md-12">
          <div class="tile">
            <div class="container-title">
              <h3 class="tile-title">Distribución Niveles</h3>
            </div>
            <div id="distribucionNiveles"></div>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-md-12">
          <div class="tile">
            <div class="tile-body"></div>
            <img src="<?= media(); ?>/images/bannerBienvenidaSIE.jpg" alt="UAF" style="height: 520px; min-width: 1205px;">
          </div>
        </div>
      </div>
    </main>

<?php footerAdmin($data); ?>

<script>

  Highcharts.chart('distribucionBecados', {
      chart: {
          plotBackgroundColor: null,
          plotBorderWidth: null,
          plotShadow: false,
          type: 'pie'
      },
      title: {
          text: 'Distribución de Alumnos, Becas'
      },
      subtitle: {
        text: 'Universidad Autónoma de Fresnillo'
      },
      tooltip: {
          pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
      },
      accessibility: {
          point: {
              valueSuffix: '%'
          }
      },
      plotOptions: {
          pie: {
              allowPointSelect: true,
              cursor: 'pointer',
              dataLabels: {
                  enabled: true,
                  format: '<b>{point.name}</b>: {point.percentage:.1f} %'
              }
          }
      },
      series: [{
          name: 'Cantidad',
          colors: [
            '#28a841', '#d4542f'
          ],
          colorByPoint: true,
          data: [
          <?php 
            foreach ($data['distribucionBecados'] AS $becados) {
              echo "{name:'".$becados['beca']."',y:".$becados['cantidad']."},";
            }
           ?>
          ]
      }]
  });

  Highcharts.chart('distribucionGenero', {
      chart: {
          plotBackgroundColor: null,
          plotBorderWidth: null,
          plotShadow: false,
          type: 'pie'
      },
      title: {
          text: 'Distribución de Alumnos, Genero'
      },
      subtitle: {
        text: 'Universidad Autónoma de Fresnillo'
      },
      tooltip: {
          pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
      },
      accessibility: {
          point: {
              valueSuffix: '%'
          }
      },
      plotOptions: {
          pie: {
              allowPointSelect: true,
              cursor: 'pointer',
              dataLabels: {
                  enabled: true,
                  format: '<b>{point.name}</b>: {point.percentage:.1f} %'
              }
          }
      },
      series: [{
          name: 'Cantidad',
          colors: [
            '#9b20d9', '#6225ed'
          ],
          colorByPoint: true,
          data: [
          <?php 
            foreach ($data['distribucionGenero'] AS $genero) {
              echo "{name:'".$genero['sexo']."',y:".$genero['cantidad']."},";
            }
           ?>
          ]
      }]
  });

  Highcharts.chart('distribucionEscuelas', {
      chart: {
          plotBackgroundColor: null,
          plotBorderWidth: null,
          plotShadow: false,
          type: 'pie'
      },
      title: {
          text: 'Distribución de Alumnos, Escuelas Procedencia'
      },
      subtitle: {
        text: 'Universidad Autónoma de Fresnillo'
      },
      tooltip: {
          pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
      },
      accessibility: {
          point: {
              valueSuffix: '%'
          }
      },
      plotOptions: {
          pie: {
              allowPointSelect: true,
              cursor: 'pointer',
              dataLabels: {
                  enabled: true,
                  format: '<b>{point.name}</b>: {point.percentage:.1f} %'
              }
          }
      },
      series: [{
          name: 'Cantidad',
          colors: [
            '#007885', '#6ED1DB'
          ],
          colorByPoint: true,
          data: [
          <?php 
            foreach ($data['distribucionEscuelas'] AS $escuela) {
              echo "{name:'".$escuela['escuela_procedencia']."',y:".$escuela['cantidad']."},";
            }
           ?>
          ]
      }]
  });

  Highcharts.chart('distribucionEscuelasBarras', {
    chart: {
        type: 'column'
    },
    title: {
        text: 'Distribución de Alumnos, Escuelas Procedencia'
    },
    subtitle: {
        text: 'Universidad Autónoma de Fresnillo'
    },
    xAxis: {
        type: 'category',
        labels: {
            autoRotation: [-45, -90],
            style: {
                fontSize: '13px',
                fontFamily: 'Verdana, sans-serif'
            }
        }
    },
    yAxis: {
        min: 0,
        title: {
            text: 'Cantidad (alumnos)'
        }
    },
    legend: {
        enabled: false
    },
    tooltip: {
        pointFormat: 'Alumnos: <b>{point.y:.1f}</b>'
    },
    series: [{
        name: 'Population',
        colors: [
            '#1f88b7', '#1693b1', '#0a9eaa', '#3667c9', '#2f72c3', '#277dbd', 
            '#6225ed', '#5b30e7', '#533be1', '#4c46db', '#4551d5', '#3e5ccf',
            '#9b20d9', '#9215ac', '#861ec9', '#7a17e6', '#7010f9', '#691af3',
            '#03c69b',  '#00f194'
        ],
        colorByPoint: true,
        groupPadding: 0,
        data: [
          <?php foreach ($data['distribucionEscuelas'] as $escuelas):
            echo "{name:'".$escuelas['escuela_procedencia']."',y:".$escuelas['cantidad']."},";
          endforeach ?>
        ],
        dataLabels: {
            enabled: true,
            rotation: -90,
            color: '#FFFFFF',
            align: 'right',
            format: '{point.y:.1f}', // Mostrar solo un decimal
            y: 10, // 10 pixeles de margen con el frame contenedor
            style: {
                fontSize: '13px',
                fontFamily: 'Verdana, sans-serif'
            }
        }
    }]
  });

  Highcharts.chart('distribucionColonias', {
      chart: {
          plotBackgroundColor: null,
          plotBorderWidth: null,
          plotShadow: false,
          type: 'pie'
      },
      title: {
          text: 'Distribución de Alumnos, Colonias'
      },
      subtitle: {
        text: 'Universidad Autónoma de Fresnillo'
      },
      tooltip: {
          pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
      },
      accessibility: {
          point: {
              valueSuffix: '%'
          }
      },
      plotOptions: {
          pie: {
              allowPointSelect: true,
              cursor: 'pointer',
              dataLabels: {
                  enabled: true,
                  format: '<b>{point.name}</b>: {point.percentage:.1f} %'
              }
          }
      },
      series: [{
          name: 'Cantidad',
          colors: [
            '#F52900', '#E8765D'
          ],
          colorByPoint: true,
          data: [
          <?php 
            foreach ($data['distribucionColonias'] AS $colonias) {
              echo "{name:'".$colonias['colonia']."',y:".$colonias['cantidad']."},";
            }
           ?>
          ]
      }]
  });

  Highcharts.chart('distribucionColoniasBarras', {
    chart: {
        type: 'column'
    },
    title: {
        text: 'Distribución de Alumnos, Colonias'
    },
    subtitle: {
        text: 'Universidad Autónoma de Fresnillo'
    },
    xAxis: {
        type: 'category',
        labels: {
            autoRotation: [-45, -90],
            style: {
                fontSize: '13px',
                fontFamily: 'Verdana, sans-serif'
            }
        }
    },
    yAxis: {
        min: 0,
        title: {
            text: 'Cantidad (alumnos)'
        }
    },
    legend: {
        enabled: false
    },
    tooltip: {
        pointFormat: 'Alumnos: <b>{point.y:.1f}</b>'
    },
    series: [{
        name: 'Population',
        colors: [
            '#1f88b7', '#1693b1', '#0a9eaa', '#3667c9', '#2f72c3', '#277dbd', 
            '#6225ed', '#5b30e7', '#533be1', '#4c46db', '#4551d5', '#3e5ccf',
            '#9b20d9', '#9215ac', '#861ec9', '#7a17e6', '#7010f9', '#691af3',
            '#03c69b',  '#00f194'
        ],
        colorByPoint: true,
        groupPadding: 0,
        data: [
          <?php foreach ($data['distribucionColonias'] as $colonias):
            echo "{name:'".$colonias['colonia']."',y:".$colonias['cantidad']."},";
          endforeach ?>
        ],
        dataLabels: {
            enabled: true,
            rotation: -90,
            color: '#FFFFFF',
            align: 'right',
            format: '{point.y:.1f}', // Mostrar solo un decimal
            y: 10, // 10 pixeles de margen con el frame contenedor
            style: {
                fontSize: '13px',
                fontFamily: 'Verdana, sans-serif'
            }
        }
    }]
  });

  Highcharts.chart('distribucionTipoBeca', {
    chart: {
        type: 'column'
    },
    title: {
        text: 'Tipo de Beca'
    },
    subtitle: {
        text: 'Universidad Autónoma de Fresnillo'
    },
    xAxis: {
        type: 'category',
        labels: {
            autoRotation: [-45, -90],
            style: {
                fontSize: '13px',
                fontFamily: 'Verdana, sans-serif'
            }
        }
    },
    yAxis: {
        min: 0,
        title: {
            text: 'Cantidad (alumnos)'
        }
    },
    legend: {
        enabled: false
    },
    tooltip: {
        pointFormat: 'Alumnos: <b>{point.y:.1f}</b>'
    },
    series: [{
        name: 'Population',
        colors: [
            '#1f88b7', '#1693b1', '#0a9eaa', '#3667c9', '#2f72c3', '#277dbd', 
            '#6225ed', '#5b30e7', '#533be1', '#4c46db', '#4551d5', '#3e5ccf',
            '#9b20d9', '#9215ac', '#861ec9', '#7a17e6', '#7010f9', '#691af3',
            '#03c69b',  '#00f194'
        ],
        colorByPoint: true,
        groupPadding: 0,
        data: [
          <?php foreach ($data['distribucionTipoBeca'] as $nivel):
            echo "{name:'".$nivel['tipo_beca']."',y:".$nivel['cantidad']."},";
          endforeach ?>
        ],
        dataLabels: {
            enabled: true,
            rotation: -90,
            color: '#FFFFFF',
            align: 'right',
            format: '{point.y:.1f}', // Mostrar solo un decimal
            y: 10, // 10 pixeles de margen con el frame contenedor
            style: {
                fontSize: '13px',
                fontFamily: 'Verdana, sans-serif'
            }
        }
    }]
  });

  Highcharts.chart('distribucionPaisNacimiento', {
    chart: {
        type: 'column'
    },
    title: {
        text: 'País de Nacimiento'
    },
    subtitle: {
        text: 'Universidad Autónoma de Fresnillo'
    },
    xAxis: {
        type: 'category',
        labels: {
            autoRotation: [-45, -90],
            style: {
                fontSize: '13px',
                fontFamily: 'Verdana, sans-serif'
            }
        }
    },
    yAxis: {
        min: 0,
        title: {
            text: 'Cantidad (alumnos)'
        }
    },
    legend: {
        enabled: false
    },
    tooltip: {
        pointFormat: 'Alumnos: <b>{point.y:.1f}</b>'
    },
    series: [{
        name: 'Population',
        colors: [
            '#1f88b7', '#1693b1', '#0a9eaa', '#3667c9', '#2f72c3', '#277dbd', 
            '#6225ed', '#5b30e7', '#533be1', '#4c46db', '#4551d5', '#3e5ccf',
            '#9b20d9', '#9215ac', '#861ec9', '#7a17e6', '#7010f9', '#691af3',
            '#03c69b',  '#00f194'
        ],
        colorByPoint: true,
        groupPadding: 0,
        data: [
          <?php foreach ($data['distribucionPaisNacimiento'] as $paises):
            echo "{name:'".$paises['pais_nacimiento']."',y:".$paises['cantidad']."},";
          endforeach ?>
        ],
        dataLabels: {
            enabled: true,
            rotation: -90,
            color: '#FFFFFF',
            align: 'right',
            format: '{point.y:.1f}', // Mostrar solo un decimal
            y: 10, // 10 pixeles de margen con el frame contenedor
            style: {
                fontSize: '13px',
                fontFamily: 'Verdana, sans-serif'
            }
        }
    }]
  });

  Highcharts.chart('distribucionMedioPromocion', {
    chart: {
        type: 'column'
    },
    title: {
        text: 'Medio de Promocion'
    },
    subtitle: {
        text: 'Universidad Autónoma de Fresnillo'
    },
    xAxis: {
        type: 'category',
        labels: {
            autoRotation: [-45, -90],
            style: {
                fontSize: '13px',
                fontFamily: 'Verdana, sans-serif'
            }
        }
    },
    yAxis: {
        min: 0,
        title: {
            text: 'Cantidad (alumnos)'
        }
    },
    legend: {
        enabled: false
    },
    tooltip: {
        pointFormat: 'Alumnos: <b>{point.y:.1f}</b>'
    },
    series: [{
        name: 'Population',
        colors: [
            '#1f88b7', '#1693b1', '#0a9eaa', '#3667c9', '#2f72c3', '#277dbd', 
            '#6225ed', '#5b30e7', '#533be1', '#4c46db', '#4551d5', '#3e5ccf',
            '#9b20d9', '#9215ac', '#861ec9', '#7a17e6', '#7010f9', '#691af3',
            '#03c69b',  '#00f194'
        ],
        colorByPoint: true,
        groupPadding: 0,
        data: [
          <?php foreach ($data['distribucionMedioPromocion'] as $medios):
            echo "{name:'".$medios['medio_promocion']."',y:".$medios['cantidad']."},";
          endforeach ?>
        ],
        dataLabels: {
            enabled: true,
            rotation: -90,
            color: '#FFFFFF',
            align: 'right',
            format: '{point.y:.1f}', // Mostrar solo un decimal
            y: 10, // 10 pixeles de margen con el frame contenedor
            style: {
                fontSize: '13px',
                fontFamily: 'Verdana, sans-serif'
            }
        }
    }]
  });

  Highcharts.chart('distribucionNiveles', {
    chart: {
        type: 'column'
    },
    title: {
        text: 'Alumnos por Nivel'
    },
    subtitle: {
        text: 'Universidad Autónoma de Fresnillo'
    },
    xAxis: {
        type: 'category',
        labels: {
            autoRotation: [-45, -90],
            style: {
                fontSize: '13px',
                fontFamily: 'Verdana, sans-serif'
            }
        }
    },
    yAxis: {
        min: 0,
        title: {
            text: 'Cantidad (alumnos)'
        }
    },
    legend: {
        enabled: false
    },
    tooltip: {
        pointFormat: 'Alumnos: <b>{point.y:.1f}</b>'
    },
    series: [{
        name: 'Population',
        colors: [
            '#94321c', '#cf3f1d', '#bd3f22', '#ab3a20', '#4c46db', '#ee451d',
            '#6225ed', '#5b30e7', '#533be1', '#4c46db', '#4551d5', '#3e5ccf',
            '#3667c9', '#2f72c3', '#277dbd', '#1f88b7', '#1693b1', '#0a9eaa',
            '#9b20d9', '#9215ac', '#861ec9', '#7a17e6', '#7010f9', '#691af3',
            '#03c69b',  '#00f194'
        ],
        colorByPoint: true,
        groupPadding: 0,
        data: [
          <?php foreach ($data['distribucionNiveles'] as $nivel):
            echo "{name:'".$nivel['nivel']."',y:".$nivel['cantidad']."},";
          endforeach ?>
        ],
        dataLabels: {
            enabled: true,
            rotation: -90,
            color: '#FFFFFF',
            align: 'right',
            format: '{point.y:.1f}', // Mostrar solo un décimal
            y: 10, // 10 pixeles de margen con el frame contenedor
            style: {
                fontSize: '13px',
                fontFamily: 'Verdana, sans-serif'
            }
        }
    }]
  });

</script>
    