<?php 
    headerAdmin($data); 
    getModal('modalReinscripciones',$data);
?>
  <main class="app-content">    
      <div class="app-title">
        <div>
            <h1><i class="fas fa-book"></i> <?= $data['page_title'] ?>
            </h1>
        </div>
        <ul class="app-breadcrumb breadcrumb">
          <li class="breadcrumb-item"><i class="fa fa-home fa-lg"></i></li>
          <li class="breadcrumb-item"><a href="<?= base_url(); ?>reinscripciones"><?= $data['page_title'] ?></a></li>
        </ul>
      </div>

      <?php if($data['datos']['baja'] == 1){ ?>
        <div class="alert alert-danger" role="alert">
          <i class="fa fa-warning"></i>&nbsp ¡ADVERTENCIA! Estatus: <strong>Alumno BAJA</strong>
          <br>
          <br>
          <p><small>Nota: En caso de tener alguna duda favor de ponerse en contacto con personal de Servicios Escolares</small></p>
        </div>
      <?php }elseif($data['datos']['irregular'] == 1){ ?>
        <div class="alert alert-danger" role="alert">
          <i class="fa fa-warning"></i>&nbsp ¡ADVERTENCIA! Estatus: <strong>Alumno Irregular</strong>
          <br>
          <br>
          <p><small>Nota: En caso de tener alguna duda favor de ponerse en contacto con personal de Servicios Escolares</small></p>
        </div>
      <?php }elseif($data['datos']['egresado'] == 1){ ?>
        <div class="alert alert-danger" role="alert">
          <i class="fa fa-warning"></i>&nbsp ¡ADVERTENCIA! Estatus: <strong>Alumno Egresado</strong>
          <br>
          <br>
          <p><small>Nota: En caso de tener alguna duda favor de ponerse en contacto con personal de Servicios Escolares</small></p>
        </div>
      <?php }else{ ?>  

      <div class="row">
        <div class="col-md-12">
          <div class="card" style="padding: 10px;">
            <div class="card-title"><h5>Datos Personales</h5></div>
            <div class="card-body">
              <form id="formDatos" name="formDatos" class="form-horizontal">
                <input class="form-control" type="hidden" id="txtIdPersona" name="txtIdPersona" value="<?= $_SESSION['userData']['idpersona']; ?>" readonly />
                <input class="form-control" type="hidden" id="txtIdAlumno" name="txtIdAlumno" value="<?= $data['datos']['idalumno']; ?>" readonly />
                <div class="form-row">
                  <div class="form-group col-md-3">
                    <label for="txtNombres">Nombres <span class="required">*</span></label>
                    <input type="text" class="form-control valid" id="txtNombres" value="<?= $data['datos']['nombres']; ?>" name="txtNombres" />
                  </div>
                  <div class="form-group col-md-3">
                    <label for="txtApellidos">Apellidos <span class="required">*</span></label>
                    <input type="text" class="form-control valid" id="txtApellidos" name="txtApellidos" value="<?= $data['datos']['apellidos']; ?>" />
                  </div>
                  <div class="form-group col-md-3">
                    <label for="txtFechaNacimiento">Fecha Nacimiento <span class="required">*</span></label>
                    <input type="date" class="form-control" id="txtFechaNacimiento" name="txtFechaNacimiento" value="<?= $data['datos']['fecha_nacimiento']; ?>"/>
                  </div>
                  <div class="form-group col-md-3">
                    <label for="txtCurp">CURP <span class="required">*</span></label>
                    <input type="text" class="form-control valid" id="txtCurp" name="txtCurp" value="<?= $data['datos']['curp']; ?>" />
                  </div>
                </div>

                <div class="form-row">
                  <div class="form-group col-md-3">
                    <label for="txtTelefonoCelular">Tel. Celular <span class="required">*</span></label>
                    <input type="text" class="form-control valid validNumber" id="txtTelefonoCelular" value="<?= $data['datos']['telefono_celular']; ?>" name="txtTelefonoCelular" />
                  </div>
                  <div class="form-group col-md-3">
                    <label for="txtTelefonoFijo">Tel. Fijo <span class="required">*</span></label>
                    <input type="text" class="form-control valid validNumber" id="txtTelefonoFijo" name="txtTelefonoFijo" value="<?= $data['datos']['telefono_fijo']; ?>" />
                  </div>
                  <div class="form-group col-md-3">
                    <label for="txtEmail">Email <span class="required">*</span></label>
                    <input type="email" class="form-control valid validEmail" id="txtEmail" name="txtEmail" value="<?= $data['datos']['email']; ?>"/>
                  </div>
                  <div class="form-group col-md-3">
                    <label for="txtCalle">Calle <span class="required">*</span></label>
                    <input type="text" class="form-control valid" id="txtCalle" name="txtCalle" value="<?= $data['datos']['calle']; ?>" />
                  </div>
                </div>

                <div class="form-row">
                  <div class="form-group col-md-3">
                    <label for="txtNumeroExterior">No. Exterior <span class="required">*</span></label>
                    <input type="text" class="form-control valid validNumber" id="txtNumeroExterior" value="<?= $data['datos']['numero_exterior']; ?>" name="txtNumeroExterior" />
                  </div>
                  <div class="form-group col-md-3">
                    <label for="txtNumeroInterior">No. Interior </label>
                    <input type="text" class="form-control valid" id="txtNumeroInterior" name="txtNumeroInterior" value="<?= $data['datos']['numero_interior']; ?>" />
                  </div>
                  <div class="form-group col-md-3">
                    <label for="txtColonia">Colonia <span class="required">*</span></label>
                    <input type="text" class="form-control valid" id="txtColonia" name="txtColonia" value="<?= $data['datos']['colonia']; ?>"/>
                  </div>
                  <div class="form-group col-md-3">
                    <label for="txtLocalidad">Localidad <span class="required">*</span></label>
                    <input type="text" class="form-control valid" id="txtLocalidad" name="txtLocalidad" value="<?= $data['datos']['localidad']; ?>"/>
                  </div>
                </div>

                <hr>

                <div class="form-row">
                  <div class="form-group col-md-6">
                    <label><strong>*solo Bachillerato</strong></label>
                    <div class="form-row">
                      <div class="form-group col-md-6">
                        <label for="txtNombreTutor">Nombre Tutor </label>
                        <input type="text" class="form-control valid" id="txtNombreTutor" name="txtNombreTutor" value="<?= $data['datos']['nombre_tutor']; ?>"/>
                      </div>
                      <div class="form-group col-md-6">
                        <label for="txtTelefonoTutor">Teléfono Tutor </label>
                        <input type="text" class="form-control valid validNumber" id="txtTelefonoTutor" name="txtTelefonoTutor" value="<?= $data['datos']['telefono_tutor']; ?>"/>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-md-6">
                    <label><strong>*solo Licenciatura y Posgrado</strong></label>
                    <div class="form-row">
                      <div class="form-group col-md-6">
                        <label for="txtNombreEmpresa">Nombre Empresa </label>
                        <input type="text" class="form-control valid" id="txtNombreEmpresa" name="txtNombreEmpresa" value="<?= $data['datos']['nombre_empresa']; ?>"/>
                      </div>
                      <div class="form-group col-md-6">
                        <label for="txtTelefonoEmpresa">Teléfono Empresa </label>
                        <input type="text" class="form-control valid validNumber" id="txtTelefonoEmpresa" name="txtTelefonoEmpresa" value="<?= $data['datos']['telefono_empresa']; ?>"/>
                      </div>
                    </div>
                  </div>
                </div>

                <hr>

                <div class="form-row">
                  <div class="form-group col-md-6">
                    <label for="txtSemestreActual">Semestre Actual </label>
                    <input type="text" class="form-control valid" id="txtSemestreActual" name="txtSemestreActual" value="<?= $data['datos']['grado']; ?>" readonly="" />
                  </div>
                  <div class="form-group col-md-6">
                    <label for="txtSemestreNuevo">Semestre a Reinscribirse </label>
                    <input type="text" class="form-control valid" id="txtSemestreNuevo" name="txtSemestreNuevo" value="<?= $data['datos']['grado'] + 1; ?>" readonly="" />
                  </div>
                </div>
                
                <br>
                <label><strong>*En caso de tener alguna duda con el proceso o con la información mostrada, favor de ponerse en contacto con su Coordinación o con Servicios Escolares.</strong></label>
                <br />
                <br />

                <div class="tile-footer">
                  <button id="btnActionForm" class="btn-block btn-primary" type="submit" style="padding: 5px"><i class="fa fa-fw fa-lg fa-refresh"></i><span id="btnText"> Reinscribirse </span></button>&nbsp;&nbsp;&nbsp;
                </div>

              </form>
            </div>
          </div>
        </div>
      </div>

    <?php } ?>

    </main>
<?php footerAdmin($data); ?>
    