<?php
    error_reporting(0);
    //dep($data);
    //exit;
    
    // --------------------------------------------------------------------------------------
    // 1. FUNCIONES DE CÁLCULO (Se mantienen sin cambios)
    // --------------------------------------------------------------------------------------

    function calcularPromedioAlumno($registro) {
        // Asegurar que las calificaciones sean numéricas (o NULL/vacío, que se convierte a 0)
        $c1 = isset($registro['primero_calificacion']) && is_numeric($registro['primero_calificacion']) ? floatval($registro['primero_calificacion']) : 0;
        $c2 = isset($registro['segundo_calificacion']) && is_numeric($registro['segundo_calificacion']) ? floatval($registro['segundo_calificacion']) : 0;
        $c3 = isset($registro['tercero_calificacion']) && is_numeric($registro['tercero_calificacion']) ? floatval($registro['tercero_calificacion']) : 0;
        
        $suma = 0;
        $contador = 0;
        
        // Contar solo los parciales que tienen calificación capturada y numérica
        if (isset($registro['primero_calificacion']) && is_numeric($registro['primero_calificacion']) && $registro['primero_calificacion'] !== '') {
            $suma += $c1; $contador++;
        }
        if (isset($registro['segundo_calificacion']) && is_numeric($registro['segundo_calificacion']) && $registro['segundo_calificacion'] !== '') {
            $suma += $c2; $contador++;
        }
        if (isset($registro['tercero_calificacion']) && is_numeric($registro['tercero_calificacion']) && $registro['tercero_calificacion'] !== '') {
            $suma += $c3; $contador++;
        }
        
        if ($contador > 0) {
            $promedio = $suma / $contador;
            // Retorna el promedio con 2 decimales (para cálculo posterior)
            return $promedio;
        }
        // Retorna NULL si no hay calificaciones para poder distinguirlo
        return null;
    }
    
    // Nueva función para calcular la calificación a reportar en el acta (Punto 4)
    function calcularReporteEnActa($califFinal) {
        if ($califFinal === null) return '-';

        if ($califFinal < 70) {
            return '50';
        } elseif ($califFinal >= 70 && $califFinal <75) {
            return '70';
        } elseif ($califFinal >= 75 && $califFinal < 85) {
            return '80';
        } elseif ($califFinal >= 85 && $califFinal < 95) {
            return '90';
        } elseif ($califFinal >= 95) {
            return '100';
        }
        return '-';
    }


    // --------------------------------------------------------------------------------------
    // 2. PREPARACIÓN DE DATOS (Se mantienen sin cambios)
    // --------------------------------------------------------------------------------------

    // Ordenar los datos por Matrícula ascendente (confirmado por el usuario)
    usort($data, function($a, $b) {
        return strcmp($a['matricula'], $b['matricula']);
    });

    // Datos del encabezado (tomados del primer registro, ya que es masivo por Grupo/Materia)
    $encabezado = $data[0] ?? null; 
    $materia = $encabezado['materia'] ?? 'Materia N/A';
    $profesor = $encabezado['nombre_profesor'] ?? 'Profesor N/A'; 

    // Inicializar contadores para el promedio general del grupo
    $sumaPromediosParcialesGrupo = 0;
    $numAlumnosConPromedio = 0;
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Acta Parcial - <?= $materia ?></title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            /* Se eliminó table-layout: fixed; */
        }
        table td, table th {
            font-size: 8px; 
            padding: 3px 1px; 
            overflow: hidden; 
            text-overflow: ellipsis; 
            white-space: nowrap; 
        }
        h4 { margin-bottom: 0; }
        .text-center { text-align: center; }
        .text-right { text-align: right; }
        .text-left { text-align: left; }
        .tbl-hader td { border: none; }
        .tbl-detalle thead th {
            padding: 5px 1px;
            background-color: #d12018;
            color: #FFF;
            text-transform: uppercase;
            border: 1px solid #000;
        }
        .tbl-detalle tbody td {
            border: 1px solid #000;
        }
        .bg-promedio { 
            background-color: #e6e6e6; 
            font-weight: bold;
        }
        .bg-ordinario {
            background-color: #ffcccc; 
        }
        .bg-final {
            background-color: #d12018; 
            color: #FFF;
            font-weight: bold;
        }
    </style>
</head>

<body>
    <table class="tbl-hader">
        <tbody>
            <tr>
                <td style="width:15%">
                    <img style="width:70px;" src="<?= media();?>/images/logoVertical.png" alt="Logo">
                </td>
                <td class="text-center" style="width:65%">
                    <h4><strong><?= NOMBRE_EMPRESA ?? 'INSTITUCIÓN' ?></strong></h4>
                    <p style="margin: 0; padding: 0;">ACTA DE CALIFICACIONES PARCIALES</p>
                    <p style="margin: 0; padding: 0;">
                        Docente: <strong><?= $profesor ?></strong><br>
                        Materia: <strong><?= $materia ?></strong>
                    </p>
                </td>
                <td class="text-right" style="width:20%">
                    <p style="margin: 0; padding: 0;">
                        Nivel: <strong><?= $encabezado['nivel'] ?? 'N/A' ?></strong><br>
                        Carrera: <strong><?= $encabezado['carrera'] ?? 'N/A' ?></strong><br>
                        Grupo: <strong><?= $encabezado['grupo_format'] ?? 'N/A' ?></strong><br>
                        Fecha: <strong><?= date('d/m/Y') ?></strong>
                    </p>
                </td>
            </tr>
        </tbody>
    </table>

    <br>
    
    <table class="tbl-detalle text-center">
        <thead>
            <tr>
                <th rowspan="2" style="width: 3.0%">#</th>
                <th rowspan="2" style="width: 8.5%">Matrícula</th> <th rowspan="2" style="width: 25.0%; text-align: left;">Nombre del Alumno</th>
                
                <th colspan="3" style="width: 12%">1ER PARCIAL</th>
                <th colspan="3" style="width: 12%">2DO PARCIAL</th>
                <th colspan="3" style="width: 12%">3ER PARCIAL</th>
                
                <th rowspan="2" style="width: 7%; background-color: #d12018;">PROM. PARCIALES</th> <th rowspan="2" style="width: 7%; background-color: #d12018;">CALIF. ORDINARIO</th> <th rowspan="2" style="width: 6%; background-color: #d12018;">CALIF. FINAL</th> <th rowspan="2" style="width: 7%; background-color: #d12018;">REPORTAR EN ACTA</th> </tr>
            <tr>
                <th style="width: 4%">F</th>   <th style="width: 4%">TNE</th> <th style="width: 4%">C</th>   <th style="width: 4%">F</th>
                <th style="width: 4%">TNE</th>
                <th style="width: 4%">C</th>
                
                <th style="width: 4%">F</th>
                <th style="width: 4%">TNE</th>
                <th style="width: 4%">C</th>
            </tr>
        </thead>
        <tbody>
            <?php $cont = 1; ?>
            <?php foreach ($data as $registro):
                
                // 1. Cálculo del Promedio de Parciales (PROM. PARCIALES)
                $promedioParciales = calcularPromedioAlumno($registro);
                // Aquí usamos 'number_format' solo para la visualización
                $displayPromedioParciales = ($promedioParciales !== null) ? number_format($promedioParciales, 2, '.', '') : '-';

                // 2. Obtener Calificación Ordinario (CALIF. ORDINARIO)
                $califOrdinario = isset($registro['ordinario_calificacion']) && is_numeric($registro['ordinario_calificacion']) ? floatval($registro['ordinario_calificacion']) : null;
                $displayCalifOrdinario = ($califOrdinario !== null) ? $califOrdinario : '-';

                // 3. Cálculo de la Calificación Final (CALIF. FINAL)
                $calificacionFinal = $promedioParciales; // Valor por defecto
                
                if ($promedioParciales !== null && $califOrdinario !== null) {
                    // Si ambos existen, se promedian
                    $calificacionFinal = ($promedioParciales + $califOrdinario) / 2;
                    $displayCalifFinal = number_format($calificacionFinal, 2, '.', '');
                } elseif ($promedioParciales !== null) {
                    // Si solo existe el promedio de parciales, se usa ese
                    $displayCalifFinal = number_format($calificacionFinal, 2, '.', '');
                } else {
                    $calificacionFinal = null; // No hay base para calcular
                    $displayCalifFinal = '-';
                }

                // 4. Cálculo de Reportar en Acta (REPORTAR EN ACTA)
                $califReporte = calcularReporteEnActa($calificacionFinal);
                
                // Acumular para el promedio general del grupo (solo se usa el de parciales)
                if ($promedioParciales !== null) {
                    $sumaPromediosParcialesGrupo += $promedioParciales;
                    $numAlumnosConPromedio++;
                }
            ?>
            <tr>
                <td><?= $cont++ ?></td>
                <td><?= $registro['matricula'] ?></td> 
                <td class="text-left"><?= $registro['nombre_alumno'] ?></td>

                <td><?= $registro['primero_inasistencias'] ?: '-' ?></td>
                <td><?= $registro['primero_ntareas'] ?: '-' ?></td>
                <td><?= $registro['primero_calificacion'] ?: '-' ?></td>
                
                <td><?= $registro['segundo_inasistencias'] ?: '-' ?></td>
                <td><?= $registro['segundo_ntareas'] ?: '-' ?></td>
                <td><?= $registro['segundo_calificacion'] ?: '-' ?></td>
                
                <td><?= $registro['tercero_inasistencias'] ?: '-' ?></td>
                <td><?= $registro['tercero_ntareas'] ?: '-' ?></td>
                <td><?= $registro['tercero_calificacion'] ?: '-' ?></td>
                
                <td class="bg-promedio"><?= $displayPromedioParciales ?></td>
                <td class="bg-ordinario"><?= $displayCalifOrdinario ?></td>
                <td><?= $displayCalifFinal ?></td>
                <td class="bg-final"><?= $califReporte ?></td>

            </tr>
            <?php endforeach; ?>
        </tbody>
        <tfoot>
            <?php
            // CÁLCULO FINAL DEL PROMEDIO GENERAL DEL GRUPO (Promedio de PROM. PARCIALES)
            $promedioGeneralGrupo = $numAlumnosConPromedio > 0 
                                   ? number_format($sumaPromediosParcialesGrupo / $numAlumnosConPromedio, 2, '.', '') 
                                   : '-';
            ?>
            <tr class="bg-final">
                <td colspan="15" class="text-right" style="border-bottom: none; border-right: none;"><b>PROMEDIO DE PARCIALES DEL GRUPO:</b></td>
                <td class="text-center" style="border-bottom: none; border-left: none;"><b><?= $promedioGeneralGrupo ?></b></td>
            </tr>
        </tfoot>
    </table>
    <br>

    <table style="width: 100%; border: none;">
        <tfoot>
            <tr>
                <td style="width:80%; border: none;"></td>
                <td style="width:20%; border: none;" class="text-right"><b>Fecha Generación:</b> <?= date('d/m/Y H:i:s') ?></td>
            </tr>
        </tfoot>
    </table>
    
    <div class="text-center">
        <br><br><br>
        <h4>"La educación forja al hombre y engrandece a la nación."</h4>
    </div>


</body>
</html>