<?php
    error_reporting(0);
    //dep($data);
    //exit;
    
    if (!function_exists('valorALetras')) {
        function valorALetras($numero) {
            if ($numero === null || $numero === '' || !is_numeric($numero)) return '-';
            
            $digitos = [
                '0' => 'CERO', '1' => 'UNO', '2' => 'DOS', '3' => 'TRES', '4' => 'CUATRO',
                '5' => 'CINCO', '6' => 'SEIS', '7' => 'SIETE', '8' => 'OCHO', '9' => 'NUEVE',
                '.' => 'PUNTO'
            ];
            
            $str = strval($numero);
            $resultado = [];
            for ($i = 0; $i < strlen($str); $i++) {
                $char = $str[$i];
                if (isset($digitos[$char])) {
                    $resultado[] = $digitos[$char];
                }
            }
            return implode(' ', $resultado);
        }
    }

    usort($data, function($a, $b) {
        return strcmp($a['matricula'], $b['matricula']);
    });

    $encabezado = $data[0] ?? null; 
    $materia = $encabezado['materia'] ?? 'Materia N/A';
    $profesor = $encabezado['nombre_profesor'] ?? 'Profesor N/A'; 

    $sumaCalificaciones = 0;
    $contadorNumericos = 0;
    $esEscalaNumerica = true;

?>

<watermarkimage src="<?= media().'/images/logoVerticalEscaled3.png' ?>" alpha="0.1" size="10" pos="" />

<style>
    body {
        font-family: helvetica;
        /* Trigger para mostrar la marca de agua configurada arriba */
        background: url("") no-repeat center center;
    }
    table {
        width: 100%;
        border-collapse: collapse;
    }
    table td, table th {
        font-size: 8px; 
        padding: 3px 1px; 
    }
    .text-center { text-align: center; }
    .text-right { text-align: right; }
    .text-left { text-align: left; }
    
    .tbl-hader td { border: none; }
    
    .tbl-detalle thead th {
        padding: 5px 1px;
        background-color: #d12018;
        color: #FFF;
        text-transform: uppercase;
        border: 1px solid #000;
    }
    .tbl-detalle tbody td, .tbl-detalle tfoot td {
        border: 1px solid #000;
    }
    .bg-promedio {
        background-color: #e6e6e6;
        font-weight: bold;
    }
    @page {
        /* Ajustamos el margen inferior para que se vea el footer */
        margin-footer: 5mm; 
        footer: html_MiFooter;
    }
</style>

<div class="content">
    <table class="tbl-hader">
        <tbody>
            <tr>
                <td style="width:30%">
                    <img style="width:45px;" src="<?= media();?>/images/logoVertical.png" alt="Logo">
                </td>
                <td class="text-center" style="width:50%">
                    <h1>UNIVERSIDAD AUTÓNOMA DE FRESNILLO</h1>
                    <h1>ACTA DE CALIFICACIONES</h1>
                </td>
                <td style="width:25%">
                </td>
            </tr>
        </tbody>
    </table>
    <br>
    <table tbl-hader>
        <tbody>
            <tr>
                <td style="width:60%">
                    <p style="font-size: 12px;"><strong>Materia: </strong><?= $materia; ?></p>
                    <p style="font-size: 12px;"><strong>Turno: </strong>Matutino <strong>&nbsp;&nbsp;&nbsp;&nbsp;De: </strong><?= $data[0]['hora_inicial']; ?> <strong>&nbsp;&nbsp;&nbsp;&nbsp;A: </strong><?=$data[0]['hora_final']; ?> <strong>&nbsp;&nbsp;&nbsp;&nbsp;Materia curricular </strong></p>
                    <p style="font-size: 12px;"><strong>Ex. Final: </strong>Ordinario <strong>&nbsp;&nbsp;&nbsp;&nbsp;Fecha Ex: </strong><?= $data[0]['fecha_cfinal']; ?> <strong>&nbsp;&nbsp;&nbsp;&nbsp;Acta NO: </p>
                    <p style="font-size: 12px;"><strong>Nivel: </strong><?= $data[0]['nivel']; ?> </p>
                    <p style="font-size: 12px;"><strong>Semestre: </strong><?= $data[0]['grupo_format'][0]; ?><strong>&nbsp;&nbsp;&nbsp;&nbsp;Grupo: </strong><?=$data[0]['grupo_format'][2]; ?></p>
                    <p style="font-size: 12px;"><strong>Catedrático: </strong><?= $data[0]['identificador'].'_'.$data[0]['nombre_profesor']; ?></p>
                </td>
                <td class="text-center" style="width:40%">
                </td>
            </tr>
        </tbody>
    </table>

    <br>

    <table class="tbl-detalle text-center">
        <thead>
            <tr>
                <th style="width: 15%">MATRICULA</th> 
                <th style="width: 15%;">CALIF. NÚM</th> 
                <th style="width: 20%;">CALIFACIÓN C/LETRA</th>
                <th style="width: 45%;">NOMBRE</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $cont = 1; 
            foreach ($data as $registro): 
                $cFinal = $registro['calificacion_final'] ?? '';
                $fechaF = !empty($registro['fecha_cfinal']) ? date('d/m/Y', strtotime($registro['fecha_cfinal'])) : '-';

                if ($cFinal !== '') {
                    if (is_numeric($cFinal)) {
                        $sumaCalificaciones += floatval($cFinal);
                        $contadorNumericos++;
                    } else {
                        $esEscalaNumerica = false;
                    }
                }
            ?>
            <tr>
                <td style="font-size: 8pt;"><?= $registro['matricula'] ?></td>
                <td style="font-weight: bold; font-size: 8pt;"><?= ($cFinal !== '') ? $cFinal : '-' ?></td>
                <td style="font-size: 7pt;"><?= valorALetras($cFinal) ?></td>
                <td class="text-left" style="font-size: 8pt;"><?= $registro['nombre_alumno'] ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
        <tfoot>
            
        </tfoot>
    </table>

    <br><br>
    
    

    <div class="text-center" style="margin-top: 50px; margin-button: 10px;">
        <htmlpagefooter name="html_MiFooter">
            <div style="width: 100%; margin: 0; padding: 0;">
                <img src="<?= media();?>/images/footerActa.png" style="width: 100%; display: block;" />
            </div>
        </htmlpagefooter>
    </div>
    <br>
</div>