<?php
    error_reporting(0);
    //dep($data);
    //exit;
    if (!function_exists('valorALetras')) {
        function valorALetras($numero) {
            if ($numero === null || $numero === '' || !is_numeric($numero)) return '-';
            
            $digitos = [
                '0' => 'CERO', '1' => 'UNO', '2' => 'DOS', '3' => 'TRES', '4' => 'CUATRO',
                '5' => 'CINCO', '6' => 'SEIS', '7' => 'SIETE', '8' => 'OCHO', '9' => 'NUEVE',
                '.' => 'PUNTO'
            ];
            
            $str = strval($numero);
            $resultado = [];
            for ($i = 0; $i < strlen($str); $i++) {
                $char = $str[$i];
                if (isset($digitos[$char])) {
                    $resultado[] = $digitos[$char];
                }
            }
            return implode(' ', $resultado);
        }
    }

    usort($data, function($a, $b) {
        return strcmp($a['matricula'], $b['matricula']);
    });

    $encabezado = $data[0] ?? null; 
    $materia = $encabezado['materia'] ?? 'Materia N/A';
    $profesor = $encabezado['nombre_profesor'] ?? 'Profesor N/A'; 

    $sumaCalificaciones = 0;
    $contadorNumericos = 0;
    $esEscalaNumerica = true;
?>
<style>
    table {
        width: 100%;
        border-collapse: collapse;
        font-family: helvetica;
    }
    table td, table th {
        font-size: 8px; 
        padding: 3px 1px; 
        overflow: hidden; 
        text-overflow: ellipsis; 
        white-space: nowrap; 
    }
    h4 { margin-bottom: 0; }
    .text-center { text-align: center; }
    .text-right { text-align: right; }
    .text-left { text-align: left; }
    .tbl-hader td { border: none; }
    .tbl-detalle thead th {
        padding: 2px 1px;
        background-color: #d12018;
        color: #FFF;
        text-transform: uppercase;
        border: 1px solid #000;
    }
    h5 { margin-bottom: 0; }
    .text-center { text-align: center; }
    .text-right { text-align: right; }
    .text-left { text-align: left; }
    .tbl-hader td { border: none; }
    .tbl-detalle thead th {
        padding: 2px 1px;
        background-color: #d12018;
        color: #FFF;
        text-transform: uppercase;
        border: 1px solid #000;
    }
    .tbl-detalle tbody td, .tbl-detalle tfoot td {
        border: 1px solid #000;
    }
    .bg-final {
        background-color: #d12018; 
        color: #FFF;
        font-weight: bold;
    }
</style>

<page backtop="10mm" backbottom="10mm" backleft="10mm" backright="10mm">
    <table class="tbl-hader">
        <tbody>
            <tr>
                <td style="width:15%">
                    <img style="width:70px;" src="<?= media();?>/images/logoVertical.png" alt="Logo">
                </td>
                <td class="text-center" style="width:65%">
                    <h4><strong><?= NOMBRE_EMPRESA ?? 'INSTITUCIÓN' ?></strong></h4>
                    <h5><strong>ACTA DE CALIFICACIONES FINALES</strong></h5>
                    <p style="margin: 0; padding: 0;">
                        Catedrático: <strong><?= $profesor ?></strong><br>
                        Materia: <strong><?= $materia ?></strong>
                    </p>
                </td>
                <td class="text-right" style="width:20%">
                    <p style="margin: 0; padding: 0;">
                        Nivel: <strong><?= $encabezado['nivel'] ?? 'N/A' ?></strong><br>
                        Carrera: <strong><?= $encabezado['carrera'] ?? 'N/A' ?></strong><br>
                        Grupo: <strong><?= $encabezado['grupo_format'] ?? 'N/A' ?></strong><br>
                        Fecha: <strong><?= date('d/m/Y') ?></strong>
                    </p>
                </td>
            </tr>
        </tbody>
    </table>

    <br>

    <table class="tbl-detalle text-center">
        <thead>
            <tr>
                <th style="width: 5.0%">#</th>
                <th style="width: 15.0%">Matrícula</th> 
                <th style="width: 35.0%; text-align: left;">Nombre del Alumno</th>
                <th style="width: 10.0%;">CALIF</th> 
                <th style="width: 20.0%;">CALIF. LETRA</th>
                <th style="width: 15.0%;">CALIF. FECHA</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $cont = 1; 
            foreach ($data as $registro): 
                $cFinal = $registro['calificacion_final'] ?? '';
                $fechaF = !empty($registro['fecha_cfinal']) ? date('d/m/Y', strtotime($registro['fecha_cfinal'])) : '-';

                if ($cFinal !== '') {
                    if (is_numeric($cFinal)) {
                        $sumaCalificaciones += floatval($cFinal);
                        $contadorNumericos++;
                    } else {
                        $esEscalaNumerica = false;
                    }
                }
            ?>
            <tr>
                <td><?= $cont++ ?></td>
                <td><?= $registro['matricula'] ?></td>
                <td class="text-left"><?= $registro['nombre_alumno'] ?></td>
                <td style="font-weight: bold;"><?= ($cFinal !== '') ? $cFinal : '-' ?></td>
                <td style="font-size: 7pt;"><?= valorALetras($cFinal) ?></td>
                <td><?= $fechaF ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
        <tfoot>
            <?php 
                $promedioFinal = "-";
                if ($esEscalaNumerica && $contadorNumericos > 0) {
                    $promedioFinal = number_format($sumaCalificaciones / $contadorNumericos, 2, '.', '');
                }
            ?>
            <tr>
                <td colspan="3" class="text-right" style="font-weight: bold; padding-right: 10px;">PROMEDIO GENERAL DEL GRUPO:</td>
                <td class="bg-promedio" style="font-weight: bold; background-color: #e6e6e6;"><?= $promedioFinal ?></td>
                <td colspan="2" style="background-color: #f5f5f5;"></td>
            </tr>
        </tfoot>
    </table>

    <br><br><br><br><br>
    
    <table style="width: 100%; border: none;">
        <tr>
            <td style="border: none; width: 50%; text-align: center;">
                <br><br>___________________________<br>Firma del Docente
            </td>
            <td style="border: none; width: 50%; text-align: center;">
                <br><br>___________________________<br>Sello y Firma Servicios Escolares
            </td>
        </tr>
    </table>

    <div class="text-center" style="margin-top: 50px;">
        <p style="font-size: 8pt; color: #555;">
            <strong>"La educación forja al hombre y engrandece a la nación."</strong><br><br>
            Fecha de generación: <?= date('d/m/Y H:i:s') ?>
        </p>
    </div>
</page>