<?php
	/*dep($data);
	exit;*/
?>
<!DOCTYPE html>
<html lang="es">
<head> 
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Comprobante</title>
	<style>
		table{
			width: 100%;
		}
		table td, table th{
			font-size: 12px;
		}
		h4{
			margin-bottom: 0px;
		}
		.logoComprobante{
			width: 150px;
			height: 100px;
		}
		.text-center{
			text-align: center;
		}
		.text-right{
			text-align: right;
		}
		.wd33{
			width: 33.33%;
		}
		.tbl-cliente{
			border: 1px solid #CCC;
			border-radius: 10px;
			padding: 5px;
		}
		.wd10{
			width: 10%;
		}
		.wd15{
			width: 15%;
		}
		.wd30{
			width: 30%;
		}
		.wd40{
			width: 40%;
		}
		.wd55{
			width: 55%;
		}
		.tbl-detalle{
			border-collapse: collapse;
		}
		.tbl-detalle thead th{
			padding: 5px;
			background-color: #009688;
			color: #FFF;
		}
		.tbl-detalle tbody td{
			border-bottom: 1px solid #CCC;
			padding: 5px;
		}
		.tbl-detalle tfoot td{
			padding: 5px;
		}
	</style>
</head>
<body>
	<table class="tbl-hader">
		<tbody>
			<tr>
				<td class="wd33">
					<img class="logoComprobante" src="<?= media();?>/images/logocalefondo.png" alt="Logo">
				</td>
				<td class="text-center wd33">
					<h4><strong><?= NOMBRE_EMPRESA ?></strong></h4>
					<p><?= DIRECCION ?> <br>
					Teléfono: <?= TELEMPRESA ?> <br>
					Email: <?= EMAIL_EMPRESA  ?></p>
				</td>
				<td class="text-right wd33">
						<p>Nivel <strong><?= $data[0]['nivel'] ?></strong><br>
						Grado: <?= $data[0]['grado'] ?>  <br>
						Grupo: <?= $data[0]['grupo'] ?> <br>
					</p>
				</td>
			</tr>
		</tbody>
	</table>
	<br>
	<table class="tbl-cliente">
		<tbody>
			<tr>
				<td class="wd10">Materia:</td>
				<td class="wd40"><?= $data[0]['materia'] ?></td>
				<td class="wd10">Profesor:</td>
				<td class="wd40"><?= $data[0]['nombre_persona'] ?></td>
			</tr>
			<tr>
				<td class="wd10">Del Periodo:</td>
				<td class="wd40"><?= $data[0]['fecha_inicial_format'] ?></td>
				<td class="wd10">Al Periodo:</td>
				<td class="wd40"><?= $data[0]['fecha_final_format'] ?></td>
			</tr>
		</tbody>
	</table>
	<br>
	<table class="tbl-detalle">
		<thead>
			<tr>
				<th class="wd10 text-right">#</th>
				<th class="wd40">Alumno</th>
				<th class="wd10 text-right">Calificacion</th>
				<th class="wd40 text-center">Comentarios</th>
			</tr>
		</thead>
		<tbody>
			<?php 
				$suma = 0;
				$contador = 0;
				$promedio = 0;
				foreach ($data as $calificacion) {
					$contador = $contador+1;
					$suma = $suma + $calificacion['calificacion'];
			 ?>
			<tr>
				<td class="text-center"><?= $contador ?></td>
				<td><?= $calificacion['nombre_alumno'] ?></td>
				<td class="text-right"><?= number_format($calificacion['calificacion'], 2) ?></td>
				<td class="text-center"><?= $calificacion['comentarios_alumno'] ?></td>
			</tr>
			<?php }
				$promedio = $suma/$contador; 
			?>
		</tbody>
		<tfoot>
			<tr>
				<td colspan="3" class="text-right"></td>
				<td class="text-right"></td>
			</tr>
			<tr>
				<td colspan="3" class="text-right"></td>
				<td class="text-right"></td>
			</tr>
			<tr>
				<td colspan="3" class="text-right"><b>Promedio Grupo:</b></td>
				<td class="text-right"><b><?= number_format($promedio,2); ?></b></td>
			</tr>
		</tfoot>
	</table>
	<div class="text-center">
		<p> <br> </p>
		<h5>La verdadera educación consiste en obtener lo mejor de uno mismo (Mahatma Gandhi)</h5>
	</div>
</body>
</html>