<?php
    error_reporting(1);
?>
<!DOCTYPE html>
<html lang="es">
<head> 
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>HORARIO ESCOLAR</title>
    <link rel="shortcut icon" href="<?= media();?>/images/logoVertical.png">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
        }
        table{
            width: 100%;
            border-collapse: collapse;
        }
        table td, table th, {
            font-size: 9px;
        }
        p {
            font-size: 10px;
        }
        h4{
            margin-bottom: 0px;
        }
        .header {
            display: inline-block;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2px;
            border-bottom: 2px solid #C82333;
            padding-bottom: 2px;
        }
        .logo {
            width: 80px;
            height: auto;
        }
        .school-info {
            text-align: center;
        }
        .school-info h2 {
            margin: 0;
            color: #012F73;
        }
        .group-info {
            text-align: right;
        }
        .schedule-title {
            text-align: center;
            font-size: 14px;
            margin: 20px 0;
            color: black;
            font-weight: bold;
            table-layout: fixed; /* Forzar columnas fijas */
        }
        .schedule-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
            table-layout: fixed;
        }
        .schedule-table th {
            background-color: #C82333;
            color: white;
            padding: 6px;
            text-align: center;
        }
        .schedule-table td {
            border: 1px solid #ddd;
            padding: 4px;
            text-align: center;
            word-break: break-word;
            white-space: normal;
        }
        .time-slot {
            font-weight: bold;
        }
        .footer {
            text-align: left;
            margin-top: 30px;
            font-style: italic;
            color: #555;
        }
        .signature {
            margin-top: 50px;
            border-top: 1px solid #333;
            width: 300px;
            text-align: center;
            margin-left: auto;
            margin-right: auto;
            padding-top: 10px;
        }
        .wd33{
            width: 33.33%;
        }
        .text-center{
            text-align: center;
        }
        .text-right{
            text-align: right;
        }
    </style>
</head>
<body>

    <table class="header">
        <tr>
            <td class="wd33">
                <img class="logo" src="<?= media();?>/images/logoVertical.png" alt="Logo">
            </td>
            <td class="text-center wd33 school-info">
                <h5><strong><?= NOMBRE_EMPRESA ?></strong></h5>
                <p><?= DIRECCION ?> <br>
                Teléfono: <?= TELEMPRESA ?> <br>
                Email: <?= EMAIL_EMPRESA  ?></p>
            </td>
            <td class="text-right wd33 group-info">
                <p>Docente <strong><?= $data[0]['nombre_profesor'] ?></strong><br>
                U. Modificación: <?= $data[0]['ultima_modificacion_format'] ?>  <br>
                </p>
            </td>
        </tr>
    </table>
    

    <div class="schedule-title">HORARIO ESCOLAR</div>

    <table class="schedule-table">
        <colgroup>
            <col style="width:12%">
            <col style="width:14%">
            <col style="width:14%">
            <col style="width:14%">
            <col style="width:14%">
            <col style="width:14%">
            <col style="width:14%">
        </colgroup>
        <thead>
            <tr>
                <th>Hora</th>
                <th>Lunes</th>
                <th>Martes</th>
                <th>Miércoles</th>
                <th>Jueves</th>
                <th>Viernes</th>
                <th>Sábado</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $schedule = [
                'lunes' => [],
                'martes' => [],
                'miercoles' => [],
                'jueves' => [],
                'viernes' => [],
                'sabado' => []
            ];
            
            // Organizar materias por día y hora
            foreach ($data as $item) {
                $dia = strtolower($item['dia']);
                $hora_inicio = $item['hora_inicial'];

                if (!isset($schedule[$dia][$hora_inicio])) {
                    $schedule[$dia][$hora_inicio] = [];
                }

                $schedule[$dia][$hora_inicio][] = [
                    'hora_final' => $item['hora_final'],
                    'materia' => $item['materia'],
                    'profesor' => $item['nombre_profesor'] ?? 'Profesor no asignado',
                    'grupo' => $item['grupo_format']
                ];
            }
            
            // Obtener todas las horas únicas
            $horas = [];
            foreach ($schedule as $clases) {
                foreach ($clases as $hora => $info) {
                    if (!in_array($hora, $horas)) {
                        $horas[] = $hora;
                    }
                }
            }
            sort($horas);
            
            // Generar filas de la tabla
            foreach ($horas as $hora) {
                echo '<tr>';
                // Mostrar hora inicial y final (si hay varias, tomamos la primera encontrada)
                $hora_final = '';
                foreach (['lunes','martes','miercoles','jueves','viernes','sabado'] as $d) {
                    if (isset($schedule[$d][$hora][0]['hora_final'])) {
                        $hora_final = $schedule[$d][$hora][0]['hora_final'];
                        break;
                    }
                }
                echo '<td class="time-slot">' . $hora . ' - ' . $hora_final . '</td>';
                
                foreach (['lunes', 'martes', 'miercoles', 'jueves', 'viernes', 'sabado'] as $dia) {
                    if (isset($schedule[$dia][$hora])) {
                        $celda = '';
                        $total = count($schedule[$dia][$hora]);
                        $i = 0;
                        foreach ($schedule[$dia][$hora] as $clase) {
                            $i++;
                            $celda .= '<strong>' . $clase['materia'] . '</strong><br>'
                                    . '<small>' . ' (Grupo ' . $clase['grupo'] . ')</small>';
                            if ($i < $total) {
                                $celda .= '<div style="border-top:1px solid #ccc;margin:2px 0;"></div>';
                            }
                        }
                        echo '<td>' . $celda . '</td>';
                    } else {
                        echo '<td>-</td>';
                    }
                }
                
                echo '</tr>';
            }
            ?>
        </tbody>
    </table>

    <div class="footer">
        <p>"Dime y lo olvido, enséñame y lo recuerdo, involúcrame y lo aprendo"</p>
        <p>Última actualización: <?= $data[0]['ultima_modificacion_format'] ?></p>
    </div>
    <br><br>
    <div class="signature">
        Vo.Bo. 
    </div>
</body>
</html>