<!DOCTYPE html>
<html lang="es">
<head> 
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Comprobante Gasto</title>
	<style>
		table{
			width: 100%;
		}
		table td, table th{
			font-size: 12px;
		}
		h4{
			margin-bottom: 0px;
		}
		.logoComprobante{
			width: 150px;
			height: 100px;
		}
		.text-center{
			text-align: center;
		}
		.text-right{
			text-align: right;
		}
		.wd33{
			width: 33.33%;
		}
		.tbl-cliente{
			border: 1px solid #CCC;
			border-radius: 10px;
			padding: 5px;
		}
		.wd10{
			width: 10%;
		}
		.wd15{
			width: 15%;
		}
		.wd40{
			width: 40%;
		}
		.wd55{
			width: 55%;
		}
		.tbl-detalle{
			border-collapse: collapse;
		}
		.tbl-detalle thead th{
			padding: 5px;
			background-color: #009688;
			color: #FFF;
		}
		.tbl-detalle tbody td{
			border-bottom: 1px solid #CCC;
			padding: 5px;
		}
		.tbl-detalle tfoot td{
			padding: 5px;
		}
	</style>
</head>
<body>
	<table class="tbl-hader">
		<tbody>
			<tr>
				<td class="wd33">
					<img class="logoComprobante" src="<?= media();?>/images/logocalefondo.png" alt="Logo">
				</td>
				<td class="text-center wd33">
					<h4><strong><?= NOMBRE_EMPRESA ?></strong></h4>
					<p><?= DIRECCION ?> <br>
					Teléfono: <?= TELEMPRESA ?> <br>
					Email: <?= EMAIL_EMPRESA  ?></p>
				</td>
				<td class="text-right wd33">
					<p>ID Gasto <strong><?= $data['idgasto'] ?></strong><br>
						Fecha Creación: <?= $data['datecreated_format'] ?>  <br>
						Método Pago: Efectivo <br>
						Generó: <?= $data['nombre_persona'] ?> <br>
					</p>
				</td>
			</tr>
		</tbody>
	</table>
	<br>
	<table class="tbl-cliente">
		<tbody>
			<tr>
				<td class="wd10">Fecha Gasto:</td>
				<td class="wd40"><?= $data['fecha_gasto_format'] ?></td>
				<td class="wd10">Comentarios:</td>
				<td class="wd40"><?= $data['comentarios'] ?></td>
			</tr>
		</tbody>
	</table>
	<br>
	<table class="tbl-detalle">
		<thead>
			<tr>
				<th class="wd55">Descripción</th>
				<th class="wd15 text-right"></th>
				<th class="wd15 text-center"></th>
				<th class="wd15 text-right">Importe</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td><?= $data['concepto'] ?></td>
				<td class="text-right"></td>
				<td class="text-center"></td>
				<td class="text-right"><?= SMONEY.' '.formatMoney($data['cantidad']) ?></td>
			</tr>
		</tbody>
		<tfoot>
			<tr>
				<td colspan="3" class="text-right">Total:</td>
				<td class="text-right"><?= SMONEY.' '.formatMoney($data['cantidad']); ?></td>
			</tr>
		</tfoot>
	</table>
	<br>
	<hr />
	<div class="text-center">
		<!--<p>Si tiene preguntas sobre su pago, <br> no dude en ponerse en contacto con nosotros. Con gusto le atenderemos</p>-->
		<h4>Instituto México</h4>
	</div>
</body>
</html>