<!DOCTYPE html>
<html lang="es">
<head> 
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Comprobante Pago</title>
	<style>
		table{
			width: 100%;
		}
		table td, table th{
			font-size: 12px;
		}
		h4{
			margin-bottom: 0px;
		}
		.logoComprobante{
			width: 150px;
			height: 100px;
		}
		.text-center{
			text-align: center;
		}
		.text-right{
			text-align: right;
		}
		.wd33{
			width: 33.33%;
		}
		.tbl-cliente{
			border: 1px solid #CCC;
			border-radius: 10px;
			padding: 5px;
		}
		.wd10{
			width: 10%;
		}
		.wd15{
			width: 15%;
		}
		.wd40{
			width: 40%;
		}
		.wd55{
			width: 55%;
		}
		.tbl-detalle{
			border-collapse: collapse;
		}
		.tbl-detalle thead th{
			padding: 5px;
			background-color: #009688;
			color: #FFF;
		}
		.tbl-detalle tbody td{
			border-bottom: 1px solid #CCC;
			padding: 5px;
		}
		.tbl-detalle tfoot td{
			padding: 5px;
		}
	</style>
</head>
<body>
	<table class="tbl-hader">
		<tbody>
			<tr>
				<td class="wd33">
					<img class="logoComprobante" src="<?= media();?>/images/logocalefondo.png" alt="Logo">
				</td>
				<td class="text-center wd33">
					<h4><strong><?= NOMBRE_EMPRESA ?></strong></h4>
					<p><?= DIRECCION ?> <br>
					Teléfono: <?= TELEMPRESA ?> <br>
					Email: <?= EMAIL_EMPRESA  ?></p>
				</td>
				<td class="text-right wd33">
					<p>No. Orden <strong><?= $data['idpago'] ?></strong><br>
						Fecha: <?= $data['fecha_pago_format'] ?>  <br>
						Método Pago: Efectivo <br>
						Atendió: <?= $data['nombre_persona'] ?> <br>
					</p>
				</td>
			</tr>
		</tbody>
	</table>
	<br>
	<table class="tbl-cliente">
		<tbody>
			<tr>
				<td class="wd10">Matricula:</td>
				<td class="wd40"><?= $data['matricula'] ?></td>
				<td class="wd10">Teléfono:</td>
				<td class="wd40"><?= $data['telefono'] ?></td>
			</tr>
			<tr>
				<td>Nombre:</td>
				<td><?= $data['nombre_alumno'] ?></td>
				<td>Dirección:</td>
				<td><?= $data['direccion'] ?></td>
			</tr>
		</tbody>
	</table>
	<br>
	<table class="tbl-detalle">
		<thead>
			<tr>
				<th class="wd55">Descripción</th>
				<th class="wd15 text-right">Importe</th>
				<th class="wd15 text-center">Pago</th>
				<th class="wd15 text-right">Cambio</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td><?= $data['concepto'] ?></td>
				<td class="text-right"><?= SMONEY.' '.formatMoney($data['importe']) ?></td>
				<td class="text-center"><?= SMONEY.' '.formatMoney($data['pago']) ?></td>
				<td class="text-right"><?= SMONEY.' '.formatMoney($data['cambio']) ?></td>
			</tr>
		</tbody>
		<tfoot>
			<tr>
				<td colspan="3" class="text-right">Total:</td>
				<td class="text-right"><?= SMONEY.' '.formatMoney($data['importe']); ?></td>
			</tr>
		</tfoot>
	</table>
	<div class="text-center">
		<p>Si tiene preguntas sobre su pago, <br> no dude en ponerse en contacto con nosotros. Con gusto le atenderemos</p>
		<h4>¡Gracias por su pago!</h4>
	</div>
</body>
</html>