<?php 
	
	if($grafica = "tipoPagoMes"){
		$pagosMes = $data;
 ?>
<script>
	Highcharts.chart('pagosMesAnio', {
	      chart: {
	          plotBackgroundColor: null,
	          plotBorderWidth: null,
	          plotShadow: false,
	          type: 'pie'
	      },
	      title: {
	          text: 'Ventas por tipo pago, <?= $pagosMes['mes'].' '.$pagosMes['anio'] ?>'
	      },
	      tooltip: {
	          pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
	      },
	      accessibility: {
	          point: {
	              valueSuffix: '%'
	          }
	      },
	      plotOptions: {
	          pie: {
	              allowPointSelect: true,
	              cursor: 'pointer',
	              dataLabels: {
	                  enabled: true,
	                  format: '<b>{point.name}</b>: {point.percentage:.1f} %'
	              }
	          }
	      },
	      series: [{
	          name: 'Brands',
	          colorByPoint: true,
	          data: [
	          <?php 
	            foreach ($pagosMes['tipospago'] as $pagos) {
	              echo "{name:'".$pagos['tipopago']."',y:".$pagos['total']."},";
	            }
	           ?>
	          ]
	      }]
	});

</script>
<?php } ?>
<?php 
	if($grafica = "ingresosMes"){
		$ingresosMes = $data;
 ?>
<script>
	  Highcharts.chart('graficaMes', {
	      chart: {
	          type: 'line'
	      },
	      title: {
	          text: 'Ingresos de <?= $ingresosMes['mes'].' del '.$ingresosMes['anio'] ?>'
	      },
	      subtitle: {
	          text: 'Total Ingresos <?= SMONEY.formatMoney($ingresosMes['total']) ?> '
	      },
	      xAxis: {
	          categories: [
	            <?php 
	                foreach ($ingresosMes['ingresos'] as $dia) {
	                  echo $dia['dia'].",";
	                }
	            ?>
	          ]
	      },
	      yAxis: {
	          title: {
	              text: ''
	          }
	      },
	      plotOptions: {
	          line: {
	              dataLabels: {
	                  enabled: true
	              },
	              enableMouseTracking: false
	          }
	      },
	      series: [{
	          name: 'Cantidad MXN',
	          data: [
	            <?php 
	                foreach ($ingresosMes['ingresos'] as $dia) {
	                  echo $dia['total'].",";
	                }
	            ?>
	          ]
	      }]
	  });
</script>
 <?php } ?>

 <?php 
	if($grafica = "ingresosAnio"){
		$ingresosAnio = $data;
 ?>
 <script>
 	Highcharts.chart('graficaAnio', {
      chart: {
          type: 'column'
      },
      title: {
          text: 'Ingresos del año <?= $ingresosAnio['anio'] ?> '
      },
      subtitle: {
          text: 'Estadística de Ingresos por mes'
      },
      xAxis: {
          type: 'category',
          labels: {
              rotation: -45,
              style: {
                  fontSize: '13px',
                  fontFamily: 'Verdana, sans-serif'
              }
          }
      },
      yAxis: {
          min: 0,
          title: {
              text: ''
          }
      },
      legend: {
          enabled: false
      },
      tooltip: {
          pointFormat: 'Ingresos: <b>{point.y:.1f} MXN</b>'
      },
      series: [{
          name: 'MXN',
          data: [
            <?php 
              foreach ($ingresosAnio['meses'] as $mes) {
                echo "['".$mes['mes']."',".$mes['ingreso']."],";
              }
             ?>                 
          ],
          dataLabels: {
              enabled: true,
              rotation: -90,
              color: '#FFFFFF',
              align: 'right',
              format: '{point.y:.1f}', // one decimal
              y: 10, // 10 pixels down from the top
              style: {
                  fontSize: '13px',
                  fontFamily: 'Verdana, sans-serif'
              }
          }
      }]
  });
 </script>

 <?php } ?>








 <?php 
	if($grafica = "gastosMes"){
		$gastosMes = $data;
 ?>
<script>
	  Highcharts.chart('graficaGastosMes', {
	      chart: {
	          type: 'line'
	      },
	      title: {
	          text: 'Gastos de <?= $gastosMes['mes'].' del '.$gastosMes['anio'] ?>'
	      },
	      subtitle: {
	          text: 'Total Gastos <?= SMONEY.formatMoney($gastosMes['total']) ?> '
	      },
	      xAxis: {
	          categories: [
	            <?php 
	                foreach ($gastosMes['gastos'] as $dia) {
	                  echo $dia['dia'].",";
	                }
	            ?>
	          ]
	      },
	      yAxis: {
	          title: {
	              text: ''
	          }
	      },
	      plotOptions: {
	          line: {
	              dataLabels: {
	                  enabled: true
	              },
	              enableMouseTracking: false
	          }
	      },
	      series: [{
	          name: 'Cantidad MXN',
	          data: [
	            <?php 
	                foreach ($gastosMes['gastos'] as $dia) {
	                  echo $dia['total'].",";
	                }
	            ?>
	          ]
	      }]
	  });
</script>
 <?php } ?>

 <?php 
	if($grafica = "gastosAnio"){
		$gastosAnio = $data;
 ?>
 <script>
 	Highcharts.chart('graficaGastosAnio', {
      chart: {
          type: 'column'
      },
      title: {
          text: 'Gastos del año <?= $gastosAnio['anio'] ?> '
      },
      subtitle: {
          text: 'Estadística de Gastos por mes'
      },
      xAxis: {
          type: 'category',
          labels: {
              rotation: -45,
              style: {
                  fontSize: '13px',
                  fontFamily: 'Verdana, sans-serif'
              }
          }
      },
      yAxis: {
          min: 0,
          title: {
              text: ''
          }
      },
      legend: {
          enabled: false
      },
      tooltip: {
          pointFormat: 'Gastos: <b>{point.y:.1f} MXN</b>'
      },
      series: [{
          name: 'MXN',
          data: [
            <?php 
              foreach ($gastosAnio['meses'] as $mes) {
                echo "['".$mes['mes']."',".$mes['gasto']."],";
              }
             ?>                 
          ],
          dataLabels: {
              enabled: true,
              rotation: -90,
              color: '#FFFFFF',
              align: 'right',
              format: '{point.y:.1f}', // one decimal
              y: 10, // 10 pixels down from the top
              style: {
                  fontSize: '13px',
                  fontFamily: 'Verdana, sans-serif'
              }
          }
      }]
  });
 </script>

 <?php } ?>