<?php
    error_reporting(1);
?>
<!DOCTYPE html>
<html lang="es">
<head> 
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>HORARIO ESCOLAR</title>
    <link rel="shortcut icon" href="<?= media();?>/images/logoVertical.png">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
        }
        table{
            width: 100%;
        }
        table td, table th{
            font-size: 12px; /* ancho de las columnas */
        }
        h4{
            margin-bottom: 0px;
        }
        .header {
            display: inline-block;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 4px;
            border-bottom: 2px solid #C82333;
            padding-bottom: 2px;
        }
        .logo {
            width: 100px;
            height: auto;
        }
        .school-info {
            text-align: center;
        }
        .school-info h2 {
            margin: 0;
            color: #012F73;
        }
        .group-info {
            text-align: right;
        }
        .schedule-title {
            text-align: center;
            font-size: 18px;
            margin: 20px 0;
            color: black;
            font-weight: bold;
        }
        .schedule-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
            table-layout: fixed; /* Forzar columnas fijas */
        }
        .schedule-table th {
            background-color: #C82333;
            color: white;
            padding: 6px;
            text-align: center;
        }
        .schedule-table td {
            border: 1px solid #ddd;
            padding: 5px;
            text-align: center;
            word-break: break-word; /* Forzar salto de línea si el texto es largo */
            white-space: normal;
        }
        .day-header {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .time-slot {
            font-weight: bold;
        }
        .footer {
            text-align: left;
            margin-top: 10px;
            font-style: italic;
            color: #555;
        }
        .signature {
            margin-top: 50px;
            border-top: 1px solid #333;
            width: 300px;
            text-align: center;
            margin-left: auto;
            margin-right: auto;
            padding-top: 10px;
        }
        .wd33{
            width: 33.33%;
        }
        .text-center{
            text-align: center;
        }
        .text-right{
            text-align: right;
        }
    </style>
</head>
<body>

    <table class="header">
        <tbody>
            <tr>
                <td class="wd33">
                    <img class="logo" src="<?= media();?>/images/logoVertical.png" alt="Logo">
                </td>
                <td class="text-center wd33 school-info">
                    <h4><strong><?= NOMBRE_EMPRESA ?></strong></h4>
                    <p><?= DIRECCION ?> <br>
                    Teléfono: <?= TELEMPRESA ?> <br>
                    Email: <?= EMAIL_EMPRESA  ?></p>
                </td>
                <td class="text-right wd33 group-info">
                        <p>Nivel <strong><?= $data[0]['nivel'] ?></strong><br>
                        Carrera: <?= $data[0]['carrera'] ?>  <br>
                        Grado: <?= $data[0]['grado'] ?>  <br>
                        Grupo: <?= $data[0]['grupo'] ?> <br>
                    </p>
                </td>
            </tr>
        </tbody>
    </table>
    

    <div class="schedule-title">HORARIO ESCOLAR</div>

    <table class="schedule-table">
        <colgroup>
            <col style="width:12%">
            <col style="width:17%">
            <col style="width:17%">
            <col style="width:17%">
            <col style="width:17%">
            <col style="width:17%">
        </colgroup>
        <thead>
            <tr>
                <th>Hora</th>
                <th>Lunes</th>
                <th>Martes</th>
                <th>Miércoles</th>
                <th>Jueves</th>
                <th>Viernes</th>
                <!--<th>Sábado</th>-->
            </tr>
        </thead>
        <tbody>
            <?php
            $schedule = [
                'lunes' => [],
                'martes' => [],
                'miercoles' => [],
                'jueves' => [],
                'viernes' => []
            ];
            
            foreach ($data as $item) {
                $dia = $item['dia'];
                $hora_inicio = $item['hora_inicial'];
                
                if (!isset($schedule[$dia][$hora_inicio])) {
                    $schedule[$dia][$hora_inicio] = [
                        'hora_final' => $item['hora_final'],
                        'materia' => $item['materia'],
                        'aula' => $item['aula'],
                        'profesor' => isset($item['nombre_profesor']) ? $item['nombre_profesor'] : 'Profesor no asignado'
                    ];
                }
            }
            
            // Obtener todas las horas únicas
            $horas = [];
            foreach ($schedule as $dia => $clases) {
                foreach ($clases as $hora => $info) {
                    if (!in_array($hora, $horas)) {
                        $horas[] = $hora;
                    }
                }
            }
            sort($horas);
            
            // Generar filas de la tabla
            foreach ($horas as $hora) {
                echo '<tr>';
                echo '<td class="time-slot">' . $hora . ' - ' . 
                     ($schedule['lunes'][$hora]['hora_final'] ?? 
                      $schedule['martes'][$hora]['hora_final'] ?? 
                      $schedule['miercoles'][$hora]['hora_final'] ?? 
                      $schedule['jueves'][$hora]['hora_final'] ?? 
                      $schedule['viernes'][$hora]['hora_final'] ?? '') . '</td>';
                
                foreach (['lunes', 'martes', 'miercoles', 'jueves', 'viernes'] as $dia) {
                    if (isset($schedule[$dia][$hora])) {
                        echo '<td><strong>' . $schedule[$dia][$hora]['materia'] . '</strong><br><small>' . 
                             $schedule[$dia][$hora]['profesor'] . '</small><br><small>' . 
                             $schedule[$dia][$hora]['aula'] . '</small></td>';
                    } else {
                        echo '<td>-</td>';
                    }
                }
                
                echo '</tr>';
            }
            ?>
        </tbody>
    </table>

    <div class="footer" style="text-align: center;">
        <p>"Dime y lo olvido, enséñame y lo recuerdo, involúcrame y lo aprendo"</p>
        <p>Última actualización: <?= $data[0]['ultima_modificacion_format'] ?></p>
    </div>
    <br>
    <br>
    <div class="signature">
        Vo.Bo. 
    </div>
</body>
</html>
