<?php
    error_reporting(0);
    //dep($data[0]['jefe_escolares']);
    //exit;
    
    if (!function_exists('valorALetras')) {
        function valorALetras($numero) {
            if ($numero === null || $numero === '' || !is_numeric($numero)) return '-';
            
            $digitos = [
                '0' => 'CERO', '1' => 'UNO', '2' => 'DOS', '3' => 'TRES', '4' => 'CUATRO',
                '5' => 'CINCO', '6' => 'SEIS', '7' => 'SIETE', '8' => 'OCHO', '9' => 'NUEVE',
                '.' => 'PUNTO'
            ];
            
            $str = strval($numero);
            $resultado = [];
            for ($i = 0; $i < strlen($str); $i++) {
                $char = $str[$i];
                if (isset($digitos[$char])) {
                    $resultado[] = $digitos[$char];
                }
            }
            return implode(' ', $resultado);
        }
    }

    usort($data, function($a, $b) {
        return strcmp($a['matricula'], $b['matricula']);
    });

    $encabezado = $data[0] ?? null; 
    $materia = $encabezado['materia'] ?? 'Materia N/A';
    $profesor = $encabezado['nombre_profesor'] ?? 'Profesor N/A'; 

    $sumaCalificaciones = 0;
    $contadorNumericos = 0;
    $esEscalaNumerica = true;

?>

<watermarkimage src="<?= media().'/images/logoVerticalEscaled3.png' ?>" alpha="0.1" size="10" pos="" />

<style>
    body {
        font-family: helvetica;
        /* Trigger para mostrar la marca de agua configurada arriba */
        background: url("") no-repeat center center;
    }
    table {
        width: 100%;
        border-collapse: collapse;
    }
    table th {
        font-size: 11px; 
        padding: 3px 1px; 
    }
    .text-center { text-align: center; }
    .text-right { text-align: right; }
    .text-left { text-align: left; }
    
    .tbl-hader td { border: none; }
    
    .tbl-detalle thead th {
        padding: 5px 1px;
        /*background-color: #d12018; Color rojo UAF*/
        background-color: #e6e6e6;
        color: black;
        
        border: 1px solid #000;
    }
    .tbl-detalle tbody td, .tbl-detalle tfoot td {
        padding-top: 5pt;
        /*border: 1px solid #000;*/
    }
    .bg-promedio {
        background-color: #e6e6e6;
        font-weight: bold;
    }
    @page {
        /* Ajustamos el margen inferior para que se vea el footer */
        margin-footer: 5mm; 
        footer: html_MiFooter;
    }
</style>

<div class="content">
    <table class="tbl-hader">
        <tbody>
            <tr>
                <td style="width:100%">
                    <img src="<?= media();?>/images/headerKI.png" alt="Logo">
                </td>
            </tr>
        </tbody>
    </table>
    <br>
    <table tbl-hader>
        <tbody>
            <tr>
                <td style="width:100%">
                    <p style="font-size: 13px;">
                        <strong>LUGAR: </strong>FRESNILLO, ZACATECAS&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <strong>MATRICULA: </strong><?= $data[0]['matricula']; ?>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <strong>SEMESTRE: </strong><?= $data[0]['grado']; ?>
                    </p>
                    <p style="font-size: 13px;">
                        <strong>NOMBRE: </strong><?= $data[0]['nombre_alumno']; ?>
                    </p>
                    <p style="font-size: 13px;">
                        <strong>CARRERA: </strong><?= $data[0]['carrera'].' '.$data[0]['carrera_format']; ?>
                    </p>
                </td>
            </tr>
        </tbody>
    </table>

    <br>

    <table class="tbl-detalle text-center">
        <thead>
            <tr>
                <th style="width: 15%">SEM</th> 
                <th style="width: 15%;">CLAVE</th> 
                <th style="width: 40%;">MATERIA</th>
                <th style="width: 15%;">CAL.</th>
                <th style="width: 15%;">FECHA</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $cont = 1; 
            $sumaCalificaciones = 0;
            $contadorNumericos = 0;
            foreach ($data as $registro): 
                $cFinal = $registro['calificacion_final'] ?? '';
                $fechaF = !empty($registro['fecha_cfinal']) ? date('d/m/Y', strtotime($registro['fecha_cfinal'])) : '-';

                if ($cFinal !== '') {
                    if (is_numeric($cFinal)) {
                        $sumaCalificaciones += floatval($cFinal);
                        $contadorNumericos++;
                    } else {
                        $esEscalaNumerica = false;
                    }
                }
            ?>
            <tr>
                <td class="text-center" style="font-size: 9pt;"><?= $registro['semestre']; ?></td>
                <td class="text-center"style="font-weight: 9pt; font-size: 8pt;"><?= $cont; ?></td>
                <td class="text-left" style="font-size: 9pt;"><?= $registro['materia']; ?></td>
                <td class="text-center"style="font-size: 9pt;"><?= $registro['calificacion_final']; ?></td>
                <td class="text-center" style="font-size: 9pt;"><?= $registro['fecha_final_format']; ?></td>
            </tr>

            <?php $cont++; endforeach; ?>
        </tbody>
    </table>
    <hr>
    <div class="text-right" style="margin-right: 6px;">
        <p>PROMEDIO: <?= number_format($sumaCalificaciones/$contadorNumericos,2); ?></p>
    </div>
    <div>
        <p style="font-size: 10pt;">Nota: La calificación mínima aprobatoria es 70. &nbsp;&nbsp;E-Extraordinario &nbsp;&nbsp;R-Recursada &nbsp;&nbsp;AC- Acreditada &nbsp;&nbsp;NA-No Acreditada</p>
    </div>
    <div class="text-right" style="margin-right: 35px;">
        <p style="font-size: 10pt;">JEFE DEL DPTO. DE SERVICIOS ESCOLARES</p>
    </div>
    <br>
    <div class="text-right" style="margin-right: 15px";>
        <p style="font-size: 9pt;">_________________________________________________________</p>
        <p style="margin-right: 35px;"><?= $data[0]['jefe_escolares'] ?></p>
    </div>
   
    
    

    <div class="text-right" style="margin-top: 50px; margin-button: 15px;">
        <htmlpagefooter name="html_MiFooter">
            <div class="text-right">
                <img src="<?= media();?>/images/footerKardex.png" style="width: 45%; display: block;" />
            </div>
        </htmlpagefooter>
    </div>
    <br>
</div>