<?php
    error_reporting(0);
    // --------------------------------------------------------------------------------------
    // 1. FUNCIONES DE CÁLCULO
    // --------------------------------------------------------------------------------------
    
    // Función para obtener el promedio de una materia (promedio de los parciales)
    function calcularPromedioMateria($registro) {
        // Inicializar calificaciones, asegurando que sean números o 0
        $c1 = isset($registro['primero_calificacion']) && is_numeric($registro['primero_calificacion']) ? floatval($registro['primero_calificacion']) : 0;
        $c2 = isset($registro['segundo_calificacion']) && is_numeric($registro['segundo_calificacion']) ? floatval($registro['segundo_calificacion']) : 0;
        $c3 = isset($registro['tercero_calificacion']) && is_numeric($registro['tercero_calificacion']) ? floatval($registro['tercero_calificacion']) : 0;
        
        $suma = $c1 + $c2 + $c3;
        $contador = 0;
        
        // Contar solo los parciales que tienen calificación capturada
        if (isset($registro['primero_calificacion']) && is_numeric($registro['primero_calificacion']) && $registro['primero_calificacion'] !== '') $contador++;
        if (isset($registro['segundo_calificacion']) && is_numeric($registro['segundo_calificacion']) && $registro['segundo_calificacion'] !== '') $contador++;
        if (isset($registro['tercero_calificacion']) && is_numeric($registro['tercero_calificacion']) && $registro['tercero_calificacion'] !== '') $contador++;
        
        if ($contador > 0) {
            $promedio = $suma / $contador;
            // Redondear el promedio a un decimal
            return number_format($promedio, 1, '.', '');
        }
        return '-';
    }

    // --------------------------------------------------------------------------------------
    // 2. PREPARACIÓN DE DATOS (Ordenamiento y Encabezado)
    // --------------------------------------------------------------------------------------
    
    // Ordenar los datos: por Semestre y luego por Materia (igual que en JS)
    usort($data, function($a, $b) {
        if ($a['semestre'] != $b['semestre']) {
            return $a['semestre'] - $b['semestre'];
        }
        return strcmp($a['materia'], $b['materia']);
    });

    // Datos del encabezado (tomados del primer registro)
    $encabezado = $data[0] ?? null; 
    
    // Inicializar contadores para el promedio general
    $sumaPromediosMaterias = 0;
    $numMateriasConPromedio = 0;
?>



    
<watermarkimage src="<?= media().'/images/logoVerticalEscaled3.png' ?>" alpha="0.1" size="10" pos="" />
<style>
    table {
        width: 100%;
        border-collapse: collapse;
        table-layout: fixed; /* Ayuda a que los anchos fijos funcionen mejor */
    }
    table td, table th {
        font-size: 8.5px; /* Ajustado para caber más información */
        padding: 3px 2px;
        overflow: hidden; /* Oculta contenido si excede el ancho (para tbl-detalle) */
        text-overflow: ellipsis; 
        white-space: nowrap; /* Evita saltos de línea dentro de las celdas */
    }
    h4 { margin: 0; padding: 0; }
    .text-center { text-align: center; }
    .text-right { text-align: right; }
    .text-left { text-align: left; }
    
    .tbl-hader td { border: none; }
    .tbl-hader p { font-size: 10px; margin: 0; padding: 0; }
    
    .tbl-detalle thead th {
        padding: 5px 2px;
        background-color: #DC3545; /* Fondo oscuro */
        color: #FFF;
        text-transform: uppercase;
        border: 1px solid #000;
    }
    .tbl-detalle tbody td, .tbl-detalle tfoot td {
        border: 1px solid #000;
        font-size: 10px;
    }
    .b { 
        background-color: #e6e6e6; /* Color claro para el promedio por materia */
        font-weight: bold;
    }
    .bg-promedio { 
        background-color: #e6e6e6; /* Color claro para el promedio por materia */
        font-weight: bold;
    }
    .bg-final {
        background-color: #DC3545; 
        color: #FFF;
        font-weight: bold;
    }
</style>

<table class="tbl-hader">
    <tbody>
        <tr>
            <td style="width:20%">
                <img style="width:70px;" src="<?= media();?>/images/LogoVertical.png" alt="Logo">
            </td>
            <td class="text-center" style="width:60%">
                <h1><strong><?= NOMBRE_EMPRESA ?? 'NOMBRE DE LA INSTITUCIÓN' ?></strong></h1>
                <p style="font-size: 12px">REPORTE INDIVIDUAL DE CALIFICACIONES PARCIALES</p>
                <br>
                <p style="font-size: 10px">
                    Alumno: <strong><?= $encabezado['nombre_alumno'] ?? 'N/A' ?></strong><br>
                    Matrícula: <strong><?= $encabezado['matricula'] ?? 'N/A' ?></strong><br>
                    Grupo: <strong><?= $encabezado['grupo_format'] ?? 'N/A' ?></strong>
                </p>
            </td>
            <td class="text-right" style="width:20%">
                <p style="font-size: 10px">
                    Nivel: <strong><?= $encabezado['nivel'] ?? 'N/A' ?></strong><br>
                    Carrera: <strong><?= $encabezado['carrera'] ?? 'N/A' ?></strong><br>
                    Fecha Generación: <strong><?= date('d/m/Y') ?></strong>
                </p>
            </td>
        </tr>
    </tbody>
</table>

<br>

<table class="tbl-detalle text-center">
    <thead>
        <tr>
            <th rowspan="2" style="width: 3%; min-width: 15px;">#</th>
            <th rowspan="2" style="width: 5%; min-width: 30px;">Sem.</th>
            <th rowspan="2" style="width: 25%; text-align: left;">Materia</th>
            
            <th colspan="3" style="width: 20%;">1ER PARCIAL</th>
            <th colspan="3" style="width: 20%;">2DO PARCIAL</th>
            <th colspan="3" style="width: 20%;">3ER PARCIAL</th>
            
            <th rowspan="2" style="width: 7%;" class="bg-final">PROM. MATERIA</th>
        </tr>
        <tr>
            <th style="width: 6%;">Faltas</th>
            <th style="width: 6%;">Tareas NE</th>
            <th style="width: 6%;">Calif.</th>
        
            <th style="width: 6%;">Faltas</th>
            <th style="width: 6%;">Tareas NE</th>
            <th style="width: 6%;">Calif.</th>
            
            <th style="width: 6%;">Faltas</th>
            <th style="width: 6%;">Tareas NE</th>
            <th style="width: 6%;">Calif.</th>
        </tr>
    </thead>
    <tbody>
        <?php 
        $cont = 1;
        $semestreActual = null;
        
        foreach ($data as $registro): 
            // Lógica de separación por semestre (como en el JS)
            if ($registro['semestre'] != $semestreActual) {
                if ($semestreActual !== null) {
                    // Fila separadora entre semestres
                    echo '<tr><td colspan="14" style="background-color: #e9ecef; height: 5px; border: none;"></td></tr>';
                }
                $semestreActual = $registro['semestre'];
            }
            
            // Calcular promedio de la materia
            $promedioMateria = calcularPromedioMateria($registro);
            
            // Acumular para el promedio general
            if ($promedioMateria !== '-') {
                $sumaPromediosMaterias += floatval($promedioMateria);
                $numMateriasConPromedio++;
            }
        ?>
        <tr>
            <td><?= $cont++ ?></td>
            <td><?= $registro['semestre'] ?></td> 
            <td class="text-left"><?= $registro['materia'] ?></td>

            <td><?= $registro['primero_inasistencias'] ?: '-' ?></td>
            <td><?= $registro['primero_ntareas'] ?: '-' ?></td>
            <td><?= $registro['primero_calificacion'] ?: '-' ?></td>
            
            <td><?= $registro['segundo_inasistencias'] ?: '-' ?></td>
            <td><?= $registro['segundo_ntareas'] ?: '-' ?></td>
            <td><?= $registro['segundo_calificacion'] ?: '-' ?></td>
            
            <td><?= $registro['tercero_inasistencias'] ?: '-' ?></td>
            <td><?= $registro['tercero_ntareas'] ?: '-' ?></td>
            <td><?= $registro['tercero_calificacion'] ?: '-' ?></td>
            
            <td class="bg-promedio"><?= $promedioMateria ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
    <tfoot>
        <?php
        // CÁLCULO FINAL
        $promedioGeneral = $numMateriasConPromedio > 0 
                           ? number_format($sumaPromediosMaterias / $numMateriasConPromedio, 1, '.', '') 
                           : '-';
        ?>
        <tr class="bg-final">
            <td colspan="12" class="text-right" style="border-bottom: none; border-right: none; color: white;"><b>PROMEDIO GENERAL:</b></td>
            <td class="text-center" style="border-bottom: none; border-left: none; color: white;"><b><?= $promedioGeneral ?></b></td>
        </tr>
    </tfoot>
</table>
<br>

<div class="text-center">
    <br><br><br>
    <h4>"La educación forja al hombre y engrandece a la nación."</h4>
</div>
