<?php
	error_reporting(0);
?>
<!DOCTYPE html>
<html lang="es">
<head> 
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<link rel="shortcut icon" href="<?= media();?>/images/logoVertical.png">
	<title>Kardex Individual</title>
	<style>
		@page {
			size: A4 portrait; /* Cambia a landscape si el contenido es muy ancho */
			margin: 20px;
		}
		body {
			font-family: Arial, sans-serif;
			font-size: 11px;
			margin: 0;
			padding: 0;
		}
		.fondoBody {
			background-image: url('<?= media(); ?>/images/banner.jpg');
			background-size: cover;
			background-repeat: no-repeat;
		}
		table {
			width: 100%;
			border-collapse: collapse;
			table-layout: fixed; /* Importante para ajuste responsivo */
			word-wrap: break-word;
		}
		th, td {
			font-size: 11px;
			padding: 6px;
			text-align: center;
			border-bottom: 1px solid #ccc;
		}
		h4 { margin: 0; }
		.logoUniversidad {
			width: 120px;
			height: auto;
		}
		.text-center { text-align: center; }
		.text-right { text-align: right; }

		.tbl-datos {
			border: 1px solid #CCC;
			border-radius: 8px;
			padding: 5px;
			margin-bottom: 10px;
		}
		.tbl-detalle thead th {
			background-color: #d12018;
			color: #FFF;
			font-weight: bold;
			padding: 6px;
		}
		.tbl-detalle tbody td {
			font-size: 10.5px;
		}
		.tbl-detalle tfoot th {
			background-color: #f2f2f2;
			font-weight: bold;
		}
		/* Evita que las filas largas se corten */
		td, th {
			word-break: break-all;
		}
	</style>
</head>

<body class="fondoBody">
	<table>
		<tr>
			<td class="text-left" style="width: 20%;">
				<img class="logoUniversidad" src="<?= media();?>/images/logoVertical.png" alt="Logo">
			</td>
			<td class="text-center" style="width: 60%;">
				<h4><strong><?= NOMBRE_EMPRESA ?></strong></h4>
				<p style="font-size:10px;">
					<?= DIRECCION ?><br>
					Teléfono: <?= TELEMPRESA ?><br>
					Email: <?= EMAIL_EMPRESA ?>
				</p>
			</td>
			<td class="text-right" style="width: 20%;">
				<p style="font-size:10px;">
					Nivel: <strong><?= $data[0]['nivel'] ?></strong><br>
					Carrera: <strong><?= $data[0]['carrera'] ?></strong><br>
					Grupo: <strong><?= $data[0]['grupo'] ?></strong>
				</p>
			</td>
		</tr>
	</table>

	<br>

	<table class="tbl-datos">
		<tr>
			<td style="width: 25%;">Matrícula: <strong><?= $data[0]['matricula'] ?></strong></td>
			<td style="width: 75%;">Alumno: <strong><?= $data[0]['nombre_alumno'] ?></strong></td>
		</tr>
	</table>

	<table class="tbl-detalle text-center">
		<thead>
			<tr>
				<th style="width: 10%;">Semestre</th>
				<th style="width: 45%;">Materia</th>
				<th style="width: 20%;">Fecha Calificación</th>
				<th style="width: 25%;">Calificación</th>
			</tr>
		</thead>
		<tbody>
			<?php 
				$cont = 0;
				$sumatoria = 0;

				foreach ($data as $kardex) 
				{
					// Última calificación no vacía
					$ultimaCalificacion = '';
					$ultimaFecha = '';

					if (!empty($kardex['calificacion_d'])) {
						$ultimaCalificacion = $kardex['calificacion_d'];
						$ultimaFecha = $kardex['fecha_d'];
					} elseif (!empty($kardex['calificacion_c'])) {
						$ultimaCalificacion = $kardex['calificacion_c'];
						$ultimaFecha = $kardex['fecha_c'];
					} elseif (!empty($kardex['calificacion_b'])) {
						$ultimaCalificacion = $kardex['calificacion_b'];
						$ultimaFecha = $kardex['fecha_b'];
					} elseif (!empty($kardex['calificacion_a'])) {
						$ultimaCalificacion = $kardex['calificacion_a'];
						$ultimaFecha = $kardex['fecha_a'];
					}

					// Valor numérico equivalente
					$calificacionNumerica = 0;
					if (strtoupper($ultimaCalificacion) == 'AC') {
						$calificacionNumerica = 100;
					} elseif (strtoupper($ultimaCalificacion) == 'NA') {
						$calificacionNumerica = 50;
					} elseif (is_numeric($ultimaCalificacion)) {
						$calificacionNumerica = floatval($ultimaCalificacion);
					}

					if ($calificacionNumerica > 0) {
						$sumatoria += $calificacionNumerica;
						$cont++;
					}

					$fechaFormat = !empty($ultimaFecha) ? date('d-m-Y', strtotime($ultimaFecha)) : '';
			?>
					<tr>
						<td><?= $kardex['semestre'] ?></td>
						<td><?= $kardex['materia'] ?></td>
						<td><?= $fechaFormat ?></td>
						<td><?= $ultimaCalificacion ?></td>
					</tr>
			<?php 
				}

				$promedio = ($cont > 0) ? ($sumatoria / $cont) : 0;
			?>
		</tbody>
		<tfoot>
			<tr>
				<th colspan="3" class="text-right">Promedio General</th>
				<th><?= number_format($promedio, 2); ?></th>
			</tr>
			<tr>
				<td colspan="3" class="text-right"><b>Fecha Generación:</b></td>
				<td><b><?= date('d/m/Y H:i:s')?></b></td>
			</tr>
		</tfoot>
	</table>

	<div class="text-center" style="margin-top: 15px;">
		<h4>"Por siempre UAF"</h4>
	</div>
</body>
</html>